/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.util.BootstrapHelper;
import com.oracle.glcm.patch.auto.db.util.BootstrapParams;
import com.oracle.glcm.patch.auto.db.util.BootstrapPlugin;
import com.oracle.glcm.patch.auto.db.util.BootstrapResult;
import com.oracle.glcm.patch.auto.db.util.PerlBootstrapPlugin;
import com.oracle.glcm.patch.auto.db.util.SRVMBootstrapPlugin;
import com.oracle.glcm.patch.auto.db.utils.BootstrapConstants;
import com.oracle.glcm.patch.auto.db.utils.BootstrapUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BootstrapController {
    private static final Logger _logger = Logger.getLogger(BootstrapController.class.getName());

    public List<BootstrapResult> executeBootstrapping(BootstrapParams bootstrapParams) throws OPatchAutoException {
        _logger.info("The bootstrap params are: " + bootstrapParams);
        ArrayList<BootstrapResult> bootstrapResults = new ArrayList<BootstrapResult>();
        String currentUser = System.getProperty("user.name");
        String bootStrapPath = bootstrapParams.getCustomConfigDir() + DBCommonPatchingConstants.CONFIG_DBTMP_DIR + "bootstrap_" + DBPatchingHelper.getHostNameWithoutDomain((String)OPatchAutoHelper.getOPatchAutoHost());
        String patchWorkPath = bootStrapPath + File.separator + "patchwork";
        BootstrapUtil.createPatchWork((String)bootstrapParams.getBaseLocation(), (String)bootstrapParams.getCustomConfigDir(), (String)currentUser, (Credential)bootstrapParams.getCredential());
        System.setProperty(BootstrapConstants.OPATCHAUTO_PATCHWORK_PATH.getValue(), patchWorkPath);
        BootstrapHelper.setPatchworkProperty(bootstrapParams.getCustomConfigDir());
        List<BootstrapPlugin> pluginList = this.getPluginList(bootstrapParams);
        BootstrapResult result = null;
        for (BootstrapPlugin plugin : pluginList) {
            result = plugin.execute(bootstrapParams);
            bootstrapResults.add(result);
        }
        return bootstrapResults;
    }

    private List<BootstrapPlugin> getPluginList(BootstrapParams params) {
        ArrayList<BootstrapPlugin> pluginList = new ArrayList<BootstrapPlugin>();
        if (!params.isOOPPatching()) {
            PerlBootstrapPlugin perlBootstrapPlugin = new PerlBootstrapPlugin();
            pluginList.add(perlBootstrapPlugin);
        }
        if (!params.isBinaryPatching() && !params.isShardSidbPatching()) {
            SRVMBootstrapPlugin srvmBootstrapPlugin = new SRVMBootstrapPlugin();
            pluginList.add(srvmBootstrapPlugin);
        }
        return pluginList;
    }
}

