/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.RHPCommandConstants;
import com.oracle.glcm.patch.auto.tracking.PatchTracking;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OPatchautoRHPHelper {
    private static final String OUI_LOCATION = "OPatch.OUI_LOCATION";
    private static final String OUI_DIR = "oui";
    private static final String SYSTEM_PROPERTY_OUI_LOC = "oracle.installer.oui_loc";
    private static final String SYSTEM_PROPERTY_LIB_LOC = "oracle.installer.library_loc";
    private static final String SYSTEM_PROPERTY_STARTUP_LOC = "oracle.installer.startup_location";
    private static final Logger _logger = Logger.getLogger(OPatchautoRHPHelper.class.getName());

    public static RHPOperation getRHPOperationType(OPatchAutoCommand command, OPatchAutoRHPOptions options) throws OPatchAutoException {
        RHPOperation operation = null;
        if (command.isRollback()) {
            operation = RHPOperation.SWITCH_BACK_HOME;
        } else if (options.getOption("create.image").isSwitchEnabled()) {
            operation = RHPOperation.CREATE_IMAGE;
        } else if (options.getOption("apply.image").isSwitchEnabled()) {
            operation = RHPOperation.PROVISION_HOME;
        } else if (options.getOption("switch").isSwitchEnabled()) {
            operation = RHPOperation.SWITCH_HOME;
        }
        _logger.info("RHP operation type=" + (Object)((Object)operation));
        return operation;
    }

    public static void setupEnvironment(String oracleHomePath, String invPtrStr) {
        System.setProperty("ORACLE_HOME", oracleHomePath);
        StringBuffer ouiLocation = null;
        String cmdOuiLocation = System.getProperty(OUI_LOCATION);
        if (cmdOuiLocation == null || cmdOuiLocation.trim().length() == 0) {
            ouiLocation = new StringBuffer(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append(OUI_DIR);
        } else {
            ouiLocation = new StringBuffer(cmdOuiLocation);
        }
        System.setProperty(SYSTEM_PROPERTY_OUI_LOC, ouiLocation.toString());
        System.setProperty(SYSTEM_PROPERTY_STARTUP_LOC, ouiLocation.toString());
        String sLibraryLoc = OiixPathOps.concatPath((String)ouiLocation.toString(), (String)"lib");
        String dirName = OiixPlatform.getCurrentPlatformDirectoryName();
        sLibraryLoc = OiixPathOps.concatPath((String)sLibraryLoc, (String)dirName);
        sLibraryLoc = OiixPathOps.getNativeForm((String)sLibraryLoc);
        System.setProperty(SYSTEM_PROPERTY_LIB_LOC, sLibraryLoc);
        if (!StringUtil.isNullOrEmpty((String)invPtrStr)) {
            System.setProperty("oracle.installer.invPtrLoc", invPtrStr);
        }
    }

    public static String getBashCmd(String command) {
        String bashCommand = "";
        if (new File(File.separator + "bin" + File.separator + "bash").exists()) {
            bashCommand = File.separator + "bin" + File.separator + "bash";
        } else if (new File(File.separator + RHPCommandConstants.USR_BIN_PATH + File.separator + "bash").exists()) {
            bashCommand = File.separator + RHPCommandConstants.USR_BIN_PATH + File.separator + "bash";
        } else {
            int ret = OPatchautoRHPHelper.runTimeExecution("which bash");
            if (ret == 0) {
                bashCommand = "bash";
            } else {
                RuntimeException re = new RuntimeException("opatchauto wasn't able to run the command \"" + command + "\" because 'bash' command could not be found on the current platform.");
                throw re;
            }
        }
        return bashCommand;
    }

    public static String getHostname() throws OPatchAutoException {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            _logger.info("Failed to query hostname due to " + e.getMessage() + " trying to get through unix command");
            hostName = OPatchautoRHPHelper.getHostNameUsingUnixCommand();
        }
        _logger.fine("hostName: " + hostName);
        return hostName;
    }

    private static String getHostNameUsingUnixCommand() throws OPatchAutoException {
        String os;
        int ret = OPatchautoRHPHelper.runTimeExecution("which hostname");
        ArrayList<String> cmds = new ArrayList<String>();
        String hostnameCmd = "hostname";
        if (ret != 0 && !new File(hostnameCmd = (os = System.getProperty("os.name").toLowerCase()).startsWith("hp") || os.startsWith("aix") || os.startsWith("sunos") ? "/usr/bin/hostname" : "/bin/hostname").exists()) {
            hostnameCmd = "hostname";
        }
        cmds.add(hostnameCmd);
        StringBuilder hostname = new StringBuilder();
        try {
            List commandOutput = OPatchAutoHelper.runtimeExecAndCaptureOutput(cmds, null, null, (boolean)false);
            for (String output : commandOutput) {
                hostname.append(output);
                hostname.append("\n");
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Host name using command:" + hostname.toString().trim());
            }
        }
        catch (IOException e) {
            _logger.warning("Host command execution failed with " + e.getMessage());
            throw new OPatchAutoException("68107", (Throwable)e, new Object[0]);
        }
        _logger.fine("hostName: " + hostname);
        return hostname.toString().trim();
    }

    public static int runTimeExecution(String systemCommand) {
        int status = -1;
        try {
            Runtime runTime = Runtime.getRuntime();
            Process process = runTime.exec(systemCommand);
            return process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            status = -1;
            return status;
        }
    }

    public static String findWorkingCopyID(String homePath) throws IOException {
        String workingCopyID = null;
        File wcInfoFile = new File(OPatchautoRHPHelper.removeTrailingFileSeperator(homePath) + File.separator + ".wcinfo");
        BufferedReader wcInfo = new BufferedReader(new FileReader(wcInfoFile));
        String readLine = "";
        while ((readLine = wcInfo.readLine()) != null) {
            if (!readLine.startsWith("WORKING_COPY=")) continue;
            String[] infoList = readLine.split("=");
            if (infoList.length <= 1) break;
            workingCopyID = infoList[1];
            break;
        }
        wcInfo.close();
        _logger.info("Working copy ID of home " + homePath + " is " + workingCopyID);
        return workingCopyID;
    }

    public static String findPreviousHomeWorkingCopyID(String homePath) throws IOException {
        Properties file = new Properties();
        file.load(new FileInputStream(OPatchautoRHPHelper.getRHPMetadataLocation(homePath) + File.separator + "rhp.properties"));
        String workingCopyID = file.getProperty("previousworkingcopyid");
        _logger.info("Previous working copy ID of home " + homePath + " is " + workingCopyID);
        return workingCopyID;
    }

    public static String removeTrailingFileSeperator(String path) {
        String modifiedPath = path;
        if (path.endsWith(File.separator)) {
            modifiedPath = path.substring(0, path.lastIndexOf(File.separator));
        }
        return modifiedPath;
    }

    public static String getRHPSessionPropertyFile() throws OPatchAutoException {
        File sessionDir = PatchTracking.getSessionDir((String)OPatchAutoHelper.getOPatchAutoHome());
        String sessionFilePath = sessionDir.getAbsolutePath() + File.separator + "rhp-session.properties";
        return sessionFilePath;
    }

    public static String getRHPMetadataLocation(String path) {
        String storage_locn = OPatchautoRHPHelper.removeTrailingFileSeperator(path) + File.separator;
        String osName = System.getProperty("os.name", "");
        storage_locn = osName.matches("[W|w]indows*.*") ? storage_locn + "opatchauto_storage" : storage_locn + ".opatchauto_storage";
        storage_locn = storage_locn + File.separator + "rhp";
        return storage_locn;
    }
}

