/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import oracle.opatch.Crs;
import oracle.opatch.CrsImpl;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.Rac;
import oracle.opatch.RacProcessor;
import oracle.opatch.Rules;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;

public class RacImpl
extends Rac {
    private static Rac.RacType racType = null;
    static boolean racSim = false;
    private static final String racFile = "nodes.lst";

    public String toString(IIPMReadServices readService) {
        StringBuffer buff = new StringBuffer("[Rac: ");
        if (racType != null) {
            buff.append(racType);
            boolean shouldProp = this.shouldPropagate(racType);
            buff.append(", should propagate file= ");
            buff.append(shouldProp);
            Rac.RacType racType = this.getInstance(readService);
            String racTypeDetail = racType.getDetail();
            String localNode = racType.getLocalNode();
            String[] remoteNodes = racType.getRemoteNodes();
            String racDiagMsg = racType.getRacDiagMessage();
            buff.append(", local node=\"");
            buff.append(localNode);
            buff.append("\", remote nodes=\"");
            for (int i = 0; i < remoteNodes.length; ++i) {
                buff.append("\"");
                buff.append(remoteNodes[i]);
                buff.append("\" ");
            }
            buff.append(", racTypeDetail=\"");
            buff.append(racTypeDetail);
            buff.append("\", racDiagMsg=\"");
            buff.append(racDiagMsg);
            buff.append(" ]");
        } else {
            buff.append("Rac has not been initialized]");
        }
        return buff.toString();
    }

    public boolean shouldPropagate(Rac.RacType racType) throws NullPointerException {
        StringBuffer buff = new StringBuffer("Rac::shouldPropagate()");
        OLogger.debug((StringBuffer)buff);
        if (racType == null) {
            buff = new StringBuffer(" racType is NULL");
            OLogger.debug((StringBuffer)buff);
            throw new NullPointerException("Rac::shouldPropagateChange() gets null argument racType");
        }
        if (racType == Rac.RacType.MULTIPLE_NODE) {
            return !OPatchEnv.isLocal();
        }
        return false;
    }

    public boolean shouldRemoteRun(Rac.RacType racType) throws NullPointerException {
        StringBuffer buff = new StringBuffer("Rac::shouldPropagate()");
        OLogger.debug((StringBuffer)buff);
        if (racType == null) {
            buff = new StringBuffer(" racType is NULL");
            OLogger.debug((StringBuffer)buff);
            throw new NullPointerException("Rac::shouldPropagateChange() gets null argument racType");
        }
        if (racType == Rac.RacType.MULTIPLE_NODE || racType == Rac.RacType.SHARED_MULTIPLE_NODE) {
            return !OPatchEnv.isLocal();
        }
        return false;
    }

    private static ClusterCmd getClusterCmd() {
        return ClusterCmdHolder.clusterCmd;
    }

    public void srvmCopyOneoffsRecursive(String node, String src) throws RuntimeException {
        boolean cont = Rules.OUIWrite_continue();
        try {
            StringBuffer ts = new StringBuffer("Start srvm-copying all one-offs from ");
            ts.append(src);
            ts.append(" to node ");
            ts.append(node);
            ts.append(" at ");
            ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
            this.srvmCopyDirectoryRecursive(node, src, cont);
            ts = new StringBuffer("Finish srvm-copying all one-offs from ");
            ts.append(src);
            ts.append(" to node ");
            ts.append(node);
            ts.append(" at ");
            ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            RuntimeException rte = new RuntimeException(e.getMessage());
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
    }

    public void srvmCopySavedPatchInPatchStorage(String node, String src) throws RuntimeException {
        boolean cont = Rules.OUIWrite_continue();
        try {
            StringBuffer ts = new StringBuffer("Start srvm-copying all saved patch from ");
            ts.append(src);
            ts.append(" to node ");
            ts.append(node);
            ts.append(" at ");
            ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
            this.srvmCopyDirectoryRecursive(node, src, cont);
            ts = new StringBuffer("Finish srvm-copying all saved patch from ");
            ts.append(src);
            ts.append(" to node ");
            ts.append(node);
            ts.append(" at ");
            ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            RuntimeException rte = new RuntimeException(e.getMessage());
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
    }

    public void srvmCopyDirectoryRecursive(String node, String src, boolean cont) throws RuntimeException {
        StringBuffer buff = new StringBuffer("Rac::srvmCopyDirectoryRecursive()");
        OLogger.debug((StringBuffer)buff);
        ClusterCmd clusterCmd = RacImpl.getClusterCmd();
        boolean ok = true;
        String[] nodeList = new String[]{node};
        if (!cont) {
            buff = new StringBuffer("REPORT: Rac::srvmCopyDirectoryRecursive() skips copy recursively the dir. ");
            buff.append(src);
            buff.append(" to node ");
            buff.append(node);
            OLogger.debug((StringBuffer)buff);
            return;
        }
        try {
            boolean exist = clusterCmd.dirExists(node, src);
            if (!exist) {
                buff = new StringBuffer("Rac::srvmCopyDirectoryRecursive(): mkdirs ");
                buff.append(src);
                buff.append(" on node \"");
                buff.append(node);
                buff.append("\"");
                OLogger.debug((StringBuffer)buff);
                ok = clusterCmd.createDirInNode(node, src);
            }
        }
        catch (Exception e) {
            buff = new StringBuffer(e.getMessage());
            buff.append("\n");
            buff.append(" (Exception thrown from SRVM) during SRVM createDirInNode()");
            throw new RuntimeException(buff.toString(), e);
        }
        if (!ok) {
            buff = new StringBuffer("Rac::srvmCopyDirectoryRecursive() failed to create ");
            buff.append(src);
            buff.append(" on node \"");
            buff.append(node);
            buff.append("\"");
            OLogger.debug((StringBuffer)buff);
            throw new RuntimeException(buff.toString());
        }
        try {
            buff = new StringBuffer("Rac::srvmCopyDirectoryRecursive() copy directory recursively from \"");
            buff.append(src);
            buff.append("\" to node \"");
            buff.append(node);
            buff.append("\"");
            OLogger.debug((StringBuffer)buff);
            ok = clusterCmd.copyDirContentsToNodes(nodeList, src);
        }
        catch (Exception e) {
            buff = new StringBuffer("Rac::srvmCopyDirectoryRecursive() fails to copy ");
            buff.append(src);
            buff.append(" to node \"");
            buff.append(node);
            buff.append("\" with destination = \"");
            buff.append(src);
            buff.append("\"");
            buff.append(" (Exception thrown from SRVM)");
            throw new RuntimeException(buff.toString(), e);
        }
        if (!ok) {
            buff = new StringBuffer("Rac::srvmCopyDirectoryRecursive() fails to copy ");
            buff.append(src);
            buff.append(" from node ");
            buff.append(node);
            buff.append(" to ");
            buff.append(src);
            buff.append(" (no exception thrown from SRVM)");
            throw new RuntimeException(buff.toString());
        }
    }

    public void srvmCopyPatchFile(String node, String src) throws RuntimeException {
        StringBuffer buff = new StringBuffer("Rac::srvmCopyPatchFile()");
        OLogger.debug((StringBuffer)buff);
        ClusterCmd clusterCmd = RacImpl.getClusterCmd();
        boolean ok = true;
        boolean cont = Rules.SystemWrite_continue();
        try {
            if (cont) {
                buff = new StringBuffer("Rac::srvmCopyPatchFile(): copy file ");
                buff.append(src);
                buff.append(" to node \"");
                buff.append(node);
                buff.append("\"");
                OLogger.debug((StringBuffer)buff);
                StringBuffer ts = new StringBuffer("Start srvm-copying file ");
                ts.append(src);
                ts.append(" to node ");
                ts.append(node);
                ts.append(" at ");
                ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
                ok = clusterCmd.copyFileToNode(src, node, src);
                ts = new StringBuffer("Finish srvm-copying file ");
                ts.append(src);
                ts.append(" to node ");
                ts.append(node);
                ts.append(" at ");
                ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
            } else {
                buff = new StringBuffer("REPORT: Rac::srvmCopyPatchFile() skips copying file ");
                buff.append(src);
                buff.append(" to node \"");
                buff.append(node);
                buff.append("\"");
                OLogger.debug((StringBuffer)buff);
            }
        }
        catch (Exception e) {
            buff = new StringBuffer("Rac::srvmCopyPatchFile() fails to copy ");
            buff.append(src);
            buff.append(" to node ");
            buff.append(node);
            buff.append("\"");
            buff.append(" (Exception thrown from SRVM)");
            OLogger.debug((StringBuffer)buff);
            throw new RuntimeException(buff.toString(), e);
        }
        if (!ok) {
            buff = new StringBuffer("Rac::srvmCopyPatchFile() fails to copy ");
            buff.append(src);
            buff.append(" to node ");
            buff.append(node);
            buff.append("\"");
            buff.append(" (no exception thrown from SRVM)");
            OLogger.debug((StringBuffer)buff);
            throw new RuntimeException(buff.toString());
        }
    }

    public void srvmCopyPatchFile(String node, String src, String dst) throws RuntimeException {
        StringBuffer buff = new StringBuffer("Rac::srvmCopyPatchFile()");
        OLogger.debug((StringBuffer)buff);
        ClusterCmd clusterCmd = RacImpl.getClusterCmd();
        boolean ok = true;
        boolean cont = Rules.SystemWrite_continue();
        try {
            if (cont) {
                buff = new StringBuffer("Rac::srvmCopyPatchFile(): copy file ");
                buff.append(src);
                buff.append(" to node \"");
                buff.append(node);
                buff.append("\"");
                buff.append(" from ");
                buff.append(src);
                buff.append(" to ");
                buff.append(dst);
                OLogger.debug((StringBuffer)buff);
                StringBuffer ts = new StringBuffer("Start srvm-copying file ");
                ts.append(src);
                ts.append(" to node ");
                ts.append(node);
                ts.append(" as ");
                ts.append(dst);
                ts.append(" at ");
                ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
                ok = clusterCmd.copyFileToNode(src, node, dst);
                ts = new StringBuffer("Finish srvm-copying file ");
                ts.append(src);
                ts.append(" to node ");
                ts.append(node);
                ts.append(" as ");
                ts.append(dst);
                ts.append(" at ");
                ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
            } else {
                buff = new StringBuffer("REPORT: Rac::srvmCopyPatchFile() skips copying file ");
                buff.append(src);
                buff.append(" to node \"");
                buff.append(node);
                buff.append("\"");
                OLogger.debug((StringBuffer)buff);
            }
        }
        catch (Exception e) {
            buff = new StringBuffer("Rac::srvmCopyPatchFile() fails to copy ");
            buff.append(src);
            buff.append(" to node ");
            buff.append(node);
            buff.append("\"");
            buff.append(" (Exception thrown from SRVM)");
            OLogger.debug((StringBuffer)buff);
            throw new RuntimeException(buff.toString(), e);
        }
        if (!ok) {
            buff = new StringBuffer("Rac::srvmCopyPatchFile() fails to copy ");
            buff.append(src);
            buff.append(" to node ");
            buff.append(node);
            buff.append("\"");
            buff.append(" (no exception thrown from SRVM)");
            OLogger.debug((StringBuffer)buff);
            throw new RuntimeException(buff.toString());
        }
    }

    public void srvmRunRemoteCommand(String node, String remoteCmd) throws RuntimeException {
        StringBuffer buff = new StringBuffer("Rac::srvmRunRemoteCommand(): invoke \"");
        buff.append(remoteCmd);
        buff.append("\" on node \"");
        buff.append(node);
        buff.append("\"");
        OLogger.debug((StringBuffer)buff);
        ClusterCmd clusterCmd = RacImpl.getClusterCmd();
        boolean ok = true;
        boolean cont = Rules.SystemWrite_continue();
        String[] args = new String[]{};
        String[] env = new String[]{};
        String[] nodeList = new String[]{node};
        try {
            if (cont) {
                StringBuffer ts = new StringBuffer("Start Cluster command ");
                ts.append(remoteCmd);
                ts.append(" on node ");
                ts.append(node);
                ts.append(" at ");
                ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
                OLogger.printlnOnLog((String)ts.toString());
                ok = clusterCmd.runCmd(remoteCmd, args, env, nodeList);
                ts = new StringBuffer("Finish Cluster command ");
                ts.append(remoteCmd);
                ts.append(" on node ");
                ts.append(node);
                ts.append(" at ");
                ts.append(OPatchACL.invokeOLogger((Object)((Object)new RacImpl()), (String)"getCurrentTimeString", null).toString());
                OLogger.printlnOnLog((String)ts.toString());
            } else {
                buff = new StringBuffer("REPORT: Rac::srvmRunRemoteCommand() skips invoking remote command");
                OLogger.debug((StringBuffer)buff);
            }
        }
        catch (Exception e) {
            buff = new StringBuffer("Invocation of command \"" + remoteCmd + "\"");
            buff.append("on node \"" + node + "\", failed:");
            buff.append(e.getMessage());
            OLogger.debug((StringBuffer)buff);
            throw new RuntimeException(buff.toString(), e);
        }
        if (!ok) {
            buff.append(", failed (no Exception thrown from SRVM)");
            throw new RuntimeException(buff.toString());
        }
    }

    public Rac.RacType getInstance(IIPMReadServices readServices, boolean recalc) {
        if (recalc) {
            racType = null;
            OPatchEnv.setRacType(null);
        }
        return this.getInstance(readServices);
    }

    public Rac.RacType getInstance(IIPMReadServices readServices) {
        StringBuffer buff = new StringBuffer("Rac::getInstance()");
        OLogger.debug((StringBuffer)buff);
        racType = OPatchEnv.getRacType();
        boolean isLocal = OPatchEnv.isLocal();
        if (isLocal) {
            buff.append(", -local specified, do not detect RAC, assume it is a single system.");
            OLogger.debug((StringBuffer)buff);
            racType = Rac.RacType.NO_RAC;
            racType.setRacDiagCode(Rac.RacDiagCode.LOCAL_FLAG_REQUESTED);
            OPatchEnv.setRacType((Rac.RacType)racType);
            return racType;
        }
        if (!readServices.isInventoryLoaded()) {
            buff = new StringBuffer(" Inventory is NULL, set racType to NO_RAC");
            OLogger.debug((StringBuffer)buff);
            racType = Rac.RacType.NO_RAC;
            racType.setRacDiagCode(Rac.RacDiagCode.NON_CLUSTER_ORACLE_HOME);
            OPatchEnv.setRacType((Rac.RacType)racType);
            return racType;
        }
        if (racType == null) {
            boolean cfs;
            String oracleHomePath;
            String sharedness;
            String[] clusterNodes;
            block30: {
                buff = new StringBuffer(" initializing racType");
                OLogger.debug((StringBuffer)buff);
                clusterNodes = new String[]{};
                sharedness = "false";
                oracleHomePath = "";
                oracleHomePath = readServices.getLocation();
                if (readServices.isDesiredHome()) {
                    String curWorkDir = System.getProperty("OPatch.RUNNING_DIR");
                    if (curWorkDir == null || curWorkDir.equals("")) {
                        curWorkDir = oracleHomePath + File.separator + "OPatch";
                    }
                    String[] supplied_nodes = OPatchEnv.getUserSuppliedNodes();
                    if (OPatchEnv.isUserSuppliedNodes()) {
                        boolean cfs2;
                        PrereqResult resObj = PrereqAPI.checkSuppliedNodesApplicable((String)oracleHomePath);
                        if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                            buff = new StringBuffer("Prerequisite check \"CheckSuppliedNodesApplicable\" failed.");
                            buff.append(resObj.toString());
                            OLogger.println((String)buff.toString());
                            OPatchStateManagerFactory.getInstance().setErrorCode(17);
                            throw new PrereqFailedException("Prerequisite check \"CheckSuppliedNodesApplicable\" failed.");
                        }
                        boolean bl = cfs2 = !OPatchEnv.isUserSuppliedCFS() ? this.isCFS(oracleHomePath, supplied_nodes, "") : true;
                        if (cfs2) {
                            buff = new StringBuffer(" CFS detected, set racType to SHARED_MULTIPLE_NODE");
                            OLogger.debug((StringBuffer)buff);
                            racType = Rac.RacType.SHARED_MULTIPLE_NODE;
                            racType.setRacDiagCode(Rac.RacDiagCode.SHARED_ORACLE_HOME);
                            racType.setLocalNode("");
                            racType.setRemoteNodes(supplied_nodes);
                            OPatchEnv.setRacType((Rac.RacType)racType);
                            return racType;
                        }
                        buff = new StringBuffer(" Certify this  racType as MULTIPLE_NODES");
                        OLogger.debug((StringBuffer)buff);
                        racType = Rac.RacType.MULTIPLE_NODE;
                        racType.setRacDiagCode(Rac.RacDiagCode.CAN_PROPAGATE_ORACLE_HOME);
                        racType.setLocalNode("");
                        racType.setRemoteNodes(supplied_nodes);
                        this.dumpList(supplied_nodes, "Certified RAC, nodes to be patched (excluding local node) are:");
                        OPatchEnv.setRacType((Rac.RacType)racType);
                        return racType;
                    }
                    if (readServices.isInventoryLoaded()) {
                        String crsHome = readServices.findCRSHomeLocation();
                        if (crsHome == null || crsHome.equals("")) {
                            buff = new StringBuffer(" No GI setup detected. There must be no RAC installation");
                            OLogger.debug((StringBuffer)buff);
                            racType = Rac.RacType.NO_RAC;
                            racType.setRacDiagCode(Rac.RacDiagCode.NON_CLUSTER_ORACLE_HOME);
                            return racType;
                        }
                        buff = new StringBuffer("Crs Home is \"" + crsHome + "\"");
                        OLogger.debug((StringBuffer)buff);
                        InstalledComponent[] topComps = readServices.getTopLevelInstalledComponents();
                        boolean racFound = false;
                        for (int i = 0; i < topComps.length; ++i) {
                            buff = new StringBuffer("comp name: ");
                            buff.append(topComps[i].getID());
                            OLogger.debug((StringBuffer)buff);
                            if (!topComps[i].getID().equals("oracle.server") && !topComps[i].getID().equals("oracle.crs")) continue;
                            racFound = true;
                            break;
                        }
                        if (!racFound) {
                            buff = new StringBuffer("Oracle Home is neither database home nor grid home.");
                            OLogger.debug((StringBuffer)buff);
                            racType = Rac.RacType.NO_RAC;
                            racType.setRacDiagCode(Rac.RacDiagCode.NON_CLUSTER_ORACLE_HOME);
                            OPatchEnv.setRacType((Rac.RacType)racType);
                            return racType;
                        }
                    }
                    try {
                        boolean isStackRunning = false;
                        Crs crs = new CrsImpl().getInstance(oracleHomePath);
                        String gridHome = crs.getGridHome();
                        Crs.CrsType type = crs.getCrsType();
                        if (type == Crs.CrsType.NONE) {
                            buff = new StringBuffer("No clusterware information detected. ");
                            OLogger.debug((StringBuffer)buff);
                            racType = Rac.RacType.NO_RAC;
                            racType.setRacDiagCode(Rac.RacDiagCode.NON_CLUSTER_ORACLE_HOME);
                            OPatchEnv.setRacType((Rac.RacType)racType);
                            return racType;
                        }
                        isStackRunning = crs.isStackRunning();
                        if (type != Crs.CrsType.CRS) break block30;
                        if (isStackRunning) {
                            OPatchSessionHelper.loadCRSRelatedLibFiles((String)oracleHomePath);
                            clusterNodes = crs.getClusterNodeList(oracleHomePath);
                            if (clusterNodes != null && clusterNodes.length > 0) {
                                sharedness = String.valueOf(this.isCFS(oracleHomePath, clusterNodes, clusterNodes[0]));
                            }
                            break block30;
                        }
                        buff = new StringBuffer(" Clusterware stack is down. Can't detect nodes information. ");
                        OLogger.debug((StringBuffer)buff);
                        racType = Rac.RacType.NO_RAC;
                        String crsCtlCmd = gridHome + File.separator + StringResource.CRSCTL_COMMAND;
                        if (OPatchEnv.isWindows()) {
                            crsCtlCmd = crsCtlCmd + ".exe";
                        }
                        if (new File(crsCtlCmd).exists()) {
                            String startCmd = gridHome + File.separator + StringResource.START_CLUSTER_COMMAND;
                            racType.setCrsDownPrompt(startCmd);
                        }
                        OPatchEnv.setRacType((Rac.RacType)racType);
                        return racType;
                    }
                    catch (Throwable e) {
                        OLogger.printlnOnLog((String)("Exception happens in lsnodes command : \n" + e.getMessage()));
                    }
                } else {
                    clusterNodes = this.getClusterNodes(readServices);
                }
            }
            if (clusterNodes == null || clusterNodes.length == 0 || clusterNodes.length == 1) {
                buff = new StringBuffer(" User did not use -no_inventory, so why clusterNodes are empty?");
                OLogger.debug((StringBuffer)buff);
                if (clusterNodes == null || clusterNodes.length == 0) {
                    buff = new StringBuffer(" clusterNodes is null or empty, set racType to NO_RAC");
                    OLogger.debug((StringBuffer)buff);
                    racType = Rac.RacType.NO_RAC;
                    racType.setRacDiagCode(Rac.RacDiagCode.NON_CLUSTER_ORACLE_HOME);
                } else {
                    buff = new StringBuffer(" clusterNodes has only one node, set racType to NO_RAC");
                    OLogger.debug((StringBuffer)buff);
                    racType = Rac.RacType.NO_RAC;
                    racType.setRacDiagCode(Rac.RacDiagCode.NODE_LIST_ONE_ELEMENT);
                }
                OPatchEnv.setRacType((Rac.RacType)racType);
                return racType;
            }
            String localNode = "";
            localNode = this.getLocalNode(readServices, clusterNodes);
            buff = new StringBuffer("Rac::getInstance(): local node is \"");
            buff.append(localNode);
            buff.append("\"");
            OLogger.debug((StringBuffer)buff);
            if (localNode == null || localNode.equals("")) {
                buff = new StringBuffer(" User didn't run with -no_inventory, why is localNode null or blank?");
                OLogger.debug((StringBuffer)buff);
                buff = new StringBuffer(" Can not get localNode, set racType to NO_RAC");
                OLogger.debug((StringBuffer)buff);
                racType = Rac.RacType.NO_RAC;
                racType.setRacDiagCode(Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL);
                OPatchEnv.setRacType((Rac.RacType)racType);
                return racType;
            }
            String[] remoteNodes = this.getRemoteNodes(clusterNodes, localNode);
            if (remoteNodes == null || remoteNodes.length == 0) {
                buff = new StringBuffer(" User didn't run with -no_inventory, why are remote nodes empty?");
                OLogger.debug((StringBuffer)buff);
                if (remoteNodes == null || remoteNodes.length == 0) {
                    buff = remoteNodes == null ? new StringBuffer(" remoteNodes is null, set racType to NO_RAC") : new StringBuffer(" remoteNodes is empty, set racType to NO_RAC");
                    OLogger.debug((StringBuffer)buff);
                    racType = Rac.RacType.NO_RAC;
                    racType.setRacDiagCode(Rac.RacDiagCode.NON_CLUSTER_ORACLE_HOME);
                    OPatchEnv.setRacType((Rac.RacType)racType);
                    return racType;
                }
            }
            if (OPatchEnv.isUserSuppliedCFS()) {
                buff = new StringBuffer(" User used -no_inventory and -remote_nodes and -cfs.  ");
                buff.append("OPatch will certify this racType as SHARED_MULTIPLE_NODE");
                buff.append(" using supplied node list, hopefully the list contains no localNode.");
                OLogger.debug((StringBuffer)buff);
                racType = Rac.RacType.SHARED_MULTIPLE_NODE;
                racType.setRacDiagCode(Rac.RacDiagCode.SHARED_ORACLE_HOME);
                racType.setLocalNode(localNode);
                racType.setRemoteNodes(remoteNodes);
                this.dumpList(remoteNodes, "Certified RAC, nodes to be patched (taken from user with trust) are:");
                OPatchEnv.setRacType((Rac.RacType)racType);
                return racType;
            }
            boolean isSubSet = RacProcessor.subset((String[])clusterNodes, (String[])remoteNodes);
            if (!isSubSet) {
                buff = new StringBuffer(" remoteNodes is not a sub-set of clusterNodes, set racType to NO_RAC");
                OLogger.debug((StringBuffer)buff);
                this.dumpList(clusterNodes, "Cluster Nodes:");
                this.dumpList(remoteNodes, "Remote Nodes:");
                racType = Rac.RacType.NO_RAC;
                racType.setRacDiagCode(Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL);
                OPatchEnv.setRacType((Rac.RacType)racType);
                return racType;
            }
            String[] tmpList = new String[]{localNode};
            String[] rNodesExcludingLocal = RacProcessor.setSubtraction((String[])remoteNodes, (String[])tmpList);
            this.dumpList(rNodesExcludingLocal, "Remote nodes excluding local node:");
            if (rNodesExcludingLocal == null || rNodesExcludingLocal.length == 0) {
                buff = new StringBuffer(" cannot filter out local node from remote nodes, set racType to NO_RAC");
                OLogger.debug((StringBuffer)buff);
                this.dumpList(remoteNodes, "Remote Nodes:");
                this.dumpList(tmpList, "Local Node:");
                racType = Rac.RacType.NO_RAC;
                racType.setRacDiagCode(Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL);
                OPatchEnv.setRacType((Rac.RacType)racType);
                return racType;
            }
            boolean bl = !OPatchEnv.isUserSuppliedCFS() ? Boolean.valueOf(sharedness).booleanValue() || this.isCFS(oracleHomePath, remoteNodes, localNode) : (cfs = true);
            if (cfs) {
                buff = new StringBuffer(" CFS detected, set racType to SHARED_MULTIPLE_NODE");
                OLogger.debug((StringBuffer)buff);
                racType = Rac.RacType.SHARED_MULTIPLE_NODE;
                racType.setRacDiagCode(Rac.RacDiagCode.SHARED_ORACLE_HOME);
                racType.setLocalNode(localNode);
                racType.setRemoteNodes(rNodesExcludingLocal);
                OPatchEnv.setRacType((Rac.RacType)racType);
                return racType;
            }
            buff = new StringBuffer(" Certify this  racType as MULTIPLE_NODES");
            OLogger.debug((StringBuffer)buff);
            racType = Rac.RacType.MULTIPLE_NODE;
            racType.setRacDiagCode(Rac.RacDiagCode.CAN_PROPAGATE_ORACLE_HOME);
            racType.setLocalNode(localNode);
            racType.setRemoteNodes(rNodesExcludingLocal);
            this.dumpList(rNodesExcludingLocal, "Certified RAC, nodes to be patched (excluding local node) are:");
            this.dumpList(tmpList, "Certificed RAC, local node is:");
        }
        buff = new StringBuffer(" racType has been initialized, just return the cached object");
        OLogger.debug((StringBuffer)buff);
        return racType;
    }

    private void dumpList(String[] nodes, String header) {
        StringBuffer buff = new StringBuffer(header);
        buff.append("\n");
        if (nodes == null || nodes.length == 0) {
            buff.append("Null list, cannot print out content");
        } else if (nodes.length == 0) {
            buff.append("Empty list, cannot print out content");
        } else {
            for (int i = 0; i < nodes.length; ++i) {
                String node = nodes[i];
                buff.append("\"");
                buff.append(node);
                buff.append("\"");
            }
        }
        OLogger.debug((StringBuffer)buff);
    }

    private HashMap getHomeNodesMap(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("Rac::getHomeNodesMap() ");
        OLogger.debug((StringBuffer)buff);
        HashMap<String, String[]> managedDBHomes = new HashMap<String, String[]>();
        String configDB = oracleHomePath + File.separator + StringResource.CONFIG_COMMAND;
        String statusIns = oracleHomePath + File.separator + StringResource.DATABASE_STATUS_COMMAND;
        SystemCall.ExecReturn rt = SystemCall.runtimeExec((String)configDB);
        String[] dbnames = new String[]{};
        if (rt.isOK()) {
            dbnames = rt.getNormalMessage().split("\n");
            buff = new StringBuffer(" Configured database name number is " + dbnames.length);
            OLogger.debug((StringBuffer)buff);
        }
        for (int i = 0; i < dbnames.length; ++i) {
            String statusCmd;
            if (dbnames[i] == null || dbnames[i].equals("")) continue;
            String[] nodes = new String[]{};
            String cfgCmd = oracleHomePath + File.separator + StringResource.DATABASE_CONFIG_COMMAND + " -d " + dbnames[i];
            rt = SystemCall.runtimeExec((String)cfgCmd);
            String oracleHome = "";
            boolean isRacOne = false;
            if (rt.isOK()) {
                int j;
                String[] details = rt.getNormalMessage().split("\n");
                buff = new StringBuffer("Detail for srvctl config databse: \n");
                for (j = 0; j < details.length; ++j) {
                    String line = details[j];
                    buff.append(line + "\n");
                    if (line.startsWith("Oracle home:")) {
                        oracleHome = line.substring(12).trim();
                    } else if (line.startsWith("Type:") && line.substring(5).trim().equals("RACOneNode")) {
                        isRacOne = true;
                    }
                    if (!isRacOne || !line.startsWith("Candidate servers:")) continue;
                    nodes = line.substring(18).trim().split(",");
                }
                if (isRacOne) {
                    buff.append("Nodes got for Rac One Home: \n");
                    for (j = 0; j < nodes.length; ++j) {
                        buff.append(nodes[j] + "\n");
                    }
                }
                OLogger.debug((StringBuffer)buff);
            }
            if (!isRacOne && (rt = SystemCall.runtimeExec((String)(statusCmd = statusIns + " -d " + dbnames[i]))).isOK()) {
                String[] lines = rt.getNormalMessage().split("\n");
                buff = new StringBuffer("Information for srvctl status databse: \n");
                nodes = new String[lines.length];
                for (int j = 0; j < lines.length; ++j) {
                    buff.append(lines[j] + "\n");
                    String[] keywords = lines[j].trim().split(" ");
                    nodes[j] = keywords[keywords.length - 1];
                    buff.append("Node: " + nodes[j] + "\n");
                }
                OLogger.debug((StringBuffer)buff);
            }
            if (oracleHome.equals("")) continue;
            managedDBHomes.put(oracleHome, nodes);
        }
        return managedDBHomes;
    }

    private String[] getClusterNodes(IIPMReadServices readServices) {
        StringBuffer buff = new StringBuffer("Rac::getClusterNodes()");
        OLogger.debug((StringBuffer)buff);
        String[] clusterNodes = new String[]{};
        if (racSim) {
            String oracleHomePath = readServices.getLocation();
            StringBuffer path = new StringBuffer(oracleHomePath);
            path.append(File.separator);
            path.append(racFile);
            File file = new File(path.toString());
            if (file.exists()) {
                buff = new StringBuffer(" Opening file \"");
                buff.append(path.toString());
                buff.append("\" to get node list, assuming local node first.");
                OLogger.verbose((Object)new Object(), (StringBuffer)buff);
                try {
                    FileReader fr = new FileReader(file);
                    BufferedReader br = new BufferedReader(fr);
                    String entry = null;
                    ArrayList<String> simNodes = new ArrayList<String>();
                    while ((entry = br.readLine()) != null) {
                        simNodes.add(entry);
                    }
                    int size = simNodes.size();
                    clusterNodes = new String[size];
                    for (int i = 0; i < size; ++i) {
                        clusterNodes[i] = (String)simNodes.get(i);
                    }
                    br.close();
                    return clusterNodes;
                }
                catch (IOException e) {
                    racSim = false;
                    buff = new StringBuffer(" Cannot parse the simulated node list.");
                    OLogger.verbose((Object)new Object(), (StringBuffer)buff);
                }
            } else {
                buff = new StringBuffer(" Running in RAC simulation node but file \"");
                buff.append(path.toString());
                buff.append("\" does not exist.  RAC simulation will be turned off.");
                OLogger.verbose((Object)new Object(), (StringBuffer)buff);
                racSim = false;
            }
        }
        buff = new StringBuffer(" calling IIPMReadServices::getNodeList()");
        OLogger.debug((StringBuffer)buff);
        Vector vNodes = readServices.getNodeList();
        if (vNodes != null) {
            int size = vNodes.size();
            buff = new StringBuffer(" IIPMReadServices::getNodeList() returned ");
            buff.append(size);
            buff.append(" elements.");
            OLogger.debug((StringBuffer)buff);
            if (size > 0) {
                clusterNodes = new String[size];
                for (int i = 0; i < size; ++i) {
                    Object obj = vNodes.get(i);
                    if (!(obj instanceof String)) {
                        buff = new StringBuffer(" Error: Vector of nodes contains unknown object");
                        OLogger.debug((StringBuffer)buff);
                        return new String[0];
                    }
                    String node = (String)obj;
                    buff = new StringBuffer(" - retrieving node ");
                    buff.append(node);
                    OLogger.debug((StringBuffer)buff);
                    clusterNodes[i] = node;
                }
            }
        } else {
            buff = new StringBuffer(" IIPMReadServices::getNodeList() returned NULL");
            OLogger.debug((StringBuffer)buff);
        }
        buff = new StringBuffer("RAC::getClusterNodes() returned a list of ");
        buff.append(clusterNodes.length);
        buff.append(" elements.");
        OLogger.debug((StringBuffer)buff);
        return clusterNodes;
    }

    public String readPatchingLevel(String patchlevelFile) throws RuntimeException {
        String result = "";
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(patchlevelFile));
            byte[] data = new byte[1024];
            while (bis.read(data) != -1) {
                result = result + new String(data);
            }
            bis.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private String getLocalNode(IIPMReadServices readServices, String[] clusterNodes) {
        StringBuffer buff = new StringBuffer("Rac::getLocalNode() with clusterNodes=");
        String nodesString = RacProcessor.getNodesString((String[])clusterNodes);
        buff.append(nodesString);
        OLogger.debug((StringBuffer)buff);
        String localNode = "";
        if (racSim) {
            buff = new StringBuffer("   Rac Simulation is true, return 1st node as local node");
            OLogger.debug((StringBuffer)buff);
            return clusterNodes[0];
        }
        if (OPatchEnv.isUserSuppliedLocalNode()) {
            buff = new StringBuffer("  user supplied -local_node, use it then: ");
            localNode = OPatchEnv.getUserSuppliedLocalNode();
            buff.append(localNode);
            OLogger.debug((StringBuffer)buff);
            return localNode;
        }
        try {
            buff = new StringBuffer(" try 10.2 OUI IIPMReadServices::getLocalNode()");
            OLogger.debug((StringBuffer)buff);
            localNode = readServices.getLocalNode();
            if (localNode != null) {
                return localNode.toLowerCase();
            }
            buff = new StringBuffer(" localNode returned from IIPMReadServices::getLocalNode() is NULL.  ");
            buff.append("It could be this is a pre-10.2 home or it is a shared home.");
            OLogger.debug((StringBuffer)buff);
        }
        catch (Throwable t) {
            buff = new StringBuffer("  10.2 OUI IIPMReadServices::getLocalNode() throws error: ");
            buff.append(t.getMessage());
            OLogger.debug((StringBuffer)buff);
        }
        if (clusterNodes != null && clusterNodes.length > 0) {
            buff = new StringBuffer(" try to get local node again, default to the 1st node in cluster nodes ");
            OLogger.debug((StringBuffer)buff);
            localNode = clusterNodes[0];
        }
        return localNode.toLowerCase();
    }

    private String[] getRemoteNodes(String[] clusterNodes, String localNode) {
        StringBuffer buff = new StringBuffer("Rac::getRemoteNodes()");
        OLogger.debug((StringBuffer)buff);
        String[] remoteNodes = new String[]{};
        if (racSim) {
            return clusterNodes;
        }
        if (OPatchEnv.isUserSuppliedRemoteNodes()) {
            buff = new StringBuffer(" user specified -remote_nodes");
            OLogger.debug((StringBuffer)buff);
            remoteNodes = OPatchEnv.getUserSuppliedRemoteNodes();
            if (remoteNodes == null || remoteNodes.length == 0 || remoteNodes[0] == null) {
                buff = new StringBuffer(" user specified -remote_nodes, ");
                buff.append("but the list is empty or null.  Return empty list to caller");
                OLogger.debug((StringBuffer)buff);
                return new String[0];
            }
            buff = new StringBuffer(" user specified -remote_nodes, ");
            buff.append("there are ");
            buff.append(remoteNodes.length);
            buff.append(" nodes retrieved thru cmd. arg.");
            OLogger.debug((StringBuffer)buff);
            this.dumpList(remoteNodes, "Remote Nodes given thru cmd. arg.");
            return remoteNodes;
        }
        if (remoteNodes == null || remoteNodes.length <= 0 || Rules.shouldCheckRACPrereq()) {
            // empty if block
        }
        buff = new StringBuffer(" No cmd. arg. given, return clusterNodes detected as remoteNodes.");
        OLogger.debug((StringBuffer)buff);
        remoteNodes = clusterNodes;
        return remoteNodes;
    }

    public boolean isCFS(String oracleHomePath, String[] remoteNodes, String localNodeName) {
        StringBuffer buff = new StringBuffer("Rac::isCFS()");
        OLogger.debug((StringBuffer)buff);
        boolean cfs = false;
        try {
            buff = new StringBuffer(" about to call SRVM Cluster::isSharedPath()");
            buff.append(" with oracleHomePath=\"");
            buff.append(oracleHomePath);
            buff.append("\", localNodeName=\"");
            buff.append(localNodeName);
            buff.append("\", remote nodes=");
            for (int i = 0; i < remoteNodes.length; ++i) {
                buff.append("\"");
                buff.append(remoteNodes[i]);
                buff.append("\"");
            }
            OLogger.debug((StringBuffer)buff);
            cfs = Cluster.isSharedPath((String)oracleHomePath, (String[])remoteNodes, (String)localNodeName);
        }
        catch (Exception e) {
            buff = new StringBuffer(" Got a Exception while trying to detect shared FS: \"");
            buff.append(e.getMessage());
            buff.append("\", ignored and assume this is not a shared FS");
            OLogger.debug((StringBuffer)buff);
            OLogger.printStackTrace((Throwable)e);
        }
        catch (Throwable t) {
            buff = new StringBuffer(" Got unknown error while trying to detect shared FS: \"");
            buff.append(t.getMessage());
            buff.append("\", ignored and assume this is not a shared FS");
            OLogger.debug((StringBuffer)buff);
            OLogger.printStackTrace((Throwable)t);
        }
        buff = new StringBuffer("Rac::isCFS() returned ");
        buff.append(cfs);
        OLogger.debug((StringBuffer)buff);
        return cfs;
    }

    static {
        String racSimEnvVar = System.getProperty("OPATCH_RAC_SIMULATION");
        if (racSimEnvVar != null && racSimEnvVar.equalsIgnoreCase("true")) {
            System.out.println("OPARCH_RAC_SIMULATION set to " + racSimEnvVar);
            racSim = true;
        }
    }

    private static class ClusterCmdHolder {
        static final ClusterCmd clusterCmd = new ClusterCmd();

        private ClusterCmdHolder() {
        }
    }
}

