/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.validator;

import java.util.List;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.patchanalyzer.PatchAnalyzer;
import oracle.opatchauto.core.validator.JdkValidatorResult;

public class JdkPatchingValidator {
    public static JdkValidatorResult validate(List<OPatchPatch> patches, String oracleHome) {
        PatchAnalyzer analyzer = new PatchAnalyzer();
        JdkValidatorResult result = new JdkValidatorResult();
        for (OPatchPatch patch : patches) {
            try {
                if (!analyzer.isJDKPatch(patch.getPatchLocation())) continue;
                OACLogger.info("Patch " + patch.getPatchLocation() + " is a jdk patch");
                if (!analyzer.isJavaSessionStartedFromHome(oracleHome)) continue;
                JdkPatchingValidator.updateResult(result, patch, "This Patch is a jdk patch and cannot be applied on " + oracleHome + " when jdk from same path is used for patching.");
            }
            catch (PatchMetadataLoadingException e) {
                JdkPatchingValidator.updateResult(result, patch, "Exception while loading the patch meta data for validating jdk patching: " + e.getMessage());
            }
            catch (InvalidPatchMetadataException e) {
                JdkPatchingValidator.updateResult(result, patch, "Exception while loading the patch for validating jdk patching as the patch meta data is invalid : " + e.getMessage());
            }
            catch (PatchNotFoundException e) {
                JdkPatchingValidator.updateResult(result, patch, "Exception while loading the patch for validating jdk patching as the patch type is invalid: " + e.getMessage());
            }
        }
        if (null != result.getInvalidPatches()) {
            result.setResult("FAILED");
        } else {
            result.setResult("SUCCESSFUL");
        }
        return result;
    }

    private static void updateResult(JdkValidatorResult result, OPatchPatch patch, String errorMessage) {
        result.addInvalidPatches(patch);
        result.setPatchErrorMessage(patch.getPatchId(), errorMessage);
    }
}

