/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.action;

import com.oracle.cie.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.action.ActionResult;
import oracle.opatchauto.core.binary.action.AutoUpdateAnalyzeAction;
import oracle.opatchauto.core.binary.action.BinaryAction;
import oracle.opatchauto.core.binary.action.OnlineAnalyzeAction;
import oracle.opatchauto.core.binary.action.PatchBag;
import oracle.opatchauto.core.binary.action.PatchParamBag;
import oracle.opatchauto.core.binary.systempatch.SystemPatchInformationLoader;

public abstract class CASAction
implements BinaryAction {
    protected void updateSystemPatchInformation(String oracleHome, List<OPatchPatch> patchList, boolean isRollback) {
        SystemPatchInformationLoader instance = SystemPatchInformationLoader.getInstance();
        String systempatchID = instance.getSystemPatchID(patchList, isRollback);
        if (systempatchID != null) {
            ArrayList<String> patchIDList = new ArrayList<String>();
            for (OPatchPatch patch : patchList) {
                patchIDList.add(patch.getPatchId());
            }
            instance.updateSubpatchInformationStore(oracleHome, systempatchID, patchIDList, isRollback);
        }
    }

    protected PatchBag getUpdatedPatchBag(ActionResult actionResult, OPatchContext context) throws OPatchException {
        ArrayList<String> patchLocationList = new ArrayList<String>();
        ArrayList<String> rollbackIDList = new ArrayList<String>();
        ArrayList<OPatchPatch> patchList = new ArrayList<OPatchPatch>();
        List<PatchResult> patchResultList = actionResult.getPatchResultList();
        for (PatchResult result : patchResultList) {
            if (result.getResult() != "SUCCESSFUL") continue;
            if (StringUtil.isNullOrEmpty((String)result.getPatchLocn(), (boolean)true)) {
                OPatchPatch patch = context.getInstalledActivePatch(result.getPatchID());
                if (patch == null) continue;
                patchList.add(patch);
                rollbackIDList.add(result.getPatchID());
                continue;
            }
            String patchLoc = result.getPatchLocn();
            boolean isComposite = OPatchAutoBinaryUtil.isComposite(patchLoc);
            if (isComposite) {
                OPatchPatch[] patchArray = OPatchPatch.getPatches((String)patchLoc);
                patchList.addAll(Arrays.asList(patchArray));
            } else {
                OPatchPatch patch = new OPatchPatch(patchLoc);
                patchList.add(patch);
            }
            patchLocationList.add(result.getPatchLocn());
        }
        PatchBag patchbag = new PatchBag(patchLocationList, rollbackIDList, patchList);
        return patchbag;
    }

    protected ActionResult analyzeAndPreparePatches(OPatchTarget target, PatchingSessionOptions sessionOptions, PatchBag patchbag, boolean isRollBack) {
        BinaryAction analyzeAction = null;
        analyzeAction = sessionOptions.getStopOnPrereqFailure() ? new OnlineAnalyzeAction(isRollBack) : new AutoUpdateAnalyzeAction(isRollBack);
        sessionOptions.setPrepareHome(true);
        PatchParamBag paramBag = new PatchParamBag();
        paramBag.setTarget(target);
        paramBag.setPatchbag(patchbag);
        paramBag.setSessionOptions(sessionOptions);
        ActionResult analyzeResult = analyzeAction.execute(paramBag);
        return analyzeResult;
    }
}

