/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.OJVMHelper;
import oracle.opatch.opatchsdk.OJVMHelperFactory;
import oracle.opatch.opatchsdk.RHPHelper;
import oracle.opatch.opatchsdk.RHPHelperFactory;
import oracle.opatch.opatchsdk.RUHelper;
import oracle.opatch.opatchsdk.RUHelperFactory;
import oracle.opatch.opatchsdk.TwoStageRPHelper;
import oracle.opatch.opatchsdk.TwoStageRPHelperFactory;
import oracle.opatchauto.core.binary.FilterDirectories;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import oracle.opatchauto.core.binary.SessionResults;

public class SessionPatches {
    private ArrayList<String> registeredPatchLocations = new ArrayList();
    private ArrayList<String> registeredParentLocations = new ArrayList();
    private ArrayList<String> rollbackPatchIDs = new ArrayList();

    public static PatchType getPatchType(String patchLocn) {
        if (!OPatchAutoBinaryUtil.checkValidLocn(patchLocn)) {
            OACLogger.info("INVALID: Either this location does not exist or it is not a Directory.");
            return PatchType.ERROR;
        }
        try {
            if (OPatchAutoBinaryUtil.isSystemPatch(patchLocn)) {
                return PatchType.SYSTEM_PATCH;
            }
            if (OPatchAutoBinaryUtil.isComposite(patchLocn)) {
                return PatchType.COMPOSITE;
            }
            if (OPatchAutoBinaryUtil.isOneOff(patchLocn)) {
                return PatchType.ONE_OFF;
            }
        }
        catch (Exception e) {
            return PatchType.ERROR;
        }
        return PatchType.UNKNOWN;
    }

    public static boolean isPatchValid(String patchLocn) {
        boolean isPatchValid = true;
        PatchType patchType = SessionPatches.getPatchType(patchLocn);
        if (patchType == PatchType.ERROR || patchType == PatchType.UNKNOWN) {
            isPatchValid = false;
        }
        return isPatchValid;
    }

    public static ArrayList<String> readParentLocation(String parentLocn) {
        File[] patchDirlist;
        ArrayList<String> completePatchList = new ArrayList<String>();
        File parentDirectory = new File(parentLocn);
        for (File patchDir : patchDirlist = parentDirectory.listFiles(new FilterDirectories())) {
            String patchLocation = "";
            try {
                patchLocation = patchDir.getCanonicalPath();
                PatchType patchType = SessionPatches.getPatchType(patchLocation);
                if (patchType == PatchType.ERROR || patchType == PatchType.UNKNOWN) {
                    OACLogger.info("Unable to detect patch type of \"" + patchLocation + "\". This directory will be ignored.");
                    continue;
                }
                if (PatchType.SYSTEM_PATCH == patchType) {
                    List<String> innerPatches = OPatchAutoBinaryUtil.getSubPatchesInSystemPatch(patchLocation);
                    if (innerPatches.size() < 1) {
                        OACLogger.info("Unable to locate valid patches inside \"" + patchLocation + "\". This directory will be ignored.");
                        continue;
                    }
                    completePatchList.add(patchLocation);
                    continue;
                }
                if (PatchType.ONE_OFF != patchType && PatchType.COMPOSITE != patchType) continue;
                completePatchList.add(patchLocation);
            }
            catch (Exception e) {
                OACLogger.info("Error handling this patch location \"" + patchLocation + "\". This directory will be ignored.");
                OACLogger.printStackTrace(e);
            }
        }
        return completePatchList;
    }

    public static List<String> getAllSubpatches(String patchLocn) {
        List<Object> innerPatches = new ArrayList();
        try {
            PatchType pt = SessionPatches.getPatchType(patchLocn);
            if (pt == PatchType.ERROR || pt == PatchType.UNKNOWN) {
                OACLogger.info("INVALID: Unable to detect patch type of this location: " + patchLocn);
                return new ArrayList<String>();
            }
            if (PatchType.SYSTEM_PATCH == pt) {
                innerPatches = OPatchAutoBinaryUtil.getSubPatchesInSystemPatch(patchLocn);
                if (innerPatches.size() < 1) {
                    OACLogger.info("INVALID: Unable to locate valid patches inside this SystemPatch: " + patchLocn);
                    return new ArrayList<String>();
                }
                return innerPatches;
            }
            if (PatchType.ONE_OFF == pt || PatchType.COMPOSITE == pt) {
                innerPatches.add(patchLocn);
                return innerPatches;
            }
        }
        catch (Exception e) {
            OACLogger.info("ERROR handling this patch location: " + patchLocn);
            OACLogger.printStackTrace(e);
            innerPatches = new ArrayList();
        }
        return innerPatches;
    }

    public static boolean isRHPPatchForApply(String patchLocation) {
        boolean isRHPPatchForApply;
        RHPHelper rhphelper = RHPHelperFactory.getInstance();
        try {
            isRHPPatchForApply = rhphelper.isRHPPatchForPatchApply(patchLocation);
            OACLogger.info("isRHPPatchForApply patchLocation " + patchLocation + " isRHPPatchForApply " + isRHPPatchForApply);
        }
        catch (Exception e) {
            isRHPPatchForApply = false;
            OACLogger.info("Unable to determine RHP Patch for apply " + e.getMessage());
        }
        return isRHPPatchForApply;
    }

    public static boolean isTwoStageRPForApply(String patchLocation) {
        boolean isTwoStageRPForApply = false;
        TwoStageRPHelper rphelper = TwoStageRPHelperFactory.getInstance();
        try {
            isTwoStageRPForApply = rphelper.isTwoStageRollingPatchForPatchApply(patchLocation);
            OACLogger.info("isTwoStageRPForApply patchLocation " + patchLocation + " isTwoStageRollingPatchForPatchApply " + isTwoStageRPForApply);
        }
        catch (Exception e) {
            isTwoStageRPForApply = false;
            OACLogger.info("Unable to determine Two Stage Rolling Patch for apply " + e.getMessage());
        }
        return isTwoStageRPForApply;
    }

    public static boolean isRHPPatchForRollback(String oracleHome, String patchID) {
        boolean isRHPPatchForRollback;
        RHPHelper rhphelper = RHPHelperFactory.getInstance();
        try {
            isRHPPatchForRollback = rhphelper.isRHPPatchForPatchRollback(oracleHome, patchID);
            OACLogger.info("isRHPPatchForRollback patchID " + patchID + " isRHPPatchForRollback " + isRHPPatchForRollback);
        }
        catch (Exception e) {
            isRHPPatchForRollback = false;
            OACLogger.info("Unable to determine RHP Patch for rollback " + e.getMessage());
        }
        return isRHPPatchForRollback;
    }

    public static boolean isTwoStageRPForRollback(String oracleHome, String patchID) {
        boolean isTwoStageRPForRollback = false;
        TwoStageRPHelper twostagerphelper = TwoStageRPHelperFactory.getInstance();
        try {
            isTwoStageRPForRollback = twostagerphelper.isTwoStageRollingPatchForPatchRollback(oracleHome, patchID);
            OACLogger.info("isTwoStageRPForRollback patchID " + patchID + " isTwoStageRPForRollback " + isTwoStageRPForRollback);
        }
        catch (Exception e) {
            isTwoStageRPForRollback = false;
            OACLogger.info("Unable to determine two stage rolling Patch for rollback " + e.getMessage());
        }
        return isTwoStageRPForRollback;
    }

    public static String getRUVersionForRollback(String oracleHome, String patchID) {
        RUHelper ruverhelper = RUHelperFactory.getInstance();
        String strRUVersion = "";
        try {
            strRUVersion = ruverhelper.getRUVersionForPatchRollback(oracleHome, patchID);
            OACLogger.info("RU Version for " + patchID + " is " + strRUVersion);
        }
        catch (Exception e) {
            strRUVersion = "";
            OACLogger.info("Unable to determine RU Version for rollback " + e.getMessage());
        }
        return strRUVersion;
    }

    public static String getRUVersionForApply(String patchLocation) {
        RUHelper ruverhelper = RUHelperFactory.getInstance();
        String strRUVersion = "";
        try {
            strRUVersion = ruverhelper.getRUVersionForPatchApply(patchLocation);
            OACLogger.info("RU Version for " + patchLocation + " is " + strRUVersion);
        }
        catch (Exception e) {
            strRUVersion = "";
            OACLogger.info("Unable to determine RU Version for apply " + e.getMessage());
        }
        return strRUVersion;
    }

    public static boolean isOJVMPatching(String home, boolean rollbackUsingID, boolean rollback, String patchID, String patchLoc, String phBaseDir) {
        String patchPath = SessionPatches.getOJVMPatchPathOrID(home, rollbackUsingID, rollback, patchID, patchLoc, phBaseDir, null);
        return patchPath != null && patchPath.length() > 0;
    }

    public static String getOJVMPatchPathOrID(String home, boolean rollbackUsingID, boolean rollback, String patchID, String patchLoc, String phBaseDir, ArrayList<OPatchPatchInfo> patchList) {
        OJVMHelper ojvmHelper = OJVMHelperFactory.getInstance();
        String patchLocation = patchLoc;
        if (patchList != null && !patchList.isEmpty()) {
            for (OPatchPatchInfo individualPatchInfo : patchList) {
                String individualPatch = individualPatchInfo.getPatchLocation();
                if (rollback) {
                    OACLogger.info("Identifying OJVM for rollback");
                    String pid = individualPatchInfo.getPatchID();
                    if (null == pid) {
                        OACLogger.info("PID is null");
                        if (null != individualPatch) {
                            File patch = new File(individualPatch);
                            pid = patch.getName();
                            OACLogger.info("PID from path is " + pid);
                        } else {
                            OACLogger.info("PID not found");
                            return null;
                        }
                    }
                    OACLogger.info("PID being checked : " + pid);
                    try {
                        if (!ojvmHelper.isOJVMPatchForPatchRollback(home, pid)) continue;
                        return individualPatch;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (!ojvmHelper.isOJVMPatchForPatchApply(individualPatch)) continue;
                return individualPatch;
            }
        }
        return null;
    }

    public static String getFileLocationForPatchApply(String patch, String libName) {
        OJVMHelper ojvmHelper = OJVMHelperFactory.getInstance();
        List locations = ojvmHelper.getFileLocationForPatchApply(patch, libName);
        if (locations != null && locations.size() > 0) {
            return (String)locations.get(0);
        }
        return null;
    }

    public static String getFileLocationForPatchRollback(String home, String libName, String patchID) {
        OJVMHelper ojvmHelper = OJVMHelperFactory.getInstance();
        List locations = ojvmHelper.getFileLocationForPatchRollback(home, libName, patchID);
        if (locations != null && locations.size() > 0) {
            return (String)locations.get(0);
        }
        return null;
    }

    public SessionResults addParentLocn(String parentLocn) {
        File[] patchDirList;
        SessionResults results = new SessionResults();
        if (this.registeredParentLocations.contains(parentLocn)) {
            OACLogger.info("WARNING : This parent location has already been registered: " + parentLocn);
            return results;
        }
        File parentDirectory = new File(parentLocn);
        for (File patchDir : patchDirList = parentDirectory.listFiles(new FilterDirectories())) {
            String patchLocation = "";
            String reason = "";
            try {
                patchLocation = patchDir.getCanonicalPath();
                PatchType pt = SessionPatches.getPatchType(patchLocation);
                if (pt == PatchType.ERROR || pt == PatchType.UNKNOWN) {
                    reason = "Unable to detect patch type of \"" + patchLocation + "\". This directory will be ignored.";
                    OACLogger.info(reason);
                    results.addPatchResult(OPatchAutoBinaryUtil.buildSkippedPR(patchLocation, reason));
                    continue;
                }
                if (PatchType.SYSTEM_PATCH == pt) {
                    List<String> innerPatches = OPatchAutoBinaryUtil.getSubPatchesInSystemPatch(patchLocation);
                    if (innerPatches.size() < 1) {
                        reason = "Unable to locate valid patches inside \"" + patchLocation + "\". This directory will be ignored.";
                        OACLogger.info(reason);
                        results.addPatchResult(OPatchAutoBinaryUtil.buildFailedPR(patchLocation, reason));
                        continue;
                    }
                    SessionResults single = this.addPatch(patchLocation);
                    results.addPatchResults(single.getAllResults());
                    continue;
                }
                if (PatchType.ONE_OFF != pt && PatchType.COMPOSITE != pt) continue;
                SessionResults single = this.addPatch(patchLocation);
                results.addPatchResults(single.getAllResults());
            }
            catch (Exception e) {
                reason = "Error handling this patch location \"" + patchLocation + "\". This directory will be ignored";
                OACLogger.info(reason);
                OACLogger.printStackTrace(e);
                results.addPatchResult(OPatchAutoBinaryUtil.buildFailedPR(patchLocation, reason + ":\n" + e.toString()));
            }
        }
        OACLogger.info("Registered this parent location: " + parentLocn);
        this.registeredParentLocations.add(parentLocn);
        if (results.getSuccessfulPatches().size() < 1) {
            OACLogger.info("WARNING: No VALID patches found inside this parent location: " + parentLocn);
        }
        return results;
    }

    public SessionResults addPatch(String location) {
        String patchLocn = location;
        SessionResults result = new SessionResults();
        if (this.registeredPatchLocations.contains(patchLocn)) {
            String reason = "This patch location has already been registered: " + patchLocn;
            OACLogger.info("WARNING : " + reason);
            result.addPatchResult(OPatchAutoBinaryUtil.buildSkippedPR(patchLocn, reason));
            return result;
        }
        PatchType pt = SessionPatches.getPatchType(patchLocn = this.getAbsolutepath(patchLocn));
        if (pt == PatchType.ERROR || pt == PatchType.UNKNOWN) {
            String reason = "Unable to detect patch type at this location: " + patchLocn;
            OACLogger.info(reason);
            result.addPatchResult(OPatchAutoBinaryUtil.buildSkippedPR(patchLocn, reason));
            return result;
        }
        this.registeredPatchLocations.add(patchLocn);
        OACLogger.console("Patch selected: " + patchLocn + "\n");
        result.addPatchResult(OPatchAutoBinaryUtil.buildSuccessfulPR(patchLocn));
        return result;
    }

    private String getAbsolutepath(String patchLocn) {
        String patchLocation = patchLocn;
        try {
            patchLocation = new File(patchLocation).getCanonicalPath();
        }
        catch (IOException e) {
            patchLocation = new File(patchLocation).getAbsolutePath();
        }
        return patchLocation;
    }

    public List<String> registerRollbackPatchIDs(ArrayList<String> patchIDs) {
        this.rollbackPatchIDs = patchIDs;
        return this.rollbackPatchIDs;
    }

    public List<String> getRegisteredRollbackPatchIDs() {
        return this.rollbackPatchIDs;
    }

    public List<String> getAllRegisteredPatches() {
        return this.registeredPatchLocations;
    }

    public List<String> getAllRegisteredParentLocns() {
        return this.registeredParentLocations;
    }

    public static enum PatchType {
        ONE_OFF,
        COMPOSITE,
        SYSTEM_PATCH,
        ERROR,
        UNKNOWN;

    }
}

