/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.wrappers;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.PatchComponentInfo;
import oracle.opatch.wrappers.PatchComponentInfoWrapper;

public class PatchComponentInfoWrapperImpl
implements PatchComponentInfoWrapper,
PatchComponentInfo {
    private Map<Path, Path> compPatchFiles;
    private ComponentInfo compInfo;

    public PatchComponentInfoWrapperImpl(ComponentInfo compInfo, Map<Path, Path> patchFiles) {
        this.compInfo = compInfo;
        this.compPatchFiles = patchFiles;
    }

    public Map<File, File> getPatchFiles() {
        return PatchComponentInfoWrapperImpl.convertPathsToFiles(this.compPatchFiles);
    }

    @Override
    public String getName() {
        return this.compInfo.getName();
    }

    @Override
    public String getVersion() {
        return this.compInfo.getVersion();
    }

    @Override
    public String getPatchLevel() {
        return this.compInfo.getPatchLevel();
    }

    @Override
    public int getRefCount() {
        return this.compInfo.getRefCount();
    }

    @Override
    public Map<Path, Path> getPatchFilePaths() {
        return this.compPatchFiles;
    }

    private static Map<File, File> convertPathsToFiles(Map<Path, Path> map) {
        HashMap<File, File> fileMap = new HashMap<File, File>();
        for (Map.Entry<Path, Path> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            fileMap.put(entry.getKey().toFile(), entry.getValue().toFile());
        }
        return fileMap;
    }

    @Override
    public PatchComponentInfo getPatchComponentInfo() {
        return this;
    }
}

