/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.opatch.OPatch;
import oracle.opatch.StringResource;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.ClassPathAdder;

public final class OuiLoader {
    public static String loadOUI(String oh, ClassLoader classLoader) throws Exception {
        ClassPathAdder.setCustomClassLoader(classLoader);
        return OuiLoader.loadOUI(oh);
    }

    public static String loadOUI(String oh) throws Exception {
        String oui_loc;
        String glcmPath = OuiLoader.glcmHomeLocation();
        try {
            oui_loc = glcmPath != "" ? OuiLoader.loadOuiFromGlcmHome(oh, glcmPath) : OuiLoader.loadOuiFromOH(oh);
        }
        catch (Exception e2) {
            throw new Exception("Loading jars from GLCM HOME failed.");
        }
        return oui_loc;
    }

    private static String glcmHomeLocation() throws Exception {
        URI uri = OPatch.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        Path pathObj = Paths.get(uri);
        String path = pathObj.toString();
        int slashIndex = path.length();
        for (int i2 = 0; i2 < 3; ++i2) {
            slashIndex = path.lastIndexOf(File.separatorChar, slashIndex - 1);
        }
        String glcmPath = path.substring(0, slashIndex);
        String lastPart = glcmPath.substring(glcmPath.lastIndexOf(File.separator) + 1);
        if (glcmPath != "" && Files.isDirectory(NioServiceFactory.getNioService().getPath(glcmPath, new String[0]), new LinkOption[0]) && lastPart.equals("glcm")) {
            OLogger.justlog(OLogger.INFO, "GLCM Home location: " + glcmPath);
            return glcmPath;
        }
        OLogger.justlog(OLogger.INFO, "GLCM Home is not used.");
        return "";
    }

    private static String loadOuiFromGlcmHome(String oh, String glcmPath) throws Exception {
        Boolean isNg = OuiLoader.isNgHome(oh);
        String oui_loc = isNg != false ? glcmPath + File.separator + "nextgen" + File.separator + "oui" : glcmPath + File.separator + "oui";
        OLogger.justlog(OLogger.INFO, "OUI location is " + oui_loc);
        OuiLoader.loadJarFromOui(oui_loc, isNg);
        return oui_loc;
    }

    private static String loadOuiFromOH(String oh) throws Exception {
        String oui_loc = oh + File.separator + "oui";
        OLogger.justlog(OLogger.INFO, "OUI location is " + oui_loc);
        if (!OuiLoader.isNgHome(oh)) {
            OuiLoader.loadJarFromOui(oui_loc, false);
        }
        return oui_loc;
    }

    private static boolean isNgHome(String oracleHomePath) throws Exception {
        if (OuiLoader.isNextGenHome(oracleHomePath)) {
            OLogger.printlnOnLog(OLogger.INFO, "This oh is ng_home.");
            System.setProperty("isNextGen", "true");
            return true;
        }
        OLogger.printlnOnLog(OLogger.INFO, "This oh isn't ng_home.");
        System.setProperty("isNextGen", "false");
        return false;
    }

    private static boolean isNextGenHome(String oracleHome) {
        if (OuiLoader.checkNextGenComp(oracleHome)) {
            return true;
        }
        return OuiLoader.checkNextGenInventory(oracleHome);
    }

    private static boolean checkNextGenComp(String oracleHome) {
        File installerLaunchJar = new File(oracleHome, "oui/modules/installer-launch.jar");
        try {
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{installerLaunchJar.toURI().toURL()});
            Class<?> clazz = urlClassLoader.loadClass("com.oracle.cie.gdr.external.InventoryFactory");
            if (clazz != null) {
                return true;
            }
        }
        catch (Exception e2) {
            return false;
        }
        return false;
    }

    private static boolean checkNextGenInventory(String oracleHome) {
        try {
            File file = new File(oracleHome, "inventory/distributions");
            if (file.exists() && file.isDirectory()) {
                File[] files = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".xml");
                    }
                });
                for (int i2 = 0; i2 < files.length; ++i2) {
                    String content = new String(Files.readAllBytes(files[i2].toPath()));
                    if (content.indexOf("distribution") <= 0) continue;
                    return true;
                }
            }
        }
        catch (Exception e2) {
            return false;
        }
        return false;
    }

    private static void loadJarFromOui(String oui_loc, Boolean isNg) throws Exception {
        if (isNg.booleanValue()) {
            ClassPathAdder.add(NioServiceFactory.getNioService().getPath(oui_loc + StringResource.OUI_JAR_FROM_NG_HOME, new String[0]));
        } else {
            String[] jars;
            for (String s : jars = StringResource.OUI_JAR_FROM_LEGACY_HOME) {
                ClassPathAdder.add(NioServiceFactory.getNioService().getPath(oui_loc + s, new String[0]));
            }
        }
    }
}

