/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdkv2impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdkv2.IPatch;

public class Patch
implements IPatch {
    private final String upi;
    private final String patchId;
    private final Path location;
    private final List<IPatch> subPatches;
    private final OPatchPatch rawPatch;

    public String getUPI() {
        return this.upi;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public Path getLocation() {
        return this.location;
    }

    public List<IPatch> getSubPatches() {
        return Collections.unmodifiableList(this.subPatches);
    }

    OPatchPatch getRaw() {
        return this.rawPatch;
    }

    public Patch(Builder b2) {
        this.upi = b2.UPI;
        this.patchId = b2.patchId;
        this.location = b2.location;
        this.subPatches = b2.subPatches;
        this.rawPatch = b2.rawPatch;
    }

    public static class Builder {
        private final String UPI;
        private final String patchId;
        private List<IPatch> subPatches = new ArrayList<IPatch>();
        private Path location = null;
        private OPatchPatch rawPatch = null;

        public Builder(String upi, String pid) {
            this.UPI = upi;
            this.patchId = pid;
        }

        public Patch build() {
            return new Patch(this);
        }

        public Builder setSubPatches(List<IPatch> subPatches) {
            this.subPatches = subPatches;
            return this;
        }

        public Builder setLocation(Path location) {
            this.location = location;
            return this;
        }

        public Builder setRaw(OPatchPatch p2) {
            this.rawPatch = p2;
            return this;
        }
    }
}

