/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchlogger;

import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.opatchlogger.ConsoleFormatter;
import oracle.opatch.opatchlogger.OLogger;

public class MyConsoleHandler
extends ConsoleHandler {
    private static ThreadLocal msgThread = new ThreadLocal(){

        protected StringBuffer initialValue() {
            StringBuffer outBuff = new StringBuffer();
            return outBuff;
        }
    };
    static PrintStream myConsoleOutStream = null;
    static PrintStream myConsoleErrStream = null;

    public MyConsoleHandler() {
        if (myConsoleOutStream == null) {
            myConsoleOutStream = new PrintStream(System.out);
        }
        if (myConsoleErrStream == null) {
            myConsoleErrStream = new PrintStream(System.err);
        }
    }

    @Override
    public void publish(LogRecord record) {
        block8: {
            if (this.getFormatter() == null) {
                this.setFormatter(new ConsoleFormatter());
            }
            boolean isFirstThread = OLogger.isFirstThread();
            try {
                if (!this.isLoggable(record)) {
                    return;
                }
                String message = this.getFormatter().format(record);
                if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
                    try {
                        if (OPatchACL.getStateOrder(this, OPatchStateManagerFactory.getInstance().getCurrentState()) != 0 && !OPatchACL.isExitWithUserReq(this)) {
                            String errorMsg = "[ Error during " + OPatchACL.getStateName(this, OPatchStateManagerFactory.getInstance().getCurrentState()) + " Phase]. Detail: ";
                            this.writeMessage(errorMsg, isFirstThread, true);
                        }
                    }
                    catch (IllegalAccessException e2) {
                        // empty catch block
                    }
                    this.writeMessage(message, isFirstThread, true);
                    break block8;
                }
                this.writeMessage(message, isFirstThread, false);
            }
            catch (Exception exception) {
                this.reportError(null, exception, 5);
                return;
            }
        }
    }

    private void writeMessage(String message, boolean isFirstThread, boolean isErrorMessage) {
        try {
            if (isFirstThread) {
                ByteArrayInputStream messageBytes = new ByteArrayInputStream(message.getBytes());
                int readBytes = 0;
                byte[] buffer = new byte[4096];
                while ((readBytes = messageBytes.read(buffer)) > 0) {
                    if (isErrorMessage) {
                        myConsoleErrStream.write(buffer, 0, readBytes);
                    } else {
                        myConsoleOutStream.write(buffer, 0, readBytes);
                    }
                    Arrays.fill(buffer, (byte)0);
                }
            } else {
                ((StringBuffer)msgThread.get()).append(message);
            }
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushToStdOutput() {
        block5: {
            StringBuffer buff = (StringBuffer)msgThread.get();
            try {
                if (buff.toString().equals("")) break block5;
                PrintStream printStream = myConsoleOutStream;
                synchronized (printStream) {
                    myConsoleOutStream.write(buff.toString().getBytes());
                    buff.delete(0, buff.length());
                }
            }
            catch (Exception e2) {
                this.reportError(null, e2, 5);
            }
        }
    }
}

