/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class CheckSOAServer
implements Operation {
    CheckSOAServer() {
    }

    @Override
    public void run(FMWContext c2) {
        OPatchStepAdapter prereqStep = null;
        SOACompositeManager scm = null;
        try {
            scm = c2.getDomain().getSOACompositeManager();
            if (scm == null) {
                prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_SERVER_AVAILABLE);
                prereqStep.setSuccess(false);
                prereqStep.setStepDescription("Check if SOA Server is available");
                prereqStep.setErrorMessage(Logger.getString(RB.Entry.SOA_SERVER_NOT_FOUND, new Object[0]));
                c2.getContextBuilder().setFailedPrereqStep(prereqStep);
                Logger.error(RB.Entry.SOA_SERVER_NOT_FOUND, new Object[0]);
            }
        }
        catch (Throwable e2) {
            String errorMsg = "Error in connecting to SOA Server.";
            if (e2 instanceof ClassNotFoundException || e2 instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " " + "Class \"" + e2.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_SERVER_AVAILABLE);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check if SOA Server is available");
            prereqStep.setErrorMessage(errorMsg);
            prereqStep.setExceptionObject(new RuntimeException(e2));
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        try {
            if (!scm.isSOAPlatformReady()) {
                prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_SERVER_STATUS_READY);
                prereqStep.setSuccess(false);
                prereqStep.setStepDescription("Check if soa-infra is ready to accept requests");
                prereqStep.setErrorMessage("SOA Server/soa-infra is not ready to accept requests.");
                c2.getContextBuilder().setFailedPrereqStep(prereqStep);
                Logger.error(RB.Entry.SOA_SERVER_NOT_READY, new Object[0]);
            } else {
                Logger.logi("The soa-infra application is ready to accept deployment requests.");
            }
        }
        catch (Throwable t) {
            String errorMsg = "Error in executing SOA API while checking if soa-infra is ready to accept requests.";
            if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            OPatchStepAdapter serverReadyStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_SERVER_STATUS_READY);
            serverReadyStep.setSuccess(false);
            serverReadyStep.setStepDescription("Check if soa-infra is ready to accept requests");
            serverReadyStep.setErrorMessage(errorMsg);
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            serverReadyStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(serverReadyStep);
            throw re;
        }
    }
}

