/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStoreHelper;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.StringsubsEngine;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class StringSubsAction
extends OrderedPatchAction {
    private String schemaPath;
    private String configPath;

    public StringSubsAction(PatchComponent patchComponent, String schemaPath, String configPath, int lineNumber) {
        super(patchComponent, lineNumber);
        if (configPath == null || schemaPath == null) {
            String errMsg = "The stringsubs action is null";
            if (configPath == null) {
                errMsg = errMsg + "The stringsubs name is null";
            }
            if (schemaPath == null) {
                errMsg = errMsg + "The stringsubs path is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.schemaPath = schemaPath;
        this.configPath = configPath;
    }

    @Override
    public boolean applicable(String oracleHomePath, String patchLocation) {
        return true;
    }

    @Override
    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        block22: {
            boolean cont;
            String ohLoc;
            StringBuffer buff = new StringBuffer("StringSubsAction::apply()");
            OLogger.debug(buff);
            buff = new StringBuffer("   Process StringSubsAction ");
            buff.append(this.toString());
            OLogger.debug(buff);
            buff = new StringBuffer(" StringSubsAction: schema file=\"");
            buff.append(this.schemaPath);
            buff.append("\", configure file=\"");
            buff.append(this.configPath);
            buff.append("\"");
            OLogger.verbose(this, buff);
            String homeLoc = ohLoc = OPatchEnv.getOracleHome();
            if (OPatchEnv.isCASFlow()) {
                homeLoc = ohLoc + File.separator + ".cas" + File.separator + OPatchEnv.getBranchKey();
            }
            String wlsHomePath = OPatchEnv.getWlsHome();
            if (OPatchEnv.isWindows()) {
                ohLoc = ohLoc.replace(File.separator, "\\\\");
                homeLoc = homeLoc.replace(File.separator, "\\\\");
                if (wlsHomePath != null && !"".equals(wlsHomePath)) {
                    wlsHomePath = wlsHomePath.replace(File.separator, "\\\\");
                }
            }
            if (cont = Rules.SystemWrite_continue()) {
                String propertiesFilePath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath) + File.separator + "var.properties";
                Path propertiesFile = WrapperFactory.getNioServiceWrapper().getPath(propertiesFilePath, new String[0]);
                StringBuilder homeBuff = new StringBuilder();
                PatchObject patchObject = this.getPatchObject();
                try {
                    IObjectStore objectStore;
                    boolean ret;
                    OLogger.printlnOnLog("Property file of string substitution: " + propertiesFilePath);
                    if (Files.exists(propertiesFile, new LinkOption[0])) {
                        Files.delete(propertiesFile);
                    }
                    Files.createFile(propertiesFile, new FileAttribute[0]);
                    OLogger.printlnOnLog("Start creating property file");
                    if (patchObject.getPatchInventory().isCustomStringsubsPropertyFile()) {
                        String patchPropertiesFilePath = OPatchEnv.getPatchPropertiesFilePath(patchObject.getPatchLocation());
                        Path patchPropertiesFile = WrapperFactory.getNioServiceWrapper().getPath(patchPropertiesFilePath, new String[0]);
                        SystemCall.copyFile(patchPropertiesFile, propertiesFile);
                        homeBuff.append("\n");
                    }
                    homeBuff.append("ORACLE_HOME=");
                    homeBuff.append(ohLoc);
                    if (wlsHomePath != null && !"".equals(wlsHomePath)) {
                        homeBuff.append("\n");
                        homeBuff.append("WL_HOME=");
                        homeBuff.append(wlsHomePath);
                    }
                    homeBuff.append("\n");
                    homeBuff.append("OH=");
                    homeBuff.append(homeLoc);
                    OLogger.printlnOnLog("Writing property file with below content: \n" + homeBuff.toString());
                    try {
                        BufferedWriter out = Files.newBufferedWriter(propertiesFile, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                        out.write(homeBuff.toString());
                        out.close();
                    }
                    catch (IOException e2) {
                        RuntimeException re = new RuntimeException(e2);
                        re.setStackTrace(e2.getStackTrace());
                        throw re;
                    }
                    String cookedPatchID = OPatchEnv.getCookedPatchID();
                    String configParentPath = OPatchEnv.getPatchBackupDirectoryPath(homeLoc, cookedPatchID) + File.separator + "etc" + File.separator + "config";
                    this.schemaPath = configParentPath + File.separator + this.schemaPath;
                    this.configPath = configParentPath + File.separator + this.configPath;
                    Path configPathInCasRepo = WrapperFactory.getNioServiceWrapper().getPath(this.configPath, new String[0]);
                    StringsubsEngine engine = new StringsubsEngine(configPathInCasRepo.toFile().getAbsolutePath());
                    String ostoreNamespace = "oracle.glcm.opatch";
                    if (propertiesFilePath != null && ostoreNamespace != null) {
                        ObjectStoreHelper.storeProperties((String)ostoreNamespace, (String)propertiesFile.toFile().getAbsolutePath());
                    }
                    if (!(ret = engine.execute(objectStore = ostoreNamespace != null ? ObjectStoreManager.getObjectStore((String)ostoreNamespace) : null))) {
                        String errMessage = "Failed to do string subtitution.";
                        RuntimeException re = new RuntimeException(errMessage);
                        throw re;
                    }
                    break block22;
                }
                catch (FileNotFoundException e3) {
                    RuntimeException re = new RuntimeException(e3);
                    re.setStackTrace(e3.getStackTrace());
                    throw re;
                }
                catch (IOException e4) {
                    RuntimeException re = new RuntimeException(e4);
                    re.setStackTrace(e4.getStackTrace());
                    throw re;
                }
                catch (StringsubsEngine.StringsubsEngineException e5) {
                    RuntimeException re = new RuntimeException(e5);
                    re.setStackTrace(e5.getStackTrace());
                    throw re;
                }
                finally {
                    try {
                        Files.delete(propertiesFile);
                    }
                    catch (IOException e6) {
                        OLogger.debug(e6.getMessage());
                    }
                }
            }
            buff = new StringBuffer("StringSubsAction::apply() skips do the substitution on the configure file ");
            Path configPathInCasRepo = WrapperFactory.getNioServiceWrapper().getPath(this.configPath, new String[0]);
            buff.append(configPathInCasRepo.toFile().getAbsolutePath());
            OLogger.debug(buff);
        }
    }

    @Override
    public String getApplicableDesc(String oracleHomePath, String owningComponent) {
        return "";
    }

    @Override
    public String getApplyDescription(String oracleHomePath) {
        return "Replace the string subs specified in the patch in the Oracle home.";
    }

    @Override
    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        return true;
    }

    @Override
    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
    }

    @Override
    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return "";
    }

    @Override
    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
    }

    @Override
    public String getRollbackableDesc(String oracleHomePath, String owningComponent) {
        return "";
    }

    @Override
    public String getBackupForRollbackDesc(String oracleHomePath) {
        return "";
    }

    @Override
    public String getRollbackDescription(String oracleHomePath) {
        return "";
    }

    @Override
    public String getChildPath() {
        return "";
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        return "";
    }

    @Override
    public String getActionName() {
        return "StringSubsAction";
    }

    @Override
    public String getActionDesc() {
        return "relace the string subs in the destination.";
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }
}

