/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchFmwEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rac;
import oracle.opatch.Rules;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;

public class EnvValidation {
    public static void validate(String oracleHomePath) {
        EnvValidation.checkAuto();
        if (OPatchEnv.isDBHome(oracleHomePath) && !OPatchEnv.isFullDBCasRepo()) {
            EnvValidation.checkConnectString(oracleHomePath);
        }
    }

    private static void checkAuto() {
        if (OPatchFmwEnv.isAuto() && !OPatchEnv.isOPatchSDKMode()) {
            String autoErrorMsg = OLogger.getString("OUI-67331", new Object[]{"napply"});
            throw new RuntimeException(autoErrorMsg);
        }
    }

    private static void checkConnectString(String oracleHomePath) {
        EnvValidation.validateConnectStringNodes(oracleHomePath);
    }

    private static void validateConnectStringNodes(String oracleHomePath) {
        StringBuffer buff = new StringBuffer();
        Rac.RacType racType = null;
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
        if (!readServices.isInventoryLoaded()) {
            buff.append("NSession needs a non-null Inventory.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        racType = Rules.OUIRead_continue() ? rac.getInstance(readServices, true) : rac.getInstance(null);
        String localNode = racType.getLocalNode();
        String[] remoteNodes = racType.getRemoteNodes();
        OPatchSession.validateConnectStringNodes(localNode, remoteNodes);
    }
}

