/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import java.util.Vector;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NapplyProcessHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.CheckConflictAdapter;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchutil.OUSession;

public class CheckInterConflict {
    private NApplyData data;
    private boolean warn = false;

    public CheckInterConflict(NApplyData data) {
        this.data = data;
    }

    public boolean doInterCheck(String oracleHomePath, NApplyData data) {
        this.getAllRes(oracleHomePath, data);
        PrereqResult.ExecuteStatus interStatus = data.getInterOutput().getResult();
        if (interStatus == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            OLogger.log("Inter-Conflict check NOT EXECUTED", new Object[0]);
            this.processNotExec(data);
        } else if (interStatus == PrereqResult.ExecuteStatus.FAILED) {
            OLogger.log("Inter-Conflict check FAILED", new Object[0]);
            this.processFail(data);
        } else if (interStatus == PrereqResult.ExecuteStatus.PASSED) {
            OLogger.log("Inter-Conflict check PASSED", new Object[0]);
            this.processSucceed(data);
            return true;
        }
        return false;
    }

    public void getAllRes(String oracleHomePath, NApplyData data) {
        StringBuffer dBuff = new StringBuffer("N-Apply: do ");
        dBuff.append(" Inter-conflict (bug and file conflict)");
        OLogger.debug(dBuff);
        OLogger.printlnOnLog("Checking conflicts against Oracle Home...");
        dBuff = new StringBuffer("N-Apply: calling CheckConflictAdapter.checkConflictAgainstOHWithDetail()");
        OLogger.debug(dBuff);
        OneOffEntry[] patchesToApply = data.getPatchesToApply();
        OneOffEntry[] OHOneOffs = null;
        try {
            OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable e2) {
            OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
        }
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        ConflictMatrixOutput interOutput = adapter.checkConflictAgainstOHWithDetail(oracleHomePath, patchesToApply, OHOneOffs);
        data.setInterOutput(interOutput);
        data.setCheckConflictAdapter(adapter);
        OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, data.getInterOutput());
        PrereqResult.ExecuteStatus interStatus = data.getInterOutput().getResult();
        if (interStatus == PrereqResult.ExecuteStatus.PASSED) {
            this.processSucceed(data);
        }
    }

    private void processNotExec(NApplyData data) {
        StringBuffer dBuff = new StringBuffer("N-Apply: PrereqAPI.checkConflictAgainstOHWithDetail()");
        dBuff.append(" returned NOT_EXECUTED.");
        OLogger.debug(dBuff);
        Vector detail = data.getInterOutput().getResultDetails();
        dBuff = new StringBuffer("N-Apply: calling OPatchUtilHelper.processPrereqNotExecuted(detail)");
        dBuff.append(" returned NOT_EXECUTED.");
        OLogger.debug(dBuff);
        NapplyProcessHelper.processPrereqNotExecuted(detail);
    }

    private void processFail(NApplyData data) {
        ConflictMatrixOutput interOutput = data.getInterOutput();
        StringBuffer dBuff = new StringBuffer("N-Apply: PrereqAPI.checkConflictAgainstOHWithDetailSkipMissingComps()");
        dBuff.append(" returned FAILED.");
        OLogger.debug(dBuff);
        CheckConflictAdapter adapter = data.getCheckConflictAdapter();
        if (adapter.isConflictStatusCode()) {
            PrereqSet patchesToBeMerged = new PrereqSet(interOutput.getListOfPatchesToBeMerged());
            OneOffEntry[] patchesCanGo = interOutput.getListOfPatchesThatCanGoNow();
            Vector detail = interOutput.getResultDetails();
            String msg = interOutput.getConflictDetailsString();
            OLogger.println(msg);
            dBuff = new StringBuffer("N-Apply: there is merge request ");
            OLogger.debug(dBuff);
            StringBuffer mergeRequestList = new StringBuffer("");
            OLogger.println("");
            for (int i2 = 0; i2 < patchesToBeMerged.size(); ++i2) {
                mergeRequestList.append("   ");
                String id = patchesToBeMerged.getElement(i2).getID();
                if (data.getModelCode() == 2) {
                    if (patchesToBeMerged.getElement(i2).getPatchType().equals("snowball")) {
                        OLogger.println("Patch \"" + id + "\" is a \"" + "Fusion Applications" + "\" patch.");
                    } else if (patchesToBeMerged.getElement(i2).getPatchType().equals("singleton")) {
                        OLogger.println("Patch \"" + id + "\" is a \"" + "singleton" + "\" patch.");
                    }
                }
                mergeRequestList.append(id);
            }
            OLogger.warn("OUI-67301", new Object[]{mergeRequestList.toString()});
            if (OPatchSessionHelper.hasHotPatch(new PrereqSet(data.getInterOutput().getListOfPatchesToBeMerged()))) {
                OLogger.warn("OUI-67281", new Object[]{OPatchSessionHelper.getHotPatchIDs(new PrereqSet(data.getInterOutput().getListOfPatchesToBeMerged()))});
                OPatchStateManagerFactory.getInstance().setErrorCode(66);
                PrereqFailedException re = new PrereqFailedException("Some Online Patch(es) has conflicts.");
                throw re;
            }
            if (patchesCanGo.length == 0) {
                OPatchStateManagerFactory.getInstance().setErrorCode(66);
                throw new RuntimeException("After skipping conflicting patches, there is no patch to apply.");
            }
            String errorMsg = "Inter-conflict checking failed in apply incoming patches";
            throw new RuntimeException(errorMsg);
        }
        if (!OPatchEnv.isForceConflict()) {
            String msg = interOutput.getConflictDetailsString();
            OLogger.println(msg);
        }
        OLogger.println("");
        throw new RuntimeException(adapter.getPrereqErrorMessage());
    }

    private void processNotNeed(NApplyData data) {
        CheckConflictAdapter adapter = data.getCheckConflictAdapter();
        ConflictMatrixOutput interOutput = data.getInterOutput();
        OneOffEntry[] notNeeds = interOutput.getListOfPatchesNotNeeded();
        ArrayList<OneOffEntry> skipConflicts = adapter.getSkipConflicts();
        ArrayList<OneOffEntry> others = new ArrayList<OneOffEntry>();
        OneOffEntry[] conflicts = interOutput.getListOfPatchesToBeMerged();
        StringBuffer message = new StringBuffer(4096);
        for (OneOffEntry notNeed : notNeeds) {
            if (skipConflicts.contains(notNeed)) continue;
            others.add(notNeed);
        }
        if (skipConflicts.size() > 0 && conflicts.length > 0) {
            for (OneOffEntry oneOff : conflicts) {
                message.append("   ");
                message.append(oneOff.getID());
            }
            OLogger.warn("OUI-67301", new Object[]{message.toString()});
            message.setLength(0);
            message.append("OPatch found that the following patch(es) are not required.\n");
            message.append("Conflict detected and skipped:\n");
            for (OneOffEntry skip : skipConflicts) {
                message.append("   ").append(skip.getID());
            }
            message.append("\n");
            OLogger.println(message.toString());
        }
        if (others.size() > 0) {
            message.setLength(0);
            for (OneOffEntry oneOff : others) {
                message.append("   ");
                message.append(oneOff.getID());
            }
            message.append("\n");
            OLogger.warn("OUI-67302", new Object[]{message.toString()});
        }
    }

    private void processSucceed(NApplyData data) {
        ConflictMatrixOutput interOutput = data.getInterOutput();
        StringBuffer dBuff = new StringBuffer("N-Apply: PrereqAPI.checkConflictAgainstOHWithDetailSkipMissingComps()");
        dBuff.append(" returned PASSED. Update patchesThatCanGoNow.");
        OLogger.debug(dBuff);
        PrereqSet patchesThatCanGoNow = new PrereqSet(interOutput.getListOfPatchesThatCanGoNow());
        PrereqSet patchesNotNeeded = new PrereqSet(interOutput.getListOfPatchesNotNeeded());
        PrereqSet patchesToBeRollback = new PrereqSet(interOutput.getListOfPatchesThatNeedToBeRollback());
        data.setPatchesToApply(patchesThatCanGoNow.getAllElements());
        data.setNotNeedPatches(patchesNotNeeded);
        data.setCanGoPatches(patchesThatCanGoNow);
        data.setRollbackPatches(patchesToBeRollback);
        StringBuffer buff = new StringBuffer("N-Apply: Saving the patches list that can be applied.");
        OLogger.debug(buff);
        data.setApOneOffs(data.getCanGoPatches().getAllElements());
        data.setNotNeedFlag(data.getNotNeedPatches().size() != 0);
        data.setCanGoFlag(data.getCanGoPatches().size() != 0);
        data.setRollbackFlag(data.getRollbackPatches().size() != 0);
        data.setIsComposite(this.hasComposite(patchesThatCanGoNow));
    }

    private void printNotNeed(PrereqSet patchesNotNeeded) {
        StringBuffer dBuff = new StringBuffer("N-Apply: patchesNotNeeded's size > 0 ");
        OLogger.debug(dBuff);
        StringBuffer buff1 = new StringBuffer("");
        StringBuffer buff2 = new StringBuffer("");
        String msg = "";
        boolean composite = false;
        for (int i2 = 0; i2 < patchesNotNeeded.size(); ++i2) {
            buff1.append("   ");
            buff2.append("   ");
            if (patchesNotNeeded.getElement(i2).getIsComposite()) {
                composite = true;
                buff1.append(patchesNotNeeded.getElement(i2).getID());
            }
            buff2.append(patchesNotNeeded.getElement(i2).getID());
        }
        if (composite) {
            OLogger.println(OLogger.getString("OUI-67905"));
            return;
        }
        OLogger.warn("OUI-67302", new Object[]{buff2.toString()});
    }

    private boolean hasComposite(PrereqSet list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.getElement(i2).getIsComposite()) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonComposite(PrereqSet list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.getElement(i2).getIsComposite()) continue;
            return true;
        }
        return false;
    }
}

