/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;

public class InstalledComponent
implements Cloneable,
Comparable {
    private String id;
    private String name;
    private String desc;
    private String[] versions = new String[0];
    private String highestVersion;
    private Vector langs = new Vector();
    private OiiiCompInstallID compInstallID;
    private OiiiInstallCompInvEntry compInvEntry;
    private boolean isTopLevel = false;

    public InstalledComponent(String product, String[] versions, boolean isTopLevel) {
        this.name = product;
        this.versions = versions;
        this.isTopLevel = isTopLevel;
    }

    private InstalledComponent(String id, String name, String desc, String[] versions, OiiiCompInstallID compInst, OiiiInstallCompInvEntry compInvEntry, boolean isTopLevel) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.compInstallID = compInst;
        this.compInvEntry = compInvEntry;
        this.isTopLevel = isTopLevel;
        this.versions = versions;
    }

    public InstalledComponent(OiiiInstallCompInvEntry compInvEntry) throws NullPointerException {
        if (compInvEntry == null) {
            throw new NullPointerException("InstalledComponent::InstallComponent(OiiiCompInvEntry) got a null param.");
        }
        this.compInvEntry = compInvEntry;
        this.compInstallID = compInvEntry.getCompInstallID();
        if (this.compInstallID == null) {
            throw new NullPointerException("InstalledComponent::InstallComponent(OiiiCompInvEntry) got a null OiiiCompInstallID object.");
        }
        this.name = compInvEntry.getName();
        this.desc = compInvEntry.getDescription();
        this.id = this.compInstallID != null ? this.compInstallID.getName() : null;
        this.isTopLevel = compInvEntry.isTopLevel();
        this.langs = compInvEntry.getLanguages();
        OiiiVersion ver = null;
        ver = this.compInstallID != null ? this.compInstallID.getVersion() : null;
        this.highestVersion = ver.getVerString();
        this.versions = new String[1];
        String string = this.versions[0] = ver != null ? ver.getVerString() : null;
        if (this.name == null || this.desc == null || this.versions[0] == null || this.id == null) {
            StringBuffer buff = new StringBuffer("InstalledComponent::InstallComponent(OiiiCompInvEntry): ");
            buff.append(" either name, id, ver, desc is null: ");
            buff.append(this.name);
            buff.append(", ");
            buff.append(this.id);
            buff.append(", ");
            buff.append(this.versions[0]);
            buff.append(", ");
            buff.append(this.desc);
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
    }

    public OiiiCompInstallID getCompInstallID() {
        return this.compInstallID;
    }

    public OiiiInstallCompInvEntry getCompInvEntry() {
        return this.compInvEntry;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Vector getLanguages() {
        return this.langs;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getVersion() {
        return this.versions[0];
    }

    public String getHighestVersion() {
        return this.highestVersion;
    }

    public String[] getVersions() {
        return this.versions;
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    public String getTopLevelDesc() {
        if (this.isTopLevel) {
            return "true";
        }
        return "false";
    }

    public int compareTo(Object obj) {
        if (obj instanceof InstalledComponent) {
            InstalledComponent ic = (InstalledComponent)obj;
            String itsName = ic.getName();
            String itsVer = ic.getVersion();
            String myName = this.getName();
            String myVer = this.getVersion();
            int ret = (myName = myName.toUpperCase()).compareTo(itsName = itsName.toUpperCase());
            if (ret == 0) {
                return myVer.compareTo(itsVer);
            }
            return ret;
        }
        return -1;
    }

    public Object clone() {
        OiiiInstallCompInvEntry compInvEntry = (OiiiInstallCompInvEntry)this.compInvEntry.clone();
        InstalledComponent c2 = new InstalledComponent(compInvEntry);
        return c2;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[InstalledComponent: id= ");
        buff.append(this.id);
        buff.append(", name= ");
        buff.append(this.name);
        buff.append(", top-level= ");
        buff.append(this.isTopLevel);
        buff.append(", desc = ");
        buff.append(this.desc);
        buff.append(", versions = (");
        for (int i2 = 0; i2 < this.versions.length; ++i2) {
            String v = this.versions[i2];
            buff.append(v);
            buff.append(", ");
        }
        buff.append(")");
        buff.append("]");
        return buff.toString();
    }

    public static InstalledComponent[] mergeComponents(InstalledComponent[] comps) {
        try {
            TreeMap<String, InstalledComponent> tree = new TreeMap<String, InstalledComponent>();
            for (int i2 = 0; i2 < comps.length; ++i2) {
                InstalledComponent c2 = comps[i2];
                String id = c2.getID();
                if (tree.containsKey(id)) {
                    int j2;
                    InstalledComponent iden = (InstalledComponent)tree.get(id);
                    String[] idenVersions = iden.getVersions();
                    String[] thisVersions = c2.getVersions();
                    int idenLen = idenVersions.length;
                    int thisLen = thisVersions.length;
                    String idenHighestVer = idenVersions[idenLen - 1];
                    String thisHighestVer = thisVersions[thisLen - 1];
                    InstalledComponent highestComp = c2;
                    if (idenHighestVer.compareTo(thisHighestVer) > 0) {
                        highestComp = iden;
                    }
                    String name = highestComp.getName();
                    String desc = highestComp.getDesc();
                    OiiiCompInstallID compInst = highestComp.getCompInstallID();
                    OiiiInstallCompInvEntry compInvEntry = highestComp.getCompInvEntry();
                    boolean isTopLevel = highestComp.isTopLevel();
                    int totalLen = idenLen + thisLen;
                    Object[] newVersions = new String[totalLen];
                    for (j2 = 0; j2 < idenLen; ++j2) {
                        newVersions[j2] = idenVersions[j2];
                    }
                    for (j2 = 0; j2 < thisLen; ++j2) {
                        newVersions[idenLen + j2] = thisVersions[j2];
                    }
                    Arrays.sort(newVersions);
                    InstalledComponent newComp = new InstalledComponent(id, name, desc, (String[])newVersions, compInst, compInvEntry, isTopLevel);
                    tree.remove(id);
                    tree.put(id, newComp);
                    continue;
                }
                tree.put(id, c2);
            }
            int size = tree.size();
            if (size == comps.length) {
                return comps;
            }
            comps = new InstalledComponent[size];
            Set set = tree.entrySet();
            Iterator iter = set.iterator();
            int i3 = 0;
            while (iter.hasNext()) {
                InstalledComponent c3;
                Map.Entry me = iter.next();
                comps[i3] = c3 = (InstalledComponent)me.getValue();
                ++i3;
            }
        }
        finally {
            return comps;
        }
        {
        }
    }

    public static void main(String[] args) {
    }
}

