/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchComponent;
import oracle.opatch.conflicttextualinterpreter.CompositePatchCategorizer;
import oracle.opatch.conflicttextualinterpreter.ConflictMap;
import oracle.opatch.conflicttextualinterpreter.ConflictMapBuilderUtil;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IConflictMapBuilder;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelationDefinition;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.conflicttextualinterpreter.Patch;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccEngine;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccException;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccPatchImpl;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchlevel.CheckPatchLevel;
import oracle.opatch.patchlevel.FileVersion;
import oracle.opatch.patchlevel.PatchLevelRelation;

public final class ConflictMapBuilder
implements IConflictMapBuilder {
    private static IConflictMapBuilder conflictMapBuilder;
    private final int DEFAULT_BUGS_SIZE = 64;
    private final int DEFAULT_FILES_SIZE = 512;
    private HashMap<String, HashSet<IPatch>> checkBugsMap;
    private TreeMap<String, HashSet<IPatch>> checkFilesMap;
    private TreeMap<String, HashSet<IPatch>> containerActionMap;
    private TreeMap<String, HashSet<IPatch>> copyActionMap;
    private HashMap<String, HashSet<IPatch>> bugConflictsMap;
    private HashMap<String, HashSet<IPatch>> fileConflictMap;
    private Collection<IPatch> oldPi;
    private boolean container = false;
    private boolean dirContainer = false;

    public static IConflictMapBuilder getInstance() {
        if (conflictMapBuilder == null) {
            conflictMapBuilder = new ConflictMapBuilder();
        }
        return conflictMapBuilder;
    }

    private ConflictMapBuilder() {
    }

    private void collectContainerDir(String file, IPatch patch) {
        if (!file.endsWith("!@!")) {
            return;
        }
        String dir = file.substring(0, file.length() - 3);
        Set<Map.Entry<String, HashSet<IPatch>>> filesSet = this.checkFilesMap.entrySet();
        Iterator<Map.Entry<String, HashSet<IPatch>>> filesIter = filesSet.iterator();
        String newFile = "";
        HashMap temp = new HashMap();
        while (filesIter.hasNext()) {
            HashSet<IPatch> tempPatchIds;
            Map.Entry<String, HashSet<IPatch>> fileEntry = filesIter.next();
            String key = fileEntry.getKey();
            if (dir.length() != key.length() && key.startsWith(dir + File.separator)) {
                newFile = new String(key);
                this.dirContainer = true;
                this.checkFilesMap.get(newFile).add(patch);
                if (temp.containsKey(dir)) continue;
                tempPatchIds = new HashSet<IPatch>();
                for (IPatch tmp : this.checkFilesMap.get(newFile)) {
                    tempPatchIds.add(tmp);
                }
                temp.put(dir, tempPatchIds);
                continue;
            }
            if (dir.length() == key.length() || !dir.startsWith(key + File.separator)) continue;
            newFile = dir.substring(0, key.length());
            this.dirContainer = true;
            this.checkFilesMap.get(newFile).add(patch);
            if (temp.containsKey(dir)) continue;
            tempPatchIds = new HashSet();
            for (IPatch tmp : this.checkFilesMap.get(newFile)) {
                tempPatchIds.add(tmp);
            }
            temp.put(file, tempPatchIds);
        }
        Set tempSet = temp.entrySet();
        for (Map.Entry tEntry : tempSet) {
            String key = (String)tEntry.getKey();
            HashSet<IPatch> addPatchIds = new HashSet<IPatch>();
            for (IPatch t : (HashSet)temp.get(key)) {
                addPatchIds.add(t);
            }
            this.checkFilesMap.put(dir, addPatchIds);
            if (!dir.contains(":")) {
                this.copyActionMap.put(dir, addPatchIds);
                continue;
            }
            this.containerActionMap.put(dir, addPatchIds);
        }
    }

    private void collectContainerFilesMap(String file, IPatch patch) {
        SortedMap<String, HashSet<IPatch>> subMap;
        if (!(file.endsWith(".a") || file.endsWith(".o") || file.endsWith(".class") || file.endsWith(".jar") || file.endsWith(".ear") || file.endsWith(".war"))) {
            return;
        }
        boolean copyActionFile = false;
        if (!file.contains(":")) {
            copyActionFile = true;
            subMap = this.containerActionMap.subMap("", file + '\uffff');
        } else {
            subMap = this.copyActionMap.subMap("", file + '\uffff');
        }
        String newFile = "";
        boolean copyOnly = false;
        String shortString = "";
        String longString = "";
        HashMap temp = new HashMap();
        for (String key : subMap.keySet()) {
            if (copyActionFile && !key.contains(":")) {
                copyOnly = true;
            }
            if (!copyOnly && file.length() != key.length()) {
                if (file.length() > key.length()) {
                    shortString = key;
                    longString = file;
                } else {
                    shortString = file;
                    longString = key;
                }
                if (longString.startsWith(shortString)) {
                    newFile = new String(key);
                    this.container = true;
                    this.checkFilesMap.get(newFile).add(patch);
                    if (!temp.containsKey(file)) {
                        HashSet<IPatch> tempPatchIds = new HashSet<IPatch>();
                        for (IPatch tmp : this.checkFilesMap.get(newFile)) {
                            tempPatchIds.add(tmp);
                        }
                        temp.put(file, tempPatchIds);
                    }
                }
            }
            copyOnly = false;
        }
        Set tempSet = temp.entrySet();
        for (Map.Entry tEntry : tempSet) {
            String key = (String)tEntry.getKey();
            HashSet<IPatch> addPatchIds = new HashSet<IPatch>();
            for (IPatch t : (HashSet)temp.get(key)) {
                addPatchIds.add(t);
            }
            this.checkFilesMap.put(file, addPatchIds);
            if (!file.contains(":")) {
                this.copyActionMap.put(file, addPatchIds);
                continue;
            }
            this.containerActionMap.put(file, addPatchIds);
        }
    }

    private void collectBugsAndFilesMap(Collection<IPatch> pis, boolean fromOH) {
        for (IPatch patch : pis) {
            Set<String> bugs = patch.getBugs();
            Set<String> files = patch.getFiles();
            for (String bug : bugs) {
                if (fromOH && this.checkBugsMap.containsKey(bug)) {
                    this.checkBugsMap.get(bug).add(patch);
                    continue;
                }
                if (fromOH) continue;
                if (this.checkBugsMap.containsKey(bug)) {
                    this.checkBugsMap.get(bug).add(patch);
                    continue;
                }
                HashSet<IPatch> belongPatchIds = new HashSet<IPatch>();
                belongPatchIds.add(patch);
                this.checkBugsMap.put(bug, belongPatchIds);
            }
            String sessionType = OPatchEnv.getSessionType();
            if (sessionType.equals("lsinventory") || sessionType.equals("lspatches") || sessionType.equals("lsinv")) continue;
            for (String file : files) {
                String fileOrDir = "";
                if (fromOH) {
                    fileOrDir = file.endsWith("!@!") ? file.substring(0, file.length() - 3) : file;
                    if (this.checkFilesMap.containsKey(fileOrDir)) {
                        this.checkFilesMap.get(fileOrDir).add(patch);
                    }
                    this.collectContainerFilesMap(fileOrDir, patch);
                    if (!file.endsWith("!@!")) continue;
                    this.collectContainerDir(file, patch);
                    continue;
                }
                if (fromOH) continue;
                fileOrDir = file.endsWith("!@!") ? file.substring(0, file.length() - 3) : file;
                if (this.checkFilesMap.containsKey(fileOrDir)) {
                    this.checkFilesMap.get(fileOrDir).add(patch);
                }
                this.collectContainerFilesMap(fileOrDir, patch);
                if (file.endsWith("!@!")) {
                    this.collectContainerDir(file, patch);
                }
                if (this.checkFilesMap.containsKey(fileOrDir)) continue;
                HashSet<IPatch> belongPatchIds = new HashSet<IPatch>();
                belongPatchIds.add(patch);
                this.checkFilesMap.put(fileOrDir, belongPatchIds);
                if (!fileOrDir.contains(":")) {
                    this.copyActionMap.put(fileOrDir, belongPatchIds);
                    continue;
                }
                this.containerActionMap.put(fileOrDir, belongPatchIds);
            }
        }
    }

    private void initConflictMapBuilder(Collection<IPatch> pis) {
        if (this.oldPi == null) {
            this.checkBugsMap = new HashMap(pis.size() * 64);
            this.checkFilesMap = new TreeMap();
            this.bugConflictsMap = new HashMap(pis.size());
            this.fileConflictMap = new HashMap(pis.size());
            this.containerActionMap = new TreeMap();
            this.copyActionMap = new TreeMap();
            this.collectBugsAndFilesMap(pis, false);
        } else if (this.oldPi != pis) {
            this.checkBugsMap.clear();
            this.checkFilesMap.clear();
            this.bugConflictsMap.clear();
            this.fileConflictMap.clear();
            this.containerActionMap.clear();
            this.copyActionMap.clear();
            this.collectBugsAndFilesMap(pis, false);
        }
        this.oldPi = pis;
    }

    private boolean canIgnoreConflict(IPatch pi, IPatch pc) {
        boolean ignore = pi.getOverlaysID().contains(pc.getPatchId());
        if (!ignore && pi.isComposite()) {
            ignore = pc.getOverlaysID().contains(pi.getPatchId());
        }
        if (!ignore && pi.getPatchId().equals(pc.getPatchId())) {
            ignore = true;
        }
        return ignore;
    }

    private void buildBugsConflict(Collection<IPatch> pis, ConflictMap conflictMap, boolean inter) {
        for (IPatch pi : pis) {
            HashSet<IPatch> conflictPatches;
            String tripletId = pi.getTripletId();
            Set<String> bugs = pi.getBugs();
            for (String bug : bugs) {
                conflictPatches = this.checkBugsMap.get(bug);
                if (conflictPatches.size() <= 1) continue;
                if (this.bugConflictsMap.containsKey(tripletId)) {
                    this.bugConflictsMap.get(tripletId).addAll(conflictPatches);
                    continue;
                }
                this.bugConflictsMap.put(tripletId, new HashSet(this.checkBugsMap.get(bug)));
            }
            if (!this.bugConflictsMap.containsKey(tripletId)) continue;
            conflictPatches = this.bugConflictsMap.get(tripletId);
            for (IPatch conflictPatch : conflictPatches) {
                if (conflictPatch == pi || pi.isComposite() && conflictPatch.isComposite() || conflictPatch.isInOh() && conflictPatch.getPatchId().equals(pi.getPatchId())) continue;
                if (OPatchEnv.isCUPSupported()) {
                    if (conflictPatch.getOneOffEntry().getSupersetPatchIDs().contains(pi.getPatchId())) {
                        conflictMap.addGenericRelation(pi, conflictPatch, NPatchRelationDefinition.RelationDefinition.SUPERSET);
                        conflictMap.addGenericRelation(conflictPatch, pi, NPatchRelationDefinition.RelationDefinition.SUBSET);
                        continue;
                    }
                    if (pi.getOneOffEntry().getSupersetPatchIDs().contains(conflictPatch.getPatchId())) {
                        conflictMap.addGenericRelation(conflictPatch, pi, NPatchRelationDefinition.RelationDefinition.SUPERSET);
                        conflictMap.addGenericRelation(pi, conflictPatch, NPatchRelationDefinition.RelationDefinition.SUBSET);
                        continue;
                    }
                    if (Arrays.asList(conflictPatch.getOneOffEntry().getOverLayPatchIDs()).contains(pi.getPatchId()) || Arrays.asList(pi.getOneOffEntry().getOverLayPatchIDs()).contains(conflictPatch.getPatchId())) continue;
                }
                HashSet<String> sameBugs = new HashSet<String>(pi.getBugs());
                sameBugs.retainAll(conflictPatch.getBugs());
                int piLen = pi.getBugs().size();
                int pcLen = conflictPatch.getBugs().size();
                int prLen = sameBugs.size();
                if (prLen > 0 && prLen < piLen && prLen < pcLen) {
                    NPatchRelations relations = conflictMap.getRelations(pi);
                    if (relations.isGenericRelation(conflictPatch)) continue;
                    ArrayList<String> sameBugsArr = new ArrayList<String>(sameBugs);
                    conflictMap.addConflictRelation(pi, conflictPatch, true, sameBugsArr);
                    if (!conflictPatch.isInOh()) continue;
                    conflictMap.addConflictRelation(conflictPatch, pi, true, sameBugsArr);
                    continue;
                }
                if (prLen <= 0) continue;
                ArrayList<String> sameBugsArr = new ArrayList<String>(sameBugs);
                if (piLen > pcLen) {
                    conflictMap.addSupersetRelation(pi, conflictPatch, sameBugsArr);
                    if (!conflictPatch.isInOh()) continue;
                    conflictMap.addSubsetRelation(conflictPatch, pi, sameBugsArr);
                    continue;
                }
                if (piLen >= pcLen) continue;
                conflictMap.addSubsetRelation(pi, conflictPatch, sameBugsArr);
                if (!conflictPatch.isInOh()) continue;
                conflictMap.addSupersetRelation(conflictPatch, pi, sameBugsArr);
            }
        }
    }

    private void buildFilesConflict(Collection<IPatch> pis, ConflictMap conflictMap, boolean inter) {
        for (IPatch pi : pis) {
            HashSet<IPatch> conflictPatches;
            String tripletId = pi.getTripletId();
            Set<String> files = pi.getFiles();
            for (String file : files) {
                String trueFile = "";
                trueFile = file.endsWith("!@!") ? file.substring(0, file.length() - 3) : file;
                conflictPatches = this.checkFilesMap.get(trueFile);
                if (conflictPatches.size() <= 1) continue;
                if (this.fileConflictMap.containsKey(tripletId)) {
                    this.fileConflictMap.get(tripletId).addAll(conflictPatches);
                    continue;
                }
                this.fileConflictMap.put(tripletId, new HashSet(this.checkFilesMap.get(trueFile)));
            }
            if (!this.fileConflictMap.containsKey(tripletId)) continue;
            conflictPatches = this.fileConflictMap.get(tripletId);
            for (IPatch conflictPatch : conflictPatches) {
                NPatchRelations relations;
                int prLen;
                boolean conflict;
                if (conflictPatch == pi || pi.isComposite() && conflictPatch.isComposite()) continue;
                if (OPatchEnv.isCUPSupported()) {
                    if (conflictPatch.getOneOffEntry().getSupersetPatchIDs().contains(pi.getPatchId())) {
                        conflictMap.addGenericRelation(pi, conflictPatch, NPatchRelationDefinition.RelationDefinition.SUPERSET);
                        conflictMap.addGenericRelation(conflictPatch, pi, NPatchRelationDefinition.RelationDefinition.SUBSET);
                        continue;
                    }
                    if (pi.getOneOffEntry().getSupersetPatchIDs().contains(conflictPatch.getPatchId())) {
                        conflictMap.addGenericRelation(conflictPatch, pi, NPatchRelationDefinition.RelationDefinition.SUPERSET);
                        conflictMap.addGenericRelation(pi, conflictPatch, NPatchRelationDefinition.RelationDefinition.SUBSET);
                        continue;
                    }
                    if (Arrays.asList(conflictPatch.getOneOffEntry().getOverLayPatchIDs()).contains(pi.getPatchId()) || Arrays.asList(pi.getOneOffEntry().getOverLayPatchIDs()).contains(conflictPatch.getPatchId())) continue;
                }
                HashSet<String> sameFiles = new HashSet<String>(pi.getFiles());
                sameFiles.retainAll(conflictPatch.getFiles());
                if (this.container || this.dirContainer) {
                    Set<String> myFiles = pi.getFiles();
                    Iterator iter = sameFiles.iterator();
                    HashSet<String> needToAdd = new HashSet<String>();
                    while (iter.hasNext()) {
                        String file = (String)iter.next();
                        if (!file.endsWith("!@!")) continue;
                        String trueFile = file.substring(0, file.length() - 3);
                        iter.remove();
                        needToAdd.add(trueFile);
                    }
                    if (needToAdd.size() > 0) {
                        sameFiles.addAll(needToAdd);
                    }
                    for (String myFile : myFiles) {
                        String myTrueFile = "";
                        myTrueFile = myFile.endsWith("!@!") ? myFile.substring(0, myFile.length() - 3) : myFile;
                        Set myPatches = this.checkFilesMap.get(myTrueFile);
                        if (!myPatches.contains(pi) || !myPatches.contains(conflictPatch)) continue;
                        if (myTrueFile.endsWith(".o") || myTrueFile.endsWith(".class") || myFile.endsWith("!@!")) {
                            for (String conflictfile : conflictPatch.getFiles()) {
                                if (conflictfile.endsWith("!@!")) {
                                    conflictfile = conflictfile.substring(0, conflictfile.length() - 3);
                                }
                                if (conflictfile.length() == myTrueFile.length() || !myTrueFile.startsWith(conflictfile)) continue;
                                sameFiles.add(myTrueFile);
                            }
                            continue;
                        }
                        sameFiles.add(myTrueFile);
                    }
                }
                if (OPatchEnv.isCUPSupported() && !(conflict = this.checkFileVersionConflict(sameFiles, pi, conflictPatch, inter)) || (prLen = sameFiles.size()) <= 0 || (relations = conflictMap.getRelations(pi)).isGenericRelation(conflictPatch)) continue;
                OLogger.debug("Files conflict detected. Trigger CBCC check.");
                boolean cbccResolved = this.cbccCheck(sameFiles, pi, conflictPatch);
                if (relations.isConflictOf(conflictPatch)) {
                    if (!cbccResolved) continue;
                    OLogger.justlog(OLogger.INFO, "Bugs/files conflict detected, CBCC resolved.");
                    this.clearConflictRelation(conflictMap, pi, conflictPatch);
                    continue;
                }
                if (cbccResolved) {
                    OLogger.justlog(OLogger.INFO, "Files conflict detected, CBCC resolved.");
                    continue;
                }
                ArrayList<String> sameFilesArr = new ArrayList<String>(sameFiles);
                conflictMap.addConflictRelation(pi, conflictPatch, false, sameFilesArr);
                if (!conflictPatch.isInOh()) continue;
                conflictMap.addConflictRelation(conflictPatch, pi, false, sameFilesArr);
            }
        }
    }

    private boolean checkFileVersionConflict(Set<String> sameFiles, IPatch pi, IPatch conflictPatch, boolean inter) {
        Iterator<String> iter = sameFiles.iterator();
        boolean conflict = false;
        HashSet<String> fileSameVersion = new HashSet<String>();
        OLogger.debug("CUP_LOG: Number of overlapped files between: " + pi.getPatchId() + " and: " + conflictPatch.getPatchId() + " before checking file version: " + sameFiles.size());
        while (iter.hasNext()) {
            String file = iter.next();
            CopyAction piCA = this.getCopyAction(pi, file);
            FileVersion piFV = null;
            if (piCA != null) {
                piFV = piCA.getFileVersionObject();
            }
            CopyAction conflictPatchPA = this.getCopyAction(conflictPatch, file);
            FileVersion conflictPatchFV = null;
            if (conflictPatchPA != null) {
                conflictPatchFV = conflictPatchPA.getFileVersionObject();
            }
            if (piFV != null && piFV.getPl() != null && conflictPatchFV != null && conflictPatchFV.getPl() != null) {
                if (piFV.getPl().compare(conflictPatchFV.getPl()) == PatchLevelRelation.SAME) {
                    if (piFV.getPatchSubType().equalsIgnoreCase("update") && conflictPatchFV.getPatchSubType().equalsIgnoreCase("upgrade")) {
                        fileSameVersion.add(file);
                        if (!inter) continue;
                        if (!pi.isPoh()) {
                            piCA.setCopyFlagBasedOnFileVersion(true);
                            OLogger.printlnOnLog("CUP_LOG: Pi PLO patch:" + pi.getPatchId() + " and CUP patch:" + conflictPatch.getPatchId() + " have overlapped file:" + file + " with same file version:" + piFV.getPl().toString() + " . No conlfict. Do copy");
                            continue;
                        }
                        piCA.setCopyFlagBasedOnFileVersion(false);
                        OLogger.printlnOnLog("CUP_LOG: Poh PLO patch:" + pi.getPatchId() + " and poh CUP patch:" + conflictPatch.getPatchId() + " have overlapped file:" + file + " with same file version:" + piFV.getPl().toString() + " . No conlfict. No copy");
                        continue;
                    }
                    if (piFV.getPatchSubType().equalsIgnoreCase("upgrade") && conflictPatchFV.getPatchSubType().equalsIgnoreCase("update")) {
                        fileSameVersion.add(file);
                        if (!inter) continue;
                        if (!pi.isPoh() && conflictPatch.isPoh()) {
                            piCA.setCopyFlagBasedOnFileVersion(false);
                            OLogger.printlnOnLog("CUP_LOG: Pi CUP patch:" + pi.getPatchId() + " and poh PLO patch:" + conflictPatch.getPatchId() + " have overlapped file:" + file + " with same file version:" + piFV.getPl().toString() + " . No conlfict. No copy");
                            continue;
                        }
                        if (!pi.isPoh() && !conflictPatch.isPoh()) {
                            piCA.setCopyFlagBasedOnFileVersion(true);
                            OLogger.printlnOnLog("CUP_LOG: Pi CUP patch:" + pi.getPatchId() + " and pi PLO patch:" + conflictPatch.getPatchId() + " have overlapped file:" + file + " with same file version:" + piFV.getPl().toString() + " . No conlfict. Do copy(PLO file will overwrite this one later)");
                            continue;
                        }
                        piCA.setCopyFlagBasedOnFileVersion(false);
                        OLogger.printlnOnLog("CUP_LOG: Poh CUP patch:" + pi.getPatchId() + " and poh PLO patch:" + conflictPatch.getPatchId() + " have overlapped file:" + file + " with same file version:" + piFV.getPl().toString() + " . No conlfict. No copy");
                        continue;
                    }
                    if (piFV.getPatchSubType().equalsIgnoreCase("upgrade") && conflictPatchFV.getPatchSubType().equalsIgnoreCase("upgrade")) {
                        fileSameVersion.add(file);
                        if (!inter) continue;
                        if (OPatchEnv.isFileAlreadyCopied(file)) {
                            piCA.setCopyFlagBasedOnFileVersion(false);
                            OLogger.printlnOnLog("CUP_LOG: CUP patch:" + pi.getPatchId() + " and other CUP patch:" + conflictPatch.getPatchId() + " have overlapped file:" + file + " with same file version:" + piFV.getPl().toString() + " . No conlfict. No copy(Already copied");
                            continue;
                        }
                        piCA.setCopyFlagBasedOnFileVersion(true);
                        OPatchEnv.addFileAlreadyCopied(file);
                        OLogger.printlnOnLog("CUP_LOG: CUP patch:" + pi.getPatchId() + " and other CUP patch:" + conflictPatch.getPatchId() + " have overlapped file:" + file + " with same file version:" + piFV.getPl().toString() + " . No conlfict. Doo copy(Copy one time");
                        continue;
                    }
                    conflict = true;
                    OLogger.printlnOnLog("CUP_LOG: Patch:" + pi.getPatchId() + " and other patch:" + conflictPatch.getPatchId() + " have overlapped file:" + file + " with same file version:" + piFV.getPl().toString() + " but it's still a file conflict (like both PLO have overlapped file with same file version");
                    continue;
                }
                conflict = true;
                OLogger.printlnOnLog("CUP_LOG: Patch:" + pi.getPatchId() + " and other patch:" + conflictPatch.getPatchId() + " have overlapped file:" + file + " with different file version:" + piFV.getPl().toString() + " and " + conflictPatchFV.getPl().toString() + " and it's a file conflict");
                continue;
            }
            conflict = true;
        }
        sameFiles.removeAll(fileSameVersion);
        OLogger.debug("CUP_LOG: Number of overlapped files after checking file version: " + sameFiles.size());
        return conflict;
    }

    private CopyAction getCopyAction(IPatch patch, String file) {
        CopyAction result = null;
        if (patch != null) {
            PatchComponent[] compArray;
            for (PatchComponent c2 : compArray = patch.getOneOffEntry().getAllComponents()) {
                LinkedList copyList = c2.getCopyList();
                for (Object o2 : copyList) {
                    CopyAction ca = (CopyAction)o2;
                    String fillPathName = OPatchEnv.getOracleHome() + File.separator + ca.getPath() + File.separator + ca.getCopyName();
                    if (!file.equalsIgnoreCase(fillPathName)) continue;
                    return ca;
                }
            }
        }
        return result;
    }

    @Override
    public IConflictMap build(String mapFile) {
        return null;
    }

    @Override
    public void generate(String mapFile, IConflictMap map) {
    }

    @Override
    public IConflictMap build(Collection<IPatch> pis) {
        if (OPatchEnv.isCUPSupported()) {
            CheckPatchLevel checkPL = new CheckPatchLevel(pis, null);
            checkPL.checkBetweenPi();
        }
        ConflictMap conflictMap = new ConflictMap(pis);
        this.initConflictMapBuilder(pis);
        ConflictMapBuilderUtil builderUtil = new ConflictMapBuilderUtil();
        builderUtil.selectBetterPatchAgainstOH(pis, new ArrayList<IPatch>(), conflictMap);
        builderUtil = null;
        this.buildBugsConflict(pis, conflictMap, false);
        this.buildFilesConflict(pis, conflictMap, false);
        conflictMap.collectRelationsToTopLevelPSU();
        conflictMap.setPohExist(false);
        return conflictMap;
    }

    @Override
    public IConflictMap build(Collection<IPatch> pis, Collection<IPatch> pohs) {
        if (OPatchEnv.isCUPSupported()) {
            CheckPatchLevel checkPL = new CheckPatchLevel(pis, pohs);
            checkPL.checkBetweenPiAndPoh();
        }
        OracleHomeConflictMap instance = OracleHomeConflictMap.getInstance();
        HashMap<IPatch, Collection<IPatch>> inactivePatchesMap = new HashMap<IPatch, Collection<IPatch>>();
        if (instance != null) {
            for (IPatch inactivePatch : instance.getSubsetIPatches()) {
                Patch patch = new Patch(inactivePatch.getOneOffEntry(), true);
                inactivePatchesMap.put(patch, instance.getSupersetPatches(inactivePatch));
                pohs.add(patch);
            }
        }
        ConflictMap conflictMap = new ConflictMap(pis, pohs);
        this.initConflictMapBuilder(pis);
        this.collectBugsAndFilesMap(pohs, true);
        ConflictMapBuilderUtil builderUtil = new ConflictMapBuilderUtil();
        builderUtil.selectBetterPatchAgainstOH(pis, pohs, conflictMap);
        builderUtil = null;
        this.buildBugsConflict(pis, conflictMap, true);
        this.buildFilesConflict(pis, conflictMap, true);
        this.buildInactiveRelations(inactivePatchesMap, pohs, conflictMap);
        conflictMap.collectRelationsToTopLevelPSU();
        conflictMap.setPohExist(true);
        return conflictMap;
    }

    @Override
    public IConflictMap buildOH(Collection<IPatch> pohs) {
        if (OPatchEnv.isCUPSupported()) {
            CheckPatchLevel checkPL = new CheckPatchLevel(null, pohs);
            checkPL.checkBetweenPoh();
        }
        ArrayList<IPatch> psus = new ArrayList<IPatch>();
        ConflictMapBuilderUtil builderUtil = new ConflictMapBuilderUtil();
        HashMap<String, IPatch> pohMap = new HashMap<String, IPatch>(pohs.size());
        builderUtil.addSubPatchToPSU(pohs, pohMap);
        builderUtil.buildOverlayAndPrereqRelation(pohs, pohMap);
        ArrayList<IPatch> subPatchList = new ArrayList<IPatch>();
        for (IPatch poh : pohs) {
            if (!poh.isTopLevelPSU()) continue;
            psus.add(poh);
            for (IPatch subPatch : poh.getSubPatches()) {
                poh.getBugs().addAll(subPatch.getBugs());
                poh.getFiles().addAll(subPatch.getFiles());
                subPatchList.add(subPatch);
            }
        }
        pohs.removeAll(subPatchList);
        ConflictMap conflictMap = new ConflictMap(pohs);
        this.initConflictMapBuilder(pohs);
        this.buildBugsConflict(pohs, conflictMap, false);
        String sessionType = OPatchEnv.getSessionType();
        if (!(sessionType.equals("lsinventory") || sessionType.equals("lspatches") || sessionType.equals("lsinv"))) {
            this.buildFilesConflict(pohs, conflictMap, false);
        }
        if (psus.size() >= 2) {
            IPatch[] psusArray = new IPatch[2];
            psus.toArray(psusArray);
            CompositePatchCategorizer.buildPSURelation(psusArray, conflictMap);
        }
        return conflictMap;
    }

    private void buildInactiveRelations(Map<IPatch, Collection<IPatch>> inactivePatchesMap, Collection<IPatch> pohs, ConflictMap conflictMap) {
        for (IPatch inactivePatch : inactivePatchesMap.keySet()) {
            for (IPatch supersetPatch : inactivePatchesMap.get(inactivePatch)) {
                for (IPatch poh : pohs) {
                    if (!poh.getPatchId().equals(supersetPatch.getPatchId())) continue;
                    conflictMap.addSubsetRelation(inactivePatch, poh, new ArrayList<String>(), true);
                    conflictMap.addSupersetRelation(poh, inactivePatch, new ArrayList<String>(), true);
                }
            }
        }
    }

    public static void destroyObject() {
        if (conflictMapBuilder != null) {
            conflictMapBuilder = null;
        }
    }

    private boolean cbccCheck(Set<String> sameFiles, IPatch p1, IPatch p2) {
        CbccPatchImpl cbccPatch1 = new CbccPatchImpl((Patch)p1);
        CbccPatchImpl cbccPatch2 = new CbccPatchImpl((Patch)p2);
        try {
            CbccEngine cbccEngine = CbccEngine.getInstance();
            for (String samefile : sameFiles) {
                cbccEngine.resolve(samefile, cbccPatch1, cbccPatch2);
            }
            return true;
        }
        catch (CbccException e2) {
            OLogger.debug("CBCC cannot resolve: " + e2.getMessage());
            return false;
        }
    }

    private void clearConflictRelation(ConflictMap conflictMap, IPatch pi, IPatch conflictPatch) {
        NPatchRelations relations = conflictMap.getRelations(pi);
        if (relations.isConflictOf(conflictPatch)) {
            OLogger.debug("Clear the conflict between (" + pi.getPatchId() + ") and (" + conflictPatch.getPatchId() + ")");
            conflictMap.clearConflictRelation(pi, conflictPatch);
        }
    }
}

