/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.ConflictMap;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelationDefinition;

public class CompositePatchCategorizer {
    private static OneOffEntry[] inactivePSUTrain = new OneOffEntry[0];

    public static void setInactivePSUTrain(OneOffEntry[] array) {
        inactivePSUTrain = array;
    }

    public static OneOffEntry[] getInactivePSUTrain() {
        return inactivePSUTrain;
    }

    public static void buildPSURelation(Collection<IPatch> pis, Collection<IPatch> pohs, ConflictMap conflictMap) {
        IPatch[] psus = new IPatch[2];
        for (IPatch pi : pis) {
            if (!pi.isTopLevelPSU()) continue;
            psus[0] = pi;
            break;
        }
        for (IPatch poh : pohs) {
            if (!poh.isTopLevelPSU()) continue;
            psus[1] = poh;
            break;
        }
        CompositePatchCategorizer.buildPSURelation(psus, conflictMap);
    }

    public static void buildPSURelation(IPatch[] psus, ConflictMap conflictMap) {
        IPatch psui = null;
        IPatch psuoh = null;
        if (psus.length == 2) {
            if (psus[0] != null && psus[0].isTopLevelPSU()) {
                psui = psus[0];
            }
            if (psus[1] != null && psus[1].isTopLevelPSU()) {
                psuoh = psus[1];
            }
        }
        if (psui != null && psuoh != null) {
            Set<String> set;
            Collection<IPatch> subPatchesPi = psui.getSubPatches();
            Collection<IPatch> subPatchesPoh = psuoh.getSubPatches();
            HashSet<String> subPatchIdsPi = new HashSet<String>();
            HashSet<String> subPatchIdsPoh = new HashSet<String>();
            for (IPatch iPatch : subPatchesPi) {
                subPatchIdsPi.add(iPatch.getPatchId());
            }
            subPatchIdsPi.add(psui.getPatchId());
            for (IPatch iPatch : subPatchesPoh) {
                subPatchIdsPoh.add(iPatch.getPatchId());
            }
            subPatchIdsPoh.add(psuoh.getPatchId());
            Set<String> piOverrides = psui.getOverridingUPIs();
            if (piOverrides != null) {
                for (IPatch iPatch : subPatchesPi) {
                    piOverrides.addAll(iPatch.getOverridingUPIs());
                }
            }
            if ((set = psuoh.getOverridingUPIs()) != null) {
                for (IPatch poh : subPatchesPoh) {
                    set.addAll(poh.getOverridingUPIs());
                }
            }
            HashSet hashSet = new HashSet(subPatchIdsPi);
            hashSet.retainAll(subPatchIdsPoh);
            if (!piOverrides.isEmpty() && piOverrides.contains(psuoh.getOneOffEntry().getPSENumber())) {
                if (hashSet.isEmpty()) {
                    conflictMap.addGenericRelation(psui, psuoh, NPatchRelationDefinition.RelationDefinition.SUPERSETPSU);
                    conflictMap.addGenericRelation(psuoh, psui, NPatchRelationDefinition.RelationDefinition.SUBSETPSU);
                } else {
                    conflictMap.addGenericRelation(psui, psuoh, NPatchRelationDefinition.RelationDefinition.INVALIDPSU);
                    conflictMap.addGenericRelation(psuoh, psui, NPatchRelationDefinition.RelationDefinition.INVALIDPSU);
                }
                return;
            }
            if (!set.isEmpty() && set.contains(psui.getOneOffEntry().getPSENumber())) {
                if (hashSet.isEmpty()) {
                    conflictMap.addGenericRelation(psui, psuoh, NPatchRelationDefinition.RelationDefinition.SUBSETPSU);
                    conflictMap.addGenericRelation(psuoh, psui, NPatchRelationDefinition.RelationDefinition.SUPERSETPSU);
                } else {
                    conflictMap.addGenericRelation(psui, psuoh, NPatchRelationDefinition.RelationDefinition.INVALIDPSU);
                    conflictMap.addGenericRelation(psuoh, psui, NPatchRelationDefinition.RelationDefinition.INVALIDPSU);
                }
                return;
            }
            if (hashSet.size() == subPatchIdsPi.size()) {
                conflictMap.addGenericRelation(psui, psuoh, NPatchRelationDefinition.RelationDefinition.LOWERPSU);
                conflictMap.addGenericRelation(psuoh, psui, NPatchRelationDefinition.RelationDefinition.HIGHERPSU);
                return;
            }
            if (hashSet.size() == subPatchIdsPoh.size()) {
                conflictMap.addGenericRelation(psui, psuoh, NPatchRelationDefinition.RelationDefinition.HIGHERPSU);
                conflictMap.addGenericRelation(psuoh, psui, NPatchRelationDefinition.RelationDefinition.LOWERPSU);
                return;
            }
            conflictMap.addGenericRelation(psui, psuoh, NPatchRelationDefinition.RelationDefinition.INVALIDPSU);
            conflictMap.addGenericRelation(psuoh, psui, NPatchRelationDefinition.RelationDefinition.INVALIDPSU);
        }
    }
}

