/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas.client.impl;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.glcm.cas.content.api.CASBuilderProviderFactory;
import oracle.glcm.cas.content.api.CASOperationException;
import oracle.glcm.cas.content.api.CASRepoFactory;
import oracle.glcm.cas.content.api.entity.Branch;
import oracle.glcm.cas.content.api.entity.CasRepo;
import oracle.glcm.cas.content.api.entity.Memento;
import oracle.glcm.cas.content.api.entity.PatchBranch;
import oracle.glcm.cas.content.api.entity.Tag;
import oracle.glcm.cas.content.api.entity.View;
import oracle.glcm.cas.content.api.out.BlackListFile;
import oracle.glcm.cas.content.api.out.PreservedStateInfo;
import oracle.glcm.cas.content.api.param.BranchCreationDetails;
import oracle.glcm.cas.content.api.param.CasRepoCreationDetails;
import oracle.glcm.cas.content.api.param.PatchBranchCreationDetails;
import oracle.glcm.cas.content.api.param.TagCreationDetails;
import oracle.opatch.OPatchEnv;
import oracle.opatch.cas.BranchInfo;
import oracle.opatch.cas.OPatchCASException;
import oracle.opatch.cas.TagUIInfo;
import oracle.opatch.cas.client.CASClient;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.util.perfmonitor.MethodTracker;
import oracle.opatch.util.perfmonitor.MethodTrackerObj;
import oracle.opatch.util.perfmonitor.TrackerTags;
import oracle.opatch.wrappers.WrapperFactory;

public class DecoupledCASClient
implements CASClient {
    String ohPath = OPatchEnv.getOracleHome();
    Path oracleHomePath = WrapperFactory.getNioServiceWrapper().getPath(this.ohPath, new String[0]);
    String defaultTagviewRegex = "[^\u0000/]+";
    String customLogLevel;
    Path casLogDir;
    static Map<Path, CasRepo> casRepoMap = new HashMap<Path, CasRepo>();
    static Map<Integer, Level> levelStrMap = new HashMap<Integer, Level>();

    public DecoupledCASClient() {
        String customLogDir = OPatchEnv.getCustomLogDir();
        this.casLogDir = customLogDir != null && !customLogDir.equals("") ? WrapperFactory.getNioServiceWrapper().getPath(customLogDir, new String[0]).resolve("opatch-cas") : Paths.get(OPatchEnv.getLogFileLocation(this.ohPath.toString()), new String[0]).getParent().resolve("opatch-cas");
        this.customLogLevel = System.getenv("LOG_LEVEL");
        if (this.customLogLevel == null || !this.isAvailableLogLevel(this.customLogLevel)) {
            this.customLogLevel = null;
        }
    }

    @Override
    public void attachMain() throws OPatchCASException {
        this.validate();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - attaching cas store");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS  - cas store attached");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to attach home. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public boolean isCasReposPresent() throws OPatchCASException {
        boolean result = false;
        this.validate();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - verifying if cas store exists");
            CASRepoFactory casRepoFactory = CASBuilderProviderFactory.getCASBuilderProvider().getCasRepoFactoryBuilder().primordialHomePath(this.oracleHomePath).build();
            result = casRepoFactory.casRepoExist();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - verified cas store, result: " + result);
        }
        catch (Throwable e2) {
            this.handleException(e2, "Decoupled CAS - verified cas store, failed . OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
        return result;
    }

    @Override
    public void detachMain() throws OPatchCASException {
        this.validate();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS -  detaching cas store");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            casRepo.destroy();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS -  detaching cas store");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to detach cas store. OPatch cannot proceed.\n", OLogger.SEVERE);
        }
    }

    @Override
    public void tagBranch(String tagId) throws OPatchCASException {
        this.validate();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS -  creating the tag for the branch");
            TagCreationDetails tagCreationDetails = CASBuilderProviderFactory.getCASBuilderProvider().getCasParamBuilder().getTagCreationDetailsBuilder().tagId(tagId).build();
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            this.verifyTagKey(tagId, casRepo);
            Memento memento = casRepo.getLatestMemento();
            memento.createTag(tagCreationDetails);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS -  created the tag for the branch");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS failed tagBranch for tagId " + tagId + " error: " + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void createBranch(String shadowDir, String branchKey, String tagKey) throws OPatchCASException {
        this.validate();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - creating branch from a repository");
            BranchCreationDetails branchCreationDetails = CASBuilderProviderFactory.getCASBuilderProvider().getCasParamBuilder().getBranchCreationDetailsBuilder().tagId(tagKey).branchId(branchKey).branchDir(shadowDir).build();
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            this.verifyBranch(shadowDir);
            this.verifyKey(branchKey);
            casRepo.createBranch(branchCreationDetails);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - created branch from a repository");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Create Branch " + branchKey + " ERROR:" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void synchBranch(String branchKey, String tagKey) throws OPatchCASException {
        this.validate();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] DecoupledCAS CAS - syncing branch started");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            View view = casRepo.getView(branchKey);
            if (view != null) {
                view.sync(tagKey);
                view.restore(tagKey);
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] DecoupledCAS CAS - syncing branch completed");
            } else {
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] DecoupledCAS CAS - The branch " + branchKey + " is not existing, skipping syncing branch");
            }
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Synch branch " + branchKey + " ERROR:" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void destroyBranch(String branchKey) throws OPatchCASException {
        this.validate();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] DecoupledCAS CAS - destroying branch");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            View view = casRepo.getView(branchKey);
            if (view != null) {
                boolean force = true;
                view.destroy(force);
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] DecoupledCAS CAS - branch destroyed");
            } else {
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] DecoupledCAS CAS - branch" + branchKey + " is not existing. Skipping the destroy ");
            }
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS destroy branch " + branchKey + " ERROR:" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public LinkedList<BranchInfo> listBranch(List<String> keys, List<Path> values) throws OPatchCASException {
        this.validate();
        LinkedList<BranchInfo> bis = new LinkedList<BranchInfo>();
        try {
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            List branches = casRepo.listBranches();
            if (branches.size() == 0) {
                OLogger.printlnOnLog("DecoupledCAS No branch is created");
            }
            for (Branch branch : branches) {
                String branchId = branch.getId();
                LinkedList<String> mKeys = new LinkedList<String>();
                Path p2 = Paths.get(branch.getLocation(), new String[0]);
                List mementos = branch.listMementoes();
                for (Memento memento : mementos) {
                    mKeys.add(memento.getName());
                }
                List tags = branch.listTags();
                String tagsKey = null;
                if (!branchId.equals("master")) {
                    tagsKey = tags.size() > 0 ? ((Tag)tags.get(tags.size() - 1)).getId() : "";
                }
                LinkedHashMap<String, String> pidMap = new LinkedHashMap();
                pidMap = this.extractPatchInfo(mKeys);
                LinkedList<String> list = this.getPatchInfoList(pidMap);
                bis.add(new BranchInfo(branchId, p2, tagsKey, list));
            }
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS List Branch ERROR:" + e2.getMessage(), OLogger.SEVERE);
        }
        return bis;
    }

    @Override
    public LinkedList<TagUIInfo> listTagsFromBranch(String branchKey) throws OPatchCASException {
        this.validate();
        LinkedList<TagUIInfo> list = new LinkedList<TagUIInfo>();
        List tags = new LinkedList();
        try {
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            Branch branch = casRepo.getBranch(branchKey);
            tags = branch.listTags();
            if (tags.size() == 0) {
                OLogger.printlnOnLog("DecoupledCAS... No tag is created");
            }
            LinkedHashSet<String> accumulativeMKeys = new LinkedHashSet<String>();
            for (Tag tag : tags) {
                List mementos = branch.getDeltaMementoes(tag.getId());
                LinkedList<String> mKeys = new LinkedList<String>();
                LinkedHashMap<String, String> pidMap = new LinkedHashMap();
                for (int i2 = mementos.size() - 1; i2 >= 0; --i2) {
                    Memento memento = (Memento)mementos.get(i2);
                    if (memento.isPristine()) continue;
                    String mKey = memento.getName();
                    accumulativeMKeys.add(mKey);
                }
                for (String mKey : accumulativeMKeys) {
                    mKeys.add(mKey);
                }
                Collections.reverse(mKeys);
                pidMap = this.extractPatchInfo(mKeys);
                LinkedList<String> taginfoList = this.getPatchInfoList(pidMap);
                list.add(new TagUIInfo(tag.getId(), taginfoList));
            }
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS listTagsFromBranch ERROR:" + e2.getMessage(), OLogger.SEVERE);
        }
        return list;
    }

    @Override
    public boolean isLastCheckpointCompleted(String oracleHomePath) throws OPatchCASException {
        try {
            Path homePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
            CasRepo casRepo = this.getCasRepo(homePath);
            PreservedStateInfo state = casRepo.getPreservedState();
            if (state != null) {
                return !casRepo.getPreservedState().isActive();
            }
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to get isLastCheckpointCompleted(). OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
        return true;
    }

    @Override
    public void restore(String oracleHomePath) throws OPatchCASException {
        try {
            Path homePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
            CasRepo casRepo = this.getCasRepo(homePath);
            casRepo.restoreToPreservedState();
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to restoreToPreservedState. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void beginPhaseTwoCheckpoint(String oracleHomePath) throws OPatchCASException {
        try {
            Path homePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
            CasRepo casRepo = this.getCasRepo(homePath);
            boolean active = true;
            casRepo.preserveCurrentState(active);
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to beginPhaseTwoCheckpoint. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void endPhaseTwoCheckpoint(String oracleHomePath) throws OPatchCASException {
        try {
            Path homePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
            CasRepo casRepo = this.getCasRepo(homePath);
            boolean active = false;
            casRepo.preserveCurrentState(active);
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to endPhaseTwoCheckpoint. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void setCustomLogLevel(String customLogLevel) {
        OLogger.printlnOnLog("CAS Log is already initialized");
    }

    @Override
    public void initializeCASService(String ohPath, String casSHADOW, Path customLogPath) throws OPatchCASException {
        try {
            OLogger.printlnOnLog("DecoupledCAS initializing the CAS");
            Path homePath = WrapperFactory.getNioServiceWrapper().getPath(ohPath, new String[0]);
            CasRepo casRepo = this.getCasRepo(homePath);
            OLogger.printlnOnLog("DecoupledCAS completed the initializing CAS");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to initialize CAS. OPatch cannot proceed. " + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void cleanupCASService() throws OPatchCASException {
        try {
            OLogger.printlnOnLog("DecoupledCAS calling cleanup CAS.\n");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            casRepo.cleanup();
            casRepoMap.clear();
            OLogger.printlnOnLog("DecoupledCAS completed cleanup CAS.\n");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to cleanupCASService()." + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void buildCASStore() throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "DecoupledCAS [OPSR-TIME] Initializing CAS and building data store");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            OLogger.justlog(OLogger.INFO, "DecoupledCAS [OPSR-TIME] Completed initializing CAS and building data store.");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS init/build CAS store failed. OPatch cannot proceed.ERROR:" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void createShadowOH(String shadowDir, String branchKey, Map<Path, String> copy, Map<Path, String> hardlink) throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - creating shadow branch, branchKey: " + branchKey + ", branchDir: " + shadowDir);
            String tagKey = null;
            PatchBranchCreationDetails patchBranchCreationDetails = ((PatchBranchCreationDetails.Builder)((PatchBranchCreationDetails.Builder)((PatchBranchCreationDetails.Builder)CASBuilderProviderFactory.getCASBuilderProvider().getCasParamBuilder().getPatchBranchDetailsBuilder().branchDir(shadowDir)).branchId(branchKey)).hardLinks(hardlink).inventory(copy).tagId(tagKey)).build();
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            casRepo.createPatchBranch(patchBranchCreationDetails);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - created shadow branch");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to create shadow home. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void destroyShadowOH(String branchKey, boolean b2) throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - destroying shadow branch");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            PatchBranch branch = casRepo.getPatchBranch(branchKey);
            if (branch != null) {
                boolean keepBranchRecord = false;
                branch.destroy(keepBranchRecord);
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - shadow branch destroyed");
            } else {
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] DecoupledCAS CAS - The branch " + branchKey + " is not existing, skipping destroy shadow branch");
            }
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to destroy shadow home. OPatch cannot proceed." + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void beginPatchBranch(String branchKey, String patchKey) throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS  - starting patch transaction and applying patch to shadow home");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            PatchBranch shadowBranch = casRepo.getPatchBranch(branchKey);
            if (shadowBranch == null) {
                throw new OPatchCASException(new Exception("DecoupledCAS - The branch " + branchKey + " is not Existing, failed to begin PatchSession. OPatch cannot proceed"));
            }
            shadowBranch.beginPatchSession(patchKey);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS  - completed patch transaction and applied patch to shadow home");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to begin PatchSession. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void endPatchBranch(String patchKey, Map<Path, String> remove, boolean endSession) throws OPatchCASException {
        try {
            String branchKey = OPatchEnv.getBranchKey();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS  - committing patch to shadow home and ending transaction");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            PatchBranch shadowBranch = casRepo.getPatchBranch(branchKey);
            if (shadowBranch == null) {
                throw new OPatchCASException(new Exception("DecoupledCAS - The branch " + branchKey + " is not Existing, failed to end PatchSession. OPatch cannot proceed"));
            }
            shadowBranch.endPatchSession(patchKey, remove, endSession);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS  - committed patch to shadow home and ending transaction");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to end PatchSession to shadow home. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyOh(Map<Path, String> ignore) throws OPatchCASException {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_HARDLINK_TO_COPY);
        trackerObj.start();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - changing oracle home files from hard link to a real copy");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            PatchBranch branch = casRepo.getPatchBranch("master");
            if (branch != null) {
                String patternFile = null;
                branch.copyHardLink(patternFile, ignore);
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - Completed changing oracle home files from hard link to a real copy");
            }
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to copy hardlink in Oracle home. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
        finally {
            trackerObj.end();
        }
    }

    @Override
    public void cleaupShadowOH(String branchKey) throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - Cleanup shadow home started.");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            PatchBranch branch = casRepo.getPatchBranch(branchKey);
            branch.cleanupFiles();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - Cleanup shadow home Finished.");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to cleanup shadow home. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void normalizeOH(boolean copyOH, Long markedTimestampForRescan) throws OPatchCASException {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_NORMALIZE_OH);
        trackerObj.start();
        try {
            Collection modifiedFiles = new ArrayList();
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            if (copyOH) {
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - started checking new files in oracle home");
                modifiedFiles = casRepo.getModifiedFilesByTimestamp(markedTimestampForRescan);
                OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - completed checking new files in oracle home");
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - started normalizing oracle home");
            String branchKey = OPatchEnv.getBranchKey();
            PatchBranch branch = casRepo.getPatchBranch(branchKey);
            branch.updateMementoAndRestoreHardLinkInHome(modifiedFiles, null);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - completed normalization of oracle home");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to normalize the Oracle home. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
        finally {
            trackerObj.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(String patchKey, Map<Path, String> ignore) throws OPatchCASException {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_COMMIT);
        trackerObj.start();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - started committing changes from shadow oh to real oh");
            String branchKey = OPatchEnv.getBranchKey();
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            PatchBranch branch = casRepo.getPatchBranch(branchKey);
            branch.mergeToMaster(patchKey, ignore);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - completed committing patch from shadow oh to real oh");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to commit changes from shadow home to Oracle home.\n" + e2.getMessage(), OLogger.SEVERE);
        }
        finally {
            trackerObj.end();
        }
    }

    @Override
    public void verify(String branchKey) throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - verifying branch");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            if (branchKey == null) {
                branchKey = "master";
            }
            Branch branch = casRepo.getBranch(branchKey);
            branch.validate();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - verified branch");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to verify CAS branch key:" + branchKey + ". OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synch(Map<Path, String> ignore) throws OPatchCASException {
        MethodTrackerObj trackerObj = MethodTracker.getTracker(TrackerTags.CAS_SYNC_TO_MASTER_BRANCH);
        trackerObj.start();
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - synching latest changes to master branch");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            casRepo.syncPrimordialHome(ignore);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - synched latest changes to master branch");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to synch up master branch to the latest CAS record. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
        finally {
            trackerObj.end();
        }
    }

    @Override
    public boolean isCasReposPresentCFS() throws OPatchCASException {
        return this.isCasReposPresent();
    }

    @Override
    public void attach() throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - starting to attach cas store");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - Completed attach cas store");
        }
        catch (Throwable e2) {
            this.handleException(e2, "Decoupled CAS - Failed attach cas store. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void detach() throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - starting to detach cas store");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            casRepo.destroy();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - Completed detach cas store");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to detach cas store. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void rescan(String patchKey) throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - starting to rescan master branch and build memento");
            String branchKey = OPatchEnv.getBranchKey();
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            PatchBranch branch = casRepo.getPatchBranch(branchKey);
            branch.rescanBuildMemento(patchKey);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - completed rescan master branch and build memento");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to rescan the Oracle home. OPatch cannot proceed.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public void getWarnings() {
    }

    @Override
    public void savePatchInfo(String memento, List<String> patchKeys) throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - starting to save memento and user defined patchkeys");
            String branchKey = OPatchEnv.getBranchKey();
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            PatchBranch branch = casRepo.getPatchBranch(branchKey);
            branch.savePatchInfos(memento, patchKeys);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - completed save memento and user defined patchkeys");
        }
        catch (Throwable e2) {
            this.handleException(e2, "DecoupledCAS Failed to save user defined patchkeys.\n" + e2.getMessage(), OLogger.SEVERE);
        }
    }

    @Override
    public List<String> getPatchInfo(String memento) throws OPatchCASException {
        try {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - starting to get user defined patchkeys by memento");
            String branchKey = OPatchEnv.getBranchKey();
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            PatchBranch branch = casRepo.getPatchBranch(branchKey);
            List patchInfo = branch.getPatchInfos(memento);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - completed get user defined patchkeys by memento");
            return patchInfo;
        }
        catch (CASOperationException e2) {
            OLogger.printStackTrace(e2);
            OLogger.justlog(OLogger.INFO, "DecoupledCAS Failed to get user defined patchkeys.\n");
            return null;
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
            OLogger.justlog(OLogger.INFO, "DecoupledCAS Failed to get user defined patchkeys.\n");
            return null;
        }
    }

    @Override
    public List<String> getBlacklistFiles() {
        try {
            ArrayList<String> blFiles = new ArrayList<String>();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - starting to get files in blacklist");
            CasRepo casRepo = this.getCasRepo(this.oracleHomePath);
            List blackListFiles = casRepo.getBlackListFiles();
            for (BlackListFile blFile : blackListFiles) {
                blFiles.add(blFile.getFilePath().toString());
            }
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - completed get files in blacklist");
            return blFiles;
        }
        catch (CASOperationException e2) {
            OLogger.printStackTrace(e2);
            OLogger.justlog(OLogger.INFO, "DecoupledCAS Failed to get blacklist files.\n");
            return null;
        }
        catch (Exception e3) {
            OLogger.printStackTrace(e3);
            OLogger.justlog(OLogger.INFO, "DecoupledCAS Failed to get blacklist files.\n" + e3.getMessage());
            return null;
        }
    }

    @Override
    public void cleanup(String tagId, boolean pruneSpace, String maxMem, boolean report) {
    }

    private CasRepo getCasRepo(Path oracleHomePath) throws CASOperationException {
        CasRepo casRepo;
        if (casRepoMap.containsKey(oracleHomePath)) {
            casRepo = casRepoMap.get(oracleHomePath);
        } else {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - creating CASRepo, OracleHome:" + oracleHomePath + ", customLogLevel:" + this.customLogLevel + ", customLogPath:" + this.casLogDir);
            CASRepoFactory casRepoFactory = CASBuilderProviderFactory.getCASBuilderProvider().getCasRepoFactoryBuilder().primordialHomePath(oracleHomePath).logDirPath(this.casLogDir).logLevel(this.customLogLevel).build();
            CasRepoCreationDetails casRepoCreationDetails = CASBuilderProviderFactory.getCASBuilderProvider().getCasParamBuilder().getCasRepoDetailsBuilder().dedupeEnabled(false).recordRootOwnedFiles(false).build();
            casRepo = casRepoFactory.createCasRepo(casRepoCreationDetails);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Decoupled CAS - created CASRepo Successfully.");
            casRepoMap.put(oracleHomePath, casRepo);
        }
        return casRepo;
    }

    private Map<String, String> extractPatchInfo(LinkedList<String> keys) {
        LinkedHashMap<String, String> pidMap = new LinkedHashMap<String, String>();
        Collections.reverse(keys);
        for (String key : keys) {
            if (key.endsWith("noncasflow")) {
                String ts = key.substring(0, key.lastIndexOf("_"));
                OLogger.printlnOnLog(MessageFormat.format("No patch information listed for non-casflow sessions. Please refer to log file at \"{0}\" for more information.", ts));
                continue;
            }
            int first = key.indexOf("_");
            int second = key.indexOf("_", first + 1);
            int third = key.indexOf("_", second + 1);
            int last = key.lastIndexOf("_");
            String id = key.substring(0, third);
            String time = key.substring(third + 1, last);
            if (key.endsWith("napply")) {
                pidMap.put(id, time);
                continue;
            }
            if (!key.endsWith("nrollback")) continue;
            pidMap.remove(id);
        }
        return pidMap;
    }

    private LinkedList<String> getPatchInfoList(Map<String, String> map) {
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] ids = entry.getKey().split("_");
            StringBuffer buff = new StringBuffer("Patch ");
            buff.append(ids[0]);
            buff.append(": applied on ");
            buff.append(entry.getValue());
            buff.append("\nUnique Patch ID: ");
            buff.append(ids[2]);
            buff.append("\nLanguage: ");
            buff.append(ids[1]);
            list.add(buff.toString());
        }
        Collections.reverse(list);
        return list;
    }

    private void validate() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            StringBuffer tBuff = new StringBuffer("DecoupledCAS OPatch doesn't support ZDT commands");
            tBuff.append(" in the environment that is not CAS-enabled. ");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
    }

    private String getTagViewRegex() {
        String customEnvRegex = System.getenv("ZDTTAGVIEW_REGEX");
        if (customEnvRegex != null && !customEnvRegex.equals("")) {
            OLogger.justlog(OLogger.INFO, "DecoupleCAS CASBranchServices env ZDTTAGVIEW_REGEX is set");
            this.defaultTagviewRegex = customEnvRegex;
        }
        return this.defaultTagviewRegex;
    }

    private void verifyTagKey(String tagKey, CasRepo casRepo) throws Throwable {
        if (tagKey != null && !tagKey.isEmpty()) {
            if (tagKey.matches(this.getTagViewRegex())) {
                String masterKey = "master";
                Branch masterBranch = casRepo.getBranch(masterKey);
                List tags = masterBranch.listTags(tagKey);
                if (tags.size() > 0) {
                    StringBuffer tBuff = new StringBuffer("Decoupled CAS Tag \"");
                    tBuff.append(tagKey);
                    tBuff.append("\" already exist. ");
                    RuntimeException re = new RuntimeException(tBuff.toString());
                    throw re;
                }
                return;
            }
            StringBuffer tBuff = new StringBuffer("DecoupleCAS The given tag id \"");
            tBuff.append(tagKey);
            tBuff.append("\" is invalid. ");
            tBuff.append("DecoupleCAS Please specify tag id containing only characters comply to regex: " + this.defaultTagviewRegex);
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        StringBuffer tBuff = new StringBuffer("DecoupleCAS Please specify a valid tag id.");
        OLogger.println(tBuff.toString());
        RuntimeException re = new RuntimeException(tBuff.toString());
        throw re;
    }

    private void verifyBranch(String shadowDir) {
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(shadowDir, new String[0]);
        boolean ok = true;
        if (!Files.exists(f2, new LinkOption[0])) {
            try {
                Files.createDirectories(f2, new FileAttribute[0]);
            }
            catch (IOException e2) {
                StringBuffer tBuff = new StringBuffer("DecoupleCAS Please specify a valid view directory. The given directory \"");
                tBuff.append(shadowDir);
                tBuff.append("\" does not exist and OPatch cannot create the view.");
                RuntimeException re = new RuntimeException(tBuff.toString());
                throw re;
            }
        }
        try (DirectoryStream<Path> fFiles = Files.newDirectoryStream(f2);){
            if (fFiles.iterator().hasNext()) {
                StringBuffer tBuff = new StringBuffer("DecoupleCAS Please specify an empty view directory. The given directory \"");
                tBuff.append(shadowDir);
                tBuff.append("\" is not empty.");
                OLogger.printlnOnLog(tBuff.toString());
                RuntimeException re = new RuntimeException(tBuff.toString());
                throw re;
            }
        }
        catch (IOException e3) {
            OLogger.debug(e3.getMessage());
        }
    }

    private void verifyKey(String branchKey) {
        if (branchKey != null && !branchKey.isEmpty()) {
            if (branchKey.matches(this.getTagViewRegex())) {
                return;
            }
            StringBuffer tBuff = new StringBuffer("The given view id \"");
            tBuff.append(branchKey);
            tBuff.append("\" is invalid. ");
            tBuff.append("DecoupleCAS Please specify view id containing only characters comply to regex: " + this.defaultTagviewRegex);
            OLogger.printlnOnLog(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        StringBuffer tBuff = new StringBuffer("DecoupleCAS Please specify a valid view id.");
        OLogger.println(tBuff.toString());
        RuntimeException re = new RuntimeException(tBuff.toString());
        throw re;
    }

    protected boolean isAvailableLogLevel(String customLogLevel) {
        for (Level level : levelStrMap.values()) {
            if (!level.getName().equalsIgnoreCase(customLogLevel)) continue;
            return true;
        }
        return false;
    }

    private void handleException(Throwable e2, String errorMsg, int level) throws OPatchCASException {
        if (e2 instanceof CASOperationException) {
            OLogger.printStackTrace(e2);
            OLogger.justlog(level, errorMsg);
            OLogger.println(errorMsg);
            throw new OPatchCASException(e2);
        }
        if (e2 instanceof OPatchCASException) {
            OLogger.printStackTrace(e2);
            OLogger.justlog(level, errorMsg);
            OLogger.println(errorMsg);
            throw (OPatchCASException)e2;
        }
        OLogger.printStackTrace(e2);
        OLogger.justlog(level, errorMsg);
        OLogger.println(errorMsg);
        throw new OPatchCASException(e2);
    }

    static {
        levelStrMap.put(OLogger.FINEST, Level.FINEST);
        levelStrMap.put(OLogger.FINER, Level.FINER);
        levelStrMap.put(OLogger.FINE, Level.FINE);
        levelStrMap.put(OLogger.CONFIG, Level.CONFIG);
        levelStrMap.put(OLogger.INFO, Level.INFO);
        levelStrMap.put(OLogger.WARNING, Level.WARNING);
        levelStrMap.put(OLogger.SEVERE, Level.SEVERE);
        levelStrMap.put(OLogger.OFF, Level.OFF);
    }
}

