/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.opatch.CustomizedActionResults;
import oracle.opatch.ICustomizedActionResults;
import oracle.opatch.ICustomizedActions;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.SparseCopyContext;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class SparseCopyPostCustomizedAction
implements ICustomizedActions {
    private List<SparseCopyContext> sccs;
    private String oracleHomePath;
    private PatchObject pObject;

    public SparseCopyPostCustomizedAction(List<SparseCopyContext> sccs, String oracleHomePath, PatchObject pObject) {
        this.sccs = sccs;
        this.oracleHomePath = oracleHomePath;
        this.pObject = pObject;
    }

    @Override
    public ICustomizedActionResults run() {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: SparseCopyPostCustomizedAction::run()");
        ArrayList<String> removeList = new ArrayList<String>();
        for (SparseCopyContext scc : this.sccs) {
            if (!scc.isFirstAppVerDirExist()) continue;
            Path oldAppVerFile = scc.getOldAppVerDir();
            if (oldAppVerFile != null && scc.isDeleteOldDirectory() && Files.exists(oldAppVerFile, new LinkOption[0])) {
                OLogger.printlnOnLog(MessageFormat.format("Delete old aplication version file: {0}", oldAppVerFile.toAbsolutePath().toString()));
                String oldAppVerDir = oldAppVerFile.toAbsolutePath().toString();
                String relativeOldAppVerDir = oldAppVerDir.substring(this.oracleHomePath.length() + 1);
                ArrayList<Path> allFileInOldAppDir = new ArrayList<Path>();
                this.listDirectory(oldAppVerFile, allFileInOldAppDir);
                boolean removeFlag = this.deleteOldAppVerDir(oldAppVerFile, scc);
                if (removeFlag) {
                    OLogger.printlnOnLog(MessageFormat.format("Add all the files in old aplication version file to remove list: {0}", relativeOldAppVerDir));
                    for (Path file : allFileInOldAppDir) {
                        String relativePath = file.toAbsolutePath().toString().substring(this.oracleHomePath.length() + 1);
                        OLogger.printlnOnLog(MessageFormat.format("Add file {0} to remove list", relativePath));
                        removeList.add(relativePath);
                    }
                }
            }
            if (scc.getCurrentAppVerDir() != scc.getNewAppVerFromPatchDir()) {
                Path oldPriorAppPtrFile = scc.getPriorAppPtrFile();
                Path newPriorAppPtrFile = this.deleteAndCreatePriorAppPtrFile(scc);
                if (oldPriorAppPtrFile != null) {
                    OLogger.printlnOnLog(MessageFormat.format("The old prior pointer file is: {0}", oldPriorAppPtrFile.toAbsolutePath().toString()));
                    removeList.add(oldPriorAppPtrFile.toAbsolutePath().toString().substring(this.oracleHomePath.length() + 1));
                }
                if (newPriorAppPtrFile != null) {
                    OLogger.printlnOnLog(MessageFormat.format("The new prior pointer file is: {0}", newPriorAppPtrFile.toAbsolutePath().toString()));
                }
            }
            Path oldLatestAppPtrFile = scc.getLatestAppPtrFile();
            Path newLatestAppPtrFile = this.deleteAndCreateLatestAppPtrFile(scc);
            if (oldLatestAppPtrFile != null) {
                OLogger.printlnOnLog(MessageFormat.format("The old latest pointer file is: {0}", oldLatestAppPtrFile.toAbsolutePath().toString()));
                OLogger.printlnOnLog(MessageFormat.format("The new latest pointer file is: {0}", newLatestAppPtrFile.toAbsolutePath().toString()));
                removeList.add(oldLatestAppPtrFile.toAbsolutePath().toString().substring(this.oracleHomePath.length() + 1));
                continue;
            }
            OLogger.printlnOnLog(MessageFormat.format("The new latest pointer file is: {0}", newLatestAppPtrFile.toAbsolutePath().toString()));
        }
        CustomizedActionResults actionResults = new CustomizedActionResults(new ArrayList<String>(), removeList);
        return actionResults;
    }

    private boolean deleteOldAppVerDir(Path oldAppVerDir, SparseCopyContext scc) {
        OLogger.justlog(OLogger.INFO, "deleteOldAppVerDir::delete old application version directory");
        String oldAppVerPath = oldAppVerDir.toAbsolutePath().toString();
        String relativeOldAppVerPath = oldAppVerPath.substring(this.oracleHomePath.length() + 1);
        try {
            if (Files.exists(oldAppVerDir, new LinkOption[0]) && !this.isWorkingDir(relativeOldAppVerPath, scc)) {
                SystemCall.deleteRecurse(oldAppVerDir, true);
                return true;
            }
        }
        catch (Exception e2) {
            OLogger.println("OPatch failed to remove old application version directory " + oldAppVerPath);
        }
        return false;
    }

    public boolean isWorkingDir(String relativePath, SparseCopyContext scc) {
        Map<String, String> workingDirs = OPatchEnv.getApplicationWorkingDirectory();
        String relativeWorkingDir = workingDirs.get(scc.getApplicationDir());
        OLogger.printlnOnLog(MessageFormat.format("isWorkingDir::compare the relative path of old application version directory {0} with working directory {1}", relativePath, relativeWorkingDir));
        return relativePath.equals(relativeWorkingDir);
    }

    private Path deleteAndCreatePriorAppPtrFile(SparseCopyContext scc) {
        OLogger.justlog(OLogger.INFO, "deleteAndCreatePriorAppPtrFile::Delete <prior-app-ptr-file> pointer file, and create a new one using the unique patchid and date-timestamp extracted from the <latest-app-ptr-file>");
        Path priorAppPtrFile = scc.getPriorAppPtrFile();
        if (priorAppPtrFile != null && Files.exists(priorAppPtrFile, new LinkOption[0])) {
            try {
                Files.deleteIfExists(priorAppPtrFile);
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException("OPatch failed to delete prior application pointer file " + priorAppPtrFile.toAbsolutePath().toString());
                throw re;
            }
        }
        String fileName = "prior-ptr-" + scc.getCurrentAppVerDir().getFileName().toString();
        priorAppPtrFile = WrapperFactory.getNioServiceWrapper().getPath(this.oracleHomePath + File.separator + scc.getApplicationDir() + File.separator + fileName, new String[0]);
        try {
            if (!Files.exists(priorAppPtrFile, new LinkOption[0])) {
                Files.createFile(priorAppPtrFile, new FileAttribute[0]);
            }
            return priorAppPtrFile;
        }
        catch (Exception e3) {
            RuntimeException re = new RuntimeException("OPatch failed to create prior application pointer file " + priorAppPtrFile.toAbsolutePath().toString());
            throw re;
        }
    }

    private Path deleteAndCreateLatestAppPtrFile(SparseCopyContext scc) {
        OLogger.justlog(OLogger.INFO, "deleteAndCreateLatestAppPtrFile::Delete the <latest-app-ptr-file> pointer file, create a new <latest-app-ptr-file> pointer file with the newly generated unique patchid and date-timestamp corresponding to the new-app-ver-from-patch-dir> directory");
        Path latestAppPtrFile = scc.getLatestAppPtrFile();
        if (latestAppPtrFile != null && Files.exists(latestAppPtrFile, new LinkOption[0])) {
            try {
                Files.deleteIfExists(latestAppPtrFile);
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException("OPatch failed to delete latest application pointer file " + latestAppPtrFile.toAbsolutePath().toString());
                throw re;
            }
        }
        String fileName = "latest-ptr-" + this.pObject.getApplicationVersion();
        latestAppPtrFile = WrapperFactory.getNioServiceWrapper().getPath(this.oracleHomePath + File.separator + scc.getApplicationDir() + File.separator + fileName, new String[0]);
        try {
            if (!Files.exists(latestAppPtrFile, new LinkOption[0])) {
                Files.createFile(latestAppPtrFile, new FileAttribute[0]);
            }
            return latestAppPtrFile;
        }
        catch (Exception e3) {
            RuntimeException re = new RuntimeException("OPatch failed to create latest application pointer file " + latestAppPtrFile.toAbsolutePath().toString());
            throw re;
        }
    }

    public void listDirectory(Path dir, List<Path> list) {
        if (!Files.exists(dir, new LinkOption[0])) {
            OLogger.printlnOnLog("File " + dir.toAbsolutePath().toString() + " doesn't exist.");
        } else if (Files.isRegularFile(dir, new LinkOption[0])) {
            dir.toAbsolutePath().toString();
            list.add(dir);
        } else {
            list.add(dir);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                for (Path entry : stream) {
                    this.listDirectory(entry, list);
                }
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
    }
}

