/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasAction;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasActionHolder;
import oracle.glcm.opatch.common.api.alias.action.MappingAction;
import oracle.glcm.opatch.common.impl.alias.action.MaintenanceAliasActionService;
import oracle.opatch.ArchiveAction;
import oracle.opatch.Bug;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CopyAction;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.InterviewContextVar;
import oracle.opatch.JarAction;
import oracle.opatch.JarClassLoader;
import oracle.opatch.MakeAction;
import oracle.opatch.NameValuePair;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchInventory;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchValidationException;
import oracle.opatch.Platform;
import oracle.opatch.StringResource;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.TargetEntity;
import oracle.opatch.Uname;
import oracle.opatch.UpdateComponent;
import oracle.opatch.WLSPatch;
import oracle.opatch.XMLConverter;
import oracle.opatch.conflicttextualinterpreter.cbcc.FileMapping;
import oracle.opatch.conflicttextualinterpreter.cbcc.FileMappingImpl;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchactions.StringSubsAction;
import oracle.opatch.opatchfafmw.OPatchFmwDS;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatchObjectUtil {
    public static String getPlatformDependentPath(String s) throws Exception {
        String tmp = "";
        s = s.replace('\\', '/');
        String[] splitedStr = s.split("/");
        String seperate = File.separator;
        if (splitedStr == null) {
            throw new Exception("PatchObjectUtil::getPlatformDependentPath(): Input string is invalid");
        }
        for (int i2 = 0; i2 < splitedStr.length; ++i2) {
            if (i2 == splitedStr.length - 1) {
                seperate = "";
            }
            tmp = tmp + splitedStr[i2] + seperate;
        }
        return tmp;
    }

    public static String[] getPlatformDependentPath(String[] s) throws Exception {
        String[] tmpStr = new String[s.length];
        for (int j2 = 0; j2 < s.length; ++j2) {
            String tmp = "";
            s[j2] = s[j2].replace('\\', '/');
            String[] splitedStr = s[j2].split("/");
            String seperate = File.separator;
            if (splitedStr == null) {
                throw new Exception("PatchObjectUtil::getPlatformDependentPath(): Input string is invalid");
            }
            for (int i2 = 0; i2 < splitedStr.length; ++i2) {
                if (splitedStr[i2].equals(".")) continue;
                if (i2 == splitedStr.length - 1) {
                    seperate = "";
                }
                tmp = tmp + splitedStr[i2] + seperate;
            }
            tmpStr[j2] = tmp;
        }
        return tmpStr;
    }

    public static String filterString(String s) throws Exception {
        int beginIndex = 0;
        if (s.equals("%ORACLE_HOME%")) {
            return "";
        }
        beginIndex = s.indexOf("%ORACLE_HOME%");
        if (beginIndex == -1) {
            return s;
        }
        beginIndex += "%ORACLE_HOME%".length();
        try {
            s = s.substring(beginIndex + 1);
            s = PatchObjectUtil.getPlatformDependentPath(s);
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new Exception("Input string of filterString() is invalid", iobe.getCause());
        }
        catch (Exception e2) {
            throw e2;
        }
        return s;
    }

    public static boolean checkCreateSimlink(PatchAction action, OneOffEntry[] oneoffs) {
        return false;
    }

    public static String filterString(String s, String key, String value) throws Exception {
        if (null == s) {
            return null;
        }
        String tmpStr = s;
        String patternStr = "(.*)(%" + key + "%)(.*)";
        Pattern PATTERN = Pattern.compile(patternStr);
        Matcher m2 = PATTERN.matcher(tmpStr);
        while (m2.find()) {
            String preText = m2.group(1);
            String postText = m2.group(3);
            tmpStr = preText + value + postText;
            m2 = PATTERN.matcher(tmpStr);
        }
        return tmpStr;
    }

    public static Document parseXMLFile(Path xmlFile) throws RuntimeException {
        OLogger.log(OLogger.FINEST, "parserXMLFile : start");
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(xmlFile.toFile());
        }
        catch (Exception e2) {
            OLogger.debug("Here: " + xmlFile.toString() + "Msg: " + e2.getMessage());
            RuntimeException re = new RuntimeException("Unable to parse the xml file.", e2);
            throw re;
        }
        return doc;
    }

    public static Document parseXMLFile(InputStream stream) throws RuntimeException {
        OLogger.log(OLogger.FINEST, "parserXMLFile : start");
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(stream);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            RuntimeException re = new RuntimeException("Unable to parse the xml file.", e2);
            throw re;
        }
        return doc;
    }

    protected static LinkedList getContentActions(Document doc, JarClassLoader oextJarLoader, String patchFilesLocation) throws Exception {
        LinkedList<PatchComponent> compList = new LinkedList<PatchComponent>();
        Element root = doc.getDocumentElement();
        int lineNumber = 1;
        PatchComponent patchComp = null;
        NodeList compsList = root.getChildNodes();
        for (int i2 = 0; i2 < compsList.getLength(); ++i2) {
            Node comp = compsList.item(i2);
            String name = comp.getNodeName();
            if (name.equals("#text")) continue;
            NamedNodeMap compAttrs = comp.getAttributes();
            if (compAttrs == null) {
                RuntimeException re = new RuntimeException("Unable to parse the actions file.");
                throw re;
            }
            ++lineNumber;
            Node verNode = compAttrs.getNamedItem("version");
            String version = verNode.getNodeValue();
            Node orNode = compAttrs.getNamedItem("opt_req");
            String requireStr = orNode.getNodeValue();
            boolean required = requireStr.equalsIgnoreCase("R");
            Node plNode = compAttrs.getNamedItem("patch_level");
            String patchLevel = plNode.getNodeValue();
            String[] rawPatchComp = new String[2];
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(name);
            sb.append(" ");
            sb.append("version");
            sb.append("=\"");
            sb.append(version);
            sb.append("\"");
            sb.append(" ");
            sb.append("opt_req");
            sb.append("=\"");
            sb.append(requireStr);
            sb.append("\"");
            sb.append(" ");
            if (patchLevel != null && !patchLevel.equals("")) {
                sb.append("patch_level");
                sb.append("=\"");
                sb.append(patchLevel);
                sb.append("\"");
                sb.append(" ");
            }
            sb.append(">");
            rawPatchComp[0] = sb.toString();
            sb.delete(0, sb.capacity());
            sb.append("</");
            sb.append(name);
            sb.append(">");
            rawPatchComp[1] = sb.toString();
            patchComp = new PatchComponent(name, version, required);
            if (patchLevel != null && !patchLevel.equals("")) {
                patchComp.setPatchLevel(patchLevel);
            }
            patchComp.setRawActionEntry(rawPatchComp);
            compList.add(patchComp);
            NodeList compActions = comp.getChildNodes();
            for (int j2 = 0; j2 < compActions.getLength(); ++j2) {
                NameValuePair nv;
                Node action = compActions.item(j2);
                String aName = action.getNodeName();
                if (aName.equals("#text")) continue;
                NamedNodeMap aAttrs = action.getAttributes();
                if (aAttrs == null) {
                    RuntimeException re = new RuntimeException("Unable to parse the actions file.");
                    throw re;
                }
                ++lineNumber;
                ArrayList<String> attributeNames = new ArrayList<String>();
                ArrayList<String> attributeValues = new ArrayList<String>();
                ArrayList<NameValuePair> attributeNameValue = new ArrayList<NameValuePair>();
                for (int k2 = 0; k2 < aAttrs.getLength(); ++k2) {
                    Node attrNode = aAttrs.item(k2);
                    NameValuePair nv2 = new NameValuePair(attrNode.getNodeName(), attrNode.getNodeValue());
                    attributeNameValue.add(nv2);
                }
                StringBuffer rawEntry = new StringBuffer();
                rawEntry.append("<");
                rawEntry.append(aName);
                rawEntry.append(" ");
                for (int k3 = 0; k3 < attributeNameValue.size(); ++k3) {
                    String attrName = ((NameValuePair)attributeNameValue.get(k3)).getAttributeName();
                    rawEntry.append(attrName);
                    rawEntry.append("=\"");
                    String value = ((NameValuePair)attributeNameValue.get(k3)).getAttributeValue();
                    String tmp = XMLConverter.getXMLString(value);
                    rawEntry.append(tmp);
                    if (k3 == attributeNameValue.size() - 1) {
                        rawEntry.append("\" />");
                        continue;
                    }
                    rawEntry.append("\" ");
                }
                String argValue1 = "";
                String argValue2 = "";
                String argValue3 = "";
                String argValue4 = "";
                String argValue5 = "";
                String argValue6 = "";
                String argValue7 = "";
                String argValue8 = "";
                if (aName.equals("copy")) {
                    boolean hasFileVersion = false;
                    for (int k4 = 0; k4 < attributeNameValue.size(); ++k4) {
                        NameValuePair nv3 = (NameValuePair)attributeNameValue.get(k4);
                        if (nv3.getAttributeName().equals("name")) {
                            argValue1 = nv3.getAttributeValue();
                            continue;
                        }
                        if (nv3.getAttributeName().equals("path")) {
                            argValue2 = nv3.getAttributeValue();
                            continue;
                        }
                        if (nv3.getAttributeName().equals("file_name")) {
                            argValue3 = nv3.getAttributeValue();
                            continue;
                        }
                        if (nv3.getAttributeName().equals("update_timestamp")) {
                            argValue4 = nv3.getAttributeValue();
                            continue;
                        }
                        if (nv3.getAttributeName().equals("file_version")) {
                            hasFileVersion = true;
                            argValue5 = nv3.getAttributeValue();
                            continue;
                        }
                        if (nv3.getAttributeName().equals("diagnostic_string")) {
                            argValue6 = nv3.getAttributeValue();
                            continue;
                        }
                        if (nv3.getAttributeName().equals("retain_permission")) {
                            argValue7 = nv3.getAttributeValue();
                            continue;
                        }
                        if (!nv3.getAttributeName().equals("mode")) continue;
                        argValue8 = nv3.getAttributeValue();
                    }
                    if (argValue4 == null || argValue4.equals("")) {
                        argValue4 = "false";
                    }
                    if (argValue7 == null || argValue7.equals("")) {
                        argValue7 = "false";
                    }
                    CopyAction copyAction = new CopyAction(patchComp, argValue1, argValue2, argValue3, lineNumber, Boolean.valueOf(argValue4), argValue5, argValue6, Boolean.valueOf(argValue7), argValue8, hasFileVersion);
                    patchComp.copyList.add(copyAction);
                    copyAction.setRawActionEntry(rawEntry.toString());
                    continue;
                }
                if (aName.equals("jar")) {
                    for (int k5 = 0; k5 < attributeNameValue.size(); ++k5) {
                        nv = (NameValuePair)attributeNameValue.get(k5);
                        if (nv.getAttributeName().equals("name")) {
                            argValue1 = nv.getAttributeValue();
                            continue;
                        }
                        if (nv.getAttributeName().equals("path")) {
                            argValue2 = nv.getAttributeValue();
                            continue;
                        }
                        if (!nv.getAttributeName().equals("class_name")) continue;
                        argValue3 = nv.getAttributeValue();
                    }
                    JarAction jarAction = new JarAction(patchComp, argValue1, argValue2, argValue3, lineNumber);
                    if (patchComp.jarList.contains(jarAction)) {
                        jarAction.setDuplicate(true);
                    }
                    patchComp.jarList.add(jarAction);
                    jarAction.setRawActionEntry(rawEntry.toString());
                    continue;
                }
                if (aName.equals("delete_from_jar")) {
                    DeleteJarAction deleteJarAction;
                    for (int k6 = 0; k6 < attributeNameValue.size(); ++k6) {
                        nv = (NameValuePair)attributeNameValue.get(k6);
                        if (nv.getAttributeName().equals("name")) {
                            argValue1 = nv.getAttributeValue();
                            continue;
                        }
                        if (nv.getAttributeName().equals("path")) {
                            argValue2 = nv.getAttributeValue();
                            continue;
                        }
                        if (nv.getAttributeName().equals("class_name")) {
                            argValue3 = nv.getAttributeValue();
                            continue;
                        }
                        if (nv.getAttributeName().equals("opatch_binary")) {
                            argValue4 = nv.getAttributeValue();
                            continue;
                        }
                        if (nv.getAttributeName().equals("backup_in_zip")) {
                            argValue5 = nv.getAttributeValue();
                            continue;
                        }
                        if (!nv.getAttributeName().equals("opt_req")) continue;
                        argValue6 = nv.getAttributeValue();
                    }
                    boolean required_action = false;
                    if (argValue6 != null && !argValue6.equals("")) {
                        boolean bl = required = argValue6.equalsIgnoreCase("R");
                    }
                    if (patchComp.deleteJarList.contains(deleteJarAction = new DeleteJarAction(patchComp, argValue1, argValue2, argValue3, lineNumber, required_action))) {
                        deleteJarAction.setDuplicate(true);
                    }
                    patchComp.deleteJarList.add(deleteJarAction);
                    deleteJarAction.setRawActionEntry(rawEntry.toString());
                    continue;
                }
                if (aName.equals("archive")) {
                    for (int k7 = 0; k7 < attributeNameValue.size(); ++k7) {
                        nv = (NameValuePair)attributeNameValue.get(k7);
                        if (nv.getAttributeName().equals("name")) {
                            argValue1 = nv.getAttributeValue();
                            continue;
                        }
                        if (nv.getAttributeName().equals("path")) {
                            argValue2 = nv.getAttributeValue();
                            continue;
                        }
                        if (!nv.getAttributeName().equals("object_name")) continue;
                        argValue3 = nv.getAttributeValue();
                    }
                    ArchiveAction archiveAction = new ArchiveAction(patchComp, argValue1, argValue2, argValue3, lineNumber);
                    patchComp.archiveList.add(archiveAction);
                    archiveAction.setRawActionEntry(rawEntry.toString());
                    continue;
                }
                if (aName.equals("make")) {
                    for (int k8 = 0; k8 < attributeNameValue.size(); ++k8) {
                        nv = (NameValuePair)attributeNameValue.get(k8);
                        if (nv.getAttributeName().equals("make_file")) {
                            argValue2 = nv.getAttributeValue();
                            continue;
                        }
                        if (nv.getAttributeName().equals("make_target")) {
                            argValue3 = nv.getAttributeValue();
                            continue;
                        }
                        if (!nv.getAttributeName().equals("change_dir")) continue;
                        argValue1 = nv.getAttributeValue();
                    }
                    MakeAction makeAction = new MakeAction(patchComp, argValue1, argValue2, argValue3, lineNumber);
                    patchComp.makeList.add(makeAction);
                    makeAction.setRawActionEntry(rawEntry.toString());
                    continue;
                }
                if (aName.equals("stringsubs")) {
                    for (int k9 = 0; k9 < attributeNameValue.size(); ++k9) {
                        nv = (NameValuePair)attributeNameValue.get(k9);
                        if (nv.getAttributeName().equals("schema")) {
                            argValue1 = nv.getAttributeValue();
                            continue;
                        }
                        if (!nv.getAttributeName().equals("configure")) continue;
                        argValue2 = nv.getAttributeValue();
                    }
                    StringSubsAction stringSubsAction = new StringSubsAction(patchComp, argValue1, argValue2, lineNumber);
                    patchComp.stringSubsList.add(stringSubsAction);
                    stringSubsAction.setRawActionEntry(rawEntry.toString());
                    continue;
                }
                for (int k10 = 0; k10 < attributeNameValue.size(); ++k10) {
                    nv = (NameValuePair)attributeNameValue.get(k10);
                    attributeNames.add(nv.getAttributeName());
                    attributeValues.add(nv.getAttributeValue());
                }
                String className = aName + "Action";
                Class<?> actionClass = null;
                try {
                    actionClass = Class.forName(className);
                }
                catch (ClassNotFoundException e2) {
                    // empty catch block
                }
                if (actionClass == null) {
                    try {
                        String classNamePath = "oracle.opatch.opatchactions." + className;
                        actionClass = Class.forName(classNamePath);
                    }
                    catch (ClassNotFoundException e3) {
                        // empty catch block
                    }
                }
                if (oextJarLoader != null && actionClass == null) {
                    actionClass = oextJarLoader.loadClass(className);
                }
                if (actionClass != null) {
                    Integer lineNumberObject = new Integer(lineNumber);
                    Class[] parameterTypes = new Class[]{patchComp.getClass(), attributeNames.getClass(), attributeValues.getClass(), lineNumberObject.getClass()};
                    Object[] parameterArgs = new Object[]{patchComp, attributeNames, attributeValues, lineNumberObject};
                    attributeNames.add("PATCH_FILES_LOCATION_TAG");
                    attributeValues.add(patchFilesLocation);
                    Constructor<?> newActionConst = actionClass.getConstructor(parameterTypes);
                    Object newAction = newActionConst.newInstance(parameterArgs);
                    patchComp.pluginList.add(newAction);
                    ((PatchAction)newAction).setRawActionEntry(rawEntry.toString());
                    continue;
                }
                StringBuffer buff = new StringBuffer("Class not found \"");
                buff.append(className);
                buff.append("\"");
                ClassNotFoundException ce = new ClassNotFoundException(buff.toString());
                throw ce;
            }
            ++lineNumber;
        }
        return compList;
    }

    protected static ChecksumEntity[] getContentChecksum(Document doc) throws Exception {
        Element root = doc.getDocumentElement();
        ArrayList<ChecksumEntity> chkObjects = new ArrayList<ChecksumEntity>();
        ChecksumEntity[] cs = new ChecksumEntity[]{};
        NodeList metadataList = root.getChildNodes();
        String rootName = root.getNodeName();
        if (rootName.equals("checksum_info")) {
            for (int i2 = 0; i2 < metadataList.getLength(); ++i2) {
                Node metadataItem = metadataList.item(i2);
                String name = metadataItem.getNodeName();
                if (name.equals("#text")) continue;
                if (name.equals("file")) {
                    Element chkSumXML = (Element)metadataItem;
                    String filePath = chkSumXML.getAttribute("path");
                    String chkSum = chkSumXML.getAttribute("checksum");
                    String appDir = chkSumXML.getAttribute("app_dir");
                    ChecksumEntity cse = new ChecksumEntity(filePath, chkSum, appDir);
                    chkObjects.add(cse);
                    continue;
                }
                RuntimeException re = new RuntimeException("Unknown metadata under \"checksum_info\" in inventory file.");
                throw re;
            }
        }
        cs = new ChecksumEntity[chkObjects.size()];
        chkObjects.toArray(cs);
        return cs;
    }

    protected static PatchInventory getContentInventory(Document doc) throws Exception {
        Element root = doc.getDocumentElement();
        int whatToShow = -1;
        Object nodeFilter = null;
        boolean expandRef = false;
        PatchInventory patchInventory = new PatchInventory();
        NodeList metadataList = root.getChildNodes();
        for (int i2 = 0; i2 < metadataList.getLength(); ++i2) {
            PatchInventory.NameVersionPair pair;
            Element productTypeElement;
            Element patchLanguage;
            String patchID;
            Element patchElement;
            NodeList prereqsNodeList;
            String path;
            RuntimeException re;
            Node child;
            Node metadataItem = metadataList.item(i2);
            String name = metadataItem.getNodeName();
            if (name.equals("#text")) continue;
            if (name.equals("reference_id") || name.equals("patch_id")) {
                Element idElement = (Element)metadataItem;
                String patchID2 = idElement.getAttribute("number");
                if (patchID2 == null || patchID2.equals("")) {
                    RuntimeException re2 = new RuntimeException("Patch has empty or null patch id metadata under \"patch_id\" in inventory file.");
                    throw re2;
                }
                patchInventory.patchID = patchID2;
                continue;
            }
            if (name.equals("unique_patch_id")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null) continue;
                    patchInventory.setPSENumber(value);
                    continue;
                }
                patchInventory.setPSENumber("");
                continue;
            }
            if (name.equals("temp_unique_patch_id")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null) continue;
                    patchInventory.setTmpPSENumber(value);
                    continue;
                }
                patchInventory.setTmpPSENumber("");
                continue;
            }
            if (name.equals("auto")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null) continue;
                    patchInventory.setAuto(Boolean.valueOf(value));
                    continue;
                }
                patchInventory.setAuto(false);
                continue;
            }
            if (name.equals("translatable")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null) continue;
                    patchInventory.setTranslatable(Boolean.valueOf(value));
                    continue;
                }
                patchInventory.setTranslatable(false);
                continue;
            }
            if (name.equals("not_rollbackable")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null) continue;
                    patchInventory.setNotRollbackable(Boolean.valueOf(value));
                    continue;
                }
                patchInventory.setNotRollbackable(false);
                continue;
            }
            if (name.equals("ojvm")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null || !value.equals("false") && !value.equals("true")) continue;
                    patchInventory.setOjvmPatch(Boolean.valueOf(value));
                    continue;
                }
                patchInventory.setOjvmPatch(false);
                continue;
            }
            if (name.equals("rhp")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null || !value.equals("false") && !value.equals("true")) continue;
                    patchInventory.setRhpPatch(Boolean.valueOf(value));
                    continue;
                }
                patchInventory.setRhpPatch(false);
                continue;
            }
            if (name.equals("two_stage_rolling")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null || !value.equals("false") && !value.equals("true")) continue;
                    patchInventory.setRrpRollingPatch(Boolean.valueOf(value));
                    continue;
                }
                patchInventory.setRrpRollingPatch(false);
                continue;
            }
            if (name.equals("ru")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null || !value.equals("false") && !value.equals("true")) continue;
                    patchInventory.setRu(Boolean.valueOf(value));
                    continue;
                }
                patchInventory.setRu(false);
                continue;
            }
            if (name.equals("ru_version")) {
                child = metadataItem.getFirstChild();
                if (child == null) continue;
                String value = child.getNodeValue();
                if (value != null) {
                    patchInventory.setRUVersion(value);
                    continue;
                }
                patchInventory.setRUVersion("");
                continue;
            }
            if (name.equals("rur")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null || !value.equals("false") && !value.equals("true")) continue;
                    patchInventory.setRur(Boolean.valueOf(value));
                    continue;
                }
                patchInventory.setRur(false);
                continue;
            }
            if (name.equals("rur_version")) {
                child = metadataItem.getFirstChild();
                if (child == null) continue;
                String value = child.getNodeValue();
                if (value != null) {
                    patchInventory.setRURVersion(value);
                    continue;
                }
                patchInventory.setRURVersion("");
                continue;
            }
            if (name.equals("minimum_opatch_version")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null) continue;
                    patchInventory.setMinOPatchVersion(value);
                    continue;
                }
                patchInventory.setMinOPatchVersion("");
                continue;
            }
            if (name.equals("date_of_patch")) {
                Element dateElement = (Element)metadataItem;
                String year = dateElement.getAttribute("year");
                String month = dateElement.getAttribute("month");
                String day = dateElement.getAttribute("day");
                String time = dateElement.getAttribute("time");
                String zone = dateElement.getAttribute("zone");
                patchInventory.setCreationTime(year, month, day, time, zone);
                StringBuffer rawCreationDate = new StringBuffer();
                rawCreationDate.append(day);
                rawCreationDate.append(" ");
                rawCreationDate.append(month);
                rawCreationDate.append(" ");
                rawCreationDate.append(year);
                rawCreationDate.append(", ");
                rawCreationDate.append(time);
                rawCreationDate.append(" ");
                rawCreationDate.append(zone);
                patchInventory.setRawCreationDate(rawCreationDate.toString());
                time = time.split(" ")[0];
                StringBuffer sb = new StringBuffer();
                sb.append(month);
                sb.append("_");
                sb.append(day);
                sb.append("_");
                sb.append(year);
                sb.append("_");
                sb.append(time);
                StringTokenizer tk = new StringTokenizer(sb.toString(), ":");
                StringBuffer buff = new StringBuffer();
                int count = tk.countTokens();
                int j2 = 0;
                while (tk.hasMoreTokens()) {
                    String s = tk.nextToken();
                    buff.append(s);
                    if (j2 < count - 1) {
                        buff.append("_");
                    }
                    ++j2;
                }
                patchInventory.setFormatCreationDate(buff.toString());
                continue;
            }
            if (name.equals("base_bugs")) {
                NodeList bugsNodeList = metadataItem.getChildNodes();
                for (int j3 = 0; j3 < bugsNodeList.getLength(); ++j3) {
                    Node bugNode = bugsNodeList.item(j3);
                    if (bugNode.getNodeName().equals("#text")) continue;
                    if (!bugNode.getNodeName().equals("bug")) {
                        re = new RuntimeException("Unknown metadata under \"base_bugs\" in inventory file.");
                        throw re;
                    }
                    Element bugElement = (Element)bugNode;
                    String number = bugElement.getAttribute("number");
                    if (number == null || number.equals("")) {
                        RuntimeException re3 = new RuntimeException("Patch has empty or null bug number metadata under \"base_bugs\" in inventory file.");
                        throw re3;
                    }
                    String description = bugElement.getAttribute("description");
                    if (description == null || description.equals("")) {
                        RuntimeException re4 = new RuntimeException("Patch has empty or null bug description metadata under \"base_bugs\" in inventory file.");
                        throw re4;
                    }
                    Bug bug = new Bug(number, description);
                    if (patchInventory.bugsToFix.contains(bug)) continue;
                    patchInventory.bugsToFix.add(bug);
                }
                continue;
            }
            if (name.equals("os_platforms")) {
                NodeList platformsNodeList = metadataItem.getChildNodes();
                for (int j4 = 0; j4 < platformsNodeList.getLength(); ++j4) {
                    Node platformNode = platformsNodeList.item(j4);
                    if (platformNode.getNodeName().equals("#text")) continue;
                    if (!platformNode.getNodeName().equals("platform")) {
                        re = new RuntimeException("Unknown metadata under \"os_platforms\" in inventory file.");
                        throw re;
                    }
                    Element platformElement = (Element)platformNode;
                    String platformName = platformElement.getAttribute("name");
                    String id = platformElement.getAttribute("id");
                    Platform platform = new Platform(platformName, id);
                    patchInventory.supportedPlatforms.add(platform);
                }
                continue;
            }
            if (name.equals("atleast_one_components")) {
                NodeList alocNodeList = metadataItem.getChildNodes();
                ArrayList<PatchComponent> alocList = new ArrayList<PatchComponent>();
                for (int j5 = 0; j5 < alocNodeList.getLength(); ++j5) {
                    Node componentNode = alocNodeList.item(j5);
                    if (componentNode.getNodeName().equals("#text")) continue;
                    if (!componentNode.getNodeName().equals("component")) {
                        RuntimeException re5 = new RuntimeException("Unknown metadata under \"atleast_one_components\" in inventory file.");
                        throw re5;
                    }
                    Element componentElement = (Element)componentNode;
                    String internal_name = componentElement.getAttribute("internal_name");
                    String version = componentElement.getAttribute("version");
                    String opt_req = componentElement.getAttribute("opt_req");
                    boolean required = opt_req.equalsIgnoreCase("R");
                    String patch_level = componentElement.getAttribute("patch_level");
                    PatchComponent comp = new PatchComponent(internal_name, version, required);
                    comp.setOptString(opt_req);
                    if (patch_level != null && !patch_level.equalsIgnoreCase("")) {
                        comp.setPatchLevel(patch_level);
                    }
                    alocList.add(comp);
                }
                patchInventory.getAtLeastOneComponents().add(alocList);
                continue;
            }
            if (name.equals("executables")) {
                NodeList executablesNodeList = metadataItem.getChildNodes();
                for (int j6 = 0; j6 < executablesNodeList.getLength(); ++j6) {
                    Node executableNode = executablesNodeList.item(j6);
                    if (executableNode.getNodeName().equals("#text")) continue;
                    if (!executableNode.getNodeName().equals("executable")) {
                        re = new RuntimeException("Unknown metadata under \"executables\" in inventory file.");
                        throw re;
                    }
                    Element executeElement = (Element)executableNode;
                    path = executeElement.getAttribute("path");
                    path = PatchObjectUtil.filterString(path);
                    patchInventory.executablesList.add(path);
                }
                continue;
            }
            if (name.equals("instance_shutdown")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.instanceShutdown = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("patch_description")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null) continue;
                patchInventory.setPatchDescription(value);
                continue;
            }
            if (name.equals("bundle_description")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null) continue;
                patchInventory.setBundleDescription(value);
                continue;
            }
            if (name.equals("online_rac_installable")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.rollingPatch = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("sql_migrate")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.sqlMigrate = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("deinstallable")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.rollbackable = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("exit_if_prescript_error")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.exitIfPreScriptError = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("update_components")) {
                NodeList updateCompsList = metadataItem.getChildNodes();
                for (int j7 = 0; j7 < updateCompsList.getLength(); ++j7) {
                    Node updateCompNode = updateCompsList.item(j7);
                    if (updateCompNode.getNodeName().equals("#text")) continue;
                    if (!updateCompNode.getNodeName().equals("update")) {
                        re = new RuntimeException("Unknown metadata uner \"update_components\" in inventory file.");
                        throw re;
                    }
                    Element updateCompElement = (Element)updateCompNode;
                    String compInternalName = updateCompElement.getAttribute("internal_name");
                    String compFromVersion = updateCompElement.getAttribute("from_version");
                    String compToVersion = updateCompElement.getAttribute("to_version");
                    String optReqFlag = updateCompElement.getAttribute("opt_req");
                    UpdateComponent uc = new UpdateComponent(compInternalName, compFromVersion, compToVersion, optReqFlag);
                    patchInventory.updateComps.add(uc);
                }
                continue;
            }
            if (name.equals("prereq_oneoffs")) {
                prereqsNodeList = metadataItem.getChildNodes();
                for (int j8 = 0; j8 < prereqsNodeList.getLength(); ++j8) {
                    Node prereqNode = prereqsNodeList.item(j8);
                    if (prereqNode.getNodeName().equals("#text")) continue;
                    if (!prereqNode.getNodeName().equals("prereq")) {
                        re = new RuntimeException("Unknown metadata under \"prereq_oneoffs\" in inventory file.");
                        throw re;
                    }
                    patchElement = (Element)prereqNode;
                    patchID = patchElement.getAttribute("oneoff_id");
                    patchInventory.prereqOneOffs.add(patchID);
                }
                continue;
            }
            if (name.equals("prereq_bugs")) {
                prereqsNodeList = metadataItem.getChildNodes();
                for (int j9 = 0; j9 < prereqsNodeList.getLength(); ++j9) {
                    Node prereqNode = prereqsNodeList.item(j9);
                    if (prereqNode.getNodeName().equals("#text")) continue;
                    if (!prereqNode.getNodeName().equals("prereq")) {
                        re = new RuntimeException("Unknown metadata under \"prereq_bugs\" in inventory file.");
                        throw re;
                    }
                    patchElement = (Element)prereqNode;
                    patchID = patchElement.getAttribute("bug_id");
                    patchInventory.prereqBugsList.add(patchID);
                }
                continue;
            }
            if (name.equals("wls_prereq_oneoffs")) {
                prereqsNodeList = metadataItem.getChildNodes();
                for (int j10 = 0; j10 < prereqsNodeList.getLength(); ++j10) {
                    Node prereqNode = prereqsNodeList.item(j10);
                    if (prereqNode.getNodeName().equals("#text")) continue;
                    if (!prereqNode.getNodeName().equals("prereq")) {
                        re = new RuntimeException("Unknown metadata under \"wls_prereq_oneoffs\" in inventory file.");
                        throw re;
                    }
                    patchElement = (Element)prereqNode;
                    patchID = patchElement.getAttribute("oneoff_id");
                    String opt_req = patchElement.getAttribute("opt_req");
                    WLSPatch wp = new WLSPatch(patchID, opt_req);
                    patchInventory.wlsPrereqOneOffs.add(wp);
                }
                continue;
            }
            if (name.equals("esyspatch_id")) {
                patchLanguage = (Element)metadataItem;
                String value = patchLanguage.getAttribute("id");
                if (value == null) continue;
                patchInventory.setESysPatchID(value);
                continue;
            }
            if (name.equals("target_entity")) {
                NodeList targetNodeList = metadataItem.getChildNodes();
                for (int j11 = 0; j11 < targetNodeList.getLength(); ++j11) {
                    Node targetNode = targetNodeList.item(j11);
                    if (targetNode.getNodeName().equals("#text")) continue;
                    if (!targetNode.getNodeName().equals("target")) {
                        re = new RuntimeException("Unknown metadata under \"target_entity\" in inventory file.");
                        throw re;
                    }
                    Element targetElement = (Element)targetNode;
                    String targetType = targetElement.getAttribute("type");
                    String targetVersion = targetElement.getAttribute("version");
                    if (null == targetVersion) {
                        targetVersion = "";
                    }
                    TargetEntity te = new TargetEntity(targetType, targetVersion);
                    patchInventory.targetEntities.add(te);
                }
                continue;
            }
            if (name.equals("coreq_oneoffs")) {
                NodeList coreqsNodeList = metadataItem.getChildNodes();
                for (int j12 = 0; j12 < coreqsNodeList.getLength(); ++j12) {
                    Node coreqNode = coreqsNodeList.item(j12);
                    if (coreqNode.getNodeName().equals("#text")) continue;
                    if (!coreqNode.getNodeName().equals("coreq")) {
                        re = new RuntimeException("Unknown metadata under \"coreq_oneoffs\" in inventory file.");
                        throw re;
                    }
                    patchElement = (Element)coreqNode;
                    patchID = patchElement.getAttribute("oneoff_id");
                    patchInventory.coreqOneOffs.add(patchID);
                }
                continue;
            }
            if (name.equals("overlay_oneoffs")) {
                NodeList overlayNodeList = metadataItem.getChildNodes();
                for (int j13 = 0; j13 < overlayNodeList.getLength(); ++j13) {
                    Node overlayNode = overlayNodeList.item(j13);
                    if (overlayNode.getNodeName().equals("#text")) continue;
                    if (!overlayNode.getNodeName().equals("overlay")) {
                        re = new RuntimeException("Unknown metadata under \"overlay_oneoffs\" in inventory file.");
                        throw re;
                    }
                    patchElement = (Element)overlayNode;
                    patchID = patchElement.getAttribute("oneoff_id");
                    patchInventory.overLayOneOffs.add(patchID);
                }
                continue;
            }
            if (name.equals("instance_shutdown_message")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null) continue;
                patchInventory.instanceShutdownMessage = value;
                continue;
            }
            if (name.equals("patch_type")) {
                Element patchTypeElement = (Element)metadataItem;
                String value = patchTypeElement.getAttribute("value");
                String subType = patchTypeElement.getAttribute("sub_type");
                if (value != null) {
                    patchInventory.patchType = value;
                    if (patchInventory.patchType.equalsIgnoreCase("psu")) {
                        patchInventory.setMiniPatchSet(true);
                    }
                }
                if (subType == null || subType.equals("")) continue;
                patchInventory.subType = subType;
                continue;
            }
            if (name.equals("patch_description")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null) continue;
                patchInventory.setPatchDescription(value);
                continue;
            }
            if (name.equals("patch_language")) {
                patchLanguage = (Element)metadataItem;
                String value = patchLanguage.getAttribute("value");
                if (value == null) continue;
                patchInventory.setPatchLanguage(value);
                continue;
            }
            if (name.equals("patching_model")) {
                Element patchModel = (Element)metadataItem;
                String value = patchModel.getAttribute("value");
                if (value == null) continue;
                patchInventory.setPatchModel(value);
                continue;
            }
            if (name.equals("PatchSetUpdate")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equalsIgnoreCase("true")) continue;
                String err = "Patch has invalid metadata \"PatchSetUpdate.\" Patch must be re-packaged.\n";
                throw new RuntimeException(err);
            }
            if (name.equals("product_family")) {
                Element productFamily = (Element)metadataItem;
                String value = productFamily.getAttribute("value");
                if (value == null) continue;
                patchInventory.productFamily = value;
                continue;
            }
            if (name.equals("applicable_product")) {
                productTypeElement = (Element)metadataItem;
                String value = productTypeElement.getAttribute("value");
                if (value == null) continue;
                patchInventory.applicableProductType = value;
                continue;
            }
            if (name.equals("system_component_list")) {
                NodeList sysCompsNodeList = metadataItem.getChildNodes();
                for (int j14 = 0; j14 < sysCompsNodeList.getLength(); ++j14) {
                    Node sysCompNode = sysCompsNodeList.item(j14);
                    if (sysCompNode.getNodeName().equals("#text")) continue;
                    if (!sysCompNode.getNodeName().equals("system_component")) {
                        re = new RuntimeException("Unknown metadata under \"system_component_list\" in inventory file.");
                        throw re;
                    }
                    Element sysCompElement = (Element)sysCompNode;
                    String sysCompName = sysCompElement.getAttribute("name");
                    String sysCompVersion = sysCompElement.getAttribute("version");
                    String sysCompShutdown = sysCompElement.getAttribute("shutdown");
                    pair = patchInventory.getNameVersionPairObject(sysCompName, sysCompVersion, (boolean)Boolean.valueOf(sysCompShutdown));
                    patchInventory.systemComponentList.add(pair);
                }
                continue;
            }
            if (name.equals("application_shutdown_list")) {
                NodeList applicationsNodeList = metadataItem.getChildNodes();
                for (int j15 = 0; j15 < applicationsNodeList.getLength(); ++j15) {
                    Node applicationNode = applicationsNodeList.item(j15);
                    if (applicationNode.getNodeName().equals("#text")) continue;
                    if (!applicationNode.getNodeName().equals("application")) {
                        re = new RuntimeException("Unknown metadata under \"application_shutdown_list\" in inventory file.");
                        throw re;
                    }
                    Element instanceElement = (Element)applicationNode;
                    String applName = instanceElement.getAttribute("name");
                    String applVersion = instanceElement.getAttribute("version");
                    PatchInventory.NameVersionPair pair2 = patchInventory.getNameVersionPairObject(applName, applVersion, true);
                    patchInventory.applicationShutdownList.add(pair2);
                }
                continue;
            }
            if (name.equals("products")) {
                NodeList productsNodeList = metadataItem.getChildNodes();
                for (int j16 = 0; j16 < productsNodeList.getLength(); ++j16) {
                    Node productNode = productsNodeList.item(j16);
                    if (productNode.getNodeName().equals("#text")) continue;
                    if (!productNode.getNodeName().equals("product")) {
                        re = new RuntimeException("Unknown metadata under \"products\" in inventory file.");
                        throw re;
                    }
                    NodeList productsDetailsNodeList = productNode.getChildNodes();
                    String productName = null;
                    String productVer = null;
                    ArrayList<String> productVersion = new ArrayList<String>();
                    for (int k2 = 0; k2 < productsDetailsNodeList.getLength(); ++k2) {
                        Node productDetailsNode = productsDetailsNodeList.item(k2);
                        if (productDetailsNode.getNodeName().equals("#text")) continue;
                        Element detailElement = (Element)productDetailsNode;
                        if (productDetailsNode.getNodeName().equals("name")) {
                            if (productName != null) {
                                RuntimeException re6 = new RuntimeException("Too many names for a single product.");
                                throw re6;
                            }
                            productName = detailElement.getAttribute("value");
                            if (productName != null && !productName.equals("")) continue;
                            throw new RuntimeException("Not able to retrieve product name.\nPossible attribute error [value] or wrong attribute");
                        }
                        if (productDetailsNode.getNodeName().equals("version")) {
                            productVer = detailElement.getAttribute("value");
                            if (productVer == null || productVer.equals("")) {
                                throw new RuntimeException("Not able to retrieve product version.\nPossible attribute error [value] or wrong attribute");
                            }
                            productVersion.add(productVer);
                            continue;
                        }
                        RuntimeException re7 = new RuntimeException("Unknown metadata under \"product\" in inventory file.");
                        throw re7;
                    }
                    if (productName == null) {
                        RuntimeException re8 = new RuntimeException("Unable to find the name of the product.");
                        throw re8;
                    }
                    if (productVersion.size() == 0) {
                        RuntimeException re9 = new RuntimeException("\"Version\" for the given product does not exist.");
                        throw re9;
                    }
                    pair = patchInventory.getNameVersionPairObject(productName, productVersion);
                    patchInventory.productsList.add(pair);
                }
                continue;
            }
            if (name.equals("constituent")) {
                productTypeElement = (Element)metadataItem;
                String active_field = productTypeElement.getAttribute("active");
                if (active_field == null) continue;
                patchInventory.constituentActiveField = active_field;
                continue;
            }
            if (name.equals("cannot_autorollback")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("true")) continue;
                patchInventory.cannotAutoRollback = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("sql_patch")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.sqlPatch = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("fmw_rolling")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.isFmwRolling = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("fmw_feature_bearing")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.isFmwFeatureBearing = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("sql_patch_database_startup_mode")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("normal") && !value.equals("upgrade")) continue;
                patchInventory.sqlPatchDatabaseStartupMode = value;
                continue;
            }
            if (name.equals("in_house_testing_patch")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.inHouseTestingPatch = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("application_dirs")) {
                NodeList applicationDirsNodeList = metadataItem.getChildNodes();
                for (int j17 = 0; j17 < applicationDirsNodeList.getLength(); ++j17) {
                    Node applicationDirNode = applicationDirsNodeList.item(j17);
                    if (applicationDirNode.getNodeName().equals("#text")) continue;
                    if (!applicationDirNode.getNodeName().equals("application_dir")) {
                        re = new RuntimeException("Unknown metadata under \"application_dirs\" in inventory file.");
                        throw re;
                    }
                    Element applicationDirElement = (Element)applicationDirNode;
                    path = applicationDirElement.getAttribute("path");
                    patchInventory.applicationDirs.add(path);
                }
                continue;
            }
            if (name.equals("delete_old_directory")) {
                String value;
                child = metadataItem.getFirstChild();
                if (child == null || (value = child.getNodeValue()) == null || !value.equals("false") && !value.equals("true")) continue;
                patchInventory.deleteOldDirectory = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("custom_stringsubs_property_file")) {
                child = metadataItem.getFirstChild();
                if (child != null) {
                    String value = child.getNodeValue();
                    if (value == null) continue;
                    patchInventory.setCustomStringsubsPropertyFile(Boolean.valueOf(value));
                    continue;
                }
                patchInventory.setCustomStringsubsPropertyFile(false);
                continue;
            }
            if (!name.equals("regressed_patch_id")) continue;
            child = metadataItem.getFirstChild();
            if (child != null) {
                String value = child.getNodeValue();
                if (value == null) continue;
                patchInventory.setRegressedPatchId(value);
                continue;
            }
            patchInventory.setRegressedPatchId("");
        }
        String language = patchInventory.getPatchLanguage();
        if (!language.equals("en")) {
            patchInventory.couldBeTranslation(true);
            if ("snowball".equals(patchInventory.patchType)) {
                patchInventory.setPatchLanguage(IPM.INSTANCE.getAuxServices().convertToOUIPatchLanguage(language));
            }
        } else {
            patchInventory.couldBeTranslation(false);
        }
        return patchInventory;
    }

    protected static OPatchFmwDS.DeployDS[] getContentDeploy(Document doc) throws Exception {
        Element root = doc.getDocumentElement();
        int whatToShow = -1;
        Object nodeFilter = null;
        boolean expandRef = false;
        String rootName = root.getNodeName();
        OPatchFmwDS.DeployDS[] deployObj = new OPatchFmwDS.DeployDS[]{};
        ArrayList<OPatchFmwDS.DeployDS> deployList = new ArrayList<OPatchFmwDS.DeployDS>();
        Object[] retObj = new Object[2];
        if (rootName.equalsIgnoreCase("deployDS")) {
            NodeList metadataList = root.getChildNodes();
            for (int i2 = 0; i2 < metadataList.getLength(); ++i2) {
                Node metadataItem = metadataList.item(i2);
                String name = metadataItem.getNodeName();
                if (name.equals("#text")) continue;
                Node deployNode = metadataItem;
                NodeList deployNodeList = deployNode.getChildNodes();
                boolean childFlag = false;
                String fileName = "";
                String filePath = "";
                String compositeName = "";
                String applName = "";
                boolean redeploy = false;
                boolean activate = false;
                boolean designChange = false;
                boolean restart = false;
                String revision = "";
                if (name.equalsIgnoreCase("J2EE-Deploy")) {
                    childFlag = true;
                    for (int j2 = 0; j2 < deployNodeList.getLength(); ++j2) {
                        Node deployEntityNode = deployNodeList.item(j2);
                        String deployEntityName = deployEntityNode.getNodeName();
                        if (deployEntityName.equals("#text")) continue;
                        if (deployEntityName.equalsIgnoreCase("deploy")) {
                            Element deploy = (Element)deployEntityNode;
                            fileName = deploy.getAttribute("name");
                            filePath = deploy.getAttribute("path");
                            applName = deploy.getAttribute("application_name");
                            redeploy = Boolean.valueOf(deploy.getAttribute("redeploy"));
                            restart = Boolean.valueOf(deploy.getAttribute("restart"));
                            String relativeDeployFilePath = "";
                            try {
                                String newFilePath = PatchObjectUtil.filterString(filePath);
                                String newFileName = PatchObjectUtil.getPlatformDependentPath(fileName);
                                relativeDeployFilePath = newFilePath + File.separator + newFileName;
                            }
                            catch (Exception e2) {
                                RuntimeException rte = new RuntimeException(e2.getMessage());
                                rte.setStackTrace(e2.getStackTrace());
                                throw rte;
                            }
                            OPatchFmwDS.DeployDS dep = new OPatchFmwDS.DeployDS(relativeDeployFilePath, applName, redeploy, restart);
                            deployList.add(dep);
                            continue;
                        }
                        throw new RuntimeException("Unknown tag \"" + deployEntityName + "\" in the deploy.xml " + "metadata of the patch. Please check if the patch is packaged properly.");
                    }
                }
                if (childFlag || name.equals("#text")) continue;
                if (name.equals("deploy")) {
                    Element deploy = (Element)metadataItem;
                    fileName = deploy.getAttribute("name");
                    filePath = deploy.getAttribute("path");
                    applName = deploy.getAttribute("application_name");
                    redeploy = Boolean.valueOf(deploy.getAttribute("redeploy"));
                    restart = Boolean.valueOf(deploy.getAttribute("restart"));
                    String relativeDeployFilePath = "";
                    try {
                        String newFilePath = PatchObjectUtil.filterString(filePath);
                        String newFileName = PatchObjectUtil.getPlatformDependentPath(fileName);
                        relativeDeployFilePath = newFilePath + File.separator + newFileName;
                    }
                    catch (Exception e3) {
                        RuntimeException rte = new RuntimeException(e3.getMessage());
                        rte.setStackTrace(e3.getStackTrace());
                        throw rte;
                    }
                    OPatchFmwDS.DeployDS dep = new OPatchFmwDS.DeployDS(relativeDeployFilePath, applName, redeploy, restart);
                    deployList.add(dep);
                    continue;
                }
                throw new RuntimeException("Unknown tag \"" + name + "\" in the deploy.xml" + " metadata of the patch. Please check if the patch is packaged properly");
            }
        }
        if (deployList.size() != 0) {
            deployObj = new OPatchFmwDS.DeployDS[deployList.size()];
            deployList.toArray(deployObj);
        }
        return deployObj;
    }

    public static InterviewContextVar[] getContentInterview(Document doc) {
        Element root = doc.getDocumentElement();
        int whatToShow = -1;
        Object nodeFilter = null;
        boolean expandRef = false;
        String rootName = root.getNodeName();
        InterviewContextVar[] icvArr = new InterviewContextVar[]{};
        ArrayList<InterviewContextVar> interviewVar = new ArrayList<InterviewContextVar>();
        if (rootName.equalsIgnoreCase("Interview")) {
            NodeList metadataList = root.getChildNodes();
            for (int i2 = 0; i2 < metadataList.getLength(); ++i2) {
                Node metadataItem = metadataList.item(i2);
                String name = metadataItem.getNodeName();
                if (name.equals("#text")) continue;
                if (name.equals("variable")) {
                    Element id = (Element)metadataItem;
                    String varName = id.getAttribute("Name");
                    String varValue = id.getAttribute("value");
                    String varDesc = id.getAttribute("Prompt");
                    boolean isEnv = Boolean.valueOf(id.getAttribute("env"));
                    boolean isPrompt = true;
                    boolean isRequired = Boolean.valueOf(id.getAttribute("required"));
                    boolean isVisible = Boolean.valueOf(id.getAttribute("HideResponse")) == false;
                    InterviewContextVar icv = new InterviewContextVar(varName, varValue.toCharArray(), varDesc, isEnv, isPrompt, isRequired, isVisible);
                    interviewVar.add(icv);
                    continue;
                }
                RuntimeException re = new RuntimeException("Unknown metadata under root 'Interview' in the interview file of the patch");
                throw re;
            }
            InterviewContextVar ucf = new InterviewContextVar("userConfigFile", "".toCharArray(), "", false, false, false, false);
            interviewVar.add(ucf);
            InterviewContextVar ukf = new InterviewContextVar("userKeyFile", "".toCharArray(), "", false, false, false, false);
            interviewVar.add(ukf);
            interviewVar.add(new InterviewContextVar("NodeManagerUsername", "".toCharArray(), "Please enter the NodeManager username", false, true, true, true));
            interviewVar.add(new InterviewContextVar("NMP", "".toCharArray(), "Please enter the NodeManager password", false, true, true, false));
            interviewVar.add(new InterviewContextVar("NodeManagerConfigFile", "".toCharArray(), "", false, false, false, false));
            interviewVar.add(new InterviewContextVar("NodeManagerKeyFile", "".toCharArray(), "", false, false, false, false));
            icvArr = new InterviewContextVar[interviewVar.size()];
            for (int i3 = 0; i3 < icvArr.length; ++i3) {
                icvArr[i3] = (InterviewContextVar)interviewVar.get(i3);
            }
        } else {
            RuntimeException re = new RuntimeException("Unknown root metadata in the interview file of the patch");
            throw re;
        }
        return icvArr;
    }

    public static Set<String> getContentMaintenanceAlias(Path maFile) {
        HashSet<String> maintenanceAliasKeys = new HashSet<String>();
        try {
            MaintenanceAliasActionHolder maintenanceAliasActionHolder = MaintenanceAliasActionService.getInstance().loadMaintenanceAliasAction(maFile.toAbsolutePath().toString());
            for (MaintenanceAliasAction maintenanceAliasAction : maintenanceAliasActionHolder.getMaintenanceAliasActions()) {
                maintenanceAliasKeys.add(maintenanceAliasAction.getMaintenanceAlias().getMaintenanceAliasKey());
            }
            for (MappingAction mappingAction : maintenanceAliasActionHolder.getMappingActions()) {
                maintenanceAliasKeys.add(mappingAction.getMaintenanceAliasKey());
            }
        }
        catch (MaintenanceAliasException e2) {
            throw new RuntimeException("Failed to load maintenance alias actions from " + maFile.toAbsolutePath(), e2);
        }
        return maintenanceAliasKeys;
    }

    public static Set<String> getContentMaintenanceAlias(Document doc) {
        HashSet<String> maintenanceAliasKeys = new HashSet<String>();
        Element root = doc.getDocumentElement();
        if (root.getNodeName().equalsIgnoreCase("maintenance-alias-info")) {
            NodeList children = root.getChildNodes();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                String maintenanceAliasKey;
                Node child = children.item(i2);
                String childName = child.getNodeName();
                if (childName.equalsIgnoreCase("maintenance-aliases")) {
                    NodeList maintenanceAliases = child.getChildNodes();
                    for (int j2 = 0; j2 < maintenanceAliases.getLength(); ++j2) {
                        Node maintenanceAlias = maintenanceAliases.item(j2);
                        if (!maintenanceAlias.getNodeName().equalsIgnoreCase("maintenance-alias")) continue;
                        maintenanceAliasKey = ((Element)maintenanceAlias).getElementsByTagName("maintenance-alias-key").item(0).getFirstChild().getNodeValue();
                        maintenanceAliasKeys.add(maintenanceAliasKey);
                    }
                    continue;
                }
                if (!childName.equalsIgnoreCase("maintenance-alias-artifacts-mapping")) continue;
                NodeList mappings = child.getChildNodes();
                for (int k2 = 0; k2 < mappings.getLength(); ++k2) {
                    Node mapping = mappings.item(k2);
                    if (!mapping.getNodeName().equalsIgnoreCase("mapping")) continue;
                    maintenanceAliasKey = ((Element)mapping).getElementsByTagName("maintenance-alias-key").item(0).getFirstChild().getNodeValue();
                    maintenanceAliasKeys.add(maintenanceAliasKey);
                }
            }
        } else {
            RuntimeException re = new RuntimeException("Unknown root metadata in the maintenance alias file of the patch");
            throw re;
        }
        return maintenanceAliasKeys;
    }

    public static FileMapping getContentFileMapping(Document doc, PatchObject patchObject) throws Exception {
        return new FileMappingImpl(doc, patchObject);
    }

    public static PatchObject loadPatch(String oracleHomePath, String patchID) throws RuntimeException {
        RuntimeException re = null;
        PatchObject patchObject = null;
        String patchLocation = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchID);
        try {
            patchObject = PatchObject.getInstance(oracleHomePath, patchID);
        }
        catch (IllegalAccessException e2) {
            OLogger.error("OUI-67075", new Object[]{patchLocation, e2.getMessage()});
            re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (Throwable t) {
            OLogger.debug(new StringBuffer("PatchObjectUtil::loadPatch unable to load patch, throws unknown exception"));
            re = t.getMessage() != null ? new RuntimeException(t.getMessage()) : new RuntimeException(OLogger.getString("OUI-67022", new Object[]{patchLocation}));
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return patchObject;
    }

    public static PatchObject loadPatch(String patchLocation) throws RuntimeException {
        RuntimeException re = null;
        PatchObject patchObject = null;
        try {
            patchObject = PatchObject.getInstance(patchLocation);
        }
        catch (IllegalAccessException e2) {
            OLogger.error("OUI-67075", new Object[]{patchLocation, e2.getMessage()});
            re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (Throwable t) {
            if (t instanceof SymbolFailureException) {
                throw (SymbolFailureException)t;
            }
            if (t instanceof PatchValidationException) {
                throw (PatchValidationException)t;
            }
            OLogger.debug(new StringBuffer("PatchObjectUtil::loadPatch unable to load patch, throws unknown exception"));
            re = t.getMessage() != null ? new RuntimeException(t.getMessage()) : new RuntimeException(OLogger.getString("OUI-67022", new Object[]{patchLocation}));
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return patchObject;
    }

    public static ChecksumEntity[] loadChecksumFile(Path checksum) throws Exception {
        try {
            if (!Files.exists(checksum, new LinkOption[0]) || Files.isDirectory(checksum, new LinkOption[0])) {
                return new ChecksumEntity[0];
            }
            Document document = PatchObjectUtil.parseXMLFile(checksum);
            return PatchObjectUtil.getContentChecksum(document);
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("PatchObject::loadChecksumFile() returns exception"));
            OLogger.error("Checksum XML File could not be parsed", new Object[]{e2.getMessage()});
            throw e2;
        }
    }

    public static int getARU_ID(String oracleHomePath, IIPMReadServices readServices) {
        int aruID = 0;
        StringBuffer buff = new StringBuffer("getARU_ID()");
        OLogger.debug(buff);
        String aruIDStr = OPatchEnv.getUserDefinedPlatformID();
        if (aruIDStr != null && !aruIDStr.equals("")) {
            try {
                aruID = Integer.parseInt(aruIDStr);
            }
            catch (NumberFormatException e2) {
                OLogger.printStackTrace(e2);
                aruID = 0;
            }
            String msg = OLogger.getString("OUI-67107", new Object[]{aruIDStr});
            OLogger.println(msg);
            return aruID;
        }
        try {
            buff.append(" calling getOracleHomeARU_ID()");
            OLogger.debug(buff);
            aruID = PatchObjectUtil.getOracleHomeARU_ID(oracleHomePath, readServices);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (Uname.invalidPlatformID(aruID)) {
            aruID = PatchObjectUtil.getIdFromUname(oracleHomePath);
            OLogger.debug("calling getIdFromUname() return Platform Id: " + aruID);
        }
        return aruID;
    }

    public static int getIdFromUname(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("getIdFromUname: fall back to uname");
        OLogger.debug(buff);
        int aruID = Uname.getOSID(oracleHomePath);
        buff.append(", which returns ");
        buff.append(aruID);
        OLogger.debug(buff);
        return aruID;
    }

    protected static int getOracleHomeARU_ID(String oracleHomePath, IIPMReadServices readServices) throws NumberFormatException, RuntimeException {
        int aru_id = 0;
        try {
            if (!readServices.isInventoryLoaded()) {
                readServices.loadInventory(oracleHomePath);
            }
            if (readServices.isOracleHomeInfoExist()) {
                StringBuffer tmpS = new StringBuffer("PatchObjectUtil::getOracleHomeARU_ID(): ");
                tmpS.append("calling OUI getARUID() to get the platform ID for the Oracle Home");
                OLogger.debug(tmpS);
                aru_id = readServices.getARUID();
                tmpS = new StringBuffer("PatchObjectUtil::getOracleHomeARU_ID(): ARU ID returned = ");
                tmpS.append(aru_id);
                OLogger.debug(tmpS);
            }
        }
        catch (NumberFormatException e2) {
            aru_id = 0;
            throw e2;
        }
        catch (Throwable t) {
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatform(): Could not get ARUID of the system: retun FALSE"));
            aru_id = 0;
        }
        return aru_id;
    }

    public static boolean patchApplicableOnPlatform(String oracleHomePath, IIPMReadServices readServices, PatchObject patchObject) {
        boolean result = false;
        int aru_id = 0;
        if (patchObject == null) {
            return result;
        }
        Platform[] platforms = patchObject.getPlatforms();
        if (platforms.length == 0) {
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatform: Platform list for the patch is EMPTY: return FALSE"));
            return result;
        }
        for (int i2 = 0; i2 < platforms.length; ++i2) {
            if (!platforms[i2].getID().equals(StringResource.GENERIC_PLATFORM_ID[0]) && !platforms[i2].getID().equals(StringResource.GENERIC_PLATFORM_ID[1])) continue;
            result = true;
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatform: Generic Patch: return TRUE"));
            return result;
        }
        try {
            aru_id = PatchObjectUtil.getARU_ID(oracleHomePath, readServices);
        }
        catch (Throwable t) {
            aru_id = 0;
        }
        if (aru_id <= 0) {
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatform: ARUID of the system is UNKNOWN: return FALSE"));
            return result;
        }
        OLogger.justlog(OLogger.INFO, "OPatch detected ARU_ID/Platform_ID as " + aru_id);
        StringBuffer sbAru = new StringBuffer();
        sbAru.append(aru_id);
        String sAru = sbAru.toString();
        for (int i3 = 0; i3 < platforms.length; ++i3) {
            if (!platforms[i3].getID().equals(sAru)) continue;
            result = true;
            break;
        }
        if (result) {
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatform: return TRUE"));
        } else {
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatform: return FALSE"));
        }
        return result;
    }

    public static boolean patchApplicableOnPlatformIOC(String oracleHomePath, PatchObject patchObject) {
        boolean result = false;
        int aru_id = 0;
        if (patchObject == null) {
            return result;
        }
        Platform[] platforms = patchObject.getPlatforms();
        if (platforms.length == 0) {
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatformIOC: Platform list for the patch is EMPTY: return FALSE"));
            return result;
        }
        for (int i2 = 0; i2 < platforms.length; ++i2) {
            if (!platforms[i2].getID().equals(StringResource.GENERIC_PLATFORM_ID[0]) && !platforms[i2].getID().equals(StringResource.GENERIC_PLATFORM_ID[1])) continue;
            result = true;
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatformIOC: Generic Patch: return TRUE"));
            return result;
        }
        aru_id = 0;
        if (aru_id <= 0) {
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatformIOC: ARUID of the system is UNKNOWN: return FALSE"));
            return result;
        }
        OLogger.justlog(OLogger.INFO, "OPatch detected ARU_ID/Platform_ID as " + aru_id);
        StringBuffer sbAru = new StringBuffer();
        sbAru.append(aru_id);
        String sAru = sbAru.toString();
        for (int i3 = 0; i3 < platforms.length; ++i3) {
            if (!platforms[i3].getID().equals(sAru)) continue;
            result = true;
            break;
        }
        if (result) {
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatformIOC: return TRUE"));
        } else {
            OLogger.debug(new StringBuffer("PatchObjectUtil::patchApplicableOnPlatformIOC: return FALSE"));
        }
        return result;
    }

    protected static long getSpaceUsedInBytes(String path, int depthLevel) {
        Path dir = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]);
        long size = 0L;
        if (depthLevel == 0) {
            return size;
        }
        boolean createDirResult = true;
        if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                Iterator<Path> iterator = stream.iterator();
                while (iterator.hasNext()) {
                    Path entry;
                    Path file = entry = iterator.next();
                    long eachSize = 0L;
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        eachSize = Files.size(file);
                    } else {
                        String eachPath = file.toAbsolutePath().toString();
                        eachSize = PatchObjectUtil.getSpaceUsedInBytes(eachPath, depthLevel--);
                    }
                    size += eachSize;
                }
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        } else if (Files.isDirectory(dir, new LinkOption[0])) {
            try {
                size = Files.size(dir);
            }
            catch (IOException e3) {
                OLogger.debug(e3.getMessage());
            }
        }
        return size;
    }

    protected static String getSizeInProperUnit(String path, int depthLevel) {
        long mega = 0x100000L;
        long kilo = 1024L;
        String megabytes = " Megabytes";
        String kilobytes = " Kilobytes";
        String bytes = " Bytes";
        long size = PatchObjectUtil.getSpaceUsedInBytes(path, depthLevel);
        long value = 0L;
        StringBuffer buff = new StringBuffer();
        if (size > mega) {
            value = size / mega;
            buff.append(value);
            buff.append(megabytes);
        } else if (size > kilo) {
            value = size / kilo;
            buff.append(value);
            buff.append(kilobytes);
        } else {
            buff.append(size);
            buff.append(bytes);
        }
        return buff.toString();
    }

    protected static String[][] getFilesTouched(String oracleHomePath, PatchAction[] patchActions) {
        if (patchActions == null) {
            return null;
        }
        ArrayList filesTouched = new ArrayList();
        for (int i2 = 0; i2 < patchActions.length; ++i2) {
            filesTouched.addAll(patchActions[i2].getFilesTouched(oracleHomePath));
        }
        String[][] ret = new String[filesTouched.size()][];
        for (int i3 = 0; i3 < filesTouched.size(); ++i3) {
            ret[i3] = (String[])filesTouched.get(i3);
        }
        return ret;
    }
}

