/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.opatch.ArchiveAction;
import oracle.opatch.CopyAction;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.JarAction;
import oracle.opatch.JarActionEntity;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentCheckResult;
import oracle.opatch.PatchObject;
import oracle.opatch.Platform;
import oracle.opatch.RacProcessor;
import oracle.opatch.RegenerateLib;
import oracle.opatch.Restorable;
import oracle.opatch.Rules;
import oracle.opatch.SQLUtilities;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.StringSubsAction;
import oracle.opatch.opatchactions.sqlprocAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.wrappers.WrapperFactory;

public class MergedPatchObject
extends PatchObject {
    private final String cookedPatchID;
    private static ArrayList sessionPatchObjects = new ArrayList();
    private static ArrayList triggeredPatchObjects = new ArrayList();
    private boolean isMiniPatchset = false;
    ArrayList isRollingList = new ArrayList();
    ArrayList isShutdownList = new ArrayList();
    ArrayList isSqlMigrateList = new ArrayList();
    ArrayList patchIDs = new ArrayList();
    ArrayList addedPlatformList = new ArrayList();
    ArrayList addedCopyActions = new ArrayList();
    ArrayList addedJarActions = new ArrayList();
    ArrayList addedDeleteJarActions = new ArrayList();
    ArrayList addedArchiveActions = new ArrayList();
    ArrayList addedMakeActions = new ArrayList();
    ArrayList addedStringSubsActions = new ArrayList();
    ArrayList addedComponents = new ArrayList();
    ArrayList addedDeleteActions = new ArrayList();
    ArrayList addedPluginActions = new ArrayList();
    ArrayList addedExternalPluginActions = new ArrayList();
    TreeSet addedExecutables = new TreeSet();
    public final String sessionName;

    public MergedPatchObject(String sessionName) {
        this.sessionName = sessionName;
        sessionPatchObjects.clear();
        triggeredPatchObjects.clear();
        String invokeTime = OLogger.getFormatTimeStamp();
        this.cookedPatchID = sessionName + File.separator + invokeTime;
    }

    public MergedPatchObject(String sessionName, String cookedID) {
        this.sessionName = sessionName;
        sessionPatchObjects.clear();
        triggeredPatchObjects.clear();
        this.cookedPatchID = cookedID;
    }

    @Override
    public Platform[] getPlatforms() {
        int size = this.addedPlatformList.size();
        Platform[] ps = new Platform[size];
        for (int i2 = 0; i2 < size; ++i2) {
            Platform p2;
            Object obj = this.addedPlatformList.get(i2);
            if (!(obj instanceof Platform)) continue;
            ps[i2] = p2 = (Platform)obj;
        }
        return ps;
    }

    public String[] getPatchIDs() {
        int size = this.patchIDs.size();
        String[] ret = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            Object obj = this.patchIDs.get(i2);
            ret[i2] = obj instanceof String ? (String)obj : "";
        }
        return ret;
    }

    @Override
    public String getCookedPatchID() {
        return this.cookedPatchID;
    }

    @Override
    public String getPatchID() {
        return this.cookedPatchID;
    }

    public void merge(String oracleHomePath, PatchObject p2, boolean session) throws RuntimeException {
        boolean firstMerge = this.patchIDs.size() == 0;
        this.isMiniPatchset = p2.getPatchInventory().isMiniPatchSet();
        this.mergePatchInventory(oracleHomePath, p2);
        this.mergePatchComponent(p2, firstMerge);
        this.patchIDs.add(p2.getPatchID());
        if (session) {
            sessionPatchObjects.add(p2);
        } else {
            triggeredPatchObjects.add(p2);
        }
        boolean isRolling = p2.isRolling();
        Boolean isR = isRolling;
        this.isRollingList.add(isR);
        boolean isShutdown = p2.isShutdown();
        Boolean isS = isShutdown;
        this.isShutdownList.add(isS);
        boolean isSqlMigrate = p2.isSqlMigrate();
        Boolean isM = isSqlMigrate;
        this.isSqlMigrateList.add(isM);
    }

    protected void mergePatchInventory(String oracleHomePath, PatchObject p2) throws RuntimeException {
        String[] executables = p2.getExecutables(oracleHomePath);
        for (int i2 = 0; i2 < executables.length; ++i2) {
            String exe = executables[i2];
            if (exe == null || this.addedExecutables.contains(exe)) continue;
            this.addedExecutables.add(exe);
        }
        Platform[] platforms = p2.getPlatforms();
        for (int i3 = 0; i3 < platforms.length; ++i3) {
            Platform eachPlat = platforms[i3];
            this.addedPlatformList.add(eachPlat);
        }
    }

    protected void mergePatchActions(LinkedList list) throws RuntimeException {
        StringBuffer buff = new StringBuffer("MergedPatchObject::mergePatchActions()");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PatchAction myPa;
            JarActionEntity myJa;
            JarActionEntity itJa;
            int j2;
            Object pa = list.get(i2);
            boolean found = false;
            if (pa instanceof CopyAction) {
                CopyAction itCa = (CopyAction)pa;
                for (j2 = 0; j2 < this.addedCopyActions.size() && !found; ++j2) {
                    CopyAction myCa = (CopyAction)this.addedCopyActions.get(j2);
                    found = myCa.equals(itCa);
                }
                if (found) continue;
                buff = new StringBuffer("  add CopyAction for ");
                buff.append(itCa.getCopyName());
                this.addedCopyActions.add(itCa);
                continue;
            }
            if (pa instanceof JarAction) {
                itJa = (JarAction)pa;
                for (j2 = 0; j2 < this.addedJarActions.size() && !found; ++j2) {
                    myJa = (JarAction)this.addedJarActions.get(j2);
                    found = ((JarAction)myJa).equals(itJa);
                }
                if (found) continue;
                buff = new StringBuffer("  add JarAction for ");
                buff.append(itJa.getJarName());
                this.addedJarActions.add(itJa);
                continue;
            }
            if (pa instanceof DeleteJarAction) {
                itJa = (DeleteJarAction)pa;
                for (j2 = 0; j2 < this.addedDeleteJarActions.size() && !found; ++j2) {
                    myJa = (DeleteJarAction)this.addedDeleteJarActions.get(j2);
                    found = ((DeleteJarAction)myJa).equals(itJa);
                }
                if (found) continue;
                buff = new StringBuffer("  add DeleteJarAction for ");
                buff.append(itJa.getJarName());
                OLogger.printlnOnLog(buff.toString());
                this.addedDeleteJarActions.add(itJa);
                continue;
            }
            if (pa instanceof ArchiveAction) {
                ArchiveAction itAa = (ArchiveAction)pa;
                for (j2 = 0; j2 < this.addedArchiveActions.size() && !found; ++j2) {
                    ArchiveAction myAa = (ArchiveAction)this.addedArchiveActions.get(j2);
                    found = myAa.equals(itAa);
                }
                if (found) continue;
                buff = new StringBuffer("  add ArchiveAction for ");
                buff.append(itAa.getArchiveName());
                OLogger.printlnOnLog(buff.toString());
                this.addedArchiveActions.add(itAa);
                continue;
            }
            if (pa instanceof MakeAction) {
                MakeAction itMa = (MakeAction)pa;
                for (j2 = 0; j2 < this.addedMakeActions.size() && !found; ++j2) {
                    MakeAction myMa = (MakeAction)this.addedMakeActions.get(j2);
                    found = myMa.equals(itMa);
                }
                if (found) continue;
                buff = new StringBuffer("  add MakeAction for ");
                buff.append(itMa.getMakeTarget());
                OLogger.printlnOnLog(buff.toString());
                this.addedMakeActions.add(itMa);
                continue;
            }
            if (pa instanceof StringSubsAction) {
                StringSubsAction itSsa = (StringSubsAction)pa;
                for (j2 = 0; j2 < this.addedStringSubsActions.size() && !found; ++j2) {
                    StringSubsAction mySsa = (StringSubsAction)this.addedStringSubsActions.get(j2);
                    found = mySsa.equals(itSsa);
                }
                if (found) continue;
                buff = new StringBuffer("  add StringSubsActions for ");
                buff.append(itSsa.getConfigPath());
                OLogger.printlnOnLog(buff.toString());
                this.addedStringSubsActions.add(itSsa);
                continue;
            }
            if (pa instanceof DeleteAction) {
                DeleteAction itDa = (DeleteAction)pa;
                for (j2 = 0; j2 < this.addedDeleteActions.size() && !found; ++j2) {
                    DeleteAction myDa = (DeleteAction)this.addedDeleteActions.get(j2);
                    found = myDa.equals(itDa);
                }
                if (found) continue;
                buff = new StringBuffer("  add DeleteAction for ");
                buff.append(itDa.getSourceFile());
                OLogger.printlnOnLog(buff.toString());
                this.addedDeleteActions.add(itDa);
                continue;
            }
            PatchAction ppa = (PatchAction)pa;
            for (j2 = 0; j2 < this.addedPluginActions.size() && !found; ++j2) {
                myPa = (PatchAction)this.addedPluginActions.get(j2);
                found = myPa.equals(ppa);
            }
            if (!found) {
                buff = new StringBuffer("  add PluginAction for ");
                buff.append(ppa.getActionName());
                OLogger.printlnOnLog(buff.toString());
                this.addedPluginActions.add(ppa);
            }
            for (j2 = 0; j2 < this.addedExternalPluginActions.size() && !found; ++j2) {
                myPa = (PatchAction)this.addedExternalPluginActions.get(j2);
                found = myPa.equals(ppa);
            }
            if (found) continue;
            buff = new StringBuffer("  add external PluginAction for ");
            buff.append(ppa.getActionName());
            OLogger.printlnOnLog(buff.toString());
            this.addedExternalPluginActions.add(ppa);
        }
        buff = new StringBuffer("MergedPatchObject::mergePatchActions() done.");
        OLogger.debug(buff);
    }

    private PatchComponent mergeComponents(PatchComponent myPc, PatchComponent itPc) {
        boolean reqd = myPc.isRequired() || itPc.isRequired();
        PatchComponent mergedPC = new PatchComponent(myPc.getName(), myPc.getVersion(), reqd);
        mergedPC.copyList = new LinkedList(myPc.getCopyList());
        mergedPC.copyList.addAll(itPc.getCopyList());
        mergedPC.archiveList = new LinkedList(myPc.getArchiveList());
        mergedPC.archiveList.addAll(itPc.getArchiveList());
        mergedPC.jarList = new LinkedList(myPc.getJarList());
        mergedPC.jarList.addAll(itPc.getJarList());
        mergedPC.makeList = new LinkedList(myPc.getMakeList());
        mergedPC.makeList.addAll(itPc.getMakeList());
        mergedPC.stringSubsList = new LinkedList(myPc.getStringSubsList());
        mergedPC.stringSubsList.addAll(itPc.getStringSubsList());
        mergedPC.deleteList = new LinkedList(myPc.getDeleteList());
        mergedPC.deleteList.addAll(itPc.getDeleteList());
        mergedPC.pluginList = new LinkedList(myPc.getPluginList());
        mergedPC.pluginList.addAll(itPc.getPluginList());
        mergedPC.externalPluginList = new LinkedList(myPc.getExternalPluginList());
        mergedPC.externalPluginList.addAll(itPc.getExternalPluginList());
        return mergedPC;
    }

    protected void mergePatchComponent(PatchObject p2, boolean firstMerge) throws RuntimeException {
        StringBuffer buff = new StringBuffer("MergedPatchObject::mergePatchComponent()");
        OLogger.debug(buff);
        PatchComponent[] pcs = p2.getPatchComponents();
        if (firstMerge) {
            buff = new StringBuffer("  first merge: just add components/actions.");
            OLogger.debug(buff);
            for (int i2 = 0; i2 < pcs.length; ++i2) {
                PatchAction pa;
                Object obj;
                int j2;
                PatchComponent pc = pcs[i2];
                buff = new StringBuffer("Add component ");
                buff.append(pc.getName());
                buff.append(", ");
                buff.append(pc.getVersion());
                OLogger.log(OLogger.FINE, buff.toString());
                this.addedComponents.add(pc);
                LinkedList list = pc.getCopyList();
                if (list != null) {
                    for (j2 = 0; j2 < list.size(); ++j2) {
                        obj = list.get(j2);
                        if (!(obj instanceof CopyAction)) continue;
                        CopyAction ca = (CopyAction)obj;
                        buff = new StringBuffer("  add CopyAction for ");
                        buff.append(ca.getCopyName());
                        this.addedCopyActions.add(ca);
                    }
                }
                if ((list = pc.getJarList()) != null) {
                    for (j2 = 0; j2 < list.size(); ++j2) {
                        JarActionEntity ja;
                        obj = list.get(j2);
                        if (obj instanceof JarAction) {
                            ja = (JarAction)obj;
                            buff = new StringBuffer("  add JarAction for ");
                            buff.append(ja.getJarName());
                            this.addedJarActions.add(ja);
                            continue;
                        }
                        if (!(obj instanceof DeleteJarAction)) continue;
                        ja = (DeleteJarAction)obj;
                        buff = new StringBuffer("  add DeleteJarAction for ");
                        buff.append(ja.getJarName());
                        OLogger.log(OLogger.FINE, buff.toString());
                        this.addedDeleteJarActions.add(ja);
                    }
                }
                if ((list = pc.getArchiveList()) != null) {
                    for (j2 = 0; j2 < list.size(); ++j2) {
                        obj = list.get(j2);
                        if (!(obj instanceof ArchiveAction)) continue;
                        ArchiveAction aa = (ArchiveAction)obj;
                        buff = new StringBuffer("  add ArchiveAction for ");
                        buff.append(aa.getArchiveName());
                        OLogger.log(OLogger.FINE, buff.toString());
                        this.addedArchiveActions.add(aa);
                    }
                }
                if ((list = pc.getMakeList()) != null) {
                    for (j2 = 0; j2 < list.size(); ++j2) {
                        obj = list.get(j2);
                        if (!(obj instanceof MakeAction)) continue;
                        MakeAction ma = (MakeAction)obj;
                        buff = new StringBuffer("  add MakeAction for ");
                        buff.append(ma.getMakeTarget());
                        OLogger.log(OLogger.FINE, buff.toString());
                        this.addedMakeActions.add(ma);
                    }
                }
                if ((list = pc.getStringSubsList()) != null) {
                    for (j2 = 0; j2 < list.size(); ++j2) {
                        obj = list.get(j2);
                        if (!(obj instanceof StringSubsAction)) continue;
                        StringSubsAction ssa = (StringSubsAction)obj;
                        buff = new StringBuffer("  add StringSubsAction for ");
                        buff.append(ssa.getConfigPath());
                        OLogger.log(OLogger.FINE, buff.toString());
                        this.addedStringSubsActions.add(ssa);
                    }
                }
                if ((list = pc.getDeleteList()) != null) {
                    for (j2 = 0; j2 < list.size(); ++j2) {
                        obj = list.get(j2);
                        if (!(obj instanceof DeleteAction)) continue;
                        DeleteAction da = (DeleteAction)obj;
                        buff = new StringBuffer("  add DeleteAction for ");
                        buff.append(da.getSourceFile());
                        OLogger.log(OLogger.FINE, buff.toString());
                        this.addedDeleteActions.add(da);
                    }
                }
                if ((list = pc.getPluginList()) != null) {
                    for (j2 = 0; j2 < list.size(); ++j2) {
                        obj = list.get(j2);
                        if (!(obj instanceof PatchAction)) continue;
                        pa = (PatchAction)obj;
                        buff = new StringBuffer(" add PluginAction for ");
                        buff.append(pa.getActionName());
                        OLogger.log(OLogger.FINE, buff.toString());
                        this.addedPluginActions.add(pa);
                    }
                }
                if ((list = pc.getExternalPluginList()) == null) continue;
                for (j2 = 0; j2 < list.size(); ++j2) {
                    obj = list.get(j2);
                    if (!(obj instanceof PatchAction)) continue;
                    pa = (PatchAction)obj;
                    buff = new StringBuffer(" add PluginAction for ");
                    buff.append(pa.getActionName());
                    OLogger.log(OLogger.FINE, buff.toString());
                    this.addedExternalPluginActions.add(pa);
                }
            }
            return;
        }
        PatchComponent myPc = null;
        PatchComponent itPc = null;
        for (int i3 = 0; i3 < pcs.length; ++i3) {
            itPc = pcs[i3];
            boolean found = false;
            boolean upgrade = false;
            for (int j3 = 0; j3 < this.addedComponents.size() && !found; ++j3) {
                Object o2 = this.addedComponents.get(j3);
                if (!(o2 instanceof PatchComponent)) continue;
                myPc = (PatchComponent)o2;
                String myPcName = myPc.getName();
                String myPcVersion = myPc.getVersion();
                String itPcName = itPc.getName();
                String itPcVersion = itPc.getVersion();
                if (!myPcName.equals(itPcName) || !myPcVersion.equals(itPcVersion)) continue;
                found = true;
                if (myPc.isRequired() || !itPc.isRequired()) continue;
                upgrade = true;
            }
            if (!found) {
                buff = new StringBuffer("MergedPatchObject: component not found, just add it.");
                OLogger.debug(buff);
                buff = new StringBuffer("Add component ");
                buff.append(itPc.getName());
                buff.append(", ");
                buff.append(itPc.getVersion());
                OLogger.log(OLogger.FINE, buff.toString());
                this.addedComponents.add(itPc);
            } else if (myPc != null && found) {
                buff = new StringBuffer("MergedPatchObject: component found as Optional. ");
                buff.append("Merge all non-dup. actions.");
                OLogger.debug(buff);
                if (upgrade) {
                    buff = new StringBuffer("Upgrade component ");
                    buff.append(myPc.getName());
                    buff.append(", ");
                    buff.append(myPc.getVersion());
                    buff.append(" from 'Optional' to 'Required'.");
                    OLogger.log(OLogger.FINE, buff.toString());
                }
                this.addedComponents.remove(myPc);
                PatchComponent mergedPC = this.mergeComponents(myPc, itPc);
                this.addedComponents.add(mergedPC);
            }
            LinkedList cList = itPc.getCopyList();
            LinkedList jList = itPc.getJarList();
            LinkedList aList = itPc.getArchiveList();
            LinkedList mList = itPc.getMakeList();
            LinkedList sList = itPc.getStringSubsList();
            LinkedList dList = itPc.getDeleteList();
            LinkedList pList = itPc.getPluginList();
            LinkedList epList = itPc.getExternalPluginList();
            this.mergePatchActions(cList);
            this.mergePatchActions(jList);
            this.mergePatchActions(aList);
            this.mergePatchActions(mList);
            this.mergePatchActions(sList);
            this.mergePatchActions(dList);
            this.mergePatchActions(pList);
            this.mergePatchActions(epList);
        }
        buff = new StringBuffer("MergedPatchObject::mergePatchComponent() done.");
        OLogger.debug(buff);
    }

    @Override
    public boolean isShutdown() {
        StringBuffer buff = new StringBuffer("MergedPatchObject::isShutdown()");
        OLogger.debug(buff);
        boolean shutdown = false;
        for (int i2 = 0; i2 < this.isShutdownList.size(); ++i2) {
            Boolean b2;
            Object obj = this.isShutdownList.get(i2);
            if (!(obj instanceof Boolean) || !(b2 = (Boolean)obj).booleanValue()) continue;
            shutdown = true;
            break;
        }
        buff = new StringBuffer(" return ");
        buff.append(shutdown);
        OLogger.debug(buff);
        return shutdown;
    }

    @Override
    public String getShutdownMsg() {
        return "";
    }

    @Override
    public boolean isRolling() {
        StringBuffer buff = new StringBuffer("MergedPatchObject::isRolling()");
        OLogger.debug(buff);
        boolean rolling = true;
        for (int i2 = 0; i2 < this.isRollingList.size(); ++i2) {
            Boolean b2;
            Object obj = this.isRollingList.get(i2);
            if (!(obj instanceof Boolean) || (b2 = (Boolean)obj).booleanValue()) continue;
            buff = new StringBuffer(" return false");
            OLogger.debug(buff);
            return false;
        }
        buff = new StringBuffer(" return ");
        buff.append(rolling);
        return rolling;
    }

    @Override
    public boolean isSqlMigrate() {
        StringBuffer buff = new StringBuffer("MergedPatchObject::isSqlMigrate()");
        OLogger.debug(buff);
        boolean sqlMigrate = false;
        for (int i2 = 0; i2 < this.isSqlMigrateList.size(); ++i2) {
            Boolean b2;
            Object obj = this.isSqlMigrateList.get(i2);
            if (!(obj instanceof Boolean) || !(b2 = (Boolean)obj).booleanValue()) continue;
            buff = new StringBuffer(" return true");
            OLogger.debug(buff);
            return true;
        }
        buff = new StringBuffer(" return ");
        buff.append(sqlMigrate);
        return sqlMigrate;
    }

    @Override
    public String[] getExecutables(String oracleHomePath) {
        return this.getExecutables();
    }

    @Override
    public String[] getExecutables() {
        int size = this.addedExecutables.size();
        String[] executables = new String[size];
        Iterator iter = this.addedExecutables.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            executables[i2] = obj instanceof String ? (String)obj : "";
            ++i2;
        }
        return executables;
    }

    private PatchComponent[] getAllPatchComponents() {
        PatchComponent[] tmp = new PatchComponent[this.addedComponents.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            PatchComponent a2;
            Object obj = this.addedComponents.get(i2);
            if (!(obj instanceof PatchComponent)) continue;
            tmp[i2] = a2 = (PatchComponent)obj;
        }
        return tmp;
    }

    public CopyAction[] getAllCopyActions() {
        CopyAction[] tmp = new CopyAction[this.addedCopyActions.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            CopyAction a2;
            Object obj = this.addedCopyActions.get(i2);
            if (!(obj instanceof CopyAction)) continue;
            tmp[i2] = a2 = (CopyAction)obj;
        }
        return tmp;
    }

    public JarAction[] getAllJarActions() {
        JarAction[] tmp = new JarAction[this.addedJarActions.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            JarAction a2;
            Object obj = this.addedJarActions.get(i2);
            if (!(obj instanceof JarAction)) continue;
            tmp[i2] = a2 = (JarAction)obj;
        }
        return tmp;
    }

    public DeleteJarAction[] getAllDeleteJarActions() {
        DeleteJarAction[] tmp = new DeleteJarAction[this.addedDeleteJarActions.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            DeleteJarAction a2;
            Object obj = this.addedDeleteJarActions.get(i2);
            if (!(obj instanceof DeleteJarAction)) continue;
            tmp[i2] = a2 = (DeleteJarAction)obj;
        }
        return tmp;
    }

    public ArchiveAction[] getAllArchiveActions() {
        ArchiveAction[] tmp = new ArchiveAction[this.addedArchiveActions.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            ArchiveAction a2;
            Object obj = this.addedArchiveActions.get(i2);
            if (!(obj instanceof ArchiveAction)) continue;
            tmp[i2] = a2 = (ArchiveAction)obj;
        }
        return tmp;
    }

    public MakeAction[] getAllMakeActions() {
        MakeAction[] tmp = new MakeAction[this.addedMakeActions.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            MakeAction a2;
            Object obj = this.addedMakeActions.get(i2);
            if (!(obj instanceof MakeAction)) continue;
            tmp[i2] = a2 = (MakeAction)obj;
        }
        return tmp;
    }

    public StringSubsAction[] getAllStringSubsActions() {
        StringSubsAction[] tmp = new StringSubsAction[this.addedStringSubsActions.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            StringSubsAction a2;
            Object obj = this.addedStringSubsActions.get(i2);
            if (!(obj instanceof StringSubsAction)) continue;
            tmp[i2] = a2 = (StringSubsAction)obj;
        }
        return tmp;
    }

    public DeleteAction[] getAllDeleteActions() {
        DeleteAction[] tmp = new DeleteAction[this.addedDeleteActions.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            DeleteAction a2;
            Object obj = this.addedDeleteActions.get(i2);
            if (!(obj instanceof DeleteAction)) continue;
            tmp[i2] = a2 = (DeleteAction)obj;
        }
        return tmp;
    }

    public PatchAction[] getAllThePluginActions() {
        PatchAction[] tmp = new PatchAction[this.addedPluginActions.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            PatchAction a2;
            Object obj = this.addedPluginActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            tmp[i2] = a2 = (PatchAction)obj;
        }
        return tmp;
    }

    public PatchAction[] getAllTheExternalPluginActions() {
        PatchAction[] tmp = new PatchAction[this.addedExternalPluginActions.size()];
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            PatchAction a2;
            Object obj = this.addedExternalPluginActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            tmp[i2] = a2 = (PatchAction)obj;
        }
        return tmp;
    }

    @Override
    public PatchAction[] getAllActions() throws NullPointerException {
        PatchAction pa;
        Object obj;
        int i2;
        StringBuffer buff = new StringBuffer("MergedPatchObject::getAllActions()");
        OLogger.debug(buff);
        int size = this.addedCopyActions.size() + this.addedJarActions.size() + this.addedArchiveActions.size() + this.addedMakeActions.size() + this.addedExternalPluginActions.size() + this.addedPluginActions.size() + this.addedDeleteActions.size() + this.addedStringSubsActions.size();
        buff = new StringBuffer(" returns ");
        buff.append(size);
        buff.append(" actions.");
        OLogger.debug(buff);
        PatchAction[] pas = new PatchAction[size];
        size = this.addedCopyActions.size();
        int index = 0;
        for (i2 = 0; i2 < size; ++i2) {
            obj = this.addedCopyActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            pa = (PatchAction)obj;
            pas[index++] = pa;
        }
        size = this.addedJarActions.size();
        for (i2 = 0; i2 < size; ++i2) {
            obj = this.addedJarActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            pa = (PatchAction)obj;
            pas[index++] = pa;
        }
        size = this.addedArchiveActions.size();
        for (i2 = 0; i2 < size; ++i2) {
            obj = this.addedArchiveActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            pa = (PatchAction)obj;
            pas[index++] = pa;
        }
        size = this.addedMakeActions.size();
        for (i2 = 0; i2 < size; ++i2) {
            obj = this.addedMakeActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            pa = (PatchAction)obj;
            pas[index++] = pa;
        }
        size = this.addedDeleteActions.size();
        for (i2 = 0; i2 < size; ++i2) {
            obj = this.addedDeleteActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            pa = (PatchAction)obj;
            pas[index++] = pa;
        }
        size = this.addedPluginActions.size();
        for (i2 = 0; i2 < size; ++i2) {
            obj = this.addedPluginActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            pa = (PatchAction)obj;
            pas[index++] = pa;
        }
        size = this.addedExternalPluginActions.size();
        for (i2 = 0; i2 < size; ++i2) {
            obj = this.addedExternalPluginActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            pa = (PatchAction)obj;
            pas[index++] = pa;
        }
        size = this.addedStringSubsActions.size();
        for (i2 = 0; i2 < size; ++i2) {
            obj = this.addedStringSubsActions.get(i2);
            if (!(obj instanceof PatchAction)) continue;
            pa = (PatchAction)obj;
            pas[index++] = pa;
        }
        return pas;
    }

    @Override
    public PatchComponent[] getOptionalPatchComponents() {
        PatchComponent[] allPCs = this.getAllPatchComponents();
        ArrayList<PatchComponent> list = new ArrayList<PatchComponent>();
        for (int i2 = 0; i2 < allPCs.length; ++i2) {
            PatchComponent pc = allPCs[i2];
            if (pc.isRequired()) continue;
            list.add(pc);
        }
        PatchComponent[] optList = new PatchComponent[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            PatchComponent pc;
            optList[i3] = pc = (PatchComponent)list.get(i3);
        }
        return optList;
    }

    public boolean restoreOH(String oracleHomePath) {
        return this.restoreOH(oracleHomePath, null);
    }

    public boolean restoreOH(String oracleHomePath, OneOffEntry[] patchesToApply) {
        if (OPatchEnv.isReport()) {
            OLogger.printlnOnLog("Reporting mode, skip restoring oh.");
            return true;
        }
        try {
            int i2;
            StringBuffer buff = new StringBuffer("\nRestoring \"");
            buff.append(oracleHomePath);
            buff.append("\" to the state prior to running ");
            buff.append(this.sessionName);
            buff.append("...");
            OLogger.println(buff.toString());
            boolean apply = false;
            boolean rollback = false;
            if (this.sessionName.equals("apply") || this.sessionName.equals(OPatchEnv.getNApplySessionName())) {
                apply = true;
            } else if (this.sessionName.equals("rollback") || this.sessionName.equals(OPatchEnv.getNRollbackSessionName())) {
                rollback = true;
            } else {
                buff = new StringBuffer("Restore is supported for apply and rollback sessions only.");
                buff.append("\nGiven session is \"" + this.sessionName + "\" an unsupported session.");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            if (OPatchEnv.isRegenerationNeeded()) {
                RegenerateLib.restoreLibraries(oracleHomePath, this.cookedPatchID);
            }
            if (patchesToApply != null) {
                this.removeAppliedPatchesMetadataFromInventory(oracleHomePath, patchesToApply);
            }
            if (!this.restoreSystemAndInventory(oracleHomePath, this.cookedPatchID)) {
                return false;
            }
            ArrayList pObjs = this.getSessionPatchObjects();
            ArrayList tPObjs = this.getTriggeredPatchObjects();
            PatchObject[] ap = new PatchObject[pObjs.size()];
            pObjs.toArray(ap);
            PatchObject[] rb = new PatchObject[tPObjs.size()];
            tPObjs.toArray(rb);
            CUPPatchComponent.restore(ap);
            CUPPatchComponent.restore(rb);
            OPatchSession.restorePatchesInventory(oracleHomePath, ap, rb, apply);
            boolean delayed = false;
            if (pObjs != null && pObjs.size() != 0) {
                for (i2 = 0; i2 < pObjs.size(); ++i2) {
                    OPatchSession.restorePluginActions(oracleHomePath, this.cookedPatchID, (PatchObject)pObjs.get(i2), apply, rollback, delayed);
                    if (!apply) continue;
                    OPatchSession.restoreNewCopyActions(oracleHomePath, this.cookedPatchID, (PatchObject)pObjs.get(i2));
                }
            } else {
                RuntimeException re = new RuntimeException("There are no patch objects to restore.");
                throw re;
            }
            if (tPObjs != null && tPObjs.size() != 0 && apply) {
                for (i2 = 0; i2 < tPObjs.size(); ++i2) {
                    OPatchSession.restorePluginActions(oracleHomePath, this.cookedPatchID, (PatchObject)tPObjs.get(i2), true, true, delayed);
                    if (!apply) continue;
                    OPatchSession.restoreNewCopyActions(oracleHomePath, this.cookedPatchID, (PatchObject)tPObjs.get(i2));
                }
            }
            if (!OPatchEnv.isWindows()) {
                OLogger.info("OUI-67111");
                if (OPatchEnv.isNolink()) {
                    OLogger.info("OUI-67217");
                } else {
                    OPatchSession.restorePatchgen(oracleHomePath);
                    OPatchSession.restoreMake(oracleHomePath, this.cookedPatchID);
                }
            }
            delayed = true;
            if (pObjs != null && pObjs.size() != 0) {
                for (i2 = 0; i2 < pObjs.size(); ++i2) {
                    OPatchSession.restorePluginActions(oracleHomePath, this.cookedPatchID, (PatchObject)pObjs.get(i2), apply, rollback, delayed);
                }
            } else {
                RuntimeException re = new RuntimeException("There are no patch objects to restore.");
                throw re;
            }
            if (tPObjs != null && tPObjs.size() != 0 && apply) {
                for (i2 = 0; i2 < tPObjs.size(); ++i2) {
                    OPatchSession.restorePluginActions(oracleHomePath, this.cookedPatchID, (PatchObject)tPObjs.get(i2), true, true, delayed);
                }
            }
            SQLUtilities.shutdownAllDB(oracleHomePath);
            OLogger.info("OUI-67037");
        }
        catch (Throwable t) {
            OLogger.error("OUI-67115", new Object[]{oracleHomePath});
            return false;
        }
        return true;
    }

    public void removeAppliedPatchesMetadataFromInventory(String oracleHomePath, OneOffEntry[] patchesApplied) {
        for (OneOffEntry patchToRemove : patchesApplied) {
            String oneoffsToBeRemoved = IPMUtil.getOneoffsLocation(oracleHomePath, patchToRemove.getTripletID());
            Path oneoffsToBeRemovedFile = WrapperFactory.getNioServiceWrapper().getPath(oneoffsToBeRemoved, new String[0]);
            if (!Files.exists(oneoffsToBeRemovedFile, new LinkOption[0])) continue;
            try {
                SystemCall.deleteRecurse(oneoffsToBeRemovedFile, true);
            }
            catch (RuntimeException e2) {
                OLogger.println("OPatch failed to remove metadata of oneoffs for patch " + patchToRemove.getPatchID());
            }
        }
    }

    public boolean restoreSystemAndInventory(String oracleHomePath, String cookedPatchID) {
        String backupLoc = OPatchUtilHelper.getBackupLoc(oracleHomePath, cookedPatchID);
        OLogger.log(OLogger.FINE, "\nRestoring files...");
        if (Rules.OUIWrite_continue() || Rules.SystemWrite_continue()) {
            OLogger.printlnOnLog("Restoring files: copy recurse from " + backupLoc + " to " + oracleHomePath);
            if (SystemCall.copyRecurseForRestore(WrapperFactory.getNioServiceWrapper().getPath(backupLoc, new String[0]), WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]), true, false)) {
                OLogger.info("OUI-67214");
                return false;
            }
            String rInterim = OPatchEnv.getRecordInventoryFileLoc(oracleHomePath);
            Path interimInv = WrapperFactory.getNioServiceWrapper().getPath(rInterim, new String[0]);
            String sInterim = OPatchEnv.getInterimInventoryFileLoc(oracleHomePath);
            Path restoreInv = WrapperFactory.getNioServiceWrapper().getPath(sInterim, new String[0]);
            if (Files.exists(interimInv, new LinkOption[0])) {
                try {
                    SystemCall.copyFile(interimInv, restoreInv);
                }
                catch (RuntimeException e2) {
                    OLogger.info("OUI-67214");
                    OLogger.printStackTrace(e2);
                    return false;
                }
            } else {
                OLogger.log(OLogger.INFO, "Unable to get \"" + rInterim + "\" for restore.");
            }
        }
        return true;
    }

    public ArrayList getSessionPatchObjects() {
        return sessionPatchObjects;
    }

    public static ArrayList getTriggeredPatchObjects() {
        return triggeredPatchObjects;
    }

    public static void setTriggeredPatchObjects(List pObjs) {
        triggeredPatchObjects = new ArrayList(pObjs);
    }

    @Override
    public PatchComponent[] getRequiredPatchComponents() {
        PatchComponent[] allPCs = this.getAllPatchComponents();
        ArrayList<PatchComponent> list = new ArrayList<PatchComponent>();
        for (int i2 = 0; i2 < allPCs.length; ++i2) {
            PatchComponent pc = allPCs[i2];
            if (!pc.isRequired()) continue;
            list.add(pc);
        }
        PatchComponent[] reqList = new PatchComponent[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            PatchComponent pc;
            reqList[i3] = pc = (PatchComponent)list.get(i3);
        }
        return reqList;
    }

    public void backupForRestore(String oracleHomePath, IIPMReadServices readServices) throws RuntimeException {
        this.backupForRestore(oracleHomePath, readServices, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public void backupForRestore(String oracleHomePath, IIPMReadServices readServices, String[] patchesToApply, String[] patchesToRollback) throws RuntimeException {
        block31: {
            buff = new StringBuffer("MergedPatchObject::backupForRestore() on ");
            buff.append(oracleHomePath);
            buff.append(" for ");
            buff.append(this.sessionName);
            OLogger.debug(buff);
            if (Rules.OUIWrite_continue()) {
                backupLoc = OPatchUtilHelper.getBackupLoc(oracleHomePath, this.cookedPatchID);
                contentsXMLSrc = IPMUtil.getCompsXMLLocation(oracleHomePath);
                contentsXMLDst = IPMUtil.getCompsXMLLocation(backupLoc);
                if (patchesToApply == null) {
                    oneOffsSrc = IPMUtil.getOneoffsLocation(oracleHomePath);
                    oneOffsDst = IPMUtil.getOneoffsLocation(backupLoc);
                    buff = new StringBuffer("Back up patch inventory from \"");
                    buff.append((String)oneOffsSrc);
                    buff.append("\" to \"");
                    buff.append(oneOffsDst);
                    buff.append("\".");
                    OLogger.log(OLogger.FINE, buff.toString());
                    srcFile = WrapperFactory.getNioServiceWrapper().getPath((String)oneOffsSrc, new String[0]);
                    dstFile = WrapperFactory.getNioServiceWrapper().getPath(oneOffsDst, new String[0]);
                    if (Files.exists(srcFile, new LinkOption[0])) {
                        try {
                            if (!Files.exists(dstFile, new LinkOption[0])) {
                                buff = new StringBuffer("Creating directory \"");
                                buff.append(dstFile.toString());
                                buff.append("\"");
                                OLogger.log(OLogger.FINE, buff.toString());
                                try {
                                    Files.createDirectories(dstFile, new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    OLogger.debug(e.getMessage());
                                }
                            }
                            debug = true;
                            SystemCall.backupRecurse(srcFile, dstFile, debug);
                        }
                        catch (RuntimeException e) {
                            OLogger.error("OUI-67083", new Object[]{this.sessionName, oneOffsSrc});
                            buff = new StringBuffer(OLogger.getString("OUI-67083", new Object[]{this.sessionName, oneOffsSrc}));
                            ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(buff);
                            if (ignoreBackupError) ** GOTO lbl95
                            throw e;
                        }
                    }
                } else if (patchesToRollback != null) {
                    for (String patchToBackup : patchesToRollback) {
                        oneOffsSrc = IPMUtil.getOneoffsLocation(oracleHomePath, patchToBackup);
                        oneOffsDst = IPMUtil.getOneoffsLocation(backupLoc, patchToBackup);
                        buff = new StringBuffer("Back up patch inventory from \"");
                        buff.append(oneOffsSrc);
                        buff.append("\" to \"");
                        buff.append(oneOffsDst);
                        buff.append("\".");
                        OLogger.log(OLogger.FINE, buff.toString());
                        srcFile = WrapperFactory.getNioServiceWrapper().getPath(oneOffsSrc, new String[0]);
                        dstFile = WrapperFactory.getNioServiceWrapper().getPath(oneOffsDst, new String[0]);
                        if (!Files.exists(srcFile, new LinkOption[0])) continue;
                        try {
                            if (!Files.exists(dstFile, new LinkOption[0])) {
                                buff = new StringBuffer("Creating directory \"");
                                buff.append(dstFile.toString());
                                buff.append("\"");
                                OLogger.log(OLogger.FINE, buff.toString());
                                try {
                                    Files.createDirectories(dstFile, new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    OLogger.debug(e.getMessage());
                                }
                            }
                            debug = true;
                            SystemCall.backupRecurse(srcFile, dstFile, debug);
                        }
                        catch (RuntimeException e) {
                            OLogger.error("OUI-67083", new Object[]{this.sessionName, oneOffsSrc});
                            buff = new StringBuffer(OLogger.getString("OUI-67083", new Object[]{this.sessionName, oneOffsSrc}));
                            ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(buff);
                            if (ignoreBackupError) continue;
                            throw e;
                        }
                    }
                }
lbl95:
                // 6 sources

                srcFile = WrapperFactory.getNioServiceWrapper().getPath(contentsXMLSrc, new String[0]);
                dstFile = WrapperFactory.getNioServiceWrapper().getPath(contentsXMLDst, new String[0]);
                buff = new StringBuffer("Back up Oracle Home Inventory from \"");
                buff.append(contentsXMLSrc);
                buff.append("\" to \"");
                buff.append(contentsXMLDst);
                buff.append("\".");
                OLogger.log(OLogger.FINE, buff.toString());
                if (Files.exists(srcFile, new LinkOption[0])) {
                    try {
                        SystemCall.backupFile(srcFile, dstFile);
                    }
                    catch (RuntimeException e) {
                        OLogger.error("OUI-67083", new Object[]{this.sessionName, contentsXMLSrc});
                        buff = new StringBuffer(OLogger.getString("OUI-67083", new Object[]{this.sessionName, contentsXMLSrc}));
                        ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(buff);
                        if (ignoreBackupError) break block31;
                        throw e;
                    }
                }
            }
        }
        if (Rules.OUIWrite_continue() || Rules.SystemWrite_continue()) {
            restoreLoc = OPatchUtilHelper.getRestoreLoc(oracleHomePath, this.cookedPatchID);
            buff = new StringBuffer("Create restore file \"");
            buff.append(restoreLoc);
            buff.append("\".");
            OLogger.log(OLogger.FINE, buff.toString());
            fRestore = WrapperFactory.getNioServiceWrapper().getPath(restoreLoc, new String[0]);
            if (!Files.exists(fRestore, new LinkOption[0])) {
                buff = new StringBuffer("Not able to create restore file for ");
                buff.append(this.sessionName);
                buff.append(".  File not exist: \"");
                buff.append(restoreLoc);
                buff.append("\".");
                re = new RuntimeException(buff.toString());
                throw re;
            }
            try {
                OPatchEnv.createRestoreFile(oracleHomePath, this.cookedPatchID, patchesToApply);
            }
            catch (IOException e) {
                re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
        }
        if (Rules.shouldWarnAboutBackupForRestoreDelay(nActions = (pas = this.getPatchActions()).length)) {
            OLogger.onlyLogInfo("OUI-67117", new Object[]{this.sessionName});
        }
        if (Rules.SystemWrite_continue()) {
            compsToBackup = new HashSet<PatchComponent>();
            rollback = this.sessionName.contains("ollback");
            actionsToBackUp = new HashMap<String, PatchAction>();
            analyzed = readServices.analyzePatchComponents(rollback != false ? MergedPatchObject.triggeredPatchObjects : MergedPatchObject.sessionPatchObjects, rollback);
            for (Map.Entry<PatchObject, Map<PatchComponent, PatchComponentCheckResult>> entry : analyzed.entrySet()) {
                for (Map.Entry<PatchComponent, PatchComponentCheckResult> pcEntry : entry.getValue().entrySet()) {
                    pc = pcEntry.getKey();
                    pcCheckResult = pcEntry.getValue().getResult();
                    if (!pcCheckResult.isProcessComponent()) continue;
                    compsToBackup.add(pc);
                    for (PatchAction pa : pc.getAllActions()) {
                        if (pa instanceof MakeAction || pa instanceof sqlprocAction || pa instanceof StringSubsAction) continue;
                        actionsToBackUp.put(pa.getParentFilePath(oracleHomePath), pa);
                    }
                }
            }
            buff = new StringBuffer("Back-up Patch Actions");
            OLogger.debug(buff);
            for (PatchAction pa : actionsToBackUp.values()) {
                if (!(pa instanceof Restorable)) continue;
                ra = (Restorable)pa;
                buff = new StringBuffer(ra.getBackupForRestoreDesc(oracleHomePath, this.cookedPatchID));
                OLogger.debug(buff);
                if (!ra.restorable(oracleHomePath, this.cookedPatchID)) continue;
                ra.backupForRestore(oracleHomePath, this.cookedPatchID);
            }
        }
    }

    @Override
    public String toString() {
        String entry;
        int i2;
        String[] patchIDs = this.getPatchIDs();
        CopyAction[] cas = this.getAllCopyActions();
        JarAction[] jas = this.getAllJarActions();
        DeleteJarAction[] djas = this.getAllDeleteJarActions();
        ArchiveAction[] aas = this.getAllArchiveActions();
        MakeAction[] mas = this.getAllMakeActions();
        StringSubsAction[] ssas = this.getAllStringSubsActions();
        String oracleHomePath = StringResource.getLiteralOracleHome();
        String[] exes = this.getExecutables(oracleHomePath);
        StringBuffer buff = new StringBuffer("[MergedPatchObject: IDs: ");
        for (i2 = 0; i2 < patchIDs.length; ++i2) {
            String id = patchIDs[i2];
            buff.append(id);
            buff.append(", ");
        }
        buff.append(", CopyAction: ");
        for (i2 = 0; i2 < cas.length; ++i2) {
            CopyAction ca = cas[i2];
            entry = ca.getRawActionEntry();
            buff.append(entry);
            buff.append(", ");
        }
        buff.append(", JarAction: ");
        for (i2 = 0; i2 < jas.length; ++i2) {
            JarAction ja = jas[i2];
            entry = ja.getRawActionEntry();
            buff.append(entry);
            buff.append(", ");
        }
        buff.append(", DeleteJarAction: ");
        for (i2 = 0; i2 < djas.length; ++i2) {
            DeleteJarAction dja = djas[i2];
            entry = dja.getRawActionEntry();
            buff.append(entry);
            buff.append(", ");
        }
        buff.append(", ArchiveAction: ");
        for (i2 = 0; i2 < aas.length; ++i2) {
            ArchiveAction aa = aas[i2];
            entry = aa.getRawActionEntry();
            buff.append(entry);
            buff.append(", ");
        }
        buff.append(", MakeAction: ");
        for (i2 = 0; i2 < mas.length; ++i2) {
            MakeAction ma = mas[i2];
            entry = ma.getRawActionEntry();
            buff.append(entry);
            buff.append(", ");
        }
        buff.append(", StringSubsAction: ");
        for (i2 = 0; i2 < ssas.length; ++i2) {
            StringSubsAction ssa = ssas[i2];
            entry = ssa.getRawActionEntry();
            buff.append(entry);
            buff.append(", ");
        }
        buff.append(", Fuser list: ");
        for (i2 = 0; i2 < exes.length; ++i2) {
            String exe = exes[i2];
            buff.append(exe);
            buff.append(", ");
        }
        return buff.toString();
    }

    @Override
    public boolean forceAllNodeMode() {
        PatchObject pObj;
        int i2;
        StringBuffer buff = new StringBuffer("MergedPatchObject::forceAllNodeMode()");
        OLogger.debug(buff);
        boolean allNodeMode = false;
        for (i2 = 0; i2 < sessionPatchObjects.size(); ++i2) {
            pObj = (PatchObject)sessionPatchObjects.get(i2);
            if (!pObj.forceAllNodeMode()) continue;
            allNodeMode = true;
        }
        for (i2 = 0; i2 < triggeredPatchObjects.size(); ++i2) {
            pObj = (PatchObject)triggeredPatchObjects.get(i2);
            if (!pObj.forceAllNodeMode()) continue;
            allNodeMode = true;
        }
        buff = new StringBuffer(" return ");
        buff.append(allNodeMode);
        return allNodeMode;
    }

    public void invokeConsolidatedMake(String oracleHomePath, PatchObject[] patchObjects) throws Error {
        StringBuffer buff = new StringBuffer(this.sessionName);
        buff.append(": re-link Oracle binaries.");
        OLogger.debug(buff);
        String fileName = "make.txt";
        String locToPlaceFile = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, this.cookedPatchID);
        MakeAction[] makes = OPatchSessionHelper.getIncludedMakeActions(oracleHomePath, patchObjects);
        try {
            buff = new StringBuffer("Write the consolidated make actions in make.txt\n");
            OLogger.debug(buff);
            this.writeMakeEntry(oracleHomePath, locToPlaceFile, fileName, makes);
        }
        catch (IOException e2) {
            buff = new StringBuffer("MergedPatchObject cannot create and write make.txt.  ");
            buff.append("The list of make actions for manual step cannot be created.");
            OLogger.warn("OUI-67124", new Object[]{buff.toString()});
        }
        OPatchSession.runMake(this.sessionName, oracleHomePath, patchObjects);
    }

    public void invokeConsolidatedRLib(String oracleHomePath, PatchObject[] patchObjects) {
        OPatchSessionHelper.runLibraryRegeneration(patchObjects, oracleHomePath);
    }

    public void promptForStartup(String oracleHomePath, IIPMReadServices readServices) {
        OPatchUtilHelper.promptForStartup(oracleHomePath, readServices);
    }

    public RacProcessor.MinDowntimeNodeSelection promptForShutdown(String oracleHomePath, IIPMReadServices readServices) throws ExitOPatchException, RuntimeException {
        try {
            boolean rolling = this.isRolling();
            boolean shutdown = this.isShutdown();
            return OPatchUtilHelper.promptForShutdown(oracleHomePath, readServices, this.sessionName, rolling, shutdown, this.getShutdownMsg());
        }
        catch (ExitOPatchException e2) {
            throw e2;
        }
        catch (RuntimeException e3) {
            throw e3;
        }
    }

    private void writeMakeEntry(String oracleHomePath, String locToPlaceFile, String fileName, MakeAction[] makes) throws IOException {
        if (OPatchEnv.isWindows()) {
            return;
        }
        if (makes == null) {
            OLogger.debug(new StringBuffer("MergedPatchObject::writeMakeEntry() - makes array is null"));
            return;
        }
        StringBuffer buff = new StringBuffer("writeMakeEntry() to \"");
        buff.append(locToPlaceFile);
        buff.append("\" as \"");
        buff.append(fileName);
        OLogger.debug(buff);
        StringBuffer fileLoc = new StringBuffer(locToPlaceFile);
        fileLoc.append(File.separator);
        fileLoc.append(fileName);
        Path fMake = WrapperFactory.getNioServiceWrapper().getPath(fileLoc.toString(), new String[0]);
        BufferedWriter fMakeWriter = null;
        if (!Files.exists(fMake, new LinkOption[0])) {
            buff = new StringBuffer("The file  \"");
            buff.append(fileLoc.toString());
            buff.append("\" didn't exist.  It should have been created prior ");
            buff.append("to this patching phrase.");
            RuntimeException re = new RuntimeException(buff.toString());
            throw re;
        }
        fMakeWriter = Files.newBufferedWriter(fMake, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
        for (int i2 = 0; i2 < makes.length; ++i2) {
            MakeAction ma = makes[i2];
            if (ma == null) continue;
            buff = new StringBuffer("MergedPatchObject::generateMakeFile() in \"");
            buff.append(fileLoc.toString());
            buff.append("\"");
            OLogger.debug(buff);
            String[] makeCmdAndDir = ma.getLocalMakeCommandEntryForMakeTxt(oracleHomePath);
            String makeCmd = makeCmdAndDir[0];
            String chDir = makeCmdAndDir[1];
            StringBuffer makeEntry = new StringBuffer("cd");
            makeEntry.append(" ");
            makeEntry.append(chDir);
            makeEntry.append(";");
            makeEntry.append(makeCmd);
            makeEntry.append("\n");
            buff = new StringBuffer(" writing the following entry to make.txt: \"");
            buff.append(makeEntry.toString());
            buff.append("\"");
            OLogger.debug(buff);
            fMakeWriter.write(makeEntry.toString());
            fMakeWriter.flush();
            continue;
        }
        fMakeWriter.close();
    }
}

