/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.LsInventoryFileFormatter;
import oracle.opatch.LsInventoryPrinter;
import oracle.opatch.LsInventoryRacInfo;
import oracle.opatch.LsInventoryToXML;
import oracle.opatch.OPatch;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSession;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.Rules;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class LsInventorySession
extends OPatchSession {
    private FileHandler logFileHandler = null;

    protected LsInventorySession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    @Override
    public boolean isReadOnly() {
        this.readOnly = true;
        return true;
    }

    public void init(String oracleHomePath) throws RuntimeException {
        StringBuffer buff = new StringBuffer("LsInventory::init()");
        OLogger.debug(buff);
        Object re = null;
        boolean ok = false;
        String sessionType = this.getSessionName();
        String outputFileName = "";
        try {
            outputFileName = OPatchACL.invokeOLogger(this, "getOutputFileNameForLsInv", new Object[]{oracleHomePath, sessionType}).toString();
        }
        catch (IllegalAccessException e2) {
            RuntimeException rte = new RuntimeException(e2.getMessage());
            rte.setStackTrace(e2.getStackTrace());
            throw rte;
        }
        buff = new StringBuffer("LsInventorySession::init(): Creating an output file: ");
        buff.append(outputFileName);
        OLogger.debug(buff);
        if (!OPatchEnv.isLogDisabled()) {
            try {
                Path outputFile = WrapperFactory.getNioServiceWrapper().getPath(outputFileName, new String[0]);
                Files.createFile(outputFile, new FileAttribute[0]);
                OUIReplacer.changePermission(outputFileName, 416);
            }
            catch (Exception e3) {
                buff = new StringBuffer("LsInventory can't/didn't create the output file: ");
                buff.append(outputFileName);
                OLogger.debug(buff);
            }
            try {
                this.logFileHandler = new FileHandler(outputFileName);
                this.logFileHandler.setFormatter(new LsInventoryFileFormatter());
                this.logFileHandler.setLevel(Level.INFO);
                OPatchACL.invokeOLogger(this, "setLsInventoryFileHandler", new Object[]{this.logFileHandler});
                OPatchACL.invokeOLogger(this, "addHandler", new Object[]{this.logFileHandler});
                buff = new StringBuffer("Lsinventory Output file location : ");
                buff.append(outputFileName);
                OLogger.log(OLogger.INFO, buff.toString());
            }
            catch (Exception e4) {
                buff = new StringBuffer("LsInventory::init() failed");
                OLogger.debug(buff);
            }
        } else {
            System.out.println("Lsinventory Output is disabled.");
        }
    }

    protected InstalledComponent[] getMatchedComponent(InstalledComponent[] comps, String regExp) {
        InstalledComponent[] filteredComps = new InstalledComponent[]{};
        ArrayList<InstalledComponent> list = new ArrayList<InstalledComponent>();
        StringBuffer buff = new StringBuffer();
        buff.append("(.*)(");
        buff.append(regExp);
        buff.append(")(.*)");
        Pattern pattern = Pattern.compile(buff.toString(), 2);
        for (int i2 = 0; i2 < comps.length; ++i2) {
            InstalledComponent ic = comps[i2];
            String ID = ic.getID();
            Matcher matcher = pattern.matcher(ID);
            if (!matcher.matches()) continue;
            list.add(ic);
        }
        int len = list.size();
        filteredComps = new InstalledComponent[len];
        for (int i3 = 0; i3 < len; ++i3) {
            InstalledComponent ic;
            filteredComps[i3] = ic = (InstalledComponent)list.get(i3);
        }
        return filteredComps;
    }

    public static String getLastUpdateInv(String oracleHomePath) throws IllegalAccessException, Exception {
        StringBuffer errorMsg = new StringBuffer("OPatchSession::getLastUpdateInv");
        String strComps_xml = oracleHomePath + File.separator + "inventory" + File.separator + "ContentsXML" + File.separator + "comps.xml";
        Path fileComps_xml = WrapperFactory.getNioServiceWrapper().getPath(strComps_xml, new String[0]);
        String result = "";
        try {
            if (Files.exists(fileComps_xml, new LinkOption[0])) {
                Date dt = new Date(Files.getLastModifiedTime(fileComps_xml, new LinkOption[0]).toMillis());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                result = sdf.format(dt).toString();
                return result;
            }
            OLogger.debug("OPatchSession::getLastUpdateInv comps.xml file: " + fileComps_xml + " does not exist");
            throw new IllegalAccessException(errorMsg.toString());
        }
        catch (Exception e2) {
            if (e2 instanceof IllegalAccessException) {
                throw new IllegalAccessException(e2.getMessage());
            }
            throw e2;
        }
    }

    @Override
    public void process(String oracleHomePath) throws RuntimeException {
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            if (!readServices.isInventoryLoaded()) {
                boolean alreadyLocked = readServices.isLocked();
                try {
                    if (!alreadyLocked) {
                        readServices.lock(oracleHomePath);
                    }
                    readServices.loadInventory(oracleHomePath);
                }
                catch (Throwable ti) {
                    throw ti;
                }
                finally {
                    if (!alreadyLocked) {
                        readServices.release();
                    }
                }
            }
            if (!readServices.isInventoryLoaded()) {
                OLogger.printlnres("OUI-67121");
            } else {
                this.loadAndPrintInventory(oracleHomePath, readServices);
            }
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t) {
            OLogger.error("OUI-67028", new Object[]{"LsInventorySession::process()"});
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAndPrintInventory(String oracleHomePath, IIPMReadServices readServices) throws RuntimeException {
        block53: {
            oneOffs = new OneOffEntry[]{};
            nodeList = new String[]{};
            oracleHomeName = "";
            re = null;
            isCRS = false;
            buff = new StringBuffer("LsInventory::loadAndPrintInventory()");
            OLogger.debug(buff);
            OLogger.debug(new StringBuffer("Retrieving inventory from Oracle Home..."));
            try {
                this.init(oracleHomePath);
                optPatchChecksum = OPatchEnv.isPatchChecksum();
                allNodes = OPatchEnv.isAllNode();
                optAll = OPatchEnv.isLsinv_all();
                optXML = OPatchEnv.isLsinv_xml();
                optMatch = OPatchEnv.isLsinv_match();
                optInactive = OPatchEnv.isLsinv_inactive();
                optPatch = OPatchEnv.isLsinv_patch();
                optDetail = OPatchEnv.isLsinv_detail();
                optBugsFixed = OPatchEnv.isSortByBugsFixed();
                optTrans = OPatchEnv.isTransPatch();
                printHome = Rules.printHomes(optAll, optXML, optMatch, optPatch, optDetail);
                printAllProduct = Rules.printAllProducts(optAll, optXML, optMatch, optPatch, optDetail);
                printTopLevelProduct = Rules.printTopLevelProducts(optAll, optXML, optMatch, optPatch, optDetail);
                printMatchedProduct = Rules.printMatchedProducts(optAll, optXML, optMatch, optPatch, optDetail);
                printPatch = Rules.printOneOffs(optAll, optXML, optMatch, optPatch, optDetail, optBugsFixed, optTrans);
                printDetail = Rules.printDetails(optAll, optXML, optMatch, optPatch, optDetail, optBugsFixed, optTrans);
                printByBugsFixed = Rules.printByBugsFixed(optAll, optXML, optMatch, optPatch, optDetail, optBugsFixed);
                printLangPatches = Rules.printLangPatch(optAll, optXML, optMatch, optPatch, optDetail, optTrans);
                printPatchChecksum = optPatchChecksum;
                if (allNodes) {
                    printHome = false;
                    printAllProduct = false;
                    printTopLevelProduct = false;
                    printMatchedProduct = false;
                    printPatch = false;
                    printDetail = false;
                    printByBugsFixed = false;
                    printLangPatches = false;
                }
                if (!optBugsFixed && !optTrans) {
                    OLogger.println("--------------------------------------------------------------------------------");
                } else {
                    OLogger.println("------------------------------------------------------------------------------------------------------");
                }
                rules = new Rules();
                buff = new StringBuffer(rules.toString());
                OLogger.debug(buff);
                oracleHomes = new OPatchSDK.OracleHome[]{};
                oneOffs = optInactive != false ? readServices.getInactivePatches() : readServices.getAllInstalledPatches();
                if (optXML) {
                    xmlOutputStream = null;
                    xmlFile = OPatchEnv.getLsinv_xml_loc();
                    ok = true;
                    try {
                        file = WrapperFactory.getNioServiceWrapper().getPath(xmlFile, new String[0]);
                        parentDir = file.getParent();
                        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                            Files.createDirectories(parentDir, new FileAttribute[0]);
                        }
                        xmlOutputStream = Files.newOutputStream(file, new OpenOption[0]);
                        comps = readServices.getInstalledComponents();
                        localNode = "";
                        if (nodeList != null && nodeList.length > 1) {
                            localNode = nodeList[0];
                        }
                        LsInventoryToXML.process(xmlOutputStream, oracleHomeName, oracleHomePath, isCRS, localNode, nodeList, comps, oneOffs, oracleHomes);
                    }
                    catch (IOException e) {
                        ok = false;
                    }
                    finally {
                        xmlOutputStream.flush();
                        xmlOutputStream.close();
                    }
                    if (!ok) {
                        System.out.println("\n\nCannot generate " + xmlFile);
                    } else {
                        System.out.println("\n\nGenerated xml file " + xmlFile + " from Oracle Home inventory shown above.");
                    }
                    if (this.logFileHandler == null) return;
                }
                ** GOTO lbl-1000
            }
            catch (SecurityException e) {
                try {
                    buff = new StringBuffer("OPatch cannot load inventory for the given Oracle Home.\n");
                    buff.append("Possible causes are:\n");
                    buff.append("  Oracle Home path does not match with entry in inventory.xml\n");
                    buff.append("  Oracle Home was installed with -invPtrLoc option");
                    OLogger.error("OUI-67028", new Object[]{buff.toString()});
                    re = new RuntimeException(e.getMessage());
                    re.setStackTrace(e.getStackTrace());
                    throw re;
                    catch (IllegalArgumentException e) {
                        buff = new StringBuffer("OPatch cannot load inventory for the given Oracle Home.\n");
                        buff.append("Possible causes are:\n");
                        buff.append("   ORACLE_HOME/oui/jlib does not exist\n");
                        buff.append("   One of the required libraries is missing");
                        OLogger.error("OUI-67028", new Object[]{buff.toString()});
                        re = new RuntimeException(e.getMessage());
                        re.setStackTrace(e.getStackTrace());
                        throw re;
                    }
                    catch (NullPointerException e) {
                        buff = new StringBuffer("OPatch cannot load inventory for the given Oracle Home.\n");
                        buff.append("Possible causes are:\n");
                        buff.append("   Oracle Home dir. path does not exist in Central Inventory\n");
                        buff.append("   Oracle Home is a symbolic link\n");
                        buff.append("   Oracle Home inventory is corrupted");
                        OLogger.error("OUI-67028", new Object[]{buff.toString()});
                        re = new RuntimeException(e.getMessage());
                        re.setStackTrace(e.getStackTrace());
                        throw re;
                    }
                    catch (Throwable t) {
                        OLogger.println("\n");
                        OLogger.error("OUI-67028", new Object[]{"OPatch cannot load inventory for the given Oracle Home.\n"});
                        re = new RuntimeException(t.getMessage());
                        re.setStackTrace(t.getStackTrace());
                        throw re;
                    }
                }
                catch (Throwable var38_56) {
                    if (this.logFileHandler == null) throw var38_56;
                    this.logFileHandler.setLevel(Level.OFF);
                    try {
                        OPatchACL.invokeOLogger(this, "rmHandler", new Object[]{this.logFileHandler});
                        throw var38_56;
                    }
                    catch (IllegalAccessException e) {
                        rte = new RuntimeException(e.getMessage());
                        rte.setStackTrace(e.getStackTrace());
                        throw rte;
                    }
                }
            }
            this.logFileHandler.setLevel(Level.OFF);
            try {
                OPatchACL.invokeOLogger(this, "rmHandler", new Object[]{this.logFileHandler});
                return;
            }
            catch (IllegalAccessException e) {
                rte = new RuntimeException(e.getMessage());
                rte.setStackTrace(e.getStackTrace());
                throw rte;
            }
lbl-1000:
            // 1 sources

            {
                LsInventoryPrinter.printLocalMachineInfo(readServices);
                if (printHome) {
                    oracleHomes = readServices.getOracleHomes();
                    LsInventoryPrinter.printListOfOracleHomes(oracleHomes);
                }
                if (printTopLevelProduct) {
                    if (OPatchEnv.isNextGen()) {
                        comps = readServices.getNextGenInstalledDistributions();
                        if (comps == null) {
                            comps = readServices.getTopLevelInstalledComponents();
                        }
                    } else {
                        comps = readServices.getTopLevelInstalledComponents();
                    }
                    header = "";
                    len = new Integer(comps.length);
                    header = OLogger.getString("OUI-67097", new Object[]{len});
                    if (comps.length != 0) {
                        LsInventoryPrinter.printInstalledComponents_ProdName_Version(comps, header, LsInventoryPrinter.ProductModelType.TOP_LEVEL_PRODUCT);
                        OLogger.println("");
                    }
                }
                if (printAllProduct) {
                    if (OPatchEnv.isNextGen()) {
                        comps = readServices.getNextGenInstalledComponents();
                        if (comps == null) {
                            comps = readServices.getInstalledComponents();
                        }
                    } else {
                        comps = readServices.getInstalledComponents();
                    }
                    len = new Integer(comps.length);
                    header = OLogger.getString("OUI-67130", new Object[]{len});
                    LsInventoryPrinter.printInstalledComponents_ProdName_Version(comps, header, LsInventoryPrinter.ProductModelType.INSTALLED_PRODUCT);
                    if (optDetail && OPatchEnv.isNextGen()) {
                        listCompsNgoui = OLogger.getString("OUI-67739");
                        OLogger.println(listCompsNgoui);
                    }
                    OLogger.println("");
                }
                if (printMatchedProduct) {
                    regExp = OPatchEnv.getLsInvRegExpression();
                    comps = readServices.getInstalledComponents();
                    comps = this.getMatchedComponent(comps, regExp);
                    LsInventoryPrinter.printMatchedInstalledComponents_ProdID_Version_Name(regExp, comps);
                    OLogger.println("");
                }
                if (printPatch) {
                    detail = OPatchEnv.isLsinv_detail();
                    if (optInactive) {
                        installedOneOffs = readServices.getInstalledPatches();
                        LsInventoryPrinter.printInactivePatches("ORACLE_HOME", oneOffs, installedOneOffs, printDetail);
                    } else {
                        LsInventoryPrinter.printInstalledPatches("ORACLE_HOME", oneOffs, printDetail, oracleHomePath);
                    }
                }
                if (printByBugsFixed) {
                    oracleHome = OPatchEnv.getOracleHome();
                    LsInventoryPrinter.printBugsFixedByPatches(oracleHome, oneOffs);
                }
                if (printLangPatches) {
                    oracleHome = OPatchEnv.getOracleHome();
                    installedPatches = readServices.getInstalledPatches();
                    inactivePatches = readServices.getInactivePatches();
                    LsInventoryPrinter.printTranslationPatches(oracleHome, installedPatches, inactivePatches);
                }
                if (printPatchChecksum) {
                    oracleHome = OPatchEnv.getOracleHome();
                    this.logFileHandler.setLevel(Level.OFF);
                    LsInventoryPrinter.printPatchAndChecksum(oracleHome, oneOffs);
                    this.logFileHandler.setLevel(Level.INFO);
                }
                oracleHomeName = readServices.getOracleHomeName();
                isCRS = readServices.isCRSHome();
                OLogger.println("");
                try {
                    nodeList = LsInventorySession.probeAndPrintRACInfo(readServices);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                if (allNodes) {
                    this.logFileHandler.setLevel(Level.OFF);
                    LsInventorySession.printAllNodesInfo(OPatchEnv.getOracleHome(), readServices);
                    this.logFileHandler.setLevel(Level.INFO);
                }
                if (!optBugsFixed && !optTrans) {
                    OLogger.println("--------------------------------------------------------------------------------");
                } else {
                    OLogger.println("------------------------------------------------------------------------------------------------------");
                }
                if (this.logFileHandler == null) break block53;
            }
            this.logFileHandler.setLevel(Level.OFF);
            try {
                OPatchACL.invokeOLogger(this, "rmHandler", new Object[]{this.logFileHandler});
            }
            catch (IllegalAccessException e) {
                rte = new RuntimeException(e.getMessage());
                rte.setStackTrace(e.getStackTrace());
                throw rte;
            }
        }
        buff = new StringBuffer("LsInventory::getInstance() returns");
        OLogger.debug(buff);
    }

    protected static String[] probeAndPrintRACInfo(IIPMReadServices readServices) throws RuntimeException {
        LsInventoryRacInfo lsInventoryRacInfo = OPatchExternalFactory.getLsInventoryRacInfo(null);
        return lsInventoryRacInfo.probeAndPrintRACInfo(readServices);
    }

    protected static void printAllNodesInfo(String oracleHomePath, IIPMReadServices readServices) throws RuntimeException {
        LsInventoryRacInfo lsInventoryRacInfo = OPatchExternalFactory.getLsInventoryRacInfo(oracleHomePath);
        lsInventoryRacInfo.printAllNodesInfo(oracleHomePath, readServices);
    }

    @Override
    public boolean helpPresent() {
        return true;
    }

    @Override
    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "lsinv_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }

    public static String getCheckSum(Path file) throws IOException {
        InputStream in = Files.newInputStream(file, new OpenOption[0]);
        int len = 0;
        MessageDigest md = null;
        byte[] buffer = new byte[4096];
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e2) {
            StringBuffer msg = new StringBuffer("LsInventorySession::getCheckSum() failed: ");
            msg.append(e2.getMessage());
            RuntimeException re = new RuntimeException(msg.toString());
            re.setStackTrace(e2.getStackTrace());
            in.close();
            throw re;
        }
        while ((len = in.read(buffer)) >= 0) {
            md.update(buffer, 0, len);
        }
        byte[] b2 = md.digest();
        in.close();
        return PatchAction.getHex(b2);
    }

    public static void main(String[] args) {
        String oracleHomePath = "C:\\oracle\\product\\10.1.0\\Db_1";
        String patchLocation = "U:\\OPatch\\Code\\OPatch\\0118481";
        LsInventorySession session = OPatchSession.LSINVENTORY;
        String patchID = "0118483";
        if (!OPatchEnv.isWindows()) {
            oracleHomePath = "/private/phi_local/home10.1.0.2";
            patchLocation = "/private/phnguyen/OPatch/Code/OPatch/0118483";
            patchID = "0118483";
        }
        oracleHomePath = "/u0a/share/phi/db_phi3";
        String patchStorageDirPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        String sessionType = session.getSessionName();
        try {
            String fileName = OPatchACL.invokeOLogger(session, "getOutputFileNameForLsInv", new Object[]{oracleHomePath, sessionType}).toString();
            System.out.println("LsInventory, if succeeds, will write output to " + fileName);
            StringBuffer ouiLoc = new StringBuffer(oracleHomePath);
            ouiLoc.append(File.separator);
            ouiLoc.append("oui");
            OPatchEnv.setOUILocation(oracleHomePath, ouiLoc.toString());
            OPatchACL.invokeOLogger(session, "setDebug", new Object[]{true});
            session.process(oracleHomePath);
            System.out.println("LsInventorySession::main() done");
            OPatch.exit(1);
        }
        catch (IllegalAccessException e2) {
            // empty catch block
        }
    }
}

