/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import oracle.opatch.OPatchSession;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.EnvInfo;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.wrappers.WrapperFactory;

public class EnableCasSession
extends OPatchSession {
    protected EnableCasSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public void process() {
        EnvInfo info = new EnvInfo();
        ArrayList<Path> casJars = info.getCasJars();
        if (null != casJars && !casJars.isEmpty()) {
            for (Path jar : casJars) {
                int index;
                String oldName = jar.toString();
                if (!jar.getFileName().toString().startsWith(".") || (index = oldName.lastIndexOf(File.separator)) == -1) continue;
                String newName = oldName.substring(0, index) + File.separator + jar.getFileName().toString().substring(1, jar.getFileName().toString().length());
                Path newFile = WrapperFactory.getNioServiceWrapper().getPath(newName, new String[0]);
                try {
                    Files.move(jar, newFile, new CopyOption[0]);
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                }
                OLogger.justlog(OLogger.INFO, jar.toString() + " has been renamed to " + newName);
            }
            OLogger.justlog(OLogger.INFO, " Complete enablecas.");
        } else if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            OLogger.printlnOnLog(OLogger.INFO, " OPatch has already supported cas, no need to enablecas.");
        } else {
            String errMsg = " You are using opatch without cas version, cannot run enablecas.";
            OLogger.printOnConsole(errMsg);
            OLogger.justlog(OLogger.WARNING, errMsg);
            throw new RuntimeException(errMsg);
        }
    }
}

