/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.nio.file.Path;
import java.util.HashSet;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

public class BusyFileProcessor {
    private static HashSet<String> activeExecutables = new HashSet();

    public static boolean isFileBusyPatching() {
        return OPS.INSTANCE.getSupportServices().isSupport(Feature.FILE_BUSY_PATCHING);
    }

    public static HashSet<String> getActiveExecutables() {
        return activeExecutables;
    }

    public static boolean canDoRenameCopy(Path dst) {
        return BusyFileProcessor.isFileBusyPatching() && activeExecutables.contains(dst.toAbsolutePath().toString());
    }
}

