/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlID;
import model.AssociationType;

public abstract class BaseClass {
    private static Logger logger = Logger.getLogger(BaseClass.class.getName());
    private final String id = UUID.randomUUID().toString();
    private final String uid = UUID.randomUUID().toString();
    private String GUID;
    protected String targetTypeId = null;
    private static Map declaredMethods = null;
    protected String name = null;
    HashMap<Class, Object> map = new HashMap();

    public String getId() {
        return this.id;
    }

    @XmlID
    public String getUId() {
        return this.getLeafClassName() + "-" + this.uid;
    }

    public String getUniqueId() {
        return this.getLeafClassName() + "-" + this.getId();
    }

    public String getTargetTypeId() {
        return this.targetTypeId;
    }

    public String getGUID() {
        return this.GUID;
    }

    public void setGUID(String in) {
        this.GUID = in;
    }

    public static boolean isDeclaredOnBaseClass(Method m2) {
        if (declaredMethods == null) {
            declaredMethods = new HashMap();
            for (Method method : BaseClass.class.getDeclaredMethods()) {
                declaredMethods.put(method, null);
            }
            for (Method method : Object.class.getDeclaredMethods()) {
                declaredMethods.put(method, null);
            }
        }
        return declaredMethods.containsKey(m2);
    }

    public static boolean isOnBaseClass(Method m2) {
        if (declaredMethods == null) {
            declaredMethods = new HashMap();
            for (Method method : BaseClass.class.getMethods()) {
                declaredMethods.put(method, null);
            }
        }
        return declaredMethods.containsKey(m2);
    }

    private Map<String, Object> gatherAttributes() throws IllegalArgumentException, IllegalAccessException {
        Class<Object> classs = this.getClass();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        while (!classs.equals(BaseClass.class)) {
            Map<String, Object> tmp = this.gatherAttributes(classs);
            for (String key : tmp.keySet()) {
                if (attrs.containsKey(key)) continue;
                attrs.put(key, tmp.get(key));
            }
            classs = classs.getSuperclass().asSubclass(BaseClass.class);
        }
        return attrs;
    }

    private Map<String, Object> gatherAttributes(Class classs) throws IllegalArgumentException, IllegalAccessException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (Field field : classs.getDeclaredFields()) {
            if (List.class.isAssignableFrom(field.getType()) || BaseClass.class.isAssignableFrom(field.getType())) continue;
            String name = field.getName();
            field.setAccessible(true);
            attrs.put(name, field.get(this));
        }
        return attrs;
    }

    public Map<String, List<BaseClass>> getOutboundAssociations() {
        String err = "Failed to retrive objects associated to" + this.toString();
        try {
            return this.getAssociatedObjects();
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(err, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(err, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(err, ex);
        }
    }

    public Map<String, List<BaseClass>> getAssociatedObjects() throws IllegalAccessException, InvocationTargetException {
        HashMap<String, List<BaseClass>> out = new HashMap<String, List<BaseClass>>();
        Class<?> c2 = this.getClass();
        for (Method method : c2.getMethods()) {
            boolean need;
            Object obj;
            if (BaseClass.isDeclaredOnBaseClass(method)) continue;
            String name = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("get") || params.length != 0 || (obj = method.invoke((Object)this, new Object[0])) == null || obj instanceof List && ((List)obj).isEmpty()) continue;
            boolean bl = need = obj instanceof BaseClass || obj instanceof List && ((List)obj).get(0) instanceof BaseClass;
            if (!need) continue;
            ArrayList<BaseClass> list = new ArrayList<BaseClass>();
            if (obj instanceof List) {
                for (Object comp : (List)obj) {
                    list.add((BaseClass)comp);
                }
            } else {
                list.add((BaseClass)obj);
            }
            out.put(name, list);
        }
        return out;
    }

    public String getLeafClassName() {
        return this.getClass().getSimpleName();
    }

    public Map<String, Object> getAttributes() {
        try {
            return this.gatherAttributes();
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(null, ex);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + (this.name() != null ? "-" + this.name : "");
    }

    public String name() {
        if (this.name != null) {
            return this.name;
        }
        try {
            Method m2 = this.getClass().getMethod("getName", new Class[0]);
            if (m2 != null) {
                this.name = (String)m2.invoke((Object)this, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.name;
    }

    public String print() {
        StringBuffer str = new StringBuffer("**********" + this.getClass().getName() + "-" + this.getGUID() + "**********");
        Class<?> classs = this.getClass();
        while (!classs.getName().contains("BaseClass")) {
            this.appendDeclared(str, classs, this);
            classs = classs.getSuperclass();
        }
        str.append("\n*******************************");
        return str.toString();
    }

    public String print(Object obj) {
        Class<?> classs = obj.getClass();
        StringBuffer str = new StringBuffer("***" + classs.getName() + "-" + ((BaseClass)obj).getGUID() + "***");
        while (!classs.getName().contains("BaseClass")) {
            this.appendDeclared(str, classs, obj);
            classs = classs.getSuperclass();
        }
        str.append("\n*******");
        return str.toString();
    }

    public void appendDeclared(StringBuffer str, Class classs, Object obj) {
        for (Field field : classs.getDeclaredFields()) {
            if (List.class.isAssignableFrom(field.getType()) || BaseClass.class.isAssignableFrom(field.getType())) continue;
            String name = field.getName();
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e2) {
                Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, e2);
            }
            if (value == null) continue;
            str.append("\n" + name + "=" + value);
        }
        for (Field field : classs.getDeclaredFields()) {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (annotation == null || !annotation.annotationType().equals(AssociationType.class)) continue;
                AssociationType assType = (AssociationType)annotation;
                field.setAccessible(true);
                BaseClass value = null;
                if (assType.value().equals((Object)AssociationType.EnumType.MOUNTED_ON)) {
                    str.append("\n" + (Object)((Object)assType.value()) + " ");
                    try {
                        if (field.get(obj) == null) {
                            str.append(" not set");
                            continue;
                        }
                        for (Object v : (List)field.get(obj)) {
                            value = (BaseClass)v;
                            str.append(value.print(value));
                        }
                        continue;
                    }
                    catch (Throwable e3) {
                        Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, e3);
                        continue;
                    }
                }
                if (!assType.value().equals((Object)AssociationType.EnumType.HOSTED_BY) && !assType.value().equals((Object)AssociationType.EnumType.RUNS_FROM)) continue;
                str.append("\n" + (Object)((Object)assType.value()) + " ");
                try {
                    value = (BaseClass)field.get(obj);
                }
                catch (Throwable e4) {
                    Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, e4);
                }
                if (value == null) {
                    str.append(" not set");
                    continue;
                }
                str.append(value.print(value));
            }
        }
    }

    public Method getSetter(Method method) {
        String name = method.getName();
        name = "s" + name.substring(1);
        Class[] paramtypes = new Class[]{method.getReturnType()};
        try {
            return this.getClass().getMethod(name, paramtypes);
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
    }

    public Method getGetter(Method method) {
        String name = method.getName();
        name = "g" + name.substring(1);
        try {
            return this.getClass().getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            logger.severe("\n NoSuchMethodException: " + this.getClass().getName() + "." + name + "( null )");
            return null;
        }
    }

    public List<Method> getRequestedAttributeGetters() {
        ArrayList<Method> out = new ArrayList<Method>();
        Class<?> c2 = this.getClass();
        for (Method method : c2.getMethods()) {
            boolean skip;
            if (BaseClass.isDeclaredOnBaseClass(method)) continue;
            String name = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("get") || params.length != 0) continue;
            Object obj = null;
            try {
                obj = method.invoke((Object)this, new Object[0]);
            }
            catch (Exception e2) {
                continue;
            }
            if (obj == null || obj instanceof List && ((List)obj).isEmpty()) continue;
            boolean bl = skip = obj instanceof BaseClass || obj instanceof List && ((List)obj).get(0) instanceof BaseClass;
            if (skip) continue;
            out.add(method);
        }
        return out;
    }

    public Map<Method, List<BaseClass>> getRequestedAssociationGetters() {
        HashMap<Method, List<BaseClass>> out = new HashMap<Method, List<BaseClass>>();
        Class<?> c2 = this.getClass();
        for (Method method : c2.getMethods()) {
            boolean need;
            if (BaseClass.isDeclaredOnBaseClass(method)) continue;
            String name = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("get") || params.length != 0) continue;
            Object obj = null;
            try {
                obj = method.invoke((Object)this, new Object[0]);
            }
            catch (Exception e2) {
                continue;
            }
            if (obj == null || obj instanceof List && ((List)obj).isEmpty()) continue;
            boolean bl = need = obj instanceof BaseClass || obj instanceof List && ((List)obj).get(0) instanceof BaseClass;
            if (!need) continue;
            ArrayList<BaseClass> list = new ArrayList<BaseClass>();
            if (obj instanceof List) {
                for (Object comp : (List)obj) {
                    list.add((BaseClass)comp);
                }
            } else {
                list.add((BaseClass)obj);
            }
            out.put(this.getSetter(method), list);
        }
        return out;
    }

    public List<Method> getRequestedGetters() {
        ArrayList<Method> out = new ArrayList<Method>();
        Class<?> c2 = this.getClass();
        for (Method method : c2.getMethods()) {
            if (BaseClass.isOnBaseClass(method)) continue;
            String name = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("get") || params.length != 0) continue;
            Object obj = null;
            try {
                obj = method.invoke((Object)this, new Object[0]);
            }
            catch (Exception e2) {
                continue;
            }
            if (obj == null) continue;
            out.add(method);
        }
        return out;
    }

    public void removeDefaultValues() {
        Class<?> c2 = this.getClass();
        for (Method method : c2.getMethods()) {
            if (BaseClass.isOnBaseClass(method)) continue;
            String name = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("get") || params.length != 0) continue;
            Object obj = null;
            try {
                obj = method.invoke((Object)this, new Object[0]);
            }
            catch (Exception e2) {
                continue;
            }
            if (obj == null) continue;
            Method setter = this.getSetter(method);
            try {
                Class<?> retType;
                if (setter == null || (retType = method.getReturnType()).equals(Boolean.class) || retType.equals(Boolean.TYPE)) continue;
                obj = setter.invoke((Object)this, retType.cast(null));
            }
            catch (Exception e3) {
                logger.log(Level.SEVERE, "While calling setter:" + setter, e3);
            }
        }
    }

    public static String getInverseAssociationType(String in) {
        if (in == null || in.length() == 0) {
            return null;
        }
        if (in.equals("HOST_FOR")) {
            return "HOSTED_BY";
        }
        if (in.equals("HOSTED_BY")) {
            return "HOST_FOR";
        }
        if (in.equals("CLUSTER_MEMBER")) {
            return "CONTAINS";
        }
        if (in.equals("CONTAINS")) {
            return "CLUSTER_MEMBER";
        }
        return null;
    }

    public <P> P getProperty(Class<P> classs) {
        return (P)this.map.get(classs);
    }

    public <P> void setProperty(Class<P> classs, P prop) {
        this.map.put(classs, prop);
    }

    public <P> void setProperty(P prop) {
        this.map.put(prop.getClass(), prop);
    }
}

