/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.xmldiff;

import com.oracle.cie.common.SecureUnmarshaller;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.xml.difftree.ActionType;
import com.oracle.cie.common.xml.difftree.AttributeType;
import com.oracle.cie.common.xml.difftree.DiffTreeType;
import com.oracle.cie.common.xml.difftree.ElementType;
import com.oracle.cie.common.xml.difftree.ObjectFactory;
import com.oracle.cie.common.xml.difftree.SimpleType;
import com.oracle.cie.common.xml.difftree.ValueType;
import com.oracle.cie.common.xmldiff.XmlDiffAction;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import com.oracle.cie.common.xmldiff.XmlDiffMerge;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class XmlDiffTree
implements Cloneable {
    private String _elementName;
    private String _id;
    private XmlDiffAction _action = XmlDiffAction.NONE;
    private Map<String, List<XmlDiffTree>> _children;
    private Map<String, DiffTreeAttribute> _simpleTypes = new LinkedHashMap<String, DiffTreeAttribute>();
    private Map<String, DiffTreeAttribute> _attributes = new LinkedHashMap<String, DiffTreeAttribute>();
    private Map<String, Object[]> _attributeModifications;
    private Map<String, Object[]> _simpleTypeModifications;
    public static final String DIFF_TREE_SCHEMA_LOCATION = "com/oracle/cie/common/xml/difftree/difftree.xsd";
    private static Schema _diffTreeSchema;

    public XmlDiffTree(String elementName) {
        this(elementName, null, XmlDiffAction.NONE);
    }

    public XmlDiffTree(String elementName, String id) {
        this(elementName, id, XmlDiffAction.NONE);
    }

    public XmlDiffTree(String elementName, XmlDiffAction action) {
        this(elementName, null, action);
    }

    public XmlDiffTree(String elementName, String id, XmlDiffAction action) {
        if (elementName == null) {
            throw new IllegalArgumentException("Element name may not be null.");
        }
        this._elementName = elementName;
        this._id = id;
        this._action = action;
    }

    public void addChild(XmlDiffTree child) {
        this.addChild(child, -1);
    }

    public void addChild(XmlDiffTree child, int index) {
        List<XmlDiffTree> c;
        if (child == null) {
            return;
        }
        if (this._children == null) {
            this._children = new LinkedHashMap<String, List<XmlDiffTree>>();
        }
        if ((c = this._children.get(child.getElementName())) == null) {
            c = new ArrayList<XmlDiffTree>();
            this._children.put(child.getElementName(), c);
        }
        if (index > -1 && index < c.size()) {
            c.add(index, child);
        } else {
            c.add(child);
        }
    }

    public void addSimpleType(String elementName, Class type, Object orginalValue, Object currentValue, XmlDiffAction action) throws XmlDiffException {
        if (action.isModify() && this._simpleTypeModifications != null) {
            this._simpleTypeModifications = null;
        }
        this.addSimpleType(elementName, new DiffTreeAttribute(elementName, type, orginalValue, currentValue, action));
    }

    void addSimpleType(String elementName, DiffTreeAttribute simpleType) {
        this._simpleTypes.put(elementName, simpleType);
        if (this.getAction().isNone() && !simpleType.getAction().isNone()) {
            this.setAction(XmlDiffAction.MODIFY);
        }
    }

    public void addAttribute(String attribName, Class type, Object orginalValue, Object currentValue, XmlDiffAction action) throws XmlDiffException {
        if (action.isModify() && this._attributeModifications != null) {
            this._attributeModifications = null;
        }
        this.addAttribute(attribName, new DiffTreeAttribute(attribName, type, orginalValue, currentValue, action));
    }

    void addAttribute(String attribName, DiffTreeAttribute attribute) {
        this._attributes.put(attribName, attribute);
        if (this.getAction().isNone() && !attribute.getAction().isNone()) {
            this.setAction(XmlDiffAction.MODIFY);
        }
    }

    public String getElementName() {
        return this._elementName;
    }

    public void setElementName(String elementName) {
        this._elementName = elementName;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public XmlDiffAction getAction() {
        return this._action;
    }

    public void setAction(XmlDiffAction action) {
        this._action = action;
    }

    public boolean hasChildren() {
        return this._children != null && !this._children.isEmpty();
    }

    public Map<String, List<XmlDiffTree>> getChildrenMap() {
        if (this._children == null) {
            this._children = new LinkedHashMap<String, List<XmlDiffTree>>();
        }
        return this._children;
    }

    public List<XmlDiffTree> getChildren(String elementName) {
        return this.hasChildren() ? this._children.get(elementName) : null;
    }

    public void setChildren(String elementName, List<XmlDiffTree> children) {
        if (this._children == null) {
            this._children = new LinkedHashMap<String, List<XmlDiffTree>>();
        }
        this._children.put(elementName, children);
    }

    public boolean hasChild(String elementName) {
        List<XmlDiffTree> child = this.getChildren(elementName);
        return child != null && !child.isEmpty();
    }

    public boolean hasModifiedChild() {
        if (this.hasChildren()) {
            Map<String, List<XmlDiffTree>> childMap = this.getChildrenMap();
            for (List<XmlDiffTree> children : childMap.values()) {
                if (children == null || children.isEmpty()) continue;
                for (XmlDiffTree child : children) {
                    if (!child.hasChange()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Collection<XmlDiffTree> getModifiedChildren() {
        return this.getModifiedChildren(this);
    }

    private Collection<XmlDiffTree> getModifiedChildren(XmlDiffTree parent) {
        ArrayList<XmlDiffTree> modifiedChildren = new ArrayList<XmlDiffTree>();
        if (parent.hasChildren()) {
            Map<String, List<XmlDiffTree>> childMap = parent.getChildrenMap();
            for (List<XmlDiffTree> children : childMap.values()) {
                if (children == null || children.isEmpty()) continue;
                for (XmlDiffTree child : children) {
                    if (!child.getAction().isNone()) {
                        modifiedChildren.add(child);
                    }
                    modifiedChildren.addAll(this.getModifiedChildren(child));
                }
            }
        }
        return modifiedChildren;
    }

    public boolean hasChange() {
        return !this.getAction().isNone() || this.hasModifiedChild();
    }

    public boolean hasModifications() {
        return this.getAction().isModify();
    }

    Map<String, DiffTreeAttribute> getSimpleTypes() {
        return this._simpleTypes;
    }

    public boolean hasSimpleTypes() {
        return this._simpleTypes != null && !this._simpleTypes.isEmpty();
    }

    public boolean hasSimpleType(String name) {
        return this.hasSimpleTypes() && this._simpleTypes.containsKey(name) && this._simpleTypes.get(name).getCurrentValue() != null;
    }

    public Set<String> getSimpleTypeNames() {
        return this._simpleTypes.keySet();
    }

    public Object getSimpleTypeValue(String name) {
        DiffTreeAttribute attrib = this._simpleTypes.get(name);
        if (attrib != null) {
            return attrib.getCurrentValue();
        }
        return null;
    }

    public Object getOriginalSimpleTypeValue(String attribName) {
        DiffTreeAttribute attrib = this._simpleTypes.get(attribName);
        if (attrib != null) {
            return attrib.getOriginalValue();
        }
        return null;
    }

    public Map<String, Object[]> getSimpleTypeModifications() {
        if (this._simpleTypeModifications == null) {
            this._simpleTypeModifications = new LinkedHashMap<String, Object[]>();
            if (this.hasSimpleTypes()) {
                for (DiffTreeAttribute attrib : this._simpleTypes.values()) {
                    if (!attrib.getAction().isModify()) continue;
                    this._simpleTypeModifications.put(attrib.getName(), attrib.getValues());
                }
            }
        }
        return this._simpleTypeModifications;
    }

    public boolean hasSimpleTypeModification(String name) {
        DiffTreeAttribute attrib = this._simpleTypes.get(name);
        return attrib != null && (attrib.getAction().isModify() || attrib.getAction().isCreate());
    }

    Map<String, DiffTreeAttribute> getAttributes() {
        return this._attributes;
    }

    public boolean hasAttributes() {
        return this._attributes != null && !this._attributes.isEmpty();
    }

    public boolean hasAttribute(String name) {
        return this.hasAttributes() && this._attributes.containsKey(name) && this._attributes.get(name).getCurrentValue() != null;
    }

    public Set<String> getAttributeNames() {
        return this._attributes.keySet();
    }

    public Object getAttributeValue(String attribName) {
        DiffTreeAttribute attrib = this._attributes.get(attribName);
        if (attrib != null) {
            return attrib.getCurrentValue();
        }
        return null;
    }

    public Object getOriginalAttributeValue(String attribName) {
        DiffTreeAttribute attrib = this._attributes.get(attribName);
        if (attrib != null) {
            return attrib.getOriginalValue();
        }
        return null;
    }

    public Map<String, Object[]> getAttributeModifications() {
        if (this._attributeModifications == null) {
            this._attributeModifications = new LinkedHashMap<String, Object[]>();
            if (this.hasAttributes()) {
                for (DiffTreeAttribute attrib : this._attributes.values()) {
                    if (!attrib.getAction().isModify()) continue;
                    this._attributeModifications.put(attrib.getName(), attrib.getValues());
                }
            }
        }
        return this._attributeModifications;
    }

    public boolean hasAttributeModification(String attribName) {
        DiffTreeAttribute attrib = this._attributes.get(attribName);
        return attrib != null && (attrib.getAction().isModify() || attrib.getAction().isCreate());
    }

    public XmlDiffTree merge(XmlDiffTree diffTree) throws XmlDiffException {
        return XmlDiffTree.merge(this, diffTree);
    }

    public static XmlDiffTree merge(XmlDiffTree ... diffTrees) throws XmlDiffException {
        XmlDiffMerge xmlDiffMerge = new XmlDiffMerge(diffTrees);
        return xmlDiffMerge.merge();
    }

    public void save(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("The file provided was null.");
        }
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            this.save(new FileOutputStream(file));
        }
        catch (Exception e) {
            throw new IOException("Failed to save diff tree to " + file, e);
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("The output stream provided was null.");
        }
        try {
            DiffTreeType diffTreeType = new DiffTreeType();
            diffTreeType.setElement(XmlDiffTree.getDiffTreeElement(this));
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DiffTreeType.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            OutputStreamWriter dataWriter = new OutputStreamWriter(outputStream, "UTF-8");
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("standalone", "yes");
            JAXBSource source = new JAXBSource(marshaller, new ObjectFactory().createDifftree(diffTreeType));
            StreamResult result = new StreamResult(dataWriter);
            t.transform((Source)source, result);
        }
        catch (Exception e) {
            throw new IOException("Failed to save diff tree.", e);
        }
        finally {
            outputStream.close();
        }
    }

    private static ElementType getDiffTreeElement(XmlDiffTree diffTree) {
        ElementType element = new ElementType();
        element.setName(diffTree.getElementName());
        element.setAction(ActionType.fromValue(diffTree.getAction().name()));
        if (diffTree.hasAttributes()) {
            List<AttributeType> attributeTypes = element.getAttribute();
            for (DiffTreeAttribute diffTreeAttribute : diffTree.getAttributes().values()) {
                attributeTypes.add(XmlDiffTree.getAttributeType(diffTreeAttribute));
            }
        }
        if (diffTree.hasSimpleTypes()) {
            List<SimpleType> simpleTypes = element.getSimpleType();
            for (DiffTreeAttribute diffTreeAttribute : diffTree.getSimpleTypes().values()) {
                simpleTypes.add(XmlDiffTree.getSimpleType(diffTreeAttribute));
            }
        }
        if (diffTree.hasChildren()) {
            List<ElementType> childElements = element.getElement();
            for (List list : diffTree.getChildrenMap().values()) {
                for (XmlDiffTree childDiffTree : list) {
                    childElements.add(XmlDiffTree.getDiffTreeElement(childDiffTree));
                }
            }
        }
        return element;
    }

    private static AttributeType getAttributeType(DiffTreeAttribute diffTreeAttribute) {
        AttributeType attributeType = new AttributeType();
        attributeType.setName(diffTreeAttribute.getName());
        attributeType.setType(diffTreeAttribute.getType().getName());
        if (diffTreeAttribute.getType().isPrimitive()) {
            attributeType.setPrimitive(true);
        }
        attributeType.setAction(ActionType.fromValue(diffTreeAttribute.getAction().name()));
        attributeType.setCurrent(XmlDiffTree.getPrintObject(diffTreeAttribute.getCurrentValue(), diffTreeAttribute.getType()));
        if (!diffTreeAttribute.getAction().isNone()) {
            attributeType.setOriginal(XmlDiffTree.getPrintObject(diffTreeAttribute.getOriginalValue(), diffTreeAttribute.getType()));
        }
        return attributeType;
    }

    private static SimpleType getSimpleType(DiffTreeAttribute diffTreeAttribute) {
        Object[] objectArray;
        Object[] values;
        Object[] objectArray2;
        SimpleType simpleType = new SimpleType();
        simpleType.setName(diffTreeAttribute.getName());
        simpleType.setType(diffTreeAttribute.getType().getName());
        if (diffTreeAttribute.getType().isPrimitive()) {
            simpleType.setPrimitive(true);
        }
        simpleType.setAction(ActionType.fromValue(diffTreeAttribute.getAction().name()));
        Object value = diffTreeAttribute.getCurrentValue();
        Object originalValue = diffTreeAttribute.getOriginalValue();
        if (value != null) {
            if (diffTreeAttribute.getType().isArray()) {
                objectArray2 = (Object[])value;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = value;
            }
        } else {
            objectArray2 = values = new Object[]{};
        }
        if (originalValue != null) {
            if (diffTreeAttribute.getType().isArray()) {
                objectArray = (Object[])originalValue;
            } else {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = originalValue;
            }
        } else {
            objectArray = new Object[]{};
        }
        Object[] originalValues = objectArray;
        List<ValueType> simpleTypeValues = simpleType.getValue();
        int size = values.length > originalValues.length ? values.length : originalValues.length;
        for (int x = 0; x < size; ++x) {
            ValueType valueType = new ValueType();
            Object v = values.length > x ? values[x] : null;
            valueType.setCurrent(XmlDiffTree.getPrintObject(v, diffTreeAttribute.getType()));
            if (!diffTreeAttribute.getAction().isNone()) {
                v = originalValues.length > x ? originalValues[x] : null;
                valueType.setOriginal(XmlDiffTree.getPrintObject(v, diffTreeAttribute.getType()));
            }
            simpleTypeValues.add(valueType);
        }
        return simpleType;
    }

    public static XmlDiffTree load(File file) throws IOException {
        return XmlDiffTree.load(file, null);
    }

    public static XmlDiffTree load(File file, ClassLoader classLoader) throws IOException {
        if (file == null) {
            throw new NullPointerException("The file provided was null.");
        }
        try {
            return XmlDiffTree.load(new FileInputStream(file), classLoader);
        }
        catch (Exception e) {
            throw new IOException("Failed to load diff tree from " + file, e);
        }
    }

    public static XmlDiffTree load(InputStream inputStream) throws IOException {
        return XmlDiffTree.load(inputStream, null);
    }

    public static XmlDiffTree load(InputStream inputStream, ClassLoader classLoader) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("The output stream provided was null.");
        }
        if (classLoader == null) {
            classLoader = XmlDiffTree.class.getClassLoader();
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(XmlDiffTree.getSchema());
            Object o = SecureUnmarshaller.unmarshal(unmarshaller, inputStream);
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            XmlDiffTree xmlDiffTree = XmlDiffTree.getDiffTreeFromElementType(((DiffTreeType)o).getElement(), classLoader);
            return xmlDiffTree;
        }
        catch (Exception e) {
            throw new IOException("Failed to load diff tree.", e);
        }
        finally {
            inputStream.close();
        }
    }

    private static XmlDiffTree getDiffTreeFromElementType(ElementType elementType, ClassLoader classLoader) throws XmlDiffException {
        List<ElementType> list;
        List<SimpleType> simpleTypes;
        if (elementType == null) {
            throw new NullPointerException("The element type provided was null.");
        }
        XmlDiffTree xmlDiffTree = new XmlDiffTree(elementType.getName(), XmlDiffAction.valueOf(elementType.getAction().name()));
        List<AttributeType> attributeTypes = elementType.getAttribute();
        if (attributeTypes != null && !attributeTypes.isEmpty()) {
            for (AttributeType attributeType : attributeTypes) {
                Class type = XmlDiffTree.getTypeClass(attributeType.getType(), attributeType.isPrimitive(), classLoader);
                xmlDiffTree.addAttribute(attributeType.getName(), type, XmlDiffTree.getParsedObject(attributeType.getOriginal(), type), XmlDiffTree.getParsedObject(attributeType.getCurrent(), type), XmlDiffAction.valueOf(attributeType.getAction().name()));
            }
        }
        if ((simpleTypes = elementType.getSimpleType()) != null && !simpleTypes.isEmpty()) {
            for (SimpleType simpleType : simpleTypes) {
                List<ValueType> valueTypes;
                Class type = XmlDiffTree.getTypeClass(simpleType.getType(), simpleType.isPrimitive(), classLoader);
                if (!type.isArray()) {
                    valueTypes = simpleType.getValue();
                    if (valueTypes.size() > 1) {
                        throw new XmlDiffException("Encountered multiple values defined for type " + type + " which is not an array " + valueTypes);
                    }
                    String currentValue = null;
                    String originalValue = null;
                    if (!valueTypes.isEmpty()) {
                        ValueType valueType = valueTypes.get(0);
                        currentValue = valueType.getCurrent();
                        originalValue = valueType.getOriginal();
                        if (originalValue == null) {
                            originalValue = currentValue;
                        }
                    }
                    xmlDiffTree.addSimpleType(simpleType.getName(), type, XmlDiffTree.getParsedObject(originalValue, type), XmlDiffTree.getParsedObject(currentValue, type), XmlDiffAction.valueOf(simpleType.getAction().name()));
                    continue;
                }
                valueTypes = simpleType.getValue();
                int size = valueTypes != null ? valueTypes.size() : 0;
                Object[] currentValues = (Object[])Array.newInstance(type.getComponentType(), size);
                Object[] originalValues = (Object[])Array.newInstance(type.getComponentType(), size);
                if (valueTypes != null && size > 0) {
                    for (int x = 0; x < size; ++x) {
                        ValueType valueType = valueTypes.get(x);
                        String current = valueType.getCurrent();
                        currentValues[x] = XmlDiffTree.getParsedObject(current, type.getComponentType());
                        String original = valueType.getOriginal();
                        originalValues[x] = original == null ? currentValues[x] : XmlDiffTree.getParsedObject(original, type.getComponentType());
                    }
                }
                xmlDiffTree.addSimpleType(simpleType.getName(), type, originalValues, currentValues, XmlDiffAction.valueOf(simpleType.getAction().name()));
            }
        }
        if ((list = elementType.getElement()) != null && !list.isEmpty()) {
            for (ElementType childElement : list) {
                xmlDiffTree.addChild(XmlDiffTree.getDiffTreeFromElementType(childElement, classLoader));
            }
        }
        return xmlDiffTree;
    }

    private static Class getTypeClass(String classType, boolean primitive, ClassLoader classLoader) throws XmlDiffException {
        Class<Object> type = null;
        try {
            if (primitive) {
                if ("int".equals(classType)) {
                    type = Integer.TYPE;
                } else if ("long".equals(classType)) {
                    type = Long.TYPE;
                } else if ("double".equals(classType)) {
                    type = Double.TYPE;
                } else if ("float".equals(classType)) {
                    type = Float.TYPE;
                } else if ("boolean".equals(classType)) {
                    type = Boolean.TYPE;
                } else if ("char".equals(classType)) {
                    type = Character.TYPE;
                } else if ("byte".equals(classType)) {
                    type = Byte.TYPE;
                } else if ("void".equals(classType)) {
                    type = Void.TYPE;
                } else if ("short".equals(classType)) {
                    type = Short.TYPE;
                }
                if (type == null) {
                    throw new ClassNotFoundException(classType);
                }
            } else {
                type = Class.forName(classType, true, classLoader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new XmlDiffException("Unable to locate class of type " + classType, e);
        }
        return type;
    }

    static Schema getSchema() throws SAXException, IOException {
        if (_diffTreeSchema == null) {
            InputStream schemaIn = XmlDiffTree.class.getClassLoader().getResourceAsStream(DIFF_TREE_SCHEMA_LOCATION);
            if (schemaIn == null) {
                throw new IOException("Unable to locate xml difftree schema com/oracle/cie/common/xml/difftree/difftree.xsd");
            }
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                _diffTreeSchema = schemaFactory.newSchema(new StreamSource(schemaIn));
            }
            finally {
                try {
                    schemaIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return _diffTreeSchema;
    }

    public String toString() {
        return this.toString(null);
    }

    String toString(String indent) {
        return this.toString(indent, true);
    }

    String toString(boolean recursive) {
        return this.toString(null, recursive);
    }

    String toString(String indent, boolean recursive) {
        String s;
        if (indent == null) {
            indent = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("Element: ").append(this.getElementName());
        if (this.getId() != null) {
            sb.append("(").append(this.getId()).append(")");
        }
        sb.append(" -- ").append((Object)this.getAction());
        if (this.hasAttributes()) {
            sb.append(" -- Attributes: [");
            s = null;
            for (String string : this._attributes.keySet()) {
                s = s == null ? "" : s + "|";
                s = s + this._attributes.get(string);
            }
            sb.append(s).append("]");
        }
        if (this.hasSimpleTypes()) {
            sb.append(" -- Simple Types: [");
            s = null;
            for (String string : this._simpleTypes.keySet()) {
                s = s == null ? "" : s + "|";
                s = s + this._simpleTypes.get(string);
            }
            sb.append(s).append("]");
        }
        sb.append("\n");
        if (recursive && this.hasChildren()) {
            Map<String, List<XmlDiffTree>> children = this.getChildrenMap();
            for (List list : children.values()) {
                for (XmlDiffTree dt : list) {
                    sb.append(dt.toString(indent + "  ", true));
                }
            }
        }
        return sb.toString();
    }

    private static String getValueString(Object obj) {
        Class<?> type = obj != null ? (obj.getClass().isArray() ? obj.getClass().getComponentType() : obj.getClass()) : null;
        return XmlDiffTree.getValueString(obj, type);
    }

    private static String getValueString(Object obj, Class type) {
        String s;
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isArray()) {
            if (obj.getClass().getComponentType() == Byte.TYPE) {
                s = Arrays.toString((byte[])obj);
            } else {
                Object[] a = (Object[])obj;
                StringBuilder b = new StringBuilder();
                b.append('[');
                int iMax = a.length - 1;
                if (iMax == -1) {
                    b.append(']');
                } else {
                    int i = 0;
                    while (true) {
                        b.append(XmlDiffTree.getPrintObject(a[i], type));
                        if (i == iMax) {
                            b.append(']').toString();
                            break;
                        }
                        b.append(", ");
                        ++i;
                    }
                }
                s = b.toString();
            }
        } else {
            s = XmlDiffTree.getPrintObject(obj, type);
        }
        return s;
    }

    public Object clone() throws CloneNotSupportedException {
        XmlDiffTree clone = new XmlDiffTree(this._elementName);
        clone.setAction(this._action);
        clone.setId(this._id);
        if (this._children != null) {
            clone._children = new LinkedHashMap<String, List<XmlDiffTree>>(this._children.size());
            for (String key : this._children.keySet()) {
                List<XmlDiffTree> list = this._children.get(key);
                ArrayList<XmlDiffTree> cloneList = new ArrayList<XmlDiffTree>(list.size());
                for (XmlDiffTree child : list) {
                    cloneList.add((XmlDiffTree)child.clone());
                }
                clone._children.put(key, cloneList);
            }
        }
        if (this.hasSimpleTypes()) {
            clone._simpleTypes = new LinkedHashMap<String, DiffTreeAttribute>(this._simpleTypes.size());
            for (String key : this._simpleTypes.keySet()) {
                clone._simpleTypes.put(key, (DiffTreeAttribute)this._simpleTypes.get(key).clone());
            }
        }
        if (this._simpleTypeModifications != null) {
            for (String key : this._simpleTypeModifications.keySet()) {
                clone._simpleTypeModifications.put(key, (Object[])this._simpleTypeModifications.get(key).clone());
            }
        }
        if (this.hasAttributes()) {
            for (String key : this._attributes.keySet()) {
                clone._attributes.put(key, (DiffTreeAttribute)this._attributes.get(key).clone());
            }
        }
        if (this._attributeModifications != null) {
            clone._attributeModifications = new LinkedHashMap<String, Object[]>();
            for (String key : this._attributeModifications.keySet()) {
                clone._attributeModifications.put(key, (Object[])this._attributeModifications.get(key).clone());
            }
        }
        return clone;
    }

    private static String getPrintObject(Object object, Class<?> type) {
        if (object == null) {
            return null;
        }
        if (type == null || !type.isInstance(object)) {
            return object.toString();
        }
        if (type.equals(String.class)) {
            return DatatypeConverter.printString((String)((String)object));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return DatatypeConverter.printInt((int)((Integer)object));
        }
        if (type.equals(BigInteger.class)) {
            return DatatypeConverter.printInteger((BigInteger)((BigInteger)object));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return DatatypeConverter.printLong((long)((Long)object));
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return DatatypeConverter.printShort((short)((Short)object));
        }
        if (type.equals(BigDecimal.class)) {
            return DatatypeConverter.printDecimal((BigDecimal)((BigDecimal)object));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return DatatypeConverter.printFloat((float)((Float)object).floatValue());
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return DatatypeConverter.printDouble((double)((Double)object));
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return DatatypeConverter.printBoolean((boolean)((Boolean)object));
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return DatatypeConverter.printByte((byte)((Byte)object));
        }
        if (type.equals(XMLGregorianCalendar.class)) {
            return ((XMLGregorianCalendar)object).toXMLFormat();
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return DatatypeConverter.printDateTime((Calendar)((Calendar)object));
        }
        if (type.equals(Date.class)) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)object);
            return DatatypeConverter.printDate((Calendar)c);
        }
        if (type.equals(Time.class)) {
            Calendar c = Calendar.getInstance();
            c.setTime((Time)object);
            return DatatypeConverter.printTime((Calendar)c);
        }
        if (type.isEnum()) {
            try {
                Method m = type.getMethod("value", new Class[0]);
                return (String)m.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                return object.toString();
            }
        }
        return object.toString();
    }

    private static Object getParsedObject(String string, Class type) throws XmlDiffException {
        if (type == null) {
            throw new XmlDiffException("The type specified was null.");
        }
        if (string == null) {
            return type.cast(null);
        }
        if (type.isInstance(string)) {
            return type.cast(string);
        }
        if (type.equals(String.class)) {
            return DatatypeConverter.parseString((String)string);
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return DatatypeConverter.parseInt((String)string);
        }
        if (type.equals(BigInteger.class)) {
            return DatatypeConverter.parseInteger((String)string);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return DatatypeConverter.parseLong((String)string);
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return DatatypeConverter.parseShort((String)string);
        }
        if (type.equals(BigDecimal.class)) {
            return DatatypeConverter.parseDecimal((String)string);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf(DatatypeConverter.parseFloat((String)string));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return DatatypeConverter.parseDouble((String)string);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return DatatypeConverter.parseBoolean((String)string);
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return DatatypeConverter.parseByte((String)string);
        }
        if (type.equals(XMLGregorianCalendar.class)) {
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)DatatypeConverter.parseDateTime((String)string));
            }
            catch (DatatypeConfigurationException e) {
                throw new XmlDiffException("Unable to create gregorian calendar.", e);
            }
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return DatatypeConverter.parseDateTime((String)string);
        }
        if (type.equals(Date.class)) {
            return DatatypeConverter.parseDate((String)string);
        }
        if (type.equals(Time.class)) {
            return DatatypeConverter.parseTime((String)string);
        }
        if (type.equals(Object.class)) {
            return string;
        }
        if (type.isEnum()) {
            Class enumClass = type;
            try {
                return Enum.valueOf(enumClass, string);
            }
            catch (IllegalArgumentException e) {
                try {
                    return Enum.valueOf(enumClass, string.toUpperCase());
                }
                catch (IllegalArgumentException e1) {
                    try {
                        Method m = enumClass.getMethod("fromValue", String.class);
                        return m.invoke(null, string);
                    }
                    catch (Exception e2) {
                        throw e;
                    }
                }
            }
        }
        throw new XmlDiffException("Unable to convert object \"" + string + "\" to type \"" + type + "\" because the type is not supported.");
    }

    class DiffTreeAttribute
    implements Cloneable {
        String _name;
        Class _type;
        Object _originalValue;
        Object _currentValue;
        XmlDiffAction _action;

        DiffTreeAttribute(String name, Class type, Object originalValue, Object currentValue, XmlDiffAction action) throws XmlDiffException {
            if (StringUtil.isNullOrEmpty(name, true)) {
                throw new XmlDiffException("The name specified was null or empty.");
            }
            if (type == null) {
                throw new XmlDiffException("The type specified was null.");
            }
            if (action == null) {
                throw new XmlDiffException("The action specified was null.");
            }
            this._name = name;
            this._type = type;
            this._originalValue = originalValue;
            this._currentValue = currentValue;
            this._action = action;
        }

        public String getName() {
            return this._name;
        }

        public Class getType() {
            return this._type;
        }

        public void setType(Class type) {
            this._type = type;
        }

        public Object getOriginalValue() {
            return this._originalValue;
        }

        public void setOriginalValue(Object originalValue) {
            this._originalValue = originalValue;
        }

        public boolean hasOriginalValue() {
            return this._originalValue != null;
        }

        public Object getCurrentValue() {
            return this._currentValue;
        }

        public void setCurrentValue(Object currentValue) {
            this._currentValue = currentValue;
        }

        public XmlDiffAction getAction() {
            return this._action;
        }

        public void setAction(XmlDiffAction action) {
            this._action = action;
        }

        public Object[] getValues() {
            return new Object[]{this._originalValue, this._currentValue};
        }

        public String toString() {
            String s = this.getName() + ":" + this.getType().getSimpleName() + ":" + (Object)((Object)this.getAction()) + ":";
            s = s + XmlDiffTree.getValueString(this.getOriginalValue()) + "->" + XmlDiffTree.getValueString(this.getCurrentValue());
            return s;
        }

        protected Object clone() throws CloneNotSupportedException {
            try {
                return new DiffTreeAttribute(this._name, this._type, this._originalValue, this._currentValue, this._action);
            }
            catch (XmlDiffException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
        }
    }
}

