/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStore;
import com.oracle.cie.common.util.ObjectStoreInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ObjectStoreFactory {
    static IObjectStore createObjectStore(String namespace) {
        return ObjectStoreFactory.createObjectStore(namespace, null);
    }

    static IObjectStore createObjectStore(String namespace, IObjectStore backingObjectStore) {
        ObjectStore os = new ObjectStore(namespace, backingObjectStore);
        if (Boolean.getBoolean("objectStore.extended.logging")) {
            IObjectStore osProxy = (IObjectStore)Proxy.newProxyInstance(IObjectStore.class.getClassLoader(), new Class[]{IObjectStore.class}, (InvocationHandler)new ObjectStoreInvocationHandler(os));
            os.setSelf(osProxy);
            return osProxy;
        }
        return os;
    }
}

