/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.IoBridge;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class IoBridgeImpl
implements IoBridge {
    @Override
    public boolean isEqual(String path1, String path2) {
        return new File(path1).equals(new File(path2));
    }

    @Override
    public String getParent(String path) {
        return this.getParent(path, false);
    }

    @Override
    public String getParent(String path, boolean absolute) {
        File f = new File(path);
        return absolute ? f.getAbsoluteFile().getParent() : f.getParent();
    }

    @Override
    public String getAbsolutePath(String path) {
        File f = new File(path);
        return f.getAbsolutePath();
    }

    @Override
    public String getFileName(String path) {
        File f = new File(path);
        return f.getName();
    }

    @Override
    public String resolve(String parentDir, String fileName) {
        return new File(parentDir, fileName).getPath();
    }

    @Override
    public boolean exists(String path) {
        File f = new File(path);
        return f.exists();
    }

    @Override
    public boolean canWrite(String path) {
        File f = new File(path);
        return f.canWrite();
    }

    @Override
    public boolean canRead(String path) {
        File f = new File(path);
        return f.canRead();
    }

    @Override
    public String[] list(String path) {
        File f = new File(path);
        return f.list();
    }

    @Override
    public String[] list(String path, FilenameFilter filter) {
        File f = new File(path);
        return f.list(filter);
    }

    @Override
    public boolean isFile(String path) {
        File f = new File(path);
        return f.isFile();
    }

    @Override
    public boolean isDirectory(String path) {
        File f = new File(path);
        return f.isDirectory();
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        return new FileInputStream(path);
    }

    @Override
    public OutputStream getOutputStream(String path) throws IOException {
        return new FileOutputStream(path);
    }

    @Override
    public BufferedReader getBufferedReader(String path) throws IOException {
        return new BufferedReader(new FileReader(path));
    }

    @Override
    public BufferedReader getBufferedReader(String path, String charSet) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), charSet));
    }

    @Override
    public BufferedWriter getBufferedWriter(String path) throws IOException {
        return new BufferedWriter(new FileWriter(path));
    }

    @Override
    public BufferedWriter getBufferedWriter(String path, String charSet) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), charSet));
    }

    @Override
    public boolean mkdirs(String dir) {
        return new File(dir).mkdirs();
    }

    @Override
    public String getCanonicalPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    @Override
    public void copyFile(String srcPath, String destPath) throws IOException {
        FileCopy.copy(new File(srcPath), new File(destPath));
    }

    @Override
    public boolean delete(String path) {
        return Delete.delete(new File(path));
    }
}

