/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRLF {
    static Locale _locale = Locale.getDefault();
    String _crlfExt = "jsp, bat, c, cmd, cpp, crt, ddl, h, html, idl, ini, j, java, jhtml, log, pl, policy,policyTemplate, preamble, properties, propertiesTemplate, realm_ddl, realm_properties, security, sh, shtml, sql, txt, xml, hosts, bea";
    String _espFiles = "ant";
    List _files = new ArrayList();
    static Logger s_logger = Logger.getLogger(CRLF.class.getName());

    public CRLF(File srcDir) {
        this.getFileList(srcDir, this._files);
    }

    public CRLF(List files) {
        this._files = files;
    }

    public void getFileList(File inDir, List allFiles) {
        File[] fList = inDir.listFiles();
        for (int i = 0; i < fList.length; ++i) {
            if (fList[i].isDirectory()) {
                this.getFileList(fList[i], allFiles);
                continue;
            }
            allFiles.add(fList[i]);
        }
    }

    public void process() {
        for (int i = 0; i < this._files.size(); ++i) {
            try {
                File f = (File)this._files.get(i);
                if (f.isDirectory() || !this.checkValidility(f.getName())) continue;
                this.processFile(f);
                continue;
            }
            catch (Exception e) {
                s_logger.log(Level.SEVERE, "error process CRLF of file: " + this._files.get(i), e);
            }
        }
    }

    private void processFile(File afile) throws Exception {
        List data = this.readData(afile);
        String thisLine = null;
        PrintWriter writer = null;
        writer = afile.getName().toLowerCase().endsWith(".xml") ? new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(afile)), "UTF-8")) : new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(afile))));
        for (int i = 0; i < data.size(); ++i) {
            thisLine = (String)data.get(i);
            writer.println(thisLine);
        }
        writer.close();
    }

    private boolean checkValidility(String fileBaseName) {
        int i;
        String[] exts = this._crlfExt.split("\\s*,\\s*");
        String[] esp = this._espFiles.split("\\s*,\\s*");
        for (i = 0; i < exts.length; ++i) {
            if (!fileBaseName.toLowerCase().endsWith("." + exts[i])) continue;
            return true;
        }
        for (i = 0; i < esp.length; ++i) {
            if (!fileBaseName.toLowerCase().equals(esp[i])) continue;
            return true;
        }
        return false;
    }

    private List readData(File file) throws Exception {
        ArrayList<String> data = new ArrayList<String>();
        BufferedReader buffReader = null;
        String thisLine = null;
        buffReader = file.getName().toLowerCase().endsWith(".xml") ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")) : new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while ((thisLine = buffReader.readLine()) != null) {
            data.add(thisLine);
        }
        buffReader.close();
        return data;
    }
}

