/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.ArchiveIncludeExclude;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ArchiveFilter {
    private static Logger _logger = Logger.getLogger(ArchiveFilter.class.getName());
    private File _jar;
    private JarHelper _jarHelper;
    private File _destination;
    private List<ArchiveIncludeExclude> _includes;
    private List<ArchiveIncludeExclude> _excludes;
    private Map<String, ArchiveFilter> _innerArchives = new HashMap<String, ArchiveFilter>();
    private boolean _isExplicitInclude = false;
    private boolean _isReversed = false;
    private boolean _includeManifest = false;
    private List<String> _includedManifest;

    public ArchiveFilter(File jar, File destination, List<ArchiveIncludeExclude> includes, List<ArchiveIncludeExclude> excludes) {
        this._jar = jar;
        this._includes = includes;
        this._excludes = excludes;
        this._destination = destination;
        if (this._includes != null && !this._includes.isEmpty()) {
            this._isExplicitInclude = true;
        }
    }

    public File apply() throws IllegalArgumentException, IOException {
        if (this._jar == null) {
            return null;
        }
        this._jarHelper = new JarHelper(this._jar);
        this._includedManifest = new ArrayList<String>();
        List<String> filtered = this.filterEntries(this._jarHelper.getEntries(), this._includes, this._excludes);
        if (filtered == null || filtered.isEmpty()) {
            _logger.warning("There are no filtered inner entries for " + this._jar.getPath());
            return null;
        }
        File filteredJar = this.createJar(filtered);
        return filteredJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createJar(List<String> entries) throws IllegalArgumentException, IOException {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        if (this._jar != null && this._jarHelper == null) {
            this._jarHelper = new JarHelper(this._jar);
        }
        this._destination.getParentFile().mkdirs();
        File destFile = this._destination;
        if (destFile.exists()) {
            destFile = File.createTempFile(destFile.getName(), ".dup", destFile.getParentFile());
            Delete.delete(destFile);
        }
        JarHelper jarHelper = new JarHelper(destFile, 1);
        try {
            for (String jarEntryName : entries) {
                if (this._innerArchives.containsKey(jarEntryName)) {
                    ArchiveFilter archiveFilter = this._innerArchives.get(jarEntryName);
                    File filteredArchive = archiveFilter.apply();
                    if (archiveFilter.isManifestIncluded()) {
                        this._includedManifest.add(jarEntryName);
                    }
                    if (null == filteredArchive) continue;
                    jarHelper.append(jarEntryName, filteredArchive);
                    continue;
                }
                jarHelper.append(jarEntryName, this._jarHelper.getInputStream(jarEntryName));
            }
        }
        finally {
            if (this._jarHelper != null) {
                this._jarHelper.close();
            }
            if (jarHelper != null) {
                if (jarHelper.getEntries() == null || jarHelper.getEntries().isEmpty()) {
                    _logger.warning("The file " + destFile.getPath() + " does not contain any entries as the result of filtering.");
                    destFile = null;
                }
                jarHelper.close();
            }
        }
        return destFile;
    }

    public List<String> filterEntries(Collection<String> entries, List<ArchiveIncludeExclude> includes, List<ArchiveIncludeExclude> excludes) throws IOException {
        ArrayList<String> filtered = new ArrayList<String>();
        String entryName = null;
        for (String entry : entries) {
            entryName = entry.endsWith("/") ? entry.substring(0, entry.length() - 1) : entry;
            if (!ArchiveFilter.accept(entryName, includes, excludes, this._isReversed)) continue;
            ArchiveIncludeExclude matchingInclude = this.getMatch(entryName, includes);
            ArchiveIncludeExclude matchingExclude = this.getMatch(entryName, excludes);
            if (matchingInclude != null && matchingInclude.getDest() != null && matchingInclude.getDest().contains("MANIFEST.MF") || matchingInclude != null && matchingInclude.getRegex() != null && matchingInclude.getRegex().contains("MANIFEST.MF")) {
                this._includeManifest = true;
            }
            if (JarUtils.isArchive(this._jarHelper, entryName) && (matchingInclude != null || matchingExclude != null)) {
                if (this._innerArchives == null) {
                    this._innerArchives = new HashMap<String, ArchiveFilter>();
                }
                File innerArchive = JarUtils.extractIntoTempFile(this._jar, entryName);
                ArchiveFilter archiveFilter = new ArchiveFilter(innerArchive, new File(System.getProperty("java.io.tmpdir"), entryName), matchingInclude != null ? matchingInclude.getInners() : null, matchingExclude != null ? matchingExclude.getInners() : null);
                innerArchive.deleteOnExit();
                this._innerArchives.put(entry, archiveFilter);
            }
            if (this._jarHelper.getJarEntry(entryName).isDirectory()) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    private ArchiveIncludeExclude getMatch(String dest, List<ArchiveIncludeExclude> includeExcludes) {
        if (null == includeExcludes) {
            return null;
        }
        for (ArchiveIncludeExclude includeExclude : includeExcludes) {
            if (includeExclude.getDest() == null || !includeExclude.getDest().equals(dest)) continue;
            return includeExclude;
        }
        for (ArchiveIncludeExclude includeExclude : includeExcludes) {
            if (!includeExclude.matches(dest)) continue;
            return includeExclude;
        }
        return null;
    }

    public boolean isExplicitInclude() {
        return this._isExplicitInclude;
    }

    public static boolean accept(String dest, List<ArchiveIncludeExclude> includes, List<ArchiveIncludeExclude> excludes, boolean reverse) {
        boolean emptyExcludes;
        boolean emptyIncludes = includes == null || includes.isEmpty();
        boolean bl = emptyExcludes = excludes == null || excludes.isEmpty();
        if (emptyIncludes && emptyExcludes) {
            return true;
        }
        boolean included = new Boolean(emptyIncludes);
        if (reverse) {
            included = ArchiveFilter.isIncluded(included, emptyIncludes, dest, includes);
            included = ArchiveFilter.isExcluded(included, emptyExcludes, dest, excludes);
        } else {
            included = ArchiveFilter.isExcluded(included, emptyExcludes, dest, excludes);
            included = ArchiveFilter.isIncluded(included, emptyIncludes, dest, includes);
        }
        return included;
    }

    private static boolean isIncluded(boolean included, boolean emptyIncludes, String dest, List<ArchiveIncludeExclude> includes) {
        if (!emptyIncludes) {
            return ArchiveFilter.matches(dest, true, includes);
        }
        return included;
    }

    private static boolean isExcluded(boolean included, boolean emptyExcludes, String dest, List<ArchiveIncludeExclude> excludes) {
        if (!emptyExcludes) {
            return !ArchiveFilter.matches(dest, false, excludes);
        }
        return included;
    }

    private static boolean matches(String dest, boolean included, List<ArchiveIncludeExclude> includeExcludes) {
        boolean matches = false;
        if (includeExcludes != null) {
            StringBuffer composedRegex = new StringBuffer();
            StringBuffer composedDest = new StringBuffer();
            ArrayList<ArchiveIncludeExclude> composedWildcard = new ArrayList<ArchiveIncludeExclude>();
            ArrayList<ArchiveIncludeExclude> composedInners = new ArrayList<ArchiveIncludeExclude>();
            for (ArchiveIncludeExclude includeExclude : includeExcludes) {
                if (includeExclude.getRegex() != null) {
                    composedRegex.append("(");
                    composedRegex.append(includeExclude.getRegex());
                    composedRegex.append(")|");
                }
                if (includeExclude.getWildcard() != null) {
                    composedWildcard.add(includeExclude);
                }
                if (includeExclude.getDest() != null) {
                    composedDest.append("(");
                    composedDest.append(Pattern.quote(includeExclude.getDest()));
                    composedDest.append(")|");
                }
                if (includeExclude.getInners() == null || includeExclude.getInners().isEmpty()) continue;
                composedInners.add(includeExclude);
            }
            String composed = composedDest.toString() + composedRegex.toString();
            ArchiveIncludeExclude composedXclude = new ArchiveIncludeExclude("", composed, ((Object)composedWildcard).toString());
            if (composedXclude.matches(dest)) {
                matches = true;
                for (ArchiveIncludeExclude inners : composedInners) {
                    if (!inners.matches(dest)) continue;
                    matches = included;
                }
            }
            for (ArchiveIncludeExclude wildcard : composedWildcard) {
                if (!wildcard.matches(dest) || wildcard.getInners() != null && !wildcard.getInners().isEmpty()) continue;
                matches = true;
            }
        }
        return matches;
    }

    public boolean isReversed() {
        return this._isReversed;
    }

    public void setReversed(boolean reversed) {
        this._isReversed = reversed;
    }

    public boolean isManifestIncluded() {
        return this._includeManifest;
    }

    public List<String> getIncludedManifest() {
        return this._includedManifest;
    }
}

