/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.ui.gui.FixedJTable;
import com.oracle.cie.common.ui.gui.InputTableModel;
import com.oracle.cie.common.ui.gui.NoDashTreeUI;
import com.oracle.cie.common.ui.gui.TreeJTreeModel;
import com.oracle.cie.common.ui.gui.TreeTableHeaderCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreeTable
extends FixedJTable {
    private TreeTableModel model;
    private TreeInputTableModel inputModel;
    private AbstractTableModel tableModel;
    private TreeModel treeModel;
    private TreeTableTableCellRenderer cellRenderer;
    private MyTableCellEditor cellEditor;
    private MyTreeModelListener treeModelListener;

    public JTreeTable(TreeTableTableCellRenderer cellRenderer, TreeTableModel treeTableModel) {
        this.cellRenderer = cellRenderer;
        this.treeModel = cellRenderer.getJTree().getModel();
        this.model = treeTableModel;
        this.inputModel = null;
        treeTableModel.setTreeModel(this.treeModel);
        this.init();
    }

    public JTreeTable(TreeModel treeModel, TreeTableModel treeTableModel) {
        this.treeModel = treeModel;
        this.model = treeTableModel;
        this.inputModel = null;
        treeTableModel.setTreeModel(treeModel);
        this.init();
    }

    public JTreeTable(TreeModel treeModel, TreeInputTableModel treeInputTableModel) {
        this.treeModel = treeModel;
        this.model = treeInputTableModel;
        this.inputModel = treeInputTableModel;
        treeInputTableModel.setTreeModel(treeModel);
        this.init();
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        if (tableColumn != null) {
            TableCellRenderer renderer = tableColumn.getHeaderRenderer();
            if (renderer == null) {
                tableColumn.setHeaderRenderer(new TreeTableHeaderCellRenderer());
            }
            tableColumn.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    TableColumn tableColumn;
                    TableCellRenderer renderer;
                    if (event.getPropertyName().equals("headerRenderer") && ((renderer = (tableColumn = (TableColumn)event.getSource()).getHeaderRenderer()) == null || !(renderer instanceof TreeTableHeaderCellRenderer))) {
                        tableColumn.setHeaderRenderer(new TreeTableHeaderCellRenderer(tableColumn.getHeaderRenderer()));
                    }
                }
            });
        }
    }

    public void setModel(TreeTableModel model) {
        this.model = model;
        this.inputModel = null;
        this.init();
    }

    public void setModel(TreeInputTableModel model) {
        this.model = model;
        this.inputModel = model;
        this.init();
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.getJTree().setCellRenderer(treeCellRenderer);
    }

    public JTree getJTree() {
        return this.cellRenderer.getJTree();
    }

    public void nodesChanged(Object node) {
        this.reloadModelNode(node);
        this.tableModel.fireTableDataChanged();
    }

    public void repaintTable() {
        this.tableModel.fireTableDataChanged();
    }

    public void repaintCell(int row, int col) {
        Object value = this.getValueAt(row, col);
        this.reloadModelNode(value);
        this.tableModel.fireTableCellUpdated(row, col);
    }

    public TreePath[] getExpandedPathEnds() {
        Enumeration<TreePath> pathEnum = this.getJTree().getExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        ArrayList<TreePath> pathVec = new ArrayList<TreePath>();
        if (pathEnum != null) {
            while (pathEnum.hasMoreElements()) {
                pathVec.add(pathEnum.nextElement());
            }
        }
        return pathVec.toArray(new TreePath[pathVec.size()]);
    }

    public void expandPaths(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            this.getJTree().expandPath(paths[i]);
        }
    }

    public Object getNodeForRow(int row) {
        TreePath path = this.getJTree().getPathForRow(row);
        if (path == null) {
            return null;
        }
        return path.getLastPathComponent();
    }

    public Object getTreeNode(int row) {
        return this.getNodeForRow(row);
    }

    public int getTreeColumn() {
        int col = 0;
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            Class c = this.model.getColumnClass(i);
            if (!TreeTableModel.class.isAssignableFrom(c)) continue;
            col = i;
            break;
        }
        return col;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getJTree().getModel().removeTreeModelListener(this.treeModelListener);
    }

    private void init() {
        this.tableModel = this.inputModel != null ? new JTreeInputTableModel(new JTreeTableModel()) : new JTreeTableModel();
        this.setModel(this.tableModel);
        this.setFocusCycleRoot(true);
        this.setFocusable(true);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.setRowHeight(this.getRowHeight() + 4);
        this.setShowGrid(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JTreeTable.this.redispatchMouseEvent(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JTreeTable.this.redispatchMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JTreeTable.this.redispatchMouseEvent(e);
            }
        });
        this.cellEditor = new MyTableCellEditor();
        if (this.cellRenderer == null) {
            this.cellRenderer = new MyTableCellRenderer(this.treeModel);
            this.getJTree().setCellRenderer(new MyTreeCellRenderer());
        }
        this.getJTree().setRowHeight(this.getRowHeight());
        this.getJTree().setRootVisible(false);
        this.getJTree().setShowsRootHandles(true);
        this.getJTree().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                JTreeTable.this.treeExpansion(e);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                JTreeTable.this.treeExpansion(e);
            }
        });
        this.treeModelListener = new MyTreeModelListener();
        this.getJTree().getModel().addTreeModelListener(this.treeModelListener);
        this.setDefaultRenderer(TreeTableModel.class, this.cellRenderer);
        this.setDefaultEditor(TreeTableModel.class, this.cellEditor);
        this.getJTree().setSelectionModel(new ListToTreeSelectionModelWrapper(){
            {
                JTreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.getSelectionModel().setSelectionMode(0);
        this.setRowSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
    }

    private void reloadModelNode(Object node) {
        if (this.treeModel instanceof DefaultTreeModel) {
            DefaultTreeModel m = (DefaultTreeModel)this.treeModel;
            m.reload((TreeNode)node);
        } else if (this.treeModel instanceof TreeJTreeModel) {
            TreeJTreeModel m = (TreeJTreeModel)this.treeModel;
            m.getTreeDataModel().reload((Tree)node);
        }
    }

    private void treeExpansion(TreeExpansionEvent e) {
        int row = this.getSelectedRow();
        int col = this.getTreeColumn();
        this.tableModel.fireTableDataChanged();
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
            this.requestFocusInWindow();
        }
        this.changeSelection(row, col, false, false);
    }

    private void redispatchMouseEvent(MouseEvent e) {
        this.getJTree().dispatchEvent(new MouseEvent(this.getJTree(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger()));
    }

    private void fireTableDataChanged(TreeModelEvent e) {
        int selRow = this.getJTree().getMinSelectionRow();
        int selCol = this.getTreeColumn();
        if (e != null) {
            TreePath path = e.getTreePath();
            Object[] children = e.getChildren();
            for (int i = 0; i < children.length; ++i) {
                TreePath cpath = path.pathByAddingChild(children[i]);
                int row = this.getJTree().getRowForPath(cpath);
                this.tableModel.fireTableRowsUpdated(row, row);
            }
        } else {
            this.tableModel.fireTableDataChanged();
        }
        this.changeSelection(selRow, selCol, false, false);
    }

    public static interface TreeInputTableModel
    extends TreeTableModel {
        public void insertNode(Object var1);

        public void nodeRemoved(Object var1);

        public boolean isNodeEmpty(Object var1);
    }

    public static interface TreeTableModel {
        public void setTreeModel(TreeModel var1);

        public int getColumnCount();

        public String getColumnName(int var1);

        public Class getColumnClass(int var1);

        public Object getValueAt(Object var1, int var2);

        public boolean isColumnEditable(Object var1, int var2);

        public void setValueAt(Object var1, Object var2, int var3);
    }

    public static interface TreeTableTableCellRenderer
    extends TableCellRenderer {
        public JTree getJTree();
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            JTreeTable.this.fireTableDataChanged(e);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            JTreeTable.this.fireTableDataChanged(null);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            JTreeTable.this.fireTableDataChanged(null);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            JTreeTable.this.fireTableDataChanged(null);
        }
    }

    public class JTreeInputTableModel
    extends InputTableModel {
        public JTreeInputTableModel(JTreeTableModel innerModel) {
            super(innerModel);
        }

        @Override
        protected boolean isEmptyValue(int column, Object value) {
            return value == null || value instanceof String && ((String)value).length() == 0;
        }

        @Override
        protected boolean isRowEmpty(int row) {
            return JTreeTable.this.inputModel.isNodeEmpty(JTreeTable.this.getTreeNode(row));
        }

        @Override
        protected void addRowToEnd(Object value) {
            JTreeTable.this.inputModel.insertNode(value);
            JTreeTable.this.nodesChanged(JTreeTable.this.treeModel.getRoot());
        }

        @Override
        protected void removeRow(int row) {
            Object node = JTreeTable.this.getNodeForRow(row);
            JTreeTable.this.inputModel.nodeRemoved(node);
            if (node instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode dm = (DefaultMutableTreeNode)node;
                dm.removeFromParent();
            } else if (node instanceof Tree) {
                Tree t = (Tree)node;
                t.getParent().removeSubtree(t);
            }
            JTreeTable.this.nodesChanged(JTreeTable.this.treeModel.getRoot());
        }

        @Override
        protected boolean isEmptyColumnEditable(int columnIndex) {
            return JTreeTable.this.inputModel.isColumnEditable(null, columnIndex);
        }
    }

    public class JTreeTableModel
    extends AbstractTableModel {
        public Class getColumnClass(int column) {
            return JTreeTable.this.model.getColumnClass(column);
        }

        @Override
        public int getColumnCount() {
            return JTreeTable.this.model.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return JTreeTable.this.model.getColumnName(column);
        }

        @Override
        public int getRowCount() {
            return JTreeTable.this.getJTree().getRowCount();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return JTreeTable.this.model.getValueAt(JTreeTable.this.getNodeForRow(row), column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (!JTreeTable.this.model.isColumnEditable(JTreeTable.this.getTreeNode(row), column)) {
                return false;
            }
            if (JTreeTable.this.model.getColumnClass(column) == TreeTableModel.class) {
                Object node = JTreeTable.this.getNodeForRow(row);
                if (node instanceof TreeNode) {
                    TreeNode tn = (TreeNode)node;
                    return tn.getParent() == JTreeTable.this.treeModel.getRoot();
                }
                if (node instanceof Tree) {
                    Tree t = (Tree)node;
                    return t.getParent() == JTreeTable.this.treeModel.getRoot();
                }
                return false;
            }
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            JTreeTable.this.model.setValueAt(value, JTreeTable.this.getTreeNode(row), column);
        }
    }

    public class MyTableCellEditor
    extends DefaultCellEditor {
        public MyTableCellEditor() {
            super(new JTextField());
            this.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            Component c = super.getTableCellEditorComponent(table, value, isSelected, row, col);
            c.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        MyTableCellEditor.this.stopCellEditing();
                    } else if (e.getKeyCode() == 27) {
                        MyTableCellEditor.this.cancelCellEditing();
                    }
                }
            });
            return c;
        }
    }

    public class MyTableCellRenderer
    extends JTree
    implements TreeTableTableCellRenderer {
        private int row;
        private JTreeTable table;

        public MyTableCellRenderer(TreeModel model) {
            super(model);
            this.setFocusable(true);
            this.setUI(new NoDashTreeUI());
        }

        @Override
        public JTree getJTree() {
            return this;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, 0, width, this.table.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.row * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.table = (JTreeTable)table;
            if (isSelected) {
                this.setBackground(table.hasFocus() ? table.getSelectionBackground() : UIManager.getColor("desktop"));
            } else {
                this.setBackground(table.getBackground());
            }
            this.row = row;
            return this;
        }
    }

    public class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ListSelectionModel sm = JTreeTable.this.getColumnModel().getSelectionModel();
            selected = selected && sm.isSelectedIndex(JTreeTable.this.getTreeColumn());
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Color backgroundColor = tree.getBackground();
            this.setBackground(backgroundColor);
            this.setBackgroundNonSelectionColor(backgroundColor);
            this.setBackgroundSelectionColor(backgroundColor);
            return this;
        }
    }

    public class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean _updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
                }
            });
        }

        @Override
        public void resetRowSelection() {
            if (!this._updatingListSelectionModel) {
                this._updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this._updatingListSelectionModel = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (this._updatingListSelectionModel) {
                return;
            }
            this._updatingListSelectionModel = true;
            try {
                int min = this.listSelectionModel.getMinSelectionIndex();
                int max = this.listSelectionModel.getMaxSelectionIndex();
                super.clearSelection();
                if (min != -1 && max != -1) {
                    for (int i = min; i <= max; ++i) {
                        TreePath selPath;
                        if (!this.listSelectionModel.isSelectedIndex(i) || (selPath = JTreeTable.this.getJTree().getPathForRow(i)) == null) continue;
                        this.addSelectionPath(selPath);
                    }
                }
            }
            finally {
                this._updatingListSelectionModel = false;
            }
        }
    }
}

