/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import com.oracle.cie.common.ui.gui.GUIHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class FixedJTable
extends JTable {
    private boolean _hasRowModel;
    private Listener _listener;
    private boolean _sizeToFitWhenAutoResizeOff;
    private boolean _initWidthsWhenAutoResizeoff;

    public FixedJTable() {
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    public FixedJTable(TableModel data) {
        super(data);
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    public FixedJTable(TableModel data, TableColumnModel columns) {
        super(data, columns);
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    protected void configureEnclosingScrollPane() {
        if (this.getTableHeader() != null) {
            super.configureEnclosingScrollPane();
        }
    }

    @Override
    protected void unconfigureEnclosingScrollPane() {
        if (this.getTableHeader() != null) {
            super.configureEnclosingScrollPane();
        }
    }

    @Override
    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        ListSelectionModel rows = this.getSelectionModel();
        ListSelectionModel columns = this.getColumnModel().getSelectionModel();
        boolean selected = this.isCellSelected(row, column);
        int anchorRow = rows.getAnchorSelectionIndex();
        int anchorColumn = columns.getAnchorSelectionIndex();
        boolean anchorSelected = anchorRow != -1 && anchorColumn != -1 && this.isCellSelected(anchorRow, anchorColumn);
        TableColumnModels.change(columns, column, toggle, extend, selected, anchorSelected);
        TableColumnModels.change(rows, row, toggle, extend, selected, anchorSelected);
        this.scrollRectToVisible(this.getCellRect(row, column, true));
    }

    @Override
    public void setColumnModel(TableColumnModel c) {
        if (c == null) {
            throw new IllegalArgumentException("null");
        }
        if (c == this.columnModel) {
            return;
        }
        this.finishEditing();
        if (this.columnModel != null) {
            this.columnModel.removeColumnModelListener(this.getListener());
        }
        super.setColumnModel(c);
        this.columnModel.removeColumnModelListener(this);
        this.columnModel.addColumnModelListener(this.getListener());
    }

    @Override
    public void setSelectionModel(ListSelectionModel s) {
        if (s == null) {
            throw new IllegalArgumentException("selectionModel can't be null");
        }
        if (s == this.selectionModel) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeListSelectionListener(this.getListener());
        }
        super.setSelectionModel(s);
        this.selectionModel.removeListSelectionListener(this);
        this.selectionModel.addListSelectionListener(this.getListener());
    }

    @Override
    public void setModel(TableModel data) {
        if (data == null) {
            throw new IllegalArgumentException("null");
        }
        if (data == this.dataModel) {
            return;
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this.getListener());
        }
        super.setModel(data);
        this.dataModel.removeTableModelListener(this);
        this.dataModel.addTableModelListener(this.getListener());
    }

    public void dispose() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this.getListener());
        }
    }

    @Override
    public void setRowHeight(int height) {
        this._hasRowModel = false;
        super.setRowHeight(height);
    }

    @Override
    public void setRowHeight(int row, int height) {
        this._hasRowModel = true;
        super.setRowHeight(row, height);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container p = this.getParent();
        if (p instanceof JViewport) {
            JViewport vp = (JViewport)p;
            if (this.getColumnModel().getTotalColumnWidth() < vp.getExtentSize().width) {
                return true;
            }
        }
        return this.getAutoResizeMode() != 0;
    }

    @Override
    public void selectAll() {
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, this.getRowCount() - 1);
        }
        if (this.getColumnCount() > 0) {
            this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        int index = e.getToIndex();
        if (this.editingColumn != -1 && index <= this.editingColumn) {
            this.setEditingColumn(this.editingColumn + 1);
        }
        this.resizeAndRepaint();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        if (this.editingColumn != -1) {
            int from = e.getFromIndex();
            if (this.editingColumn == from) {
                this.removeEditor();
            } else if (this.editingColumn > from) {
                this.setEditingColumn(this.editingColumn - 1);
            }
        }
        this.resizeAndRepaint();
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        if (this.editingColumn != -1) {
            TableColumn c;
            int from = e.getFromIndex();
            int to = e.getToIndex();
            if (this.editingColumn == from) {
                this.setEditingColumn(to);
            } else if (from > to) {
                if (this.editingColumn >= to && this.editingColumn < from) {
                    this.setEditingColumn(this.editingColumn + 1);
                }
            } else if (this.editingColumn > from && this.editingColumn <= to) {
                this.setEditingColumn(this.editingColumn - 1);
            }
            TableColumn tableColumn = c = this.tableHeader != null ? this.tableHeader.getDraggedColumn() : null;
            if (c != null && this.tableHeader.getDraggedDistance() != 0 && this.editingColumn != from) {
                this.finishEditing();
            }
        }
        this.repaint();
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle result = super.getCellRect(row, column, includeSpacing);
        if (!this.getComponentOrientation().isLeftToRight() && column >= 0 && column < this.getColumnCount()) {
            TableColumnModel columns = this.getColumnModel();
            result.width = columns.getColumn(column).getWidth();
            result.x = this.getWidth() - result.width;
            for (int i = 0; i < column; ++i) {
                result.x -= columns.getColumn(i).getWidth();
            }
            if (!includeSpacing && row >= 0 && row < this.getRowCount()) {
                int margin = this.getColumnModel().getColumnMargin();
                result.x -= margin / 2;
                result.width -= margin;
            }
        }
        return result;
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        TableColumn c = this.resizingColumn();
        if (c != null && this.autoResizeMode == 0) {
            c.setPreferredWidth(c.getWidth());
        }
        this.resizeAndRepaint();
    }

    @Override
    public void doLayout() {
        if (this.getAutoResizeMode() == 0) {
            if (!this._initWidthsWhenAutoResizeoff) {
                GUIHelper.calcColumnWidths(this);
                this._initWidthsWhenAutoResizeoff = true;
            }
            if (!this._sizeToFitWhenAutoResizeOff && this.getColumnModel().getTotalColumnWidth() < this.getWidth()) {
                this._sizeToFitWhenAutoResizeOff = true;
                this.sizeColumnsToFit(-1);
                Enumeration<TableColumn> e = this.getColumnModel().getColumns();
                while (e.hasMoreElements()) {
                    TableColumn d = e.nextElement();
                    if (d.getWidth() == d.getPreferredWidth()) continue;
                    d.setPreferredWidth(d.getWidth());
                }
            } else {
                Enumeration<TableColumn> e = this.getColumnModel().getColumns();
                while (e.hasMoreElements()) {
                    TableColumn d = e.nextElement();
                    if (d.getWidth() == d.getPreferredWidth()) continue;
                    d.setWidth(d.getPreferredWidth());
                }
            }
            return;
        }
        TableColumn c = this.resizingColumn();
        if (c == null) {
            super.doLayout();
        } else {
            int column = TableColumnModels.indexOf(this.getColumnModel(), c);
            this.sizeColumnsToFit(column);
            int delta = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            if (delta != 0) {
                c.setWidth(c.getWidth() + delta);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int first = e.getFirstRow();
        int last = e.getLastRow();
        if (e.getType() == 0) {
            if (first == -1 || first == 0 && last == Integer.MAX_VALUE) {
                this._sizeToFitWhenAutoResizeOff = false;
                this.removeEditor();
                super.tableChanged(e);
                if (this.getRowHeight() != 0) {
                    this.setRowHeight(this.getRowHeight());
                }
            } else {
                int column = e.getColumn();
                if (column == -1) {
                    if (this.editingRow != -1 && this.editingRow >= first && this.editingRow <= last) {
                        this.removeEditor();
                    }
                    Rectangle r = this.getCellRect(first, -1, false);
                    if (last != first) {
                        r = r.union(this.getCellRect(last, -1, false));
                    }
                    r.width = this.getWidth();
                    this.repaint(r);
                } else if ((column = this.convertColumnIndexToView(column)) != -1) {
                    if (this.editingColumn == column && this.editingRow >= first && this.editingRow <= last) {
                        this.removeEditor();
                    }
                    Rectangle r = this.getCellRect(first, column, false);
                    if (last != first) {
                        r = r.union(this.getCellRect(last, column, false));
                    }
                    this.repaint(r);
                }
            }
        } else if (e.getType() == 1) {
            super.tableChanged(e);
            if (this.editingRow != -1 && this.editingRow >= first) {
                this.setEditingRow(this.editingRow + 1 + last - first);
            }
        } else {
            super.tableChanged(e);
            if (this.editingRow != -1 && this.editingRow >= first) {
                if (this.editingRow <= last) {
                    this.removeEditor();
                } else {
                    this.setEditingRow(this.editingRow - 1 + last - first);
                }
            }
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor f = this.getCellEditor();
        if (f != null) {
            int row = this.editingRow;
            int column = this.editingColumn;
            Object val = f.getCellEditorValue();
            this.originalRemoveEditor();
            this.setValueAt(val, row, column);
        }
    }

    public void finishEditing() {
        TableCellEditor e = this.getCellEditor();
        if (e != null && !e.stopCellEditing()) {
            e.cancelCellEditing();
        }
    }

    public boolean stopEditing() {
        TableCellEditor e = this.getCellEditor();
        return e == null || e.stopCellEditing();
    }

    public void cancelEditing() {
        TableCellEditor e = this.getCellEditor();
        if (e != null) {
            e.cancelCellEditing();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.originalRemoveEditor();
    }

    @Override
    public void removeEditor() {
        TableCellEditor e = this.getCellEditor();
        if (e != null) {
            e.cancelCellEditing();
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        TableCellEditor editor = this.getCellEditor(row, column);
        if (editor == null || !editor.isCellEditable(e)) {
            return false;
        }
        this.editorComp = this.prepareEditor(editor, row, column);
        if (this.editorComp == null) {
            return false;
        }
        this.scrollRectToVisible(this.getCellRect(row, column, true));
        this.setCellEditor(editor);
        this.setEditingRow(row);
        this.setEditingColumn(column);
        this.add(this.editorComp);
        this.editorComp.setBounds(this.getCellRect(row, column, false));
        this.editorComp.validate();
        this.editorComp.repaint();
        editor.addCellEditorListener(this.getListener());
        return true;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Rectangle r;
        String result = null;
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        int column = this.columnAtPoint(p);
        if (column != -1 && row != -1 && (r = this.getCellRect(row, column, false)).contains(p)) {
            TableCellRenderer s = this.getCellRenderer(row, column);
            Component c = this.prepareRenderer(s, row, column);
            p.translate(-r.x, -r.y);
            c.setSize(r.width, r.height);
            if (c instanceof Container) {
                Component d;
                c.validate();
                for (Component cc = d = ((Container)c).findComponentAt(p); cc != c; cc = cc.getParent()) {
                    p.translate(-cc.getX(), -cc.getY());
                }
                c = d;
            }
            if (c instanceof JComponent) {
                MouseEvent f = new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
                result = ((JComponent)c).getToolTipText(f);
            }
        }
        if (result == null) {
            result = this.getToolTipText();
        }
        return result;
    }

    protected TableColumn resizingColumn() {
        return this.getTableHeader() != null ? this.getTableHeader().getResizingColumn() : null;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke k, KeyEvent e, int condition, boolean pressed) {
        if (condition == 1 && !this.isEditing()) {
            return this.processKeyBindingImpl(k, e, condition, pressed);
        }
        return super.processKeyBinding(k, e, condition, pressed);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        KeyStroke k;
        super.processKeyEvent(e);
        if (!e.isConsumed() && !this.isEditing() && super.processKeyBinding(k = KeyStroke.getKeyStrokeForEvent(e), e, 1, e.getID() == 401)) {
            e.consume();
        }
    }

    protected void originalRemoveEditor() {
        TableCellEditor e = this.getCellEditor();
        if (e != null) {
            e.removeCellEditorListener(this.getListener());
        }
        super.removeEditor();
    }

    private boolean processKeyBindingImpl(KeyStroke k, KeyEvent e, int condition, boolean pressed) {
        if (this.isEnabled()) {
            Object binding = this.getInputMap(condition).get(k);
            if (binding == null) {
                return false;
            }
            Action a = this.getActionMap().get(binding);
            if (a != null) {
                return SwingUtilities.notifyAction(a, k, e, this, e.getModifiers());
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dataModel != null) {
            this.dataModel.addTableModelListener(this.getListener());
        }
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this.getListener());
        }
        if (this.columnModel != null) {
            this.columnModel.addColumnModelListener(this.getListener());
        }
        if (this.cellEditor != null) {
            this.cellEditor.addCellEditorListener(this.getListener());
        }
    }

    private Listener getListener() {
        if (this._listener == null) {
            this._listener = this.createListener();
        }
        return this._listener;
    }

    private Listener createListener() {
        return new Listener();
    }

    private static class TableColumnModels {
        private TableColumnModels() {
        }

        private static int indexOf(TableColumnModel columns, TableColumn c) {
            for (int i = columns.getColumnCount() - 1; i >= 0; --i) {
                if (!c.equals(columns.getColumn(i))) continue;
                return i;
            }
            return -1;
        }

        private static void change(ListSelectionModel selection, int index, boolean toggle, boolean extend, boolean selected, boolean anchorSelected) {
            if (toggle) {
                if (extend) {
                    selection.setAnchorSelectionIndex(index);
                } else if (selected) {
                    selection.removeSelectionInterval(index, index);
                } else {
                    selection.addSelectionInterval(index, index);
                }
            } else if (extend) {
                int anchor = selection.getAnchorSelectionIndex();
                if (anchor == -1) {
                    if (selected) {
                        selection.removeSelectionInterval(index, index);
                    } else {
                        selection.addSelectionInterval(index, index);
                    }
                } else {
                    int lead = selection.getLeadSelectionIndex();
                    if (lead == -1) {
                        lead = index;
                    }
                    if (anchorSelected) {
                        boolean old = selection.getValueIsAdjusting();
                        selection.setValueIsAdjusting(true);
                        if (anchor <= index) {
                            if (index < lead) {
                                selection.removeSelectionInterval(index + 1, lead);
                            } else if (lead < anchor) {
                                selection.removeSelectionInterval(lead, anchor - 1);
                            }
                        }
                        if (index <= anchor) {
                            if (lead < index) {
                                selection.removeSelectionInterval(lead, index - 1);
                            } else if (anchor < lead) {
                                selection.removeSelectionInterval(anchor + 1, lead);
                            }
                        }
                        selection.addSelectionInterval(anchor, index);
                        selection.setValueIsAdjusting(old);
                    } else {
                        selection.removeSelectionInterval(anchor, index);
                    }
                }
            } else {
                selection.setSelectionInterval(index, index);
            }
        }
    }

    private class Listener
    implements TableModelListener,
    TableColumnModelListener,
    ListSelectionListener,
    CellEditorListener {
        private Listener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            FixedJTable.this.tableChanged(e);
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            FixedJTable.this.columnAdded(e);
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            FixedJTable.this.columnRemoved(e);
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            FixedJTable.this.columnMoved(e);
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            FixedJTable.this.columnMarginChanged(e);
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
            FixedJTable.this.columnSelectionChanged(e);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FixedJTable.this.valueChanged(e);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            FixedJTable.this.editingStopped(e);
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            FixedJTable.this.editingCanceled(e);
        }
    }
}

