/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import com.oracle.cie.common.ui.gui.CheckTreeCellRenderer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class CheckTree
extends JTree {
    protected boolean _notifyModel = true;

    public CheckTree(TreeModel m) {
        super(m);
        this.init();
    }

    public abstract boolean toggleSelected(TreePath var1);

    public abstract boolean toggleSelectable(TreePath var1);

    public abstract boolean setSelectable(Object var1, boolean var2);

    public abstract boolean isSelectable(Object var1);

    public abstract boolean setSelected(Object var1, boolean var2);

    public abstract boolean isSelected(Object var1);

    public abstract boolean setDisabled(Object var1, boolean var2);

    public abstract boolean isDisabled(Object var1);

    public void toggleSelectedPath(TreePath path) {
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (!this.isSelectable(obj) || this.isDisabled(obj)) {
            return;
        }
        this.toggleSelected(path);
        if (this._notifyModel) {
            this.getModel().valueForPathChanged(path, null);
        }
    }

    protected void init() {
        this.setCellRenderer(new CheckTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
        ActionListener a = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckTree.this.toggleSelectedPath(CheckTree.this.getSelectionPath());
            }
        };
        this.registerKeyboardAction(a, KeyStroke.getKeyStroke("SPACE"), 0);
        this.registerKeyboardAction(a, KeyStroke.getKeyStroke("ctrl SPACE"), 0);
        this.addMouseListener(new CheckTreeMouseListener());
    }

    public class CheckTreeMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            int y;
            if (!CheckTree.this.isEnabled() || (e.getModifiers() & 4) != 0) {
                return;
            }
            int x = e.getX();
            TreePath path = CheckTree.this.getPathForLocation(x, y = e.getY());
            if (path == null) {
                return;
            }
            Object obj = path.getLastPathComponent();
            if (!CheckTree.this.isSelectable(obj) || CheckTree.this.isDisabled(obj)) {
                return;
            }
            Rectangle rec = CheckTree.this.getRowBounds(CheckTree.this.getMaxSelectionRow());
            if (rec == null) {
                return;
            }
            CheckTreeCellRenderer renderer = (CheckTreeCellRenderer)CheckTree.this.getCellRenderer();
            Dimension checkDim = renderer.getCheckBoxPreferredSize();
            int deltax = x - rec.x;
            int deltay = y - rec.y;
            if (deltax > 0 && deltax < checkDim.width && deltay > 0 && deltay < checkDim.height) {
                CheckTree.this.toggleSelectedPath(path);
            }
        }
    }
}

