/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.services;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.util.IOUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderService {
    public static final String DEFAULT_CLASSLOADER_KEY = "DEFAULT";
    private static ClassLoaderService _instance;
    private static final Logger _log;
    private Map<String, ClassLoader> _classLoaderCache = new HashMap<String, ClassLoader>();
    private List<File> _extractedFiles = new ArrayList<File>();

    public static synchronized ClassLoaderService getInstance() {
        if (_instance == null) {
            _instance = new ClassLoaderService();
        }
        return _instance;
    }

    private ClassLoaderService() {
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader((URL[])null);
    }

    public ClassLoader getClassLoader(String key) {
        return this.getClassLoader(key, (URL[])null);
    }

    public ClassLoader getClassLoader(URL url) {
        URL[] uRLArray;
        if (url != null) {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        } else {
            uRLArray = null;
        }
        return this.getClassLoader(uRLArray);
    }

    public ClassLoader getClassLoader(String key, URL url) {
        URL[] uRLArray;
        if (url != null) {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        } else {
            uRLArray = null;
        }
        return this.getClassLoader(key, uRLArray);
    }

    public synchronized ClassLoader getClassLoader(URL[] urls) {
        return this.getClassLoader(DEFAULT_CLASSLOADER_KEY, urls);
    }

    public synchronized ClassLoader getClassLoader(String key, URL[] urls) {
        return this.getClassLoader(key, urls, ClassLoaderService.class.getClassLoader());
    }

    public synchronized ClassLoader getClassLoader(String key, URL[] urls, ClassLoader parentClassLoader) {
        ClassLoader classLoader = this.getCachedClassLoader(key);
        if (classLoader == null) {
            UpdateableURLClassLoader cl = new UpdateableURLClassLoader(new URL[0], parentClassLoader);
            this.setCacheClassLoader(key, cl);
            if (urls != null && urls.length > 0) {
                cl.addURLs(urls);
            }
            classLoader = cl;
        } else if (urls != null && urls.length > 0 && classLoader instanceof UpdateableURLClassLoader) {
            ((UpdateableURLClassLoader)classLoader).addURLs(urls);
        }
        return classLoader;
    }

    public void clearCachedClassLoader() {
        this.clearCachedClassLoader(DEFAULT_CLASSLOADER_KEY);
    }

    public void clearCachedClassLoader(String key) {
        this._classLoaderCache.remove(key);
    }

    public boolean hasClassLoader(String key) {
        return this._classLoaderCache.containsKey(key);
    }

    public ClassLoader getCachedClassLoader(String key) {
        return this._classLoaderCache.get(key);
    }

    public void setCacheClassLoader(String key, ClassLoader classLoader) {
        this._classLoaderCache.put(key, classLoader);
    }

    public boolean isClassLoaded(String className) {
        return this.isClassLoaded(className, this.getClassLoader());
    }

    public boolean isClassLoaded(String key, String className) {
        return this.isClassLoaded(className, this.getClassLoader(key));
    }

    public boolean isClassLoaded(String className, ClassLoader classloader) {
        if (className != null && classloader != null) {
            try {
                classloader.loadClass(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public URL getLatestJar(List<URL> modules) {
        URL latestJar = null;
        if (modules != null && modules.size() > 0) {
            Version latestVersion = null;
            for (URL url : modules) {
                String version = this.getModuleVersion(url.getFile());
                if (version == null || version.trim().length() <= 0) continue;
                try {
                    Version v = new Version(version);
                    if (latestJar != null && v.compareTo(latestVersion) <= 0) continue;
                    latestJar = url;
                    latestVersion = v;
                }
                catch (Exception e) {
                    _log.fine("Unable to parse version from gpr jar " + url);
                }
            }
        }
        return latestJar;
    }

    public String getModuleVersion(String name) {
        if (name != null && name.length() > 0) {
            int index1 = name.lastIndexOf(95) + 1;
            int index2 = name.lastIndexOf(46);
            if (index1 > 0 && index2 > index1) {
                return name.substring(index1, index2);
            }
        }
        return null;
    }

    public List<URL> getModuleJars(File dir, String modulePrefix) throws MalformedURLException {
        return this.getModuleJars(dir, modulePrefix, (Class)null);
    }

    public List<URL> getModuleJars(File dir, String modulePrefix, Class locatorClazz) throws MalformedURLException {
        return this.getModuleJars(DEFAULT_CLASSLOADER_KEY, dir, modulePrefix, null, locatorClazz);
    }

    public List<URL> getModuleJars(File dir, String modulePrefix, String version) throws MalformedURLException {
        return this.getModuleJars(DEFAULT_CLASSLOADER_KEY, dir, modulePrefix, version);
    }

    public List<URL> getModuleJars(String key, File dir, String modulePrefix, String version) throws MalformedURLException {
        return this.getModuleJars(key, dir, modulePrefix, version, null);
    }

    public List<URL> getModuleJars(String key, File dir, final String modulePrefix, final String version, Class locatorClazz) throws MalformedURLException {
        URL url;
        File[] files;
        FileFilter filter;
        ArrayList<URL> modules;
        block11: {
            File myself;
            modules = new ArrayList<URL>();
            filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    if (version != null) {
                        return name.startsWith(modulePrefix + version) && name.endsWith(".jar");
                    }
                    return name.startsWith(modulePrefix) && name.endsWith(".jar");
                }
            };
            File userDir = new File(System.getProperty("user.dir"));
            File file = myself = locatorClazz == null ? this.determineMyself(this.getClassLoader(key)) : this.locateClass(locatorClazz, this.getClassLoader(key, null, locatorClazz.getClassLoader()));
            if (myself != null && !myself.isDirectory() && myself.exists() && !userDir.equals(myself.getParentFile()) && (files = myself.getParentFile().listFiles(filter)) != null && files.length > 0) {
                for (File file2 : files) {
                    url = file2.toURI().toURL();
                    if (modules.contains(url)) continue;
                    modules.add(url);
                }
            }
            if (userDir.isDirectory() && (files = userDir.listFiles(filter)) != null && files.length > 0) {
                for (File file2 : files) {
                    url = file2.toURI().toURL();
                    if (modules.contains(url)) continue;
                    modules.add(url);
                }
            }
            if (myself != null && myself.isFile() && !myself.getName().toLowerCase().endsWith(".class")) {
                try {
                    JarFile jarFile = new JarFile(myself);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    String prefix = modulePrefix;
                    if (version != null && version.length() > 0) {
                        prefix = prefix + version;
                    }
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(prefix)) continue;
                        URL url2 = new URL("jar:" + myself.toURI().toURL() + "!/" + entry);
                        modules.add(url2);
                    }
                }
                catch (IOException e) {
                    if (!_log.isLoggable(Level.FINE)) break block11;
                    _log.log(Level.FINE, "Error accessing myself " + myself, e);
                }
            }
        }
        if (dir != null && dir.isDirectory() && (files = dir.listFiles(filter)) != null && files.length > 0) {
            for (File file2 : files) {
                url = file2.toURI().toURL();
                if (modules.contains(url)) continue;
                modules.add(url);
            }
        }
        return modules;
    }

    private File determineMyself(ClassLoader classloader) {
        return this.locateClass(ClassLoaderService.class, classloader);
    }

    public File locateClass(Class clazz) {
        return this.locateClass(clazz, this.getClassLoader());
    }

    public File locateClass(String key, Class clazz) {
        return this.locateClass(clazz, this.getClassLoader(key));
    }

    public File locateClass(Class clazz, ClassLoader classloader) {
        if (clazz != null) {
            return this.locateClass(clazz.getName(), classloader);
        }
        return null;
    }

    public File locateClass(String className) {
        return this.locateClass(className, this.getClassLoader());
    }

    public File locateClass(String key, String className) {
        return this.locateClass(className, this.getClassLoader(key));
    }

    public File locateClass(String className, ClassLoader classloader) {
        if (className != null && classloader != null) {
            try {
                URL classResource = classloader.getResource(className.endsWith(".class") ? className : className.replace('.', '/') + ".class");
                if (classResource != null) {
                    String fileComponent = classResource.getFile();
                    if (classResource.getProtocol().equals("file")) {
                        int classFileIndex = fileComponent.lastIndexOf(className);
                        if (classFileIndex != -1) {
                            fileComponent = fileComponent.substring(0, classFileIndex);
                        }
                        fileComponent = fileComponent.replaceAll("\\+", "%2B");
                        return new File(URLDecoder.decode(fileComponent, "UTF-8"));
                    }
                    if (classResource.getProtocol().equals("jar")) {
                        int classSeparatorIndex = fileComponent.lastIndexOf("!");
                        if (classSeparatorIndex != -1) {
                            fileComponent = fileComponent.substring(0, classSeparatorIndex);
                        }
                        fileComponent = fileComponent.replaceAll("\\+", "%2B");
                        URL u = new URL(URLDecoder.decode(fileComponent, "UTF-8"));
                        return new File(u.getFile());
                    }
                } else if (_log.isLoggable(Level.FINE)) {
                    _log.fine("Unable to locate class " + className);
                }
            }
            catch (UnsupportedEncodingException e) {
                _log.fine(e.getMessage());
            }
            catch (MalformedURLException e) {
                _log.fine(e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL extractNestedJar(URL jarUrl) {
        File f;
        String url = jarUrl.toString();
        if (!url.startsWith("jar:")) {
            return jarUrl;
        }
        url = url.substring(4);
        int index = url.indexOf("!/");
        if (index <= -1) {
            return jarUrl;
        }
        String nestedJar = url.substring(index + 2);
        url = url.substring(0, index);
        try {
            f = new File(new URI(url));
        }
        catch (URISyntaxException e) {
            if (_log.isLoggable(Level.WARNING)) {
                _log.log(Level.WARNING, "Error creating URI.", e);
            }
            if (url.startsWith("file:")) {
                url = url.substring(5);
            }
            f = new File(url);
        }
        JarFile jarFile = null;
        InputStream is = null;
        OutputStream fos = null;
        URL newUrl = null;
        try {
            File dir;
            File dest;
            jarFile = new JarFile(f);
            JarEntry entry = jarFile.getJarEntry(nestedJar);
            String extractDir = System.getProperty("SelfExtractionTask.temp.directory");
            if (extractDir == null || extractDir.length() < 1) {
                extractDir = System.getProperty("java.io.tmpdir");
            }
            if ((dest = new File(dir = new File(extractDir), nestedJar)).exists() && !this._extractedFiles.contains(dest)) {
                dest.delete();
            }
            if (!dest.exists()) {
                is = jarFile.getInputStream(entry);
                fos = new FileOutputStream(dest);
                IOUtil.bufferedCopy(is, fos);
                dest.deleteOnExit();
                this._extractedFiles.add(dest);
            }
            newUrl = dest.toURI().toURL();
        }
        catch (IOException e) {
            if (_log.isLoggable(Level.WARNING)) {
                _log.log(Level.WARNING, "Error extracting nexted jar!", e);
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (IOException iOException) {}
            }
        }
        return newUrl;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._classLoaderCache != null && !this._classLoaderCache.isEmpty()) {
            this._classLoaderCache.clear();
        }
        if (this._extractedFiles != null) {
            for (File f : this._extractedFiles) {
                if (f == null || !f.exists() || f.delete()) continue;
                f.deleteOnExit();
            }
        }
    }

    static {
        _log = Logger.getLogger(ClassLoaderService.class.getName());
    }

    private class UpdateableURLClassLoader
    extends URLClassLoader {
        public UpdateableURLClassLoader(URL[] urls) {
            super(urls);
        }

        public UpdateableURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public UpdateableURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }

        @Override
        public void addURL(URL url) {
            if (_log.isLoggable(Level.FINE)) {
                _log.fine("Adding url to classpath " + url);
            }
            if (url != null) {
                if ("jar".equals(url.getProtocol())) {
                    URL newUrl = ClassLoaderService.this.extractNestedJar(url);
                    if (newUrl != null) {
                        super.addURL(newUrl);
                    }
                } else {
                    super.addURL(url);
                }
            }
        }

        public void addURLs(URL[] urls) {
            if (urls != null) {
                for (URL url : urls) {
                    if (url == null) continue;
                    this.addURL(url);
                }
            }
        }
    }
}

