/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.jni;

import com.oracle.cie.common.jni.Win32Registry;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WinRegistryHelper {
    public static Logger s_logger = Logger.getLogger(WinRegistryHelper.class.getName());

    public static String getRegistry(String key, String regname) {
        int start = WinRegistryHelper.getStart(key);
        if (start == -1) {
            s_logger.severe("Invalid registry key specified: " + key);
            return null;
        }
        String subkey = WinRegistryHelper.getSubkey(key);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("key=" + key);
            s_logger.fine("regname=" + regname);
            s_logger.fine("start=" + start);
            s_logger.fine("subkey=" + subkey);
        }
        int hKey = Win32Registry.RegOpenKeyExA(start, subkey, 131097);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegOpenKeyExA return " + hKey);
        }
        if (hKey == -1) {
            s_logger.info("Open  key failed: " + key);
            return null;
        }
        int[] typeA = new int[1];
        byte[] res = Win32Registry.RegQueryValueExA(hKey, regname, typeA);
        String val = null;
        if (res != null) {
            val = new String(res).trim();
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegQueryValueExA return " + val + " type " + typeA[0]);
        }
        int ret = Win32Registry.RegCloseKey(hKey);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegCloseKey return " + ret);
        }
        return val;
    }

    public static boolean createRegistry(String key, String regname, String type, String value) {
        int ret;
        int start = WinRegistryHelper.getStart(key);
        if (start == -1) {
            s_logger.severe("Invalid registry key specified: " + key);
            return false;
        }
        String subkey = WinRegistryHelper.getSubkey(key);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("key=" + key);
            s_logger.fine("regname=" + regname);
            s_logger.fine("type=" + type);
            s_logger.fine("value=" + value);
            s_logger.fine("start=" + start);
            s_logger.fine("subkey=" + subkey);
        }
        if (type == null || value == null) {
            return false;
        }
        int hKey = Win32Registry.RegCreateKeyExA(start, subkey, 0, 131078);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegCreateKeyExA return " + hKey);
        }
        if (hKey == -1) {
            s_logger.warning("Create Key Failed: " + key);
            return false;
        }
        int intType = WinRegistryHelper.getRegType(type);
        if (intType == 4) {
            int intVal;
            try {
                intVal = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                intVal = -1;
            }
            ret = Win32Registry.RegSetValueEx(hKey, regname, intVal);
        } else {
            ret = Win32Registry.RegSetValueEx(hKey, regname, intType, value);
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegSetValueEx return " + ret);
        }
        ret = Win32Registry.RegCloseKey(hKey);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegCloseKey return " + ret);
        }
        return true;
    }

    public static boolean deleteRegistry(String key, String regname) {
        int start = WinRegistryHelper.getStart(key);
        if (start == -1) {
            s_logger.severe("Invalid registry key specified: " + key);
            return false;
        }
        String subkey = WinRegistryHelper.getSubkey(key);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("key=" + key);
            s_logger.fine("regname=" + regname);
            s_logger.fine("start=" + start);
            s_logger.fine("subkey=" + subkey);
        }
        int hKey = Win32Registry.RegOpenKeyExA(start, subkey, 983103);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegOpenKeyExA return " + hKey);
        }
        if (hKey == -1) {
            return false;
        }
        int ret = Win32Registry.RegDeleteValueA(hKey, regname);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegDeleteValueA return " + ret);
        }
        ret = Win32Registry.RegCloseKey(hKey);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegCloseKey return " + ret);
        }
        return true;
    }

    public static boolean deleteKey(String key) {
        int start = WinRegistryHelper.getStart(key);
        if (start == -1) {
            s_logger.severe("Invalid registry key specified: " + key);
            return false;
        }
        String subkey = WinRegistryHelper.getSubkey(key);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("key=" + key);
            s_logger.fine("start=" + start);
            s_logger.fine("subkey=" + subkey);
        }
        int hKey = Win32Registry.RegOpenKeyExA(start, subkey, 983103);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegOpenKeyExA return " + hKey);
        }
        if (hKey == -1) {
            return false;
        }
        int ret = Win32Registry.RegDeleteKeyA(start, subkey);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("RegDeleteValueA return " + ret);
        }
        return true;
    }

    private static String getSubkey(String key) {
        return key.substring(key.indexOf("\\") + 1, key.length());
    }

    private static int getStart(String key) {
        if (key.indexOf(92) >= 0) {
            key = key.substring(0, key.indexOf("\\"));
        }
        if (key.equalsIgnoreCase("HKEY_LOCAL_MACHINE")) {
            return -2147483646;
        }
        if (key.equalsIgnoreCase("HKEY_CLASSES_ROOT")) {
            return Integer.MIN_VALUE;
        }
        if (key.equalsIgnoreCase("HKEY_CURRENT_USER")) {
            return -2147483647;
        }
        if (key.equalsIgnoreCase("HKEY_USERS")) {
            return -2147483645;
        }
        if (key.equalsIgnoreCase("HKEY_PERFORMANCE_DATA")) {
            return -2147483644;
        }
        return -1;
    }

    private static int getRegType(String type) {
        if (type.equalsIgnoreCase("REG_NONE")) {
            return 0;
        }
        if (type.equalsIgnoreCase("REG_SZ")) {
            return 1;
        }
        if (type.equalsIgnoreCase("REG_EXPAND_SZ")) {
            return 2;
        }
        if (type.equalsIgnoreCase("REG_BINARY")) {
            return 3;
        }
        if (type.equalsIgnoreCase("REG_DWORD")) {
            return 4;
        }
        if (type.equalsIgnoreCase("REG_DWORD_LITTLE_ENDIAN")) {
            return 4;
        }
        if (type.equalsIgnoreCase("REG_DWORD_BIG_ENDIAN")) {
            return 5;
        }
        if (type.equalsIgnoreCase("REG_LINK")) {
            return 6;
        }
        if (type.equalsIgnoreCase("REG_MULTI_SZ")) {
            return 7;
        }
        if (type.equalsIgnoreCase("REG_RESOURCE_LIST")) {
            return 8;
        }
        if (type.equalsIgnoreCase("REG_FULL_RESOURCE_DESCRIPTOR")) {
            return 9;
        }
        if (type.equalsIgnoreCase("REG_RESOURCE_REQUIREMENTS_LIST")) {
            return 10;
        }
        return 1;
    }
}

