/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.AdjacencyListGraph;
import com.oracle.cie.common.comdev.Attributes;
import com.oracle.cie.common.comdev.Edge;
import com.oracle.cie.common.comdev.Graph;
import com.oracle.cie.common.comdev.LoopFinder;
import com.oracle.cie.common.comdev.PrePostVisitor;
import com.oracle.cie.common.comdev.PrePostVisitorAdapter;
import com.oracle.cie.common.comdev.Vertex;
import com.oracle.cie.common.comdev.Visitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class GraphHelper {
    protected static final String COLOR_ATTR = "color";
    protected static final String[] VISIT_COLORS = new String[]{"W", "G", "B"};
    protected static final String IN_DEGREE = "inDegree";

    public static void breadthFirstTraversal(Graph g, Visitor visitor, Vertex start) {
        Iterator it = g.getVertices();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            if (start == null) {
                start = v;
            }
            v.getAttributes().setAttribute(COLOR_ATTR, VISIT_COLORS[0]);
        }
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        queue.addLast(start);
        int depth = 0;
        start.getAttributes().setAttribute(COLOR_ATTR, VISIT_COLORS[1]);
        while (!queue.isEmpty() && !visitor.isDone()) {
            Vertex v = (Vertex)queue.removeFirst();
            visitor.visit(v, null);
            Iterator it2 = g.getOutgoingVertices(v);
            while (it2.hasNext()) {
                Vertex to = (Vertex)it2.next();
                String color = (String)to.getAttributes().getAttribute(COLOR_ATTR);
                if (!VISIT_COLORS[0].equals(color)) continue;
                ++depth;
                to.getAttributes().setAttribute(COLOR_ATTR, VISIT_COLORS[1]);
                queue.addLast(to);
            }
            v.getAttributes().setAttribute(COLOR_ATTR, VISIT_COLORS[2]);
        }
    }

    public static void depthFirstTraversal(Graph g, PrePostVisitor visitor, Vertex start) {
        Iterator it = g.getVertices();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            v.getAttributes().setAttribute(COLOR_ATTR, VISIT_COLORS[0]);
        }
        int time = 0;
        if (start == null) {
            Iterator it2 = g.getVertices();
            while (it2.hasNext()) {
                Vertex v = (Vertex)it2.next();
                Object color = v.getAttributes().getAttribute(COLOR_ATTR);
                if (!VISIT_COLORS[0].equals(color)) continue;
                GraphHelper.depthFirstTraversalVisit(g, visitor, v, time);
            }
        } else {
            GraphHelper.depthFirstTraversalVisit(g, visitor, start, time);
        }
    }

    private static void depthFirstTraversalVisit(Graph g, PrePostVisitor visitor, Vertex v, int time) {
        if (visitor.isDone()) {
            return;
        }
        Attributes attrs = v.getAttributes();
        attrs.setAttribute(COLOR_ATTR, VISIT_COLORS[1]);
        visitor.preVisit(v, null);
        ++time;
        Iterator it = g.getOutgoingVertices(v);
        while (it.hasNext()) {
            Vertex to = (Vertex)it.next();
            Object color = to.getAttributes().getAttribute(COLOR_ATTR);
            if (!VISIT_COLORS[0].equals(color)) continue;
            GraphHelper.depthFirstTraversalVisit(g, visitor, to, time);
        }
        attrs.setAttribute(COLOR_ATTR, VISIT_COLORS[2]);
        ++time;
        visitor.postVisit(v, null);
    }

    public static LinkedList getTopologicalSort(Graph g, Vertex start) {
        final LinkedList ts = new LinkedList();
        PrePostVisitorAdapter visitor = new PrePostVisitorAdapter(){

            @Override
            public void postVisit(Object o, Object filter) {
                ts.addFirst(o);
            }
        };
        GraphHelper.depthFirstTraversal(g, visitor, start);
        return ts;
    }

    public static void topologicalOrderTraversalDFS(Graph g, Visitor visitor) {
        LinkedList ts = GraphHelper.getTopologicalSort(g, null);
        for (Vertex v : ts) {
            visitor.visit(v, null);
        }
    }

    public static void topologicalOrderTraversalIndegree(Graph g, Visitor visitor) {
        int[] inDegree;
        Attributes attrs;
        Iterator it = g.getEdges();
        while (it.hasNext()) {
            Edge edge = (Edge)it.next();
            Vertex to = edge.getV1();
            attrs = to.getAttributes();
            inDegree = (int[])attrs.getAttribute(IN_DEGREE, new int[]{0});
            inDegree[0] = inDegree[0] + 1;
            attrs.setAttribute(IN_DEGREE, inDegree);
        }
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        Iterator it2 = g.getVertices();
        while (it2.hasNext()) {
            Vertex v = (Vertex)it2.next();
            attrs = v.getAttributes();
            inDegree = (int[])attrs.getAttribute(IN_DEGREE);
            if (inDegree != null && inDegree[0] != 0) continue;
            queue.addLast(v);
        }
        while (!queue.isEmpty() && !visitor.isDone()) {
            Vertex v = (Vertex)queue.removeFirst();
            visitor.visit(v, null);
            Iterator it3 = g.getOutgoingVertices(v);
            while (it3.hasNext()) {
                Vertex to = (Vertex)it3.next();
                Attributes attrs2 = to.getAttributes();
                int[] inDegree2 = (int[])attrs2.getAttribute(IN_DEGREE);
                inDegree2[0] = inDegree2[0] - 1;
                attrs2.setAttribute(IN_DEGREE, inDegree2);
                if (inDegree2[0] != 0) continue;
                queue.addLast(to);
            }
        }
    }

    public static Graph transpose(Graph in) {
        if (!in.isDirected()) {
            return in;
        }
        if (!(in instanceof AdjacencyListGraph)) {
            throw new UnsupportedOperationException("only support AdjacencyListGraph");
        }
        AdjacencyListGraph out = new AdjacencyListGraph(true);
        HashMap<Vertex, Vertex> vertexMap = new HashMap<Vertex, Vertex>();
        Iterator it = in.getEdges();
        while (it.hasNext()) {
            Vertex v1;
            Edge e = (Edge)it.next();
            Vertex v0 = (Vertex)vertexMap.get(e.getV0());
            if (v0 == null) {
                v0 = out.insertVertex(e.getV0().getKey());
                vertexMap.put(e.getV0(), v0);
            }
            if ((v1 = (Vertex)vertexMap.get(e.getV1())) == null) {
                v1 = out.insertVertex(e.getV1().getKey());
                vertexMap.put(e.getV1(), v1);
            }
            out.insertDirectedEdge(v1, v0, e.getKey());
        }
        vertexMap.clear();
        return out;
    }

    public static LinkedList getCyclicVertices(Graph g, String startID) {
        Vertex start = g.getVertex(startID);
        if (start == null) {
            return new LinkedList();
        }
        return GraphHelper.getCyclicVertices(g, start);
    }

    public static LinkedList getCyclicVertices(Graph g, Vertex start) {
        Iterator it = g.getVertices();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            v.getAttributes().setAttribute(COLOR_ATTR, VISIT_COLORS[0]);
        }
        LinkedList ts = new LinkedList();
        LoopFinder visitor = new LoopFinder(g, start, ts);
        GraphHelper.depthFirstTraversalVisit(g, visitor, start);
        return ts;
    }

    public static LinkedList getCyclicVertices(Graph g) {
        LinkedList cyclicVertices = new LinkedList();
        Iterator it = g.getVertices();
        while (it.hasNext()) {
            Iterator iter = g.getVertices();
            while (iter.hasNext()) {
                Vertex v = (Vertex)iter.next();
                v.getAttributes().setAttribute(COLOR_ATTR, VISIT_COLORS[0]);
            }
            Vertex start = (Vertex)it.next();
            LoopFinder visitor = new LoopFinder(g, start, cyclicVertices);
            GraphHelper.depthFirstTraversalVisit(g, visitor, start);
            if (cyclicVertices.size() <= 0) continue;
            break;
        }
        return cyclicVertices;
    }

    private static void depthFirstTraversalVisit(Graph g, PrePostVisitor visitor, Vertex v) {
        if (visitor.isDone()) {
            return;
        }
        Attributes attrs = v.getAttributes();
        attrs.setAttribute(COLOR_ATTR, VISIT_COLORS[1]);
        visitor.preVisit(v, null);
        Iterator it = g.getOutgoingVertices(v);
        while (it.hasNext()) {
            Vertex to = (Vertex)it.next();
            Object color = to.getAttributes().getAttribute(COLOR_ATTR);
            if (!VISIT_COLORS[0].equals(color)) continue;
            GraphHelper.depthFirstTraversalVisit(g, visitor, to);
        }
        attrs.setAttribute(COLOR_ATTR, VISIT_COLORS[2]);
        visitor.postVisit(v, null);
    }
}

