/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common;

import java.io.Serializable;
import java.math.BigInteger;

public class Version
implements Cloneable,
Serializable,
Comparable<Version> {
    private static final int NUM_POS = 5;
    private static final int POS_SIZE = 63;
    private static final long POS_MASK = Long.MAX_VALUE;
    private BigInteger _version = BigInteger.ZERO;
    private String _codeName = null;

    public Version(String version, String codeName) {
        if (version == null) {
            throw new IllegalArgumentException("You must supply a valid version string. (" + version + ")");
        }
        String[] positions = version.split("\\.");
        if (positions.length > 5) {
            throw new IllegalArgumentException("Number of version positions exceeds maximum of 5");
        }
        for (int i = 0; i < positions.length; ++i) {
            try {
                BigInteger posVal = new BigInteger(positions[i]);
                if (posVal.compareTo(BigInteger.ZERO) < 0) {
                    throw new IllegalArgumentException("Each version component must be a positive integer.");
                }
                if (!posVal.and(BigInteger.valueOf(Long.MIN_VALUE)).equals(BigInteger.ZERO)) {
                    throw new IllegalArgumentException("Version component " + posVal + " exceeds maximum value " + Long.MAX_VALUE);
                }
                int offset = (5 - (i + 1)) * 63;
                this._version = this._version.or(posVal.shiftLeft(offset));
                continue;
            }
            catch (NumberFormatException nfx) {
                throw new IllegalArgumentException("You must supply a valid version string. (" + version + ")", nfx);
            }
        }
        this._codeName = codeName;
    }

    public Version(String version) {
        this(version, null);
    }

    public boolean hasCodeName() {
        return this._codeName != null;
    }

    public String getCodeName() {
        return this._codeName;
    }

    public boolean isInRange(Version minVersion, boolean isMinInclusive, Version maxVersion, boolean isMaxInclusive) {
        return (minVersion == null || this._version.compareTo(minVersion._version) > 0 || isMinInclusive && this._version.equals(minVersion._version)) && (maxVersion == null || this._version.compareTo(maxVersion._version) < 0 || isMaxInclusive && this._version.equals(maxVersion._version));
    }

    @Override
    public int compareTo(Version v) {
        return this._version.compareTo(v._version);
    }

    public int hashCode() {
        return this._version.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Version && this._version.equals(((Version)obj)._version);
    }

    public int getNumMatchingPositions(Version v) {
        int numPositions;
        BigInteger version = this._version;
        BigInteger compv = v._version;
        for (numPositions = 5; numPositions > 0; --numPositions) {
            int offset = (5 - numPositions) * 63;
            if (!version.shiftRight(offset).equals(compv.shiftRight(offset))) continue;
            return numPositions;
        }
        return numPositions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 4; i >= 0; --i) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(this.getPositionValue(i));
        }
        return sb.toString();
    }

    public String getLegacyVersionString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 4; i >= 1; --i) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(this.getPositionValue(i));
        }
        return sb.toString();
    }

    private long getPositionValue(int pos) {
        return this._version.shiftRight(pos * 63).longValue() & Long.MAX_VALUE;
    }
}

