/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common;

import com.oracle.cie.common.util.IsolatedClassLoader;
import com.oracle.cie.common.util.StringUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarClassLoader {
    private String _classpath;
    private String _classname;
    private boolean _useThreadContextClassLoader;
    private boolean _childFirst;
    private Map<String, Class> _mapNameToClass = new HashMap<String, Class>();
    private static Logger _log = Logger.getLogger(JarClassLoader.class.getName());

    public JarClassLoader(String classpath) {
        this(classpath, false);
    }

    public JarClassLoader(String classpath, boolean useThreadContextClassLoader) {
        this(classpath, useThreadContextClassLoader, false);
    }

    public JarClassLoader(String classpath, boolean useThreadContextClassLoader, boolean childFirst) {
        this._classpath = classpath;
        this._useThreadContextClassLoader = useThreadContextClassLoader;
        this._childFirst = childFirst;
    }

    public JarClassLoader(String classpath, String classname) {
        this._classpath = classpath;
        this._classname = classname;
    }

    public ClassLoader load() {
        URLClassLoader classloader = null;
        try {
            if (!StringUtil.isNullOrEmpty(this._classpath)) {
                URL[] urls = new URL[]{new File(this._classpath).toURI().toURL()};
                classloader = this._useThreadContextClassLoader ? (this._childFirst ? new IsolatedClassLoader(urls, Thread.currentThread().getContextClassLoader(), null) : new URLClassLoader(urls, Thread.currentThread().getContextClassLoader())) : (this._childFirst ? new IsolatedClassLoader(urls, null, null) : new URLClassLoader(urls));
            }
        }
        catch (Exception e) {
            _log.log(Level.FINEST, e.getMessage(), e);
        }
        return classloader;
    }

    public Class loadClass() {
        Class<?> classZ = null;
        try {
            ClassLoader classloader = this.load();
            classZ = this._mapNameToClass.get(this._classname);
            if (classZ == null) {
                classZ = classloader.loadClass(this._classname);
                this._mapNameToClass.put(this._classname, classZ);
            }
        }
        catch (Exception e) {
            _log.log(Level.FINEST, e.getMessage(), e);
        }
        return classZ;
    }
}

