/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wallet.impl;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wallet.WalletHandler;
import com.oracle.cie.wallet.WalletHandlerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;

public class WalletHandlerImpl
implements WalletHandler {
    public static final Logger log = Logger.getLogger(WalletHandlerImpl.class.getName());
    private static Map<String, WeakReference<OracleWallet>> walletCache = new HashMap<String, WeakReference<OracleWallet>>();
    private OracleWallet _wallet;
    public static final String ORACLE_WALLET_FILE = "cwallet.sso";

    @Override
    public byte[] getWallet(String alias, char[] secret, boolean autoLogin) throws WalletHandlerException {
        byte[] walletData;
        if (StringUtil.isNullOrEmpty((String)alias)) {
            throw new WalletHandlerException("alias in Oracle wallet has not been specified");
        }
        try {
            OracleWallet wallet = new OracleWallet();
            wallet.createSSO();
            OracleSecretStore secretStore = wallet.getSecretStore();
            secretStore.setSecret(alias, secret);
            wallet.setSecretStore(secretStore);
            walletData = wallet.getWalletArrayB(autoLogin);
        }
        catch (IOException e) {
            throw new WalletHandlerException("Unable to create OracleWallet", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Unable to create OracleWallet", e);
        }
        return walletData;
    }

    @Override
    public char[] getSecret(InputStream in, String alias) throws WalletHandlerException {
        char[] data;
        if (in == null) {
            throw new WalletHandlerException("Oracle wallet data has not been specified");
        }
        if (StringUtil.isNullOrEmpty((String)alias)) {
            throw new WalletHandlerException("alias in Oracle wallet has not been specified");
        }
        try {
            OracleWallet wallet = new OracleWallet();
            wallet.setWalletArray(in, null);
            OracleSecretStore secretStore = wallet.getSecretStore();
            data = secretStore.getSecret(alias);
        }
        catch (IOException e) {
            throw new WalletHandlerException("Unable to get wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Unable to get wallet data", e);
        }
        return data;
    }

    @Override
    public char[] getSecret(String alias) throws WalletHandlerException {
        char[] data;
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            data = secretStore.getSecret(alias);
        }
        catch (IOException e) {
            throw new WalletHandlerException("Unable to get wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Unable to get wallet data", e);
        }
        return data;
    }

    @Override
    public void setSecret(String alias, char[] secret) throws WalletHandlerException {
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            secretStore.setSecret(alias, secret);
            this._wallet.setSecretStore(secretStore);
        }
        catch (IOException e) {
            throw new WalletHandlerException("I/O Error setting wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Error setting wallet data", e);
        }
    }

    @Override
    public void deleteAlias(String alias) throws WalletHandlerException {
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            secretStore.deleteSecret(alias);
            this._wallet.setSecretStore(secretStore);
        }
        catch (IOException e) {
            throw new WalletHandlerException("I/O Error setting wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Error setting wallet data", e);
        }
    }

    @Override
    public List<String> listAliases() throws WalletHandlerException {
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            Enumeration enumeration = secretStore.internalAliases();
            while (enumeration.hasMoreElements()) {
                aliases.add(enumeration.nextElement().toString());
            }
        }
        catch (IOException e) {
            throw new WalletHandlerException("I/O Error reading wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Error reading wallet data", e);
        }
        return aliases;
    }

    @Override
    public void createUserCredential(String map, String key, String username, char[] pw) throws WalletHandlerException {
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            secretStore.createUserCredential(map, key, username, pw);
            this._wallet.setSecretStore(secretStore);
        }
        catch (IOException e) {
            throw new WalletHandlerException("I/O Error setting wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Error setting wallet data", e);
        }
    }

    @Override
    public void deleteUserCredential(String map, String key) throws WalletHandlerException {
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            secretStore.deleteUserCredential(map, key);
            this._wallet.setSecretStore(secretStore);
        }
        catch (IOException e) {
            throw new WalletHandlerException("I/O Error setting wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Error setting wallet data", e);
        }
    }

    @Override
    public String getUsernameCredential(String map, String key) throws WalletHandlerException {
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            return secretStore.getUsernameCredential(map, key);
        }
        catch (IOException e) {
            throw new WalletHandlerException("I/O Error reading wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Credentials do not exist for map=" + map + " key=" + key, e);
        }
    }

    @Override
    public char[] getPasswordCredential(String map, String key) throws WalletHandlerException {
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            return secretStore.getPasswordCredential(map, key);
        }
        catch (IOException e) {
            throw new WalletHandlerException("I/O Error reading wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Credentials do not exist for map=" + map + " key=" + key, e);
        }
    }

    @Override
    public void createDefaultWallet(File walletLocation, String commonName, String aliasName) throws WalletHandlerException {
        if (StringUtil.isNullOrEmpty((String)commonName, (boolean)true)) {
            commonName = "localhost";
        }
        if (StringUtil.isNullOrEmpty((String)aliasName, (boolean)true)) {
            aliasName = "orakey";
        }
        log.fine("creating oracle wallet at " + walletLocation.getAbsolutePath());
        if (!walletLocation.exists() && !walletLocation.mkdirs()) {
            throw new WalletHandlerException("Unable to create dir " + walletLocation.getAbsolutePath());
        }
        if (!walletLocation.exists() || !walletLocation.isDirectory()) {
            log.warning("Unable to create default Oracle wallet. Dir not found : " + walletLocation.getAbsolutePath());
            throw new WalletHandlerException("Unable to create default Oracle wallet. Dir not found : " + walletLocation.getAbsolutePath());
        }
        OracleWallet wallet = new OracleWallet();
        try {
            wallet.createSSO();
            String subjectDN = "CN=" + commonName + ", OU=FOR TESTING ONLY, O=FOR TESTING ONLY";
            X500Principal subjectPrincipal = new X500Principal(subjectDN);
            log.fine("creating self signed certificate");
            wallet.createSelfSigned(subjectPrincipal, 2048, 1825, BigInteger.ZERO, null, aliasName);
            log.fine("saving default oracle wallet to " + walletLocation.getAbsolutePath());
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            FileAttribute<Set<PosixFilePermission>> fileAttribute = PosixFilePermissions.asFileAttribute(permissions);
            File walletFile = new File(walletLocation, ORACLE_WALLET_FILE);
            if (!ComdevHelper.isWindows()) {
                log.fine("creating OracleWallet file.");
                Files.createFile(Paths.get(walletFile.getAbsolutePath(), new String[0]), fileAttribute);
            }
            log.fine("saving OracleWallet file.");
            wallet.saveAs(walletLocation.getAbsolutePath());
        }
        catch (IOException e) {
            throw new WalletHandlerException("Unable to create default wallet at " + walletLocation.getAbsolutePath(), e);
        }
    }

    private OracleWallet getCachedWallet(File walletDir) throws WalletHandlerException {
        WeakReference<OracleWallet> walletRef = walletCache.get(walletDir.getPath());
        return walletRef != null ? (OracleWallet)walletRef.get() : null;
    }

    private File getCanonicalWalletDir(File walletDir) throws WalletHandlerException {
        if (walletDir == null) {
            String path = OracleWallet.getDefaultLocation();
            if (path == null) {
                throw new WalletHandlerException("No default wallet directory");
            }
            walletDir = new File(path);
        }
        walletDir = FileUtils.getFile((File)walletDir);
        return walletDir;
    }

    @Override
    public void loadWallet(File walletDir) throws WalletHandlerException {
        if (this._wallet != null) {
            log.severe("Attempt to reload wallet: " + walletDir);
            throw new WalletHandlerException("Wallet is already loaded");
        }
        walletDir = this.getCanonicalWalletDir(walletDir);
        this._wallet = this.getCachedWallet(walletDir);
        if (this._wallet != null) {
            return;
        }
        if (!walletDir.isDirectory()) {
            log.severe("Wallet directory is invalid: " + walletDir.getAbsolutePath());
            throw new WalletHandlerException("Wallet directory is invalid");
        }
        this._wallet = new OracleWallet();
        try {
            this._wallet.open(walletDir.getAbsolutePath(), null);
        }
        catch (IOException ioe) {
            log.severe("Unable to open wallet: " + walletDir.getAbsolutePath());
            throw new WalletHandlerException("Unable to open wallet", ioe);
        }
        walletCache.put(walletDir.getPath(), new WeakReference<OracleWallet>(this._wallet));
    }

    @Override
    public void saveWallet() throws WalletHandlerException, IOException {
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        this._wallet.save();
    }

    @Override
    public void createWallet(File walletDir) throws WalletHandlerException {
        if (this._wallet != null) {
            log.severe("Attempt to reload wallet: " + walletDir);
            throw new WalletHandlerException("Wallet is already loaded");
        }
        walletDir = this.getCanonicalWalletDir(walletDir);
        this._wallet = this.getCachedWallet(walletDir);
        if (this._wallet == null) {
            OracleWallet wallet = new OracleWallet();
            try {
                if (!this.walletExists(wallet, walletDir, true)) {
                    this.createDefaultWallet(walletDir, null, null);
                }
            }
            catch (IOException e) {
                throw new WalletHandlerException("I/O error checking for wallet existance");
            }
            this.loadWallet(walletDir);
        }
    }

    @Override
    public void createWallet(File walletDir, char[] pwd) throws WalletHandlerException {
        byte bWalletConf = 0;
        if (this._wallet != null) {
            log.severe("Attempt to reload wallet: " + walletDir);
            throw new WalletHandlerException("Wallet is already loaded");
        }
        walletDir = this.getCanonicalWalletDir(walletDir);
        this._wallet = this.getCachedWallet(walletDir);
        if (this._wallet == null) {
            block8: {
                OracleWallet wallet = new OracleWallet();
                try {
                    if (this.walletExists(wallet, walletDir, false)) break block8;
                    if (!OracleWallet.isValidPassword((char[])pwd)) {
                        log.severe("Invalid Password for wallet");
                        throw new WalletHandlerException("Invalid Password for wallet");
                    }
                    try {
                        wallet.create(OraclePKIGenFunc.getCreatePassword((String)new String(pwd), (boolean)false), bWalletConf);
                        wallet.saveAs(walletDir.getPath(), bWalletConf);
                    }
                    catch (IOException e) {
                        log.severe("Unable to save wallet at " + walletDir.getPath());
                        throw new WalletHandlerException("Unable to save wallet");
                    }
                    catch (Exception e) {
                        log.severe("Unable to save wallet at " + walletDir.getPath());
                        throw new WalletHandlerException("Unable to save wallet");
                    }
                }
                catch (IOException e) {
                    throw new WalletHandlerException("I/O error checking for wallet existance");
                }
            }
            this.loadWallet(walletDir, pwd);
        }
    }

    @Override
    public void modifyUserCredential(String map, String key, String username, char[] pw) throws WalletHandlerException {
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            secretStore.modifyUserCredential(map, key, username, pw);
            this._wallet.setSecretStore(secretStore);
        }
        catch (IOException e) {
            throw new WalletHandlerException("I/O Error setting wallet data", e);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Error setting wallet data", e);
        }
    }

    @Override
    public void loadWallet(File walletDir, char[] pwd) throws WalletHandlerException {
        if (this._wallet != null) {
            log.severe("Attempt to reload wallet: " + walletDir);
            throw new WalletHandlerException("Wallet is already loaded");
        }
        walletDir = this.getCanonicalWalletDir(walletDir);
        this._wallet = this.getCachedWallet(walletDir);
        if (this._wallet != null) {
            return;
        }
        if (!walletDir.isDirectory()) {
            log.severe("Wallet directory is invalid: " + walletDir.getAbsolutePath());
            throw new WalletHandlerException("Wallet directory is invalid");
        }
        this._wallet = new OracleWallet();
        try {
            this._wallet.open(walletDir.getAbsolutePath(), pwd);
        }
        catch (IOException ioe) {
            log.severe("Unable to open wallet: " + walletDir.getAbsolutePath());
            throw new WalletHandlerException("Unable to open wallet", ioe);
        }
        walletCache.put(walletDir.getPath(), new WeakReference<OracleWallet>(this._wallet));
    }

    @Override
    public boolean walletExists(File walletDir, boolean autoLoginWallet) throws IOException {
        return this.walletExists(new OracleWallet(), walletDir, autoLoginWallet);
    }

    private boolean walletExists(OracleWallet wallet, File walletDir, boolean autoLoginWallet) throws IOException {
        return wallet.exists(walletDir.getPath(), autoLoginWallet);
    }

    @Override
    public boolean containsAlias(String key) throws WalletHandlerException {
        boolean contains;
        if (this._wallet == null) {
            throw new WalletHandlerException("Wallet is not loaded");
        }
        try {
            OracleSecretStore secretStore = this._wallet.getSecretStore();
            contains = secretStore.containsAlias(key);
        }
        catch (OracleSecretStoreException e) {
            throw new WalletHandlerException("Unable to look up in wallet ", e);
        }
        catch (IOException e) {
            throw new WalletHandlerException("Unable to look up in wallet ", e);
        }
        return contains;
    }

    @Override
    public void close() {
        this._wallet = null;
    }
}

