/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.engineeredsystem;

import dbmodel.bundle_xml.SystemPatchBundleXML;
import dbmodel.bundle_xml.fvalue;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.patchmodel.PatchPackage;
import dbmodel.util.BundleValidationException;
import dbmodel.util.BundleXmlException;
import dbmodel.util.BundleXmlHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.engineeredsystem.HashComputeFunction;
import oracle.dbsysmodel.engineeredsystem.IncludeAutomationXml;
import oracle.dbsysmodel.engineeredsystem.InventoryAndActionOnly;
import oracle.dbsysmodel.engineeredsystem.InventoryAndActionOnlyV2;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.dbsysmodel.patchsdk.PatchValidatorAndGenerator;
import oracle.dbsysmodel.patchsdk.ZipStringResource;

public class EngineeredSystemPatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    static Logger logger = Logger.getLogger(EngineeredSystemPatchValidatorAndGenerator.class.getName());
    public static final String BUNDLE_XML = "bundle.xml";
    public static final String AUTOMATION_XML = "automation";
    public static final String BUNDLE_XML_NAME = "bundle.xml";
    public static final String RESOURCE_BUNDLE = "messages.properties";
    public static final String ETC_CONFIG = "etc" + File.separator + "config";
    public static final String ACTIONS_XML = ETC_CONFIG + File.separator + "actions.xml";
    public static final String INVENTORY_XML = ETC_CONFIG + File.separator + "inventory.xml";
    public static final String COMPOSITE_XML = ETC_CONFIG + File.separator + "composite.xml";
    public static HashMap<Integer, HashComputeFunction> hashFunctions = new HashMap();

    @Override
    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        String function;
        HashComputeFunction trueFunc;
        assert (patchLocation != null);
        SystemPatchBundleXML esysbundle = this.validateAndGenerateSystemBundleXml(patchLocation);
        if (esysbundle == null) {
            return false;
        }
        fvalue fv = esysbundle.getFvalue();
        String hv = fv.getValue();
        if (hv == null) {
            hv = new String();
        }
        if ((trueFunc = hashFunctions.get(new Integer(function = fv.getFunction()))) != null) {
            List<String> metaList = trueFunc.fileList(patchLocation, esysbundle);
            String valueComp = trueFunc.computeHash(metaList);
            if (!valueComp.equals(hv)) {
                throw new PatchPackageException("Engineered System Patch may be modified. Please try the same patch from MOS");
            }
        } else {
            StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
            bundleXMLLoc.append(File.separator);
            bundleXMLLoc.append("bundle.xml");
            File bxml = new File(bundleXMLLoc.toString());
            throw new PatchPackageException("Hash function of fvalue in \"" + bxml.getAbsolutePath() + "\" is not supported in current version.");
        }
        return true;
    }

    public SystemPatchBundleXML validateAndGenerateSystemBundleXml(String patchLocation) throws PatchPackageException {
        SystemPatchBundleXML esysbundle;
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The patch specified by the given location " + patchLocation + " is not a directory");
        }
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(File.separator);
        bundleXMLLoc.append("bundle.xml");
        File bxml = new File(bundleXMLLoc.toString());
        if (!bxml.exists()) {
            logger.log(Level.SEVERE, "Bundle.xml was not found at the given patch location " + bundleXMLLoc.toString());
            return null;
        }
        if (!bxml.isFile()) {
            logger.log(Level.SEVERE, "Bundle.xml was found but it is not a file.");
            throw new PatchPackageException("Bundle.xml was found at location " + bxml.getAbsolutePath() + " but it is not a file");
        }
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            esysbundle = bhxml.readBundle(bxml);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception was thrown while creating the bundleXml object from the bundleXml. ", e);
        }
        catch (BundleValidationException e) {
            logger.log(Level.SEVERE, "The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ");
            return null;
        }
        return esysbundle;
    }

    @Override
    public boolean isPatchValid(Map map) throws PatchPackageException {
        HashComputeFunction trueFunc;
        String function;
        SystemPatchBundleXML esysbundle;
        assert (!map.isEmpty());
        Object[] bundleXMLArray = (Object[])map.get(ZipStringResource.BUNDLE);
        if (bundleXMLArray.length == 0) {
            logger.log(Level.FINE, "Bundle.xml was not found in the given patch zip file ");
            return false;
        }
        Object[] applyAutoArray = (Object[])map.get(ZipStringResource.APPLYAUTO);
        Object[] rollbackAutoArray = (Object[])map.get(ZipStringResource.ROLLBACKAUTO);
        ByteArrayInputStream bundleXML = new ByteArrayInputStream((byte[])bundleXMLArray[1]);
        byte[] applyAutomation = null;
        byte[] rollbackAutomation = null;
        String applyAutoEntry = null;
        String rollbackAutoEntry = null;
        if (applyAutoArray != null && applyAutoArray.length != 0) {
            applyAutomation = (byte[])applyAutoArray[1];
            applyAutoEntry = (String)applyAutoArray[0];
        }
        if (rollbackAutoArray != null && rollbackAutoArray.length != 0) {
            rollbackAutomation = (byte[])rollbackAutoArray[1];
            rollbackAutoEntry = (String)rollbackAutoArray[0];
        }
        HashMap<String, byte[]> metaMap = new HashMap<String, byte[]>();
        if (map.containsKey(ZipStringResource.INVENTORY)) {
            Map inventoryAutoMap = (Map)map.get(ZipStringResource.INVENTORY);
            for (Map.Entry invEntry : inventoryAutoMap.entrySet()) {
                metaMap.put((String)invEntry.getKey(), (byte[])invEntry.getValue());
            }
        }
        if (map.containsKey(ZipStringResource.ACTION)) {
            Map actionAutoMap = (Map)map.get(ZipStringResource.ACTION);
            for (Map.Entry actionEntry : actionAutoMap.entrySet()) {
                metaMap.put((String)actionEntry.getKey(), (byte[])actionEntry.getValue());
            }
        }
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            esysbundle = bhxml.readBundle((InputStream)bundleXML);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception was thrown while creating the bundleXml object from the bundleXml. ", e);
        }
        catch (BundleValidationException e) {
            logger.log(Level.SEVERE, "The given patch has bundle.xml but it could not be validated to be a Engineered System Patch bundleXml. ");
            return false;
        }
        fvalue fv = esysbundle.getFvalue();
        String hv = fv.getValue();
        if (hv == null) {
            hv = new String();
        }
        if ((function = fv.getFunction()).equals(2)) {
            if (applyAutoEntry != null) {
                metaMap.put(applyAutoEntry, applyAutomation);
            }
            if (rollbackAutoEntry != null) {
                metaMap.put(rollbackAutoEntry, rollbackAutomation);
            }
        }
        if ((trueFunc = hashFunctions.get(new Integer(function))) != null) {
            String valueComp = trueFunc.computeHash(metaMap);
            if (!valueComp.equals(hv)) {
                throw new PatchPackageException("Engineered System Patch may be modified. Please try the same patch from MOS");
            }
        } else {
            throw new PatchPackageException("Hash function of fvalue in the given patch zip file is not supported in current version.");
        }
        return true;
    }

    public StringBuffer getContentWithFilter(InputStream is, String filterWord, boolean newLine) throws IOException {
        Scanner sc = new Scanner(is);
        sc.useDelimiter("\n");
        StringWriter sw = new StringWriter();
        String line = null;
        String tempLine = null;
        while (sc.hasNext()) {
            if (tempLine != null) {
                sw.write(line);
                sw.write(10);
            }
            if (!(line = sc.next()).contains(filterWord)) {
                tempLine = line;
                continue;
            }
            tempLine = null;
        }
        if (tempLine != null) {
            sw.write(tempLine);
            if (newLine) {
                sw.write(10);
            }
        }
        sw.close();
        return sw.getBuffer();
    }

    @Override
    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        SystemPatchBundleXML esysbundle;
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The patch specified by the given location " + patchLocation + " is not a directory");
        }
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(File.separator);
        bundleXMLLoc.append("bundle.xml");
        File bxml = new File(bundleXMLLoc.toString());
        if (!bxml.exists()) {
            logger.log(Level.SEVERE, "Bundle.xml was not found at the given patch location " + patchLocation);
            throw new PatchPackageException("Bundle.xml was not found at the given patch location");
        }
        if (!bxml.isFile()) {
            logger.log(Level.SEVERE, "Bundle.xml was found but it is not a file.");
            throw new PatchPackageException("Bundle.xml was found at location " + bxml.getAbsolutePath() + " but it is not a file");
        }
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            esysbundle = bhxml.readBundle(bxml);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception was thrown while creating the bundleXml object from the bundleXml. ", e);
        }
        catch (BundleValidationException e) {
            logger.log(Level.INFO, "The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ");
            throw new PatchPackageException("The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ");
        }
        EngineeredSystemPatch patch = new EngineeredSystemPatch();
        patch.setPatchLocation(patchLocation);
        patch.setPatchID(esysbundle.getPatchID());
        patch.setBundleXmlLoc(bxml.getAbsolutePath());
        patch.setScripts(esysbundle.getScripts());
        try {
            patch.setBundleXml(this.getContent(new FileInputStream(bxml)).toString());
        }
        catch (IOException e) {
            throw new PatchPackageException("Couldn't get the string content of the bundle.xml");
        }
        patch.setPatchTool(this.getPatchTool());
        File automationXmlFolderLocation = new File(patchDir, AUTOMATION_XML);
        if (automationXmlFolderLocation.exists()) {
            if (!automationXmlFolderLocation.isDirectory()) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but is not a folder");
            }
            if (automationXmlFolderLocation.listFiles() == null || automationXmlFolderLocation.listFiles().length == 0) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but does not contain any automationXmls.");
            }
            patch.setAutomationXmlLocation(automationXmlFolderLocation.getAbsolutePath());
            ArrayList<String> automationXmls = new ArrayList<String>();
            for (File file : automationXmlFolderLocation.listFiles()) {
                if (!file.isFile()) continue;
                try {
                    if (RESOURCE_BUNDLE.equals(file.getName())) {
                        patch.setResourceBundle(this.getContent(new FileInputStream(file)).toString());
                        continue;
                    }
                    automationXmls.add(this.getContent(new FileInputStream(file)).toString());
                }
                catch (IOException e) {
                    throw new PatchPackageException("Couldn't read the file from automation folder", e);
                }
            }
            patch.setAutoXmls(automationXmls);
        } else {
            patch.setAutomationXmlLocation(null);
        }
        patch.setSubPatches(new ArrayList());
        return patch;
    }

    @Override
    public PatchPackage generate(Map map) throws PatchPackageException {
        SystemPatchBundleXML esysbundle;
        assert (!map.isEmpty());
        Object[] bundleXMLArray = (Object[])map.get(ZipStringResource.BUNDLE);
        if (bundleXMLArray.length == 0) {
            logger.log(Level.FINE, "Bundle.xml was not found in the given patch zip file");
            throw new PatchPackageException("Bundle.xml was not found in the given patch zip file");
        }
        byte[] bundleXML = (byte[])bundleXMLArray[1];
        ArrayList<byte[]> automationList = new ArrayList<byte[]>();
        Map autoStreamMap = (Map)map.get(ZipStringResource.AUTOS);
        if (autoStreamMap != null) {
            Iterator autoStreamIterator = autoStreamMap.values().iterator();
            while (autoStreamIterator.hasNext()) {
                automationList.add((byte[])autoStreamIterator.next());
            }
        }
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            esysbundle = bhxml.readBundle((InputStream)new ByteArrayInputStream(bundleXML));
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception was thrown while creating the bundleXml object from the bundleXml. ", e);
        }
        catch (BundleValidationException e) {
            logger.log(Level.INFO, "The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ");
            throw new PatchPackageException("The given patch has bundle.xml but it could not bevalidated to be a Engineered System Patch bundleXml. ");
        }
        EngineeredSystemPatch patch = new EngineeredSystemPatch();
        patch.setPatchLocation(null);
        patch.setPatchID(esysbundle.getPatchID());
        patch.setBundleXmlLoc((String)bundleXMLArray[0]);
        try {
            patch.setBundleXml(this.getContent(new ByteArrayInputStream(bundleXML)).toString());
        }
        catch (IOException e) {
            throw new PatchPackageException("Couldn't get the string content of the bundle.xml");
        }
        patch.setPatchTool(this.getPatchTool());
        patch.setScripts(esysbundle.getScripts());
        if (!automationList.isEmpty()) {
            ArrayList<String> automationXmls = new ArrayList<String>();
            for (byte[] automationXml : automationList) {
                try {
                    automationXmls.add(this.getContent(new ByteArrayInputStream(automationXml)).toString());
                }
                catch (IOException e) {
                    throw new PatchPackageException("Couldn't read the automationXmls", e);
                }
            }
            patch.setAutoXmls(automationXmls);
        }
        patch.setAutomationXmlLocation(null);
        Object[] messageXMLArray = (Object[])map.get(ZipStringResource.MESSAGE_PROPERTIES);
        if (messageXMLArray.length == 2) {
            byte[] message = (byte[])messageXMLArray[1];
            try {
                patch.setResourceBundle(this.getContent(new ByteArrayInputStream(message)).toString());
                logger.fine("resource bundle in osys s:\t" + patch.getResourceBundle());
            }
            catch (IOException e) {
                throw new PatchPackageException("Couldn't read the message.properties", e);
            }
        }
        patch.setSubPatches(new ArrayList());
        return patch;
    }

    @Override
    public String getPatchTool() {
        return "EsysPatch";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer();
    }

    public static boolean IsSubPatchCompositePatch(String subLocation) {
        File compositePatchDir = new File(subLocation);
        if (compositePatchDir.exists()) {
            for (File subPatch : compositePatchDir.listFiles()) {
                if (!subPatch.isDirectory()) continue;
                File subPatchinvxml = new File(subPatch, INVENTORY_XML);
                File compositeXml = new File(subPatch, COMPOSITE_XML);
                if (!subPatchinvxml.isFile() || !compositeXml.isFile()) continue;
                logger.info("There is a composite patch in " + subLocation);
                return true;
            }
        }
        return false;
    }

    static {
        hashFunctions.put(1, new InventoryAndActionOnly());
        hashFunctions.put(2, new IncludeAutomationXml());
        hashFunctions.put(3, new InventoryAndActionOnlyV2());
    }
}

