/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.helper.remote;

import com.oracle.cie.remote.SshRemoteConnectionHost;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import com.oracle.helper.remote.RemoteCommandExecutor;
import com.oracle.helper.remote.RemoteCommandHandler;
import com.oracle.helper.remote.RemoteCommandListener;
import com.oracle.helper.remote.RemoteCommandListenerObject;
import com.oracle.helper.remote.RemoteExecutionResult;
import com.oracle.helper.remote.RemoteHandlerListener;
import com.oracle.helper.remote.RemoteRequestParam;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class UserEquivalenceCommandHandler
implements RemoteCommandHandler {
    List<RemoteCommandListenerObject> listenerObjects = new ArrayList<RemoteCommandListenerObject>();
    private List<Thread> cmdExecutorHandlers = new ArrayList<Thread>();
    private RemoteHandlerListener remoteHandlerListener;
    private Logger logger = Logger.getLogger(UserEquivalenceCommandHandler.class.getName());
    private List<RemoteRequestParam> remoteRequestParams;
    private int threadCount = 0;

    public UserEquivalenceCommandHandler(List<RemoteRequestParam> remoteRequestParams, RemoteHandlerListener remoteHandlerListener) {
        this.remoteRequestParams = remoteRequestParams;
        this.remoteHandlerListener = remoteHandlerListener;
    }

    @Override
    public void executeCommand() {
        for (RemoteRequestParam remoteRequestParam : this.remoteRequestParams) {
            this.cmdExecutorHandlers.add(this.createExecutionThread(remoteRequestParam, false));
        }
        this.threadCount = this.cmdExecutorHandlers.size();
        this.startRemoteExecution();
    }

    public Thread createExecutionThread(RemoteRequestParam remoteRequestParam, boolean retry) {
        SshRemoteConnectionHost targetHost = this.createHostObj(remoteRequestParam.getHost(), retry);
        RemoteCommandExecutor remoteCmdExecutor = new RemoteCommandExecutor(remoteRequestParam.getRequestParams(), targetHost, new UserEquiCommandListener(), remoteRequestParam.isExitOnFailure());
        Thread thread = new Thread(remoteCmdExecutor);
        return thread;
    }

    private void startRemoteExecution() {
        for (Thread t : this.cmdExecutorHandlers) {
            t.start();
        }
        for (Thread t : this.cmdExecutorHandlers) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                this.logger.warning("InterruptedException: " + e.getMessage());
            }
        }
    }

    private SshRemoteConnectionHost createHostObj(String nodeName, boolean retry) {
        HostImpl hostImpl = new HostImpl();
        hostImpl.setHost(nodeName);
        hostImpl.setRemoteConnectionType("linuxclisshuserequivalence");
        return hostImpl;
    }

    private class UserEquiCommandListener
    implements RemoteCommandListener {
        private UserEquiCommandListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyResult(SshRemoteConnectionHost host, List<RemoteExecutionResult> remoteExecutionResults) {
            UserEquivalenceCommandHandler.this.logger.info("Received command execution result for host " + host);
            for (RemoteRequestParam remoteExecutionParam : UserEquivalenceCommandHandler.this.remoteRequestParams) {
                if (!host.getHost().equalsIgnoreCase(remoteExecutionParam.getHost())) continue;
                RemoteCommandListenerObject listenerObject = new RemoteCommandListenerObject();
                listenerObject.setHost(host.getHost());
                listenerObject.setRemoteExecutionResults(remoteExecutionResults);
                List<RemoteCommandListenerObject> list = UserEquivalenceCommandHandler.this.listenerObjects;
                synchronized (list) {
                    UserEquivalenceCommandHandler.this.listenerObjects.add(listenerObject);
                }
            }
            if (UserEquivalenceCommandHandler.this.listenerObjects.size() == UserEquivalenceCommandHandler.this.threadCount) {
                UserEquivalenceCommandHandler.this.logger.fine("Notifying request status.");
                UserEquivalenceCommandHandler.this.threadCount = 0;
                UserEquivalenceCommandHandler.this.remoteHandlerListener.notifyResult(UserEquivalenceCommandHandler.this.listenerObjects);
            }
        }
    }
}

