/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.automationselection;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.oplan.core.automationselection.AutomationSelection;
import oracle.oplan.core.oplan.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomationSetSelection {
    public List<URL> selectAutomationSetForPatches() {
        return Collections.emptyList();
    }

    public void addAutomationMap(HashMap<Automation, URL> auto_map, Automation auto, Operation operation, URL automationFile, File autoDir) {
        Logger logger = Logger.getLogger(AutomationSetSelection.class.getName());
        if (auto.getOperation().equals((Object)operation)) {
            logger.info("Selected automation:" + automationFile.toString());
            auto_map.put(auto, automationFile);
            this.saveSelectedAutomation(automationFile, autoDir);
        }
    }

    protected void saveSelectedAutomation(URL url, File autoDir) {
        Logger logger = Logger.getLogger(AutomationSelection.class.getName());
        File auto_file = new File(url.getPath());
        File autoCopy = new File(autoDir, auto_file.getName());
        try {
            IOUtils.copyStream(url.openStream(), new FileOutputStream(autoCopy));
        }
        catch (IOException e) {
            System.out.println("Unable to save selected automation file to " + autoCopy.getAbsolutePath());
            System.out.println(e.getMessage());
            logger.log(Level.CONFIG, "Automation Saving Error", e);
        }
    }
}

