/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.ui.tree;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class TextTreeGenerator {
    private int LINE_SPACING = 1;
    private String NODE_PREFIX = "+---";
    private int NODE_PREFIX_LEN = this.NODE_PREFIX.length();
    private char NODE_CHAR = this.NODE_PREFIX.charAt(0);
    private char VERTICAL = (char)124;
    private ArrayList<Pair> lines;
    private int longestLine = 0;
    private char MARKER = (char)35;
    private boolean indentRoot = true;
    private TreeNodeLabelResolver resolver = new TreeNodeLabelResolver(){};

    public static void main(String[] args) throws IOException {
        TextTreeGenerator tg = new TextTreeGenerator();
        tg.printTree(TextTreeGenerator.processHierarchy(), System.out);
    }

    public void setTreeNodeLabelResolver(TreeNodeLabelResolver resolver) {
        this.resolver = resolver;
    }

    public void printTree(DefaultMutableTreeNode tree, PrintStream out) throws IOException {
        out.print(this.getTreeText(tree));
    }

    public String getTreeText(DefaultMutableTreeNode tree) {
        this.processTree(tree);
        StringBuilder sb = new StringBuilder();
        for (Pair p : this.lines) {
            sb.append((CharSequence)p.sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static int getAllNodeCount(DefaultMutableTreeNode tree) {
        int count = 1;
        Enumeration<TreeNode> e = tree.children();
        while (e.hasMoreElements()) {
            count += TextTreeGenerator.getAllNodeCount((DefaultMutableTreeNode)e.nextElement());
        }
        return count;
    }

    private void processTree(DefaultMutableTreeNode tree) {
        this.lines = new ArrayList();
        this.createBasicTreeLayout(tree, 0, 0);
        this.fillVerticals();
        this.fillLabels();
    }

    private void createBasicTreeLayout(DefaultMutableTreeNode tree, int level, int parentLen) {
        if (tree == null) {
            return;
        }
        String prefix = tree.isRoot() && !this.indentRoot ? "" : this.sps(level * this.NODE_PREFIX_LEN) + this.NODE_PREFIX;
        String line = prefix + this.MARKER;
        int len = line.length();
        this.lines.add(new Pair(new StringBuilder(line), tree));
        for (int i = 0; i < this.LINE_SPACING; ++i) {
            this.lines.add(new Pair(new StringBuilder(this.sps(len))));
        }
        if (this.longestLine < len) {
            this.longestLine = len;
        }
        int childrenLevel = tree.isRoot() && !this.indentRoot ? 0 : level + 1;
        Enumeration<TreeNode> e = tree.children();
        while (e.hasMoreElements()) {
            this.createBasicTreeLayout((DefaultMutableTreeNode)e.nextElement(), childrenLevel, len);
        }
    }

    private void fillVerticals() {
        for (int column = 0; column <= this.longestLine; column += this.NODE_PREFIX_LEN) {
            boolean begin = false;
            int start = 0;
            for (int row = 0; row < this.lines.size(); ++row) {
                char cur;
                if (!begin) {
                    if (column > this.lines.get((int)row).sb.length() || (cur = this.lines.get((int)row).sb.charAt(column)) != this.MARKER && cur != this.NODE_CHAR) continue;
                    begin = true;
                    start = row + 1;
                    continue;
                }
                if (column > this.lines.get((int)row).sb.length()) continue;
                cur = this.lines.get((int)row).sb.charAt(column);
                if (cur == this.NODE_CHAR) {
                    int end = row;
                    for (int i = start; i < end; ++i) {
                        this.lines.get((int)i).sb.replace(column, column + 1, "" + this.VERTICAL);
                    }
                    start = row + 1;
                    continue;
                }
                if (cur == this.MARKER || cur == this.NODE_CHAR) {
                    start = row + 1;
                    continue;
                }
                if (cur == ' ') continue;
                begin = false;
            }
        }
    }

    private void fillLabels() {
        for (Pair p : this.lines) {
            if (p.node == null) continue;
            p.sb.deleteCharAt(p.sb.length() - 1);
            p.sb.append(this.resolver.getLabel(p.node));
        }
    }

    private String sps(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static DefaultMutableTreeNode processHierarchy() {
        Object[] hierarchy = new Object[]{"javax.swing", "javax.swing.border", "javax.swing.colorchooser", "javax.swing.event", "javax.swing.filechooser", new Object[]{"javax.swing.plaf", "javax.swing.plaf.basic", "javax.swing.plaf.metal", "javax.swing.plaf.multi"}, "javax.swing.table", new Object[]{"javax.swing.text", new Object[]{"javax.swing.text.html", new Object[]{"javax.swing.text.html", new Object[]{"javax.swing.text.html", new Object[]{"javax.swing.text.html", "javax.swing.text.html.parser"}, "javax.swing.text.html.parser"}, "javax.swing.text.html.parser"}, "javax.swing.text.html.parser"}, "javax.swing.text.rtf"}, "javax.swing.tree", "javax.swing.undo"};
        return TextTreeGenerator.processHierarchy(hierarchy);
    }

    private static DefaultMutableTreeNode processHierarchy(Object[] hierarchy) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(hierarchy[0]);
        for (int i = 1; i < hierarchy.length; ++i) {
            Object nodeSpecifier = hierarchy[i];
            DefaultMutableTreeNode child = nodeSpecifier instanceof Object[] ? TextTreeGenerator.processHierarchy((Object[])nodeSpecifier) : new DefaultMutableTreeNode(nodeSpecifier);
            node.add(child);
        }
        return node;
    }

    private class Pair {
        public StringBuilder sb;
        public DefaultMutableTreeNode node;

        public Pair(StringBuilder sb, DefaultMutableTreeNode node) {
            this.sb = sb;
            this.node = node;
        }

        public Pair(StringBuilder sb) {
            this.sb = sb;
            this.node = null;
        }
    }

    public static abstract class TreeNodeLabelResolver {
        public String getLabel(DefaultMutableTreeNode node) {
            return node.getUserObject().toString();
        }
    }
}

