/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.readme;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.db_crs.RACDatabase;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.opatch.system.automation.jaxb.ServiceStatus;
import oracle.oplan.core.readme.ReadmeDecorator;
import oracle.oplan.core.readme.ReadmeGeneratorBase;
import oracle.oplan.core.ui.tree.ConfigTreeImageGenerator;
import oracle.oplan.sdk.exec.api.ExecutionPhase;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.exec.api.ExeuctionPlanUtil;
import oracle.oplan.sdk.exec.api.GroupByHost;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.readme.ReadmeFactory;
import oracle.oplan.sdk.resource.OPlanBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlReadmeGenerator
extends ReadmeGeneratorBase {
    private static final Class c;
    Logger logger = Logger.getLogger(HtmlReadmeGenerator.class.getName());
    protected static final String BC = "<blockquote class='style=margin: 0 0 0 0px;'>";
    protected static final String BC_E = "</blockquote>";
    public static final String HL = "<b><i>";
    public static final String HL_E = "</i></b>";
    private static char[] map1;
    String appendixaPatchReadmeID = "appendixareadme" + this.rf.hashCode();

    public HtmlReadmeGenerator(ReadmeFactory rf) {
        super(rf);
        this.setDecoratorContext(new ReadmeDecorator.HTMLReadmeDecorator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> generateReadme() throws IOException {
        ArrayList<File> readmeList = new ArrayList<File>();
        List<Set<String>> splitHostList = this.rf.getSplitHostList();
        for (int i = 0; i < splitHostList.size(); ++i) {
            Set<String> filterHosts = splitHostList.get(i);
            this.setCurrentFilterHosts(filterHosts);
            File readme = null;
            readme = this.rf.isSplit() ? this.getReadmeFile(i + 1) : this.getReadmeFile();
            assert (!readme.isFile());
            this.generateConfigImageFile();
            FileWriter fw = new FileWriter(readme);
            try {
                ExecutionPlan singleEP = this.rf.getSingleExecutionPlan();
                fw.write("<html>\n");
                this.writeTitleBarTitle(fw, singleEP);
                fw.write("<body>\n");
                this.writeCSS(fw);
                this.writeJS(fw);
                this.writeProductName(fw);
                this.writeTitle(fw, singleEP);
                this.writeStatMessage(fw, singleEP);
                this.writeConfigImage(fw, singleEP);
                this.writeButton(fw, singleEP);
                this.writePlanBlurb(fw, singleEP, false, false);
                this.writePlanNote(fw, singleEP);
                this.writeTOC(fw, singleEP);
                this.writeBody(fw, singleEP);
                fw.write("</span>");
                this.writeCopyRight(fw);
                fw.write("</body>\n");
                fw.write("</html>\n");
            }
            finally {
                fw.close();
            }
            readmeList.add(readme);
        }
        return readmeList;
    }

    protected void writeButton(FileWriter fw, ExecutionPlan plan) throws IOException {
        String prefixHeader = this.rf.getBundleMessagePrefix(plan);
        String titleMesgHeader = OPlanBundle.getPrefixedReadmeMessage(prefixHeader, "TITLE", "", "");
        fw.write("<hr/>");
        String hideShowID = this.makeId("hideShow", plan);
        String buttonID = this.makeId("button", plan);
        fw.write("<h2 id='" + this.makeId(titleMesgHeader, plan) + "'>");
        fw.write(titleMesgHeader);
        fw.write("<input type='button' id='" + buttonID + "' class=\"buttonposition\" onclick=\"toggleDiv('" + hideShowID + "','" + buttonID + "')\" value='Hide Steps'/>");
        fw.write("</h2>");
        fw.write("<script>");
        fw.write("callOnLoad('" + hideShowID + "','" + buttonID + "')");
        fw.write("</script>");
        fw.write("<span id='" + hideShowID + "' class=\"fullPlanSpan\">");
    }

    protected void writePlanBlurb(FileWriter fw, ExecutionPlan plan, boolean writeTitle, boolean writeDetailedLink) throws IOException {
        if (plan.getAutomation().getOperation().equals((Object)Operation.SWITCHBACK)) {
            this.writeSwitchbackBlurb(fw, plan, writeTitle || writeDetailedLink);
            return;
        }
        String prefix = this.rf.getBundleMessagePrefix(plan);
        String title = OPlanBundle.getPrefixedReadmeMessage(prefix, "TITLE", "", "");
        String id = this.makeId(title, plan);
        String hideShowID = this.makeId("hideShow", plan);
        String buttonID = this.makeId("button", plan);
        String onclick = "onclick=\"showDiv('" + hideShowID + "','" + buttonID + "')\"";
        String link = "<a " + onclick + " href=\"#" + id + "\">" + title + "</a>";
        if (writeTitle) {
            fw.write("<span  class='blurbTitle'>");
            fw.write(link + ":");
            fw.write("</span>");
            fw.write("<span class='blurbMessage'>");
            fw.write(OPlanBundle.getPrefixedReadmeMessage(prefix, "MESSAGE", "<b>", "</b>"));
            fw.write("</span>");
        }
        fw.write("<ul>");
        fw.write("<li>");
        fw.write(OPlanBundle.getPrefixedReadmeMessage(prefix, "THIS_STRATEGY_IS_OPT_FOR", "<b>", "</b>"));
        fw.write(OPlanBundle.getPrefixedReadmeMessage(prefix, "OPT", "<b>", "</b>"));
        fw.write("</li>");
        fw.write("<li>");
        fw.write(OPlanBundle.getPrefixedReadmeMessage(prefix, "THIS_STRATEGY_IS_NOT_OPT_FOR", "<b>", "</b>"));
        fw.write(OPlanBundle.getPrefixedReadmeMessage(prefix, "NOPT", "<b>", "</b>"));
        fw.write("</li>");
        this.writePlanStats(fw, plan);
        fw.write("</ul>");
        if (writeDetailedLink) {
            fw.write("<span class='blurbMessage'>");
            fw.write(OPlanBundle.getReadmeMessage("CLICK_HERE_FOR_DETAILED", link));
            fw.write("</span>");
            fw.write("<br/><br/>");
        }
    }

    protected void writeSwitchbackBlurb(FileWriter fw, ExecutionPlan plan, boolean writeblurb) throws IOException {
        if (!writeblurb) {
            return;
        }
        String prefix = this.rf.getBundleMessagePrefix(plan);
        String title = OPlanBundle.getPrefixedReadmeMessage(prefix, "TITLE", "", "");
        String id = this.makeId(title, plan);
        String hideShowID = this.makeId("hideShow", plan);
        String buttonID = this.makeId("button", plan);
        String onclick = "onclick=\"showDiv('" + hideShowID + "','" + buttonID + "')\"";
        String link = "<a " + onclick + " href=\"#" + id + "\">" + title + "</a>";
        fw.write("<span class='blurbMessage'>");
        fw.write(OPlanBundle.getPrefixedReadmeMessage(prefix, "MESSAGE", new Object[0]));
        fw.write("</span>");
        fw.write("<br/>");
        fw.write("<span class='blurbMessage'>");
        fw.write(OPlanBundle.getReadmeMessage("CLICK_HERE_FOR_DETAILED", link));
        fw.write("</span>");
        fw.write("<br/><br/>");
    }

    protected void writePlanNote(FileWriter fw, ExecutionPlan plan) throws IOException {
        String prefix = this.rf.getBundleMessagePrefix(plan);
        String global = OPlanBundle.getReadmeMessage("GLOBAL_PLAN_NOTE", "<li>", "</li>", "<b>", "</b>");
        String local = OPlanBundle.getPrefixedMessageNE(c, prefix, "PLAN_NOTE", "<li>", "</li>", HL, HL_E);
        boolean writeSwitchbackNote = false;
        ExecutionPlan sbplan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.switchbacks(this.rf.getPlans()));
        if (DeploymentType.OUT_OF_PLACE.equals((Object)plan.getAutomation().getDeploymentType()) && Operation.APPLY.equals((Object)plan.getAutomation().getOperation()) && sbplan != null) {
            writeSwitchbackNote = true;
            local = null;
        }
        if (global != null || local != null || writeSwitchbackNote) {
            fw.write("<p>");
            fw.write("<b>");
            fw.write(OPlanBundle.getReadmeMessage("IMPORTANT_NOTE", new Object[0]));
            fw.write("</b>");
            fw.write("<ul>");
            if (global != null) {
                fw.write(global);
            }
            if (local != null) {
                fw.write(local);
            }
            if (writeSwitchbackNote) {
                String str = OPlanBundle.getPrefixedMessageNE(c, prefix, "OplaceApplyRolling-SWITCHBACK-PLAN_NOTE", "<li>", "</li>", HL, HL_E);
                fw.write(str);
                fw.write("<li>");
                this.writeSwitchbackBlurb(fw, sbplan, true);
                fw.write("</li>");
            }
            fw.write("</ul>");
            fw.write("</p>");
        }
    }

    protected void writePlanStats(FileWriter fw, ExecutionPlan plan) throws IOException {
        List<String> strs = this.rf.getStepsStats(plan, HL, HL_E);
        assert (strs.size() > 1);
        fw.write("<li>");
        fw.write(strs.get(0));
        fw.write("</li>");
        fw.write("<ul>");
        for (int i = 1; i < strs.size(); ++i) {
            fw.write("<li>");
            fw.write(strs.get(i));
            fw.write("</li>");
        }
        fw.write("</ul>");
    }

    protected void generateConfigImageFile() {
        this.logger.finest("Starting: generate config tree image.");
        try {
            ConfigTreeImageGenerator.createImage(this.rf.getConfigTree(), this.getConfigImageFile());
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Could not create image file for configuration tree", e);
        }
        this.logger.finest("End: generate config tree image.");
    }

    protected File getConfigImageFile() {
        return OPlan.getInstance().getLogInfo().getConfigImageFile();
    }

    @Override
    protected File getReadmeFile() {
        return OPlan.getInstance().getLogInfo().getReadmeHtml();
    }

    protected File getReadmeFile(int index) {
        return OPlan.getInstance().getLogInfo().getReadmeHtml(index);
    }

    protected File getLogDir() {
        return OPlan.getInstance().getLogInfo().getLogDir();
    }

    protected void writeTitleBarTitle(FileWriter fw, ExecutionPlan plan) throws IOException {
        OPlanEnv env = this.getOplanEnv();
        fw.write("<title>");
        fw.write(OPlanBundle.getPrefixedReadmeMessage(ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "README_TITLE", env.getPatchesBag().getPatchesListAsString(), this.getTargetName(plan)));
        fw.write("</title>");
    }

    protected void writeTitle(FileWriter fw, ExecutionPlan plan) throws IOException {
        DateFormat date = DateFormat.getDateTimeInstance(0, 0);
        String created = date.format(new Date(System.currentTimeMillis()));
        fw.write("<h1>");
        OPlanEnv env = this.getOplanEnv();
        fw.write(OPlanBundle.getPrefixedReadmeMessage(ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "README_TITLE", this.bi(env.getPatchesBag().getPatchesListAsString()), this.bi(this.getTargetName(plan)) + "\n"));
        fw.write("</h1>");
        fw.write("<p>");
        fw.write(OPlanBundle.getReadmeMessage("README_GEN_STATS", this.bi(created), this.bi(System.getProperty("user.name")), this.bi(env.getLocalHost()), this.bi(env.getOperation().value()), this.bi(env.getOPlanVersion())) + "\n");
        fw.write("</p>");
    }

    protected void writeStatMessage(FileWriter fw, ExecutionPlan plan) throws IOException {
        fw.write("<p>");
        fw.write(OPlanBundle.getReadmeMessage("README_CONTENT_STATS", this.bi("" + this.rf.getSystemInstanceEntityCount()), this.bi(this.getTargetName(plan)), "\n"));
        fw.write("</p>");
    }

    protected void writeTOC(FileWriter fw, ExecutionPlan plan) throws IOException {
        String prefix = this.rf.getBundleMessagePrefix(plan);
        String operationBundleKey = ReadmeFactory.getOperationBundlePropertySuffixKey(plan);
        String titleMesg = OPlanBundle.getPrefixedReadmeMessage(prefix, "PATCH_" + operationBundleKey + "_SUMMARY_HEADER", new Object[0]);
        int phaseNo = 1;
        Set<String> filterHosts = this.getCurrentFilterHosts();
        fw.write("<span>");
        fw.write("<h3 id='" + this.makeId(titleMesg, plan) + "'>");
        fw.write(titleMesg);
        fw.write("</h3>");
        fw.write("<ul>");
        this.rf.changeHostOfPostPhase(plan);
        boolean hasContext = false;
        for (ExecutionPhase phase : plan.getExecutionPhase()) {
            GroupByHost gbh = GroupByHost.getInstance(phase, filterHosts);
            if (gbh.getHostGrouping().size() == 0) continue;
            hasContext = true;
            fw.write("<li class='noStyle'>");
            String phaseName = this.getPhaseTitle(phase);
            String downtime = this.getDowntime(phase);
            String str1 = this.STEP + phaseNo + ": " + phaseName;
            String conv1 = "#" + this.makeId(str1, plan);
            fw.write("<b>");
            fw.write("<a href='" + conv1 + "' >");
            fw.write(str1 + downtime);
            fw.write("</a>");
            fw.write("</b>");
            fw.write("</li>");
            if (gbh.isWorthGrouping()) {
                int group = 1;
                for (GroupByHost.HostGroup host : gbh.getHostGrouping()) {
                    fw.write("<ul>");
                    String hostName = host.getHost() == null ? "$HOST_NAME" : host.getHost().getDisplayName();
                    String str2 = this.STEP + phaseNo + "." + group + ": " + phaseName + " on " + this.bi(hostName);
                    String conv2 = "#" + this.makeId(str2, plan);
                    fw.write("<li class='noStyle'>");
                    fw.write("<a href='" + conv2 + "' >");
                    fw.write(str2);
                    fw.write("</a>");
                    fw.write("</li>");
                    this.writeTOCTitleMessages(fw, host.getExecSteps(), this.STEP + phaseNo + "." + group, plan);
                    fw.write("</ul>");
                    ++group;
                }
            } else {
                this.writeTOCTitleMessages(fw, phase.getExecutionStep(), this.STEP + phaseNo, plan);
            }
            ++phaseNo;
        }
        if (!hasContext) {
            fw.write("Nothing to do on this host");
        }
        fw.write("</ul>");
        fw.write("</span>");
    }

    protected void writeTOCTitleMessages(FileWriter fw, List<ExecutionStep> steps, String stepPrefix, ExecutionPlan plan) throws IOException {
        int stepNo = 1;
        fw.write("<ul>");
        for (ExecutionStep step : steps) {
            fw.write("<li class='circles'>");
            String str2 = stepPrefix + "." + stepNo + ": " + this.getTitle(step);
            String conv2 = "#" + this.makeId(str2, plan);
            fw.write("<a href='" + conv2 + "' >");
            fw.write(str2);
            fw.write("</a>");
            ++stepNo;
            fw.write("</li>");
        }
        fw.write("</ul>");
        fw.write("<br/>");
    }

    protected String bi(String str) {
        return HL + str + HL_E;
    }

    protected void writeConfigImage(FileWriter fw, ExecutionPlan plan) throws IOException {
        String str = OPlanBundle.getReadmeMessage("CONFIG_IMAGE_HEADER", new Object[0]);
        fw.write("<h2 id='" + this.makeId(str, plan) + "' >");
        fw.write(str);
        fw.write("</h2>");
        fw.write("<p>");
        String link = ".";
        if (this.rf.getPatchReadme() != null) {
            link = "<a href='#" + this.appendixaPatchReadmeID + "'>" + OPlanBundle.getReadmeMessage("APPENDIX_A_PATCH_README", new Object[0]) + "</a>";
            link = " located at " + link + ".";
        }
        fw.write(this.conv_nl(OPlanBundle.getReadmeMessage("CONFIG_IMAGE_DESCRIPTION", "<b>", "</b>", link, "<b>", "</b>")));
        fw.write("</p>");
        this.writeStatMessage(fw, plan);
        String altText = OPlanBundle.getReadmeMessage("CONFIG_IMAGE_ALT_TEXT", OPlan.getInstance().getOPlanEnv().getLocalHost(), this.getConfigImageFile().getAbsolutePath());
        String data = this.encodeImageFileBase64(this.getConfigImageFile(), false);
        fw.write("<img src='data:image/png;base64," + data + "' alt='" + altText + "' />");
        this.writeWarningMessage(fw);
        fw.write("<hr/>");
    }

    protected void writeBody(FileWriter fw, ExecutionPlan plan) throws IOException {
        String operationBundleKey = ReadmeFactory.getOperationBundlePropertySuffixKey(plan);
        fw.write("<br/><br/>");
        fw.write("<h3>");
        fw.write(OPlanBundle.getPrefixedReadmeMessage(this.rf.getBundleMessagePrefix(plan), "DETAILED_" + operationBundleKey + "_STEPS_HEADER", new Object[0]));
        fw.write("<hr/>");
        fw.write("</h3>");
        fw.write("<br/>");
        int phaseNo = 1;
        Set<String> filterHosts = this.getCurrentFilterHosts();
        this.rf.changeHostOfPostPhase(plan);
        boolean hasContext = false;
        for (ExecutionPhase phase : plan.getExecutionPhase()) {
            GroupByHost gbh = GroupByHost.getInstance(phase, filterHosts);
            if (gbh.getHostGrouping().size() != 0) {
                hasContext = true;
                String phaseName = this.getPhaseTitle(phase);
                String downtime = this.getDowntime(phase);
                fw.write("<div><blockquote class='style=margin: 0 0 0 0px;'>");
                String str1 = this.STEP + phaseNo + ": " + phaseName;
                String conv1 = this.makeId(str1, plan);
                fw.write("<h4 id='" + conv1 + "'>");
                fw.write(str1 + downtime);
                fw.write("<hr/>");
                fw.write("</h4>");
                if (gbh.isWorthGrouping()) {
                    int group = 1;
                    for (GroupByHost.HostGroup host : gbh.getHostGrouping()) {
                        fw.write(BC);
                        String hostName = host.getHost() == null ? "$HOST_NAME" : host.getHost().getDisplayName();
                        String str2 = this.STEP + phaseNo + "." + group + ": " + phaseName + " on " + this.bi(hostName);
                        String conv2 = this.makeId(str2, plan);
                        fw.write("<h5 id='" + conv2 + "' >");
                        fw.write(str2);
                        fw.write("<hr/>");
                        fw.write("</h5>");
                        fw.write(BC);
                        this.writeMessageBody(fw, host.getExecSteps(), this.STEP + phaseNo + "." + group, plan);
                        fw.write(BC_E);
                        fw.write(BC_E);
                        ++group;
                    }
                } else {
                    this.writeMessageBody(fw, phase.getExecutionStep(), this.STEP + phaseNo, plan);
                }
                ++phaseNo;
            }
            fw.write("</blockquote></div>");
        }
        if (!hasContext) {
            fw.write("<ul>");
            fw.write("Nothing to do on this host");
            fw.write("</ul>");
        }
    }

    protected void writeMessageBody(FileWriter fw, List<ExecutionStep> steps, String stepPrefix, ExecutionPlan plan) throws IOException {
        int stepNo = 1;
        for (ExecutionStep step : steps) {
            String ts;
            List<ExecutionStep.Command> shellCommands;
            String str2 = stepPrefix + "." + stepNo + ": " + this.getTitle(step);
            String conv2 = this.makeId(str2, plan);
            fw.write("<div><blockquote class='style=margin: 0 0 0 0px;'>");
            fw.write("<h5 id='" + conv2 + "'>");
            fw.write(str2);
            fw.write("</h5>");
            fw.write("<p>");
            fw.write(BC);
            if (this.getMessage(step) != null) {
                fw.write(this.conv_nl(this.getMessage(step)) + "<br/>\n");
            }
            if ((shellCommands = step.getCommand()) != null) {
                String userName = "";
                if (step.getUser() != null && step.getUser().getValue() != null) {
                    userName = step.getUser().getValue();
                }
                String prefix = shellCommands.size() > 1 ? "COMMANDS_USER_HOST_INFO" : "COMMAND_USER_HOST_INFO";
                prefix = OPlanBundle.getReadmeMessage(prefix, userName, step.getHost().getDisplayName(), "<font class='importantText'><b><i>", "</i></b></font>");
                boolean haveWritten = false;
                for (ExecutionStep.Command cmd : shellCommands) {
                    if (cmd == null || cmd.getValue() == null || cmd.getValue().trim().equals("")) continue;
                    if (!haveWritten) {
                        fw.write("<br/>");
                        fw.write(prefix);
                        fw.write("<br/>");
                        haveWritten = true;
                    }
                    fw.write("<br/>");
                    if (cmd.getType().isNonShellPrompt()) {
                        fw.write(cmd.getType().getPrompt(step) + " ");
                    } else {
                        fw.write("[" + userName + "@" + step.getHost().getDisplayName() + "]" + cmd.getType().getPrompt(step) + " ");
                    }
                    fw.write("<br/>");
                    fw.write("<div class='codeblock'>");
                    fw.write("<code>");
                    fw.write(cmd.getValue());
                    fw.write("</code>");
                    fw.write("</div>");
                    String error = this.getCommandErrorMessage(cmd, step);
                    if (error == null) continue;
                    fw.write("<p>");
                    fw.write(this.conv_nl(error));
                    fw.write("</p>");
                }
            }
            if ((ts = this.getTroubleshoot(step)) != null && ts != "") {
                fw.write("<br/>");
                fw.write("<b>" + this.TROUBLE + "</b>" + ": " + ts + "<br/>\n<br/>\n");
            }
            ++stepNo;
            fw.write(BC_E);
            fw.write("</p>");
            fw.write("</blockquote></div>");
            fw.write("<hr/>");
        }
    }

    protected String conv_nl(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\n", "<br/>");
    }

    protected String makeId(String str, ExecutionPlan plan) {
        String prefix = "" + plan.hashCode();
        if (str == null) {
            return null;
        }
        return prefix + str.replaceAll(" ", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCSS(FileWriter fw) throws IOException {
        BufferedReader is = new BufferedReader(new InputStreamReader(HtmlReadmeGenerator.class.getClassLoader().getResourceAsStream("oracle/oplan/core/readme/readme.css")));
        fw.write("<style>");
        String line = null;
        try {
            while ((line = is.readLine()) != null) {
                fw.write(line + "\n");
            }
        }
        finally {
            is.close();
        }
        fw.write("</style>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJS(FileWriter fw) throws IOException {
        BufferedReader is = new BufferedReader(new InputStreamReader(HtmlReadmeGenerator.class.getClassLoader().getResourceAsStream("oracle/oplan/core/readme/readme.js")));
        fw.write("<script type=\"text/javascript\">");
        fw.write("<!--\n");
        String line = null;
        try {
            while ((line = is.readLine()) != null) {
                fw.write(line + "\n");
            }
        }
        finally {
            is.close();
        }
        fw.write("//-->\n");
        fw.write("</script>");
    }

    protected void writeCopyRight(FileWriter fw) throws IOException {
        fw.write("<br/>");
        fw.write("<hr/>");
        fw.write("<p class='ora_copyright'>");
        fw.write(OPlanBundle.getReadmeMessage("COPY_RIGHT_MESSAGE_HTML", new Object[0]));
        fw.write("</p>");
    }

    protected void writeProductName(FileWriter fw) throws IOException {
        String prod = OPlanBundle.getReadmeMessage("PRODUCT_NAME", new Object[0]);
        this.writeProductImage(fw);
        fw.write("<span class='heading'>");
        fw.write(prod);
        fw.write("</span>");
    }

    protected void writeProductImage(FileWriter fw) throws IOException {
        File imgFile = new File(this.getLogDir(), "oracle_product_logo.png");
        String data = this.encodeImageFileBase64(imgFile, true);
        fw.write("<img class='oraimage' src='data:image/png;base64," + data + "' />");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encodeImageFileBase64(File file, boolean logo) throws IOException {
        InputStream is = null;
        int paddingPosition = -1;
        String toRemove = "";
        is = logo ? HtmlReadmeGenerator.class.getClassLoader().getResourceAsStream(this.rf.getProductImage()) : new FileInputStream(file);
        StringBuilder data = new StringBuilder();
        if (is != null) {
            try {
                int len;
                byte[] buff = new byte[1023];
                while ((len = is.read(buff)) != -1) {
                    data.append(HtmlReadmeGenerator.encode(buff, len));
                }
            }
            finally {
                is.close();
            }
        } else {
            System.out.println("inputstream is null");
        }
        paddingPosition = data.lastIndexOf("=");
        toRemove = "";
        if (paddingPosition > 0) {
            toRemove = data.substring(paddingPosition, data.length()).replaceAll("=", "");
        }
        return data.toString().replace(toRemove, "");
    }

    private static char[] encode(byte[] buffer, int length) {
        int dataLength = length / 3 * 4;
        int dataLengthWithPadding = (length + 2) / 3 * 4;
        char[] output = new char[dataLengthWithPadding];
        int index = 0;
        int index2 = 0;
        while (index < length) {
            int b0 = buffer[index++] & 0xFF;
            int b1 = index < length ? buffer[index++] & 0xFF : 0;
            int b2 = index < length ? buffer[index++] & 0xFF : 0;
            int group0 = b0 >>> 2;
            int group1 = (b0 & 3) << 4 | b1 >>> 4;
            int group2 = (b1 & 0xF) << 2 | b2 >>> 6;
            int group3 = b2 & 0x3F;
            output[index2++] = map1[group0];
            output[index2++] = map1[group1];
            output[index2] = index2 < dataLength ? map1[group2] : 61;
            int n = ++index2 < dataLength ? map1[group3] : 61;
            output[index2] = n;
            ++index2;
        }
        return output;
    }

    protected String getDowntime(ExecutionPhase phase) {
        String res = "<font color='";
        String downtime = this.rf.getDowntime(phase);
        if (phase.getServiceStatus().equals((Object)ServiceStatus.DOWN)) {
            res = res + "red";
        }
        if (phase.getServiceStatus().equals((Object)ServiceStatus.UP)) {
            res = res + "green";
        }
        if (phase.getServiceStatus().equals((Object)ServiceStatus.LIMITED)) {
            res = res + "orange";
        }
        res = res + "'> (" + downtime + ")" + "</font>";
        return res;
    }

    protected void writeTraditionalReadmeBody(FileWriter fw) throws IOException {
        File pr = this.rf.getPatchReadme();
        if (pr == null) {
            return;
        }
        fw.write("<hr/>");
        String hideShowID = "hideShow-appendix-a-readme" + this.rf.hashCode();
        String buttonID = "button-appendix-a-readme" + this.rf.hashCode();
        fw.write("<h2 id='" + this.appendixaPatchReadmeID + "'>");
        fw.write(OPlanBundle.getReadmeMessage("APPENDIX_A_PATCH_README", new Object[0]));
        fw.write("<input type='button' id='" + buttonID + "' class=\"buttonposition\" onclick=\"toggleAppendixDiv('" + hideShowID + "','" + buttonID + "')\" value='Hide Content'/>");
        fw.write("</h2>");
        fw.write("<script>");
        fw.write("appendixDivID =\"" + hideShowID + "\";");
        fw.write("appendixButtonID =\"" + buttonID + "\";");
        fw.write("</script>");
        fw.write("<span id='" + hideShowID + "' class=\"fullPlanSpan\">");
        String patchReadmeNotice = OPlanBundle.getReadmeMessage("LOCATION_MESSAGE_FOR_PATCH_README", OPlan.getInstance().getOPlanEnv().getLocalHost(), pr.getAbsolutePath());
        fw.write("<p>");
        fw.write(patchReadmeNotice);
        fw.write("</p>");
        fw.write("<iframe src='" + pr.getName() + "' height='100%' width='100%'> </iframe>");
        fw.write("</span>");
    }

    protected void writeTraditionalReadmeNotice(FileWriter fw) throws IOException {
        fw.write("<p>");
        if (this.rf.getPatchReadme() != null) {
            String link = "<a href='#" + this.appendixaPatchReadmeID + "'>" + OPlanBundle.getReadmeMessage("APPENDIX_A_PATCH_README", new Object[0]) + "</a>";
            fw.write(OPlanBundle.getReadmeMessage("REFER_TO_PATCH_README", link, "<b>", "</b>"));
        } else {
            fw.write(OPlanBundle.getReadmeMessage("REFER_TO_PATCH_README", "patch README ", "<b>", "</b>"));
        }
        fw.write("</p>");
    }

    private void writeWarningMessage(FileWriter fw) throws IOException {
        fw.write("<p>");
        if (OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class) != null && OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class).size() > 0) {
            List<String> skipedRacs = OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class);
            StringBuffer skipedRacStr = null;
            for (String skipedRac : skipedRacs) {
                if (skipedRacStr == null) {
                    skipedRacStr = new StringBuffer(skipedRac);
                    continue;
                }
                skipedRacStr.append("," + skipedRac);
            }
            fw.write(OPlanBundle.getReadmeMessage("SKIP_TARGET_WARNING", "RAC Database " + skipedRacStr.toString(), "Oracle Cluster", "<b>", "</b>"));
        }
        fw.write("</p>");
    }

    static {
        int c;
        HtmlReadmeGenerator.c = HtmlReadmeGenerator.class;
        map1 = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            HtmlReadmeGenerator.map1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            HtmlReadmeGenerator.map1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            HtmlReadmeGenerator.map1[i++] = c;
        }
        HtmlReadmeGenerator.map1[i++] = 43;
        HtmlReadmeGenerator.map1[i++] = 47;
    }
}

