/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.patch;

import java.util.ArrayList;
import java.util.List;
import model.patchmodel.PatchingTool;
import oracle.oplan.core.patch.CompositePatchValidatorAndGenerator;
import oracle.oplan.core.patch.DefaultPatchValidatorAndGenerator;
import oracle.oplan.core.patch.ExapatchPatchValidatorAndGenerator;
import oracle.oplan.core.patch.OPatchBundlePatchValidatorAndGenerator;
import oracle.oplan.core.patch.OPatchSingletonPatchValidatorAndGenerator;
import oracle.osysmodel.patchsdk.PatchPackageException;
import oracle.osysmodel.patchsdk.PatchValidatorAndGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportedPatchTools {
    private static List<PatchingTool> oplanRecognizedPatchingTools = new ArrayList<PatchingTool>();
    private static List<PatchValidatorAndGenerator> supportedPatchValidatorsAndGenerators = new ArrayList<PatchValidatorAndGenerator>();
    private static List<PatchValidatorAndGenerator> supportedBundlePatchGenericPatchValidatorsAndGenerators = new ArrayList<PatchValidatorAndGenerator>();

    public static List<PatchValidatorAndGenerator> getSupportedPatchValidatorsAndGenerators() {
        return supportedPatchValidatorsAndGenerators;
    }

    public static List<PatchValidatorAndGenerator> getSupportedBundlePatchGenericPatchValidatorAndGenerators() {
        return supportedBundlePatchGenericPatchValidatorsAndGenerators;
    }

    public static List<PatchingTool> getOplanRecognizedPatchingTools() throws PatchPackageException {
        if (oplanRecognizedPatchingTools.isEmpty()) {
            for (PatchValidatorAndGenerator vg : SupportedPatchTools.getSupportedPatchValidatorsAndGenerators()) {
                try {
                    PatchingTool pt = (PatchingTool)PatchingTool.valueOf(PatchingTool.class, (String)vg.getPatchTool());
                    oplanRecognizedPatchingTools.add(pt);
                }
                catch (IllegalArgumentException e) {
                    throw new PatchPackageException("The PatchValidatorAndGenerator doesn't have a recognized patch tool", (Throwable)e);
                }
            }
        }
        return oplanRecognizedPatchingTools;
    }

    static {
        supportedBundlePatchGenericPatchValidatorsAndGenerators.add(new OPatchSingletonPatchValidatorAndGenerator());
        supportedBundlePatchGenericPatchValidatorsAndGenerators.add(new CompositePatchValidatorAndGenerator());
        supportedBundlePatchGenericPatchValidatorsAndGenerators.add(new ExapatchPatchValidatorAndGenerator());
        supportedBundlePatchGenericPatchValidatorsAndGenerators.add(new DefaultPatchValidatorAndGenerator());
        supportedPatchValidatorsAndGenerators.add(new OPatchBundlePatchValidatorAndGenerator());
        for (PatchValidatorAndGenerator psvg : supportedBundlePatchGenericPatchValidatorsAndGenerators) {
            supportedPatchValidatorsAndGenerators.add(psvg);
        }
    }
}

