/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.oplan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.oplan.core.oplan.IOUtils;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanInternalException;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.oplan.sdk.resource.OPlanBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineParsing {
    Logger logger = Logger.getLogger(CommandLineParsing.class.getName());
    private String[] args;
    private CommandLine cmdline = null;
    private OplanActions commandline_action = null;
    private OplanOptions commandline_options = null;
    private Options options = new Options();
    private Options shown_options = new Options();
    private Properties planProps = new Properties();
    private volatile String commandlineParsed;
    private String patchloc;
    private String save_configXML_location;
    private String configCompare_firstXML;
    private String configCompare_secondXML;
    private static Map<String, OplanActions> cmdToOplanAction = null;

    public CommandLineParsing(String[] args) {
        this.args = args;
    }

    public synchronized void parseCommandLine() {
        if (this.commandlineParsed != null) {
            return;
        }
        Option help = new Option("h", "help", false, "Prints help message.");
        Option version = new Option("v", "version", false, "Prints OPlan's version information.");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override a property read from the response file.");
        Option x = OptionBuilder.create((String)"X");
        OptionBuilder.withArgName((String)"racpatches");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Comma separated list of patches to be applied to Database Homes");
        Option racPatches = OptionBuilder.create((String)"RACPatches");
        OptionBuilder.withArgName((String)"gipatches");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Comma separated list of patches to be applied to Grid Infrastructure Homes");
        Option giPatches = OptionBuilder.create((String)"GIPatches");
        OptionBuilder.withArgName((String)"NodeNumberPerReadme");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Node Number for each readme file for a execution plan");
        Option nodeNumberPerReadme = OptionBuilder.create((String)"NodeNumberPerReadme");
        OptionBuilder.withArgName((String)"logDir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Directory for logging and output");
        Option logDir = OptionBuilder.create((String)"logDir");
        OptionBuilder.withArgName((String)"MoveConfigToOH");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Database Home to migrate the config");
        Option moveConfigToOH = OptionBuilder.create((String)"MoveConfigToOH");
        OptionBuilder.withArgName((String)"IntgFactoryClass");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"integration xml location");
        Option intgXML = OptionBuilder.create((String)"IntgFactoryClass");
        OptionBuilder.withArgName((String)"customLogPath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Location for OPatch core logs. Pass parameter as $ORACLE_HOME/path if to be logged inside OH");
        Option customLogPath = OptionBuilder.create((String)"customLogPath");
        this.options.addOption(help).addOption(version).addOption(x).addOption(racPatches).addOption(giPatches).addOption(nodeNumberPerReadme).addOption(moveConfigToOH).addOption(logDir).addOption(customLogPath);
        this.shown_options.addOption(help).addOption(version).addOption(racPatches).addOption(giPatches).addOption(nodeNumberPerReadme).addOption(moveConfigToOH).addOption(logDir).addOption(customLogPath);
        OptionBuilder.withArgName((String)"adminserverurl");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"URL of the AdminServer of the GCDomain");
        Option adminServerURL = OptionBuilder.create((String)"AdminServerURL");
        OptionBuilder.withArgName((String)"adminserveruser");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Username of the AdminServer of the GCDomain");
        Option adminServerUser = OptionBuilder.create((String)"AdminServerUser");
        OptionBuilder.withArgName((String)"adminserverpassword");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Password of the AdminServer of the GCDomain");
        Option adminServerPassword = OptionBuilder.create((String)"AdminServerPassword");
        this.options.addOption(help).addOption(version).addOption(x).addOption(racPatches).addOption(giPatches).addOption(adminServerURL).addOption(adminServerUser).addOption(adminServerPassword).addOption(intgXML);
        this.shown_options.addOption(help).addOption(version).addOption(racPatches).addOption(giPatches);
        GnuParser parser = new GnuParser();
        try {
            this.cmdline = parser.parse(this.options, this.args);
            if (this.cmdline.hasOption('h')) {
                this.commandline_options = OplanOptions.HELP;
                this.commandlineParsed = "True";
                return;
            }
            if (this.cmdline.hasOption("AdminServerURL")) {
                String adminServerURLStr = this.cmdline.getOptionValue("AdminServerURL");
                this.planProps.put("AdminServerURL", adminServerURLStr);
            }
            if (this.cmdline.hasOption("AdminServerUser")) {
                String adminServerUserStr = this.cmdline.getOptionValue("AdminServerUser");
                this.planProps.put("AdminServerUser", adminServerUserStr);
            }
            if (this.cmdline.hasOption("AdminServerPassword")) {
                String adminServerPasswordStr = this.cmdline.getOptionValue("AdminServerPassword");
                this.planProps.put("AdminServerPassword", adminServerPasswordStr);
            }
            if (this.cmdline.hasOption('v')) {
                this.commandline_options = OplanOptions.VERSION;
                this.commandlineParsed = "True";
                return;
            }
            if (this.cmdline.hasOption("RACPatches")) {
                String[] rac_patches = this.cmdline.getOptionValues("RACPatches");
                this.planProps.put("RACPatchLocations", this.convertArrayToCommaSeprateStr(rac_patches));
            }
            if (this.cmdline.hasOption("GIPatches")) {
                String[] gi_patches = this.cmdline.getOptionValues("GIPatches");
                this.planProps.put("GIPatchLocations", this.convertArrayToCommaSeprateStr(gi_patches));
            }
            if (this.cmdline.hasOption("NodeNumberPerReadme")) {
                String nodeNubmerPerReadme = this.cmdline.getOptionValue("NodeNumberPerReadme");
                this.planProps.put("NodeNumberPerReadme", nodeNubmerPerReadme);
            }
            if (this.cmdline.hasOption("logDir")) {
                this.planProps.put("logDir", this.cmdline.getOptionValue("logDir"));
            }
            if (this.cmdline.hasOption("MoveConfigToOH")) {
                String cloneRACOH = this.cmdline.getOptionValue("MoveConfigToOH");
                this.planProps.put("MoveConfigToOH", cloneRACOH);
            }
            if (this.cmdline.hasOption("IntgFactoryClass")) {
                String intgClass = this.cmdline.getOptionValue("IntgFactoryClass");
                this.planProps.put("IntgFactoryClass", intgClass);
            }
            if (this.cmdline.hasOption("customLogPath")) {
                String customPath = this.cmdline.getOptionValue("customLogPath");
                this.planProps.put("customLogPath", customPath);
            }
            if (this.cmdline.hasOption("X")) {
                Properties cmdProps = CommandLineParsing.getOptionProperties(this.cmdline, "X");
                this.planProps.putAll((Map<?, ?>)cmdProps);
            }
            if (this.cmdline.getArgList().size() < 2 && this.cmdline.getArgList().size() > 3) {
                throw new OPlanException("Expected two arguments for generating steps. Or, expected two or three arguments for comparing two system configuration in oplan command.");
            }
            String action = this.cmdline.getArgs()[0];
            if (!cmdToOplanAction.containsKey(action)) {
                throw new OPlanException("Unrecognized command " + action);
            }
            this.commandline_action = cmdToOplanAction.get(action);
            if (this.commandline_action.equals((Object)OplanActions.CONFIGDIFF)) {
                if (this.cmdline.getArgList().size() != 2 && this.cmdline.getArgList().size() != 3) {
                    throw new OPlanException(action + " expects one or two configuration XMLs as argument.");
                }
                this.configCompare_firstXML = this.cmdline.getArgs()[1];
                if (this.cmdline.getArgList().size() == 3) {
                    this.configCompare_secondXML = this.cmdline.getArgs()[2];
                }
                this.commandlineParsed = "True";
                return;
            }
            if (this.commandline_action.equals((Object)OplanActions.SAVE_CONFIG)) {
                if (this.cmdline.getArgList().size() != 2) {
                    throw new OPlanException(action + " expects a file location argument to save configuration to XML file.");
                }
                if (new File(((String)this.cmdline.getArgList().get(1)).toString()).exists()) {
                    throw new OPlanException("File location given to save configuration to XML already exists: " + ((String)this.cmdline.getArgList().get(1)).toString());
                }
                this.save_configXML_location = this.cmdline.getArgs()[1];
                this.commandlineParsed = "True";
                return;
            }
            if (this.cmdline.getArgList().size() != 2) {
                String errMsg = "";
                if (this.cmdline.getArgList().size() < 2) {
                    errMsg = "The patch location argument is not given.. ";
                } else {
                    errMsg = "The following arguments are invalid:\n";
                    String[] args = this.cmdline.getArgs();
                    for (int j = 2; j < args.length; ++j) {
                        errMsg = errMsg + "\t" + args[j] + "\n";
                    }
                }
                throw new OPlanException(errMsg);
            }
            String patchLocation = this.cmdline.getArgs()[1];
            File patchLocationFile = new File(patchLocation);
            this.patchloc = patchLocationFile.getAbsolutePath();
            this.commandlineParsed = "True";
        }
        catch (ParseException exp) {
            throw new OPlanException(exp.getMessage(), exp);
        }
    }

    public static Properties getOptionProperties(CommandLine cmdline, String option) {
        String[] values;
        Properties props = new Properties();
        for (String str : values = cmdline.getOptionValues(option)) {
            String[] mapKeyVal = str.split("=");
            String key = mapKeyVal[0];
            String val = mapKeyVal.length < 2 ? "true" : mapKeyVal[1];
            props.put(key, val);
        }
        return props;
    }

    public void printHelp() {
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        System.out.println();
        formatter.printHelp(OPlanBundle.getMessage(OPlan.class, "USAGE", new Object[0]), this.shown_options, false);
        PrintWriter out = new PrintWriter(System.out, true);
        int width = formatter.defaultWidth;
        System.out.println();
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "GENERATESTEPS", new Object[0]));
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "GENERATEAPPLY", new Object[0]));
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "GENERATEROLLBACK", new Object[0]));
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "SAVE_CONFIG", new Object[0]));
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "CONFIG_COMPARE", new Object[0]));
        System.out.println();
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "EXAMPLES", new Object[0]));
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "NOTE_SETOH_TO_GI", new Object[0]));
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "EXPORT_OH", "export ORACLE_HOME"));
        System.out.println();
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "OPLAN_GENERATE_EX", new Object[0]));
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "OPLAN_COMMAND_EX", "oplan generateSteps"));
        System.out.println();
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "SAVE_CONFIG_CMD_MESSAGE", new Object[0]));
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "SAVE_CONFIG_CMD", new Object[0]));
        System.out.println();
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "CONFIGDIFF_XML_CURRENT_CONFIG", new Object[0]));
        formatter.printWrapped(out, width, 4, "oplan configurationCompare <configuration.xml>");
        System.out.println();
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "CONFIGDIFF_TWO_XMLS", new Object[0]));
        formatter.printWrapped(out, width, 4, "oplan configurationCompare <configuration1.xml> <configuration2.xml>");
        System.out.println();
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "RAC_GI_ONE_OFF_PATCHES", new Object[0]));
        formatter.printWrapped(out, width, 4, OPlanBundle.getMessage(OPlan.class, "APPLY_WITH_RAC_GI_ONE_OFF_PATCHES_CMD", new Object[0]));
    }

    public static void printVersionInfo() {
        InputStream is = OPlan.class.getClassLoader().getResourceAsStream("oracle/oplan/core/oplan/versioninfo.txt");
        try {
            IOUtils.copyStream(is, System.out);
        }
        catch (IOException e) {
            throw new OPlanInternalException(e.getMessage(), e);
        }
    }

    public void setFilePermissions(File logDir) {
        try {
            Process pdir = new ProcessBuilder("find", logDir.getAbsolutePath(), "-type", "d", "-exec", "chmod", "550", "{}", ";").redirectErrorStream(true).start();
            IOUtils.writeStream(pdir.getInputStream(), System.out);
            int statusDir = pdir.waitFor();
            if (statusDir != 0) {
                this.logger.log(Level.WARNING, "Directory Permissions Not Modified");
            }
            Process pfile = new ProcessBuilder("find", logDir.getAbsolutePath(), "-type", "f", "-exec", "chmod", "440", "{}", ";").redirectErrorStream(true).start();
            IOUtils.writeStream(pfile.getInputStream(), System.out);
            int statusFile = pfile.waitFor();
            if (statusFile != 0) {
                this.logger.log(Level.WARNING, "File Permissions Not Modified");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Changing file permissions of the log files to read only failed", e);
        }
    }

    static void printLicense() {
        File markerFile = new File("/tmp/.oplanlicenseaccepted");
        if (markerFile.exists()) {
            return;
        }
        InputStream is = OPlan.class.getClassLoader().getResourceAsStream("oracle/oplan/core/oplan/LICENSE.txt");
        try {
            IOUtils.writeStream(is, System.out);
        }
        catch (IOException e) {
            throw new OPlanInternalException(e.getMessage(), e);
        }
        System.out.println();
        System.out.println("Do you agree to the license terms? ([y]es/[n]o):");
        Scanner in = new Scanner(System.in);
        String response = in.nextLine();
        if (!response.startsWith("y")) {
            throw new OPlanUserException("LICENSE_REQUIRED", new Object[0]);
        }
        try {
            markerFile.createNewFile();
        }
        catch (IOException e) {
            throw new OPlanException(e.getMessage(), e);
        }
    }

    public OplanActions getCommandLineAction() {
        if (this.commandlineParsed == null) {
            this.parseCommandLine();
        }
        return this.commandline_action;
    }

    public OplanOptions getCommandLineOptions() {
        if (this.commandlineParsed == null) {
            this.parseCommandLine();
        }
        return this.commandline_options;
    }

    public Properties getPlanProps() {
        if (this.commandlineParsed == null) {
            this.parseCommandLine();
        }
        return this.planProps;
    }

    public String getBundlePatchLocation() {
        if (this.commandlineParsed == null) {
            this.parseCommandLine();
        }
        return this.patchloc;
    }

    public String getSaveConfigurationXML() {
        if (this.commandlineParsed == null) {
            this.parseCommandLine();
        }
        return this.save_configXML_location;
    }

    public String getConfigCompareFirstXML() {
        if (this.commandlineParsed == null) {
            this.parseCommandLine();
        }
        return this.configCompare_firstXML;
    }

    public String getConfigCompareSecondXML() {
        if (this.commandlineParsed == null) {
            this.parseCommandLine();
        }
        return this.configCompare_secondXML;
    }

    private String convertArrayToCommaSeprateStr(String[] patches) {
        String result = "";
        if (patches != null && patches.length > 0) {
            StringBuffer patchesBuffer = new StringBuffer();
            for (int i = 0; i < patches.length; ++i) {
                patchesBuffer.append(patches[i].trim());
                patchesBuffer.append(",");
            }
            result = patchesBuffer.toString().replace(",,", ",");
            if (result.endsWith(",")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    static {
        cmdToOplanAction = new HashMap<String, OplanActions>();
        cmdToOplanAction.put("generateApplySteps", OplanActions.APPLY);
        cmdToOplanAction.put("generateRollbackSteps", OplanActions.ROLLBACK);
        cmdToOplanAction.put("generateSteps", OplanActions.ALL_OPERATIONS);
        cmdToOplanAction.put("configurationCompare", OplanActions.CONFIGDIFF);
        cmdToOplanAction.put("saveConfigurationSnapshot", OplanActions.SAVE_CONFIG);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OplanOptions {
        HELP,
        VERSION,
        X,
        RACPATCHES,
        GIPATCHES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OplanActions {
        ALL_OPERATIONS,
        APPLY,
        ROLLBACK,
        CONFIGDIFF,
        SAVE_CONFIG;

    }
}

