/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.install;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.glcm.opatch.common.impl.install.ComponentInfoImpl;

public class InventoryComponentInfoImpl
extends ComponentInfoImpl
implements InventoryComponentInfo {
    private Map<FileState, List<Path>> _affectedPaths = new HashMap<FileState, List<Path>>();
    private Map<Path, Path> _backupFilePaths = new HashMap<Path, Path>();
    private ComponentCheckResult _compCheckResult;
    private InventoryComponentInfo.Action _action;

    public InventoryComponentInfoImpl(String name, String version, String patchLevel, InventoryComponentInfo.Action action, int refCount) {
        super(name, version, patchLevel, refCount);
        this._action = action;
    }

    public ComponentCheckResult getComponentCheckResult() {
        return this._compCheckResult;
    }

    @Deprecated
    public Map<FileState, List<File>> getAffectedFiles() {
        HashMap<FileState, List<File>> affectedFiles = new HashMap<FileState, List<File>>();
        for (Map.Entry<FileState, List<Path>> entry : this._affectedPaths.entrySet()) {
            ArrayList<File> files = new ArrayList<File>();
            List<Path> paths = entry.getValue();
            for (Path affectedPath : paths) {
                files.add(new File(affectedPath.toString()));
            }
            affectedFiles.put(entry.getKey(), files);
        }
        return affectedFiles;
    }

    public Map<FileState, List<Path>> getAffectedFilePaths() {
        return this._affectedPaths;
    }

    @Deprecated
    public void addAffectedFile(FileState fileState, File file) {
        this.addAffectedFile(fileState, NioServiceFactory.getNioService().getPath(file));
    }

    public void addAffectedFile(FileState fileState, Path affectedFilePath) {
        List<Path> affectedStateFiles = null;
        affectedStateFiles = this._affectedPaths.containsKey(fileState) ? this._affectedPaths.get(fileState) : new ArrayList<Path>();
        affectedStateFiles.add(affectedFilePath);
        this._affectedPaths.put(fileState, affectedStateFiles);
    }

    @Deprecated
    public Map<File, File> getBackupFiles() {
        HashMap<File, File> backupFiles = new HashMap<File, File>();
        for (Map.Entry<Path, Path> entry : this._backupFilePaths.entrySet()) {
            backupFiles.put(new File(entry.getKey().toString()), new File(entry.getValue().toString()));
        }
        return backupFiles;
    }

    public Map<Path, Path> getBackupFilePaths() {
        return this._backupFilePaths;
    }

    @Deprecated
    public void addBackupFile(File homeFile, File backupFile) {
        this.addBackupFile(NioServiceFactory.getNioService().getPath(homeFile), NioServiceFactory.getNioService().getPath(backupFile));
    }

    public void addBackupFile(Path homeFile, Path backupFile) {
        this._backupFilePaths.put(homeFile, backupFile);
    }

    public void setComponentCheckResult(ComponentCheckResult result) {
        this._compCheckResult = result;
    }

    public InventoryComponentInfo.Action getAction() {
        return this._action;
    }

    public void setAction(InventoryComponentInfo.Action action) {
        this._action = action;
    }
}

