/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.glcm.opatch.common.api.DomainInventoryLoadingException;
import oracle.glcm.opatch.common.api.DomainInventoryUpdatingException;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchXMLValidationEventHandler;
import oracle.glcm.opatch.common.impl.configinv.ConfigPatchInv;
import oracle.glcm.opatch.common.utils.SecureUnmarshaller;
import org.xml.sax.SAXException;

public class PatchConfigInventoryDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static Class<ConfigPatchInv> ConfigPatchInvClass = ConfigPatchInv.class;
    private static String ConfigPatchInvPackage = ConfigPatchInvClass.getPackage().getName();
    private static String ConfigPatchInvXSD = "/oracle/glcm/opatch/common/impl/configinv/configpatchinv.xsd";
    private static String configInventoryFileName = "configpatchinv.xml";
    private ConfigPatchInv invObj = null;
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;
    private String configInventoryFileFullName = null;
    private Schema schema = null;
    private boolean loaded = false;

    public PatchConfigInventoryDAO(String instanceDir) throws FileNotFoundException, DomainInventoryLoadingException {
        this.logger.info("Enter PatchConfigInventoryDAO constructor...");
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ConfigPatchInvPackage);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = ConfigPatchInvClass.getResource(ConfigPatchInvXSD);
            this.schema = sf.newSchema(url);
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setSchema(this.schema);
            this.marshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.unmarshaller.setSchema(this.schema);
            this.unmarshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
        }
        catch (JAXBException e) {
            throw new DomainInventoryLoadingException("Failed to initialize jaxb context for config inventory", (Throwable)e);
        }
        catch (SAXException e) {
            throw new DomainInventoryLoadingException("Failed to initialize jaxb context for config inventory", (Throwable)e);
        }
        File fInstanceDir = new File(instanceDir);
        if (!fInstanceDir.exists() || fInstanceDir.isFile()) {
            throw new FileNotFoundException("Domain directory: " + instanceDir + " does not exist");
        }
        this.configInventoryFileFullName = instanceDir + Constants.PATH + configInventoryFileName;
        File file = new File(this.configInventoryFileFullName);
        if (file.exists()) {
            try {
                this.invObj = (ConfigPatchInv)SecureUnmarshaller.unmarshal(this.unmarshaller, new File(this.configInventoryFileFullName));
            }
            catch (JAXBException je) {
                throw new DomainInventoryLoadingException("Failed to load or parse the configpatchinv.xml", (Throwable)je);
            }
            this.loaded = true;
        }
        this.logger.info("Done PatchConfigInventoryDAO creation");
    }

    public void load() {
        if (!this.loaded) {
            this.invObj = new ConfigPatchInv();
            this.loaded = true;
        }
        this.logger.info(" PatchConfigInventoryDAO just loaded.");
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void save() throws DomainInventoryUpdatingException {
        if (this.loaded) {
            try {
                this.marshaller.marshal((Object)this.invObj, new File(this.configInventoryFileFullName));
            }
            catch (JAXBException e) {
                throw new DomainInventoryUpdatingException("Failed to save config patch inventory", (Throwable)e);
            }
        }
    }

    public void add(HashMap<String, String> map) throws DomainInventoryUpdatingException {
        if (!this.loaded) {
            this.load();
        }
        List patchList = this.invObj.getPatch();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ConfigPatchInv.Patch found = null;
            for (ConfigPatchInv.Patch p : patchList) {
                if (!p.getId().equals(entry.getKey()) || !p.getUpid().equals(entry.getValue())) continue;
                found = p;
                break;
            }
            if (found != null) continue;
            ConfigPatchInv.Patch newp = new ConfigPatchInv.Patch();
            newp.setId(entry.getKey());
            newp.setUpid(entry.getValue());
            patchList.add(newp);
        }
        this.save();
    }

    public void remove(HashMap<String, String> map) throws DomainInventoryUpdatingException {
        Set<String> keyset = map.keySet();
        for (String patchId : keyset) {
            String patchUpid = map.get(patchId);
            this.remove(patchId, patchUpid);
        }
        this.save();
    }

    public void remove(String patchId, String patchUpid) {
        if (!this.loaded) {
            this.load();
        }
        List patchList = this.invObj.getPatch();
        ConfigPatchInv.Patch found = null;
        for (ConfigPatchInv.Patch p : patchList) {
            if (!p.getId().equals(patchId) || !p.getUpid().equals(patchUpid)) continue;
            found = p;
            break;
        }
        if (found != null) {
            patchList.remove(found);
        }
    }

    public List<String> getAll() {
        List patchList = null;
        if (this.loaded) {
            patchList = this.invObj.getPatch();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (patchList != null) {
            for (ConfigPatchInv.Patch p : patchList) {
                result.add(p.getId());
            }
        }
        return result;
    }
}

