/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.glcm.opatch.common.api.DomainInventoryLoadingException;
import oracle.glcm.opatch.common.api.DomainInventoryUpdatingException;
import oracle.glcm.opatch.common.impl.PatchXMLValidationEventHandler;
import oracle.glcm.opatch.common.impl.configinventory.action.ActionConfigInventory;
import oracle.glcm.opatch.common.utils.LocalUtils;
import oracle.glcm.opatch.common.utils.SecureUnmarshaller;
import org.xml.sax.SAXException;

public class ActionConfigInventoryDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static Class<ActionConfigInventory> aciClass = ActionConfigInventory.class;
    private static String aciPackage = aciClass.getPackage().getName();
    private static String aciXsdFile = "action_config_inventory.xsd";
    private static String dciDir = "domain_config_inventory";
    private static String aciXmlFile = "action_config_inventory.xml";
    private File aciXmlFileFullPath = null;
    private ActionConfigInventory invObj = null;
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;
    private Schema schema = null;

    public ActionConfigInventoryDAO(String domainDir) throws FileNotFoundException, DomainInventoryLoadingException, DomainInventoryUpdatingException {
        this.logger.info("Enter ActionConfigInventoryDAO constructor...");
        File domainDirFile = new File(domainDir);
        if (!domainDirFile.exists() || !domainDirFile.isDirectory()) {
            throw new FileNotFoundException("Domain directory does not exist.");
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)aciPackage);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = aciClass.getResource(aciXsdFile);
            this.schema = sf.newSchema(url);
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setSchema(this.schema);
            this.marshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.unmarshaller.setSchema(this.schema);
            this.unmarshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
        }
        catch (JAXBException e) {
            throw new DomainInventoryLoadingException("Failed to initialize jaxb context for domain config inventory", (Throwable)e);
        }
        catch (SAXException e) {
            throw new DomainInventoryLoadingException("Failed to initialize jaxb context for domain config inventory", (Throwable)e);
        }
        String file = domainDir + File.separator + dciDir + File.separator + aciXmlFile;
        this.aciXmlFileFullPath = new File(file);
        if (!this.aciXmlFileFullPath.exists() || !this.aciXmlFileFullPath.isFile()) {
            this.logger.info("Action Config Inventory xml file " + file + " does not exist. Create a new object");
            this.invObj = new ActionConfigInventory();
            File dciFullDirFile = new File(domainDir + File.separator + dciDir);
            if (!(dciFullDirFile.exists() && !dciFullDirFile.isFile() || dciFullDirFile.mkdir())) {
                throw new FileNotFoundException("Cannot create directory:" + dciFullDirFile.getName());
            }
            try {
                this.aciXmlFileFullPath.createNewFile();
            }
            catch (IOException e) {
                throw new FileNotFoundException("Cannot create file:" + this.aciXmlFileFullPath.getName());
            }
            this.saveToFile(this.invObj);
            this.logger.info("Done done creating ActionConfigInventory obj in constructor, and created blank xml file");
        } else {
            try {
                this.invObj = (ActionConfigInventory)SecureUnmarshaller.unmarshal(this.unmarshaller, this.aciXmlFileFullPath);
                this.logger.info("Done loading existing xml file in ActionConfigInventoryDAO constructor");
            }
            catch (JAXBException je) {
                throw new DomainInventoryLoadingException("Failed to load or parse the action_config_inventory.xml", (Throwable)je);
            }
            this.logger.info("Done ActionConfigInventoryDAO constructor");
        }
    }

    private synchronized void saveToFile(ActionConfigInventory obj) throws DomainInventoryUpdatingException {
        try {
            this.marshaller.marshal((Object)obj, this.aciXmlFileFullPath);
        }
        catch (JAXBException e) {
            throw new DomainInventoryUpdatingException("Failed to marshall to file action_config_inventory.xml", (Throwable)e);
        }
    }

    public synchronized void addEntry(String name, Date date, String actor) throws DomainInventoryUpdatingException {
        try {
            this.invObj = (ActionConfigInventory)SecureUnmarshaller.unmarshal(this.unmarshaller, this.aciXmlFileFullPath);
            List listAce = this.invObj.getActionInventoryEntry();
            for (ActionConfigInventory.ActionInventoryEntry e : listAce) {
                if (!e.getName().equals(name)) continue;
                this.logger.warning("The entry with name:" + name + " already exists in inventory");
                return;
            }
            ActionConfigInventory.ActionInventoryEntry ace = new ActionConfigInventory.ActionInventoryEntry();
            ace.setName(name);
            ace.setDate(LocalUtils.convertDate(date));
            ace.setActor(actor);
            listAce.add(ace);
            this.marshaller.marshal((Object)this.invObj, this.aciXmlFileFullPath);
        }
        catch (JAXBException e) {
            throw new DomainInventoryUpdatingException("Failed to udpate action config inventory, marshalling failed", (Throwable)e);
        }
    }

    public ActionConfigInventory.ActionInventoryEntry getEntry(String name) throws DomainInventoryLoadingException {
        ActionConfigInventory.ActionInventoryEntry result = null;
        try {
            if (this.aciXmlFileFullPath.exists() && this.aciXmlFileFullPath.isFile()) {
                this.invObj = (ActionConfigInventory)SecureUnmarshaller.unmarshal(this.unmarshaller, this.aciXmlFileFullPath);
            }
            for (ActionConfigInventory.ActionInventoryEntry e : this.invObj.getActionInventoryEntry()) {
                if (!e.getName().equals(name)) continue;
                result = e;
            }
        }
        catch (JAXBException e) {
            this.logger.severe("Failed to load action_config_inventory.xml file");
            throw new DomainInventoryLoadingException("Failed to load action_config_inventory.xml file");
        }
        return result;
    }

    public List<ActionConfigInventory.ActionInventoryEntry> getEntries() throws DomainInventoryLoadingException {
        try {
            if (this.aciXmlFileFullPath.exists() && this.aciXmlFileFullPath.isFile()) {
                this.invObj = (ActionConfigInventory)SecureUnmarshaller.unmarshal(this.unmarshaller, this.aciXmlFileFullPath);
            }
            return this.invObj.getActionInventoryEntry();
        }
        catch (JAXBException e) {
            this.logger.severe("Failed to load action_config_inventory.xml file");
            throw new DomainInventoryLoadingException("Failed to load action_config_inventory.xml file");
        }
    }

    public synchronized ActionConfigInventory.ActionInventoryEntry removeEntry(String name) throws DomainInventoryLoadingException, DomainInventoryUpdatingException {
        ActionConfigInventory.ActionInventoryEntry result = null;
        try {
            this.invObj = (ActionConfigInventory)SecureUnmarshaller.unmarshal(this.unmarshaller, this.aciXmlFileFullPath);
            List listAce = this.invObj.getActionInventoryEntry();
            Iterator iterator = listAce.iterator();
            while (iterator.hasNext()) {
                ActionConfigInventory.ActionInventoryEntry aie = (ActionConfigInventory.ActionInventoryEntry)iterator.next();
                if (!aie.getName().equals(name)) continue;
                result = aie;
                iterator.remove();
            }
            if (result == null) {
                this.logger.info("Entry with name: " + name + " does not exist in action config inventory");
            } else {
                this.marshaller.marshal((Object)this.invObj, this.aciXmlFileFullPath);
            }
            return result;
        }
        catch (JAXBException e) {
            throw new DomainInventoryUpdatingException("Error when trying to load or flush the action_config_inventory.xml", (Throwable)e);
        }
    }

    public boolean entryExists(String name) throws DomainInventoryLoadingException {
        boolean result = false;
        try {
            if (this.aciXmlFileFullPath.exists() && this.aciXmlFileFullPath.isFile()) {
                this.invObj = (ActionConfigInventory)SecureUnmarshaller.unmarshal(this.unmarshaller, this.aciXmlFileFullPath);
            }
            for (ActionConfigInventory.ActionInventoryEntry e : this.invObj.getActionInventoryEntry()) {
                if (!e.getName().equals(name)) continue;
                result = true;
            }
        }
        catch (JAXBException e) {
            this.logger.severe("Failed to load action_config_inventory.xml file");
            throw new DomainInventoryLoadingException("Failed to load action_config_inventory.xml file");
        }
        return result;
    }
}

