/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.alias;

import java.util.Collection;
import java.util.HashSet;
import oracle.glcm.opatch.common.api.alias.ArtifactReference;
import oracle.glcm.opatch.common.api.alias.MaintenanceAlias;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasBuilder;
import oracle.glcm.opatch.common.impl.alias.ArtifactReferenceImpl;

public class MaintenanceAliasImpl
implements MaintenanceAlias {
    private String _productFamily;
    private String _maintenanceAliasKey;
    private String _product;
    private String _bundleType;
    private String _version;
    private String _timestamp;
    private String _patchType;
    private String _patchLevel;
    private Collection<ArtifactReference> _mapping;

    private MaintenanceAliasImpl(MaintenanceAliasBuilderImpl builder) {
        this._productFamily = builder._productFamily;
        this._maintenanceAliasKey = builder._maintenanceAliasKey;
        this._product = builder._product;
        this._bundleType = builder._bundleType;
        this._version = builder._version;
        this._timestamp = builder._timestamp;
        this._patchType = builder._patchType;
        this._mapping = builder._mapping;
    }

    public String getMaintenanceAliasKey() {
        return this._maintenanceAliasKey;
    }

    public Collection<ArtifactReference> getMapping() {
        return this._mapping;
    }

    public String getCompleteMaintenanceAlias() {
        StringBuilder builder = new StringBuilder();
        String separator = " ";
        if (this._product != null) {
            builder.append(this._product);
            builder.append(" ");
        }
        if (this._bundleType != null) {
            builder.append(this._bundleType);
            builder.append(" ");
        }
        if (this._version != null) {
            builder.append(this._version);
            builder.append(" ");
        }
        if (this._timestamp != null) {
            builder.append(" ");
            builder.append("(");
            builder.append(this._timestamp);
            builder.append(")");
        }
        if (this._patchType != null) {
            builder.append("(");
            builder.append(this._patchType);
            builder.append(")");
        }
        return builder.toString();
    }

    public String getProduct() {
        return this._product;
    }

    public String getProductFamily() {
        return this._productFamily;
    }

    public String getBundleType() {
        return this._bundleType;
    }

    public String getVersion() {
        return this._version;
    }

    public String getTimestamp() {
        return this._timestamp;
    }

    public String getPatchType() {
        return this._patchType;
    }

    public Collection<ArtifactReference> getComponents() {
        HashSet<ArtifactReference> comps = new HashSet<ArtifactReference>();
        for (ArtifactReference artifactRef : this._mapping) {
            if (!((ArtifactReferenceImpl)artifactRef).getArtifactType().equals((Object)ArtifactReferenceImpl.ArtifactType.component)) continue;
            comps.add(artifactRef);
        }
        return comps;
    }

    public Collection<ArtifactReference> getFeatureSets() {
        HashSet<ArtifactReference> featuresets = new HashSet<ArtifactReference>();
        for (ArtifactReference artifactRef : this._mapping) {
            if (!((ArtifactReferenceImpl)artifactRef).getArtifactType().equals((Object)ArtifactReferenceImpl.ArtifactType.featureSet)) continue;
            featuresets.add(artifactRef);
        }
        return featuresets;
    }

    public Collection<ArtifactReference> getDistributions() {
        HashSet<ArtifactReference> distributions = new HashSet<ArtifactReference>();
        for (ArtifactReference artifactRef : this._mapping) {
            if (!((ArtifactReferenceImpl)artifactRef).getArtifactType().equals((Object)ArtifactReferenceImpl.ArtifactType.distribution)) continue;
            distributions.add(artifactRef);
        }
        return distributions;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.getProduct().hashCode();
        result = 31 * result + this.getVersion().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaintenanceAlias)) {
            return false;
        }
        MaintenanceAlias c = (MaintenanceAlias)o;
        return c.getCompleteMaintenanceAlias().equals(this.getCompleteMaintenanceAlias());
    }

    public String getPatchLevel() {
        return this._patchLevel;
    }

    public static class MaintenanceAliasBuilderImpl
    implements MaintenanceAliasBuilder {
        private String _productFamily;
        private String _maintenanceAliasKey;
        private String _product;
        private String _bundleType;
        private String _version;
        private String _timestamp;
        private String _patchType;
        private String _patchLevel;
        private Collection<ArtifactReference> _mapping;

        public MaintenanceAliasBuilderImpl(String productFamily, String maintenanceAliasKey, String product, String bundleType, String version, String timestamp, String patchType, Collection<ArtifactReference> mapping) {
            this._productFamily = productFamily;
            this._maintenanceAliasKey = maintenanceAliasKey;
            this._product = product;
            this._bundleType = bundleType;
            this._version = version;
            this._timestamp = timestamp;
            this._patchType = patchType;
            this._mapping = mapping;
        }

        public MaintenanceAliasBuilder setPatchLevel(String patchLevel) {
            this._patchLevel = patchLevel;
            return this;
        }

        public MaintenanceAlias build() {
            MaintenanceAliasImpl alias = new MaintenanceAliasImpl(this);
            alias._patchLevel = this._patchLevel;
            return alias;
        }
    }
}

